/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.mockito.repackaged;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.mockito.Incubating;
import org.mockito.exceptions.base.MockitoSerializationIssue;
import org.mockito.internal.creation.instance.DefaultInstantiatorProvider;
import org.mockito.internal.creation.settings.CreationSettings;
import org.mockito.internal.util.MockUtil;
import org.mockito.internal.util.StringJoiner;
import org.mockito.internal.util.reflection.FieldSetter;
import org.mockito.mock.MockCreationSettings;
import org.mockito.mock.MockName;
import org.mockito.mock.SerializableMode;
import org.powermock.api.mockito.repackaged.ClassImposterizer;
import org.powermock.api.mockito.repackaged.cglib.proxy.Factory;

@Incubating
class AcrossJVMSerializationFeature
implements Serializable {
    private static final long serialVersionUID = 7411152578314420778L;
    private static final String MOCKITO_PROXY_MARKER = "MockitoProxyMarker";
    private final Lock mutex = new ReentrantLock();
    private boolean instanceLocalCurrentlySerializingFlag = false;

    AcrossJVMSerializationFeature() {
    }

    public boolean isWriteReplace(Method method) {
        return method.getReturnType() == Object.class && method.getParameterTypes().length == 0 && method.getName().equals("writeReplace");
    }

    public Object writeReplace(Object mockitoMock) throws ObjectStreamException {
        try {
            this.mutex.lock();
            if (this.mockIsCurrentlyBeingReplaced()) {
                Object object = mockitoMock;
                return object;
            }
            this.mockReplacementStarted();
            AcrossJVMMockSerializationProxy acrossJVMMockSerializationProxy = new AcrossJVMMockSerializationProxy(mockitoMock);
            return acrossJVMMockSerializationProxy;
        }
        catch (IOException ioe) {
            MockUtil mockUtil = new MockUtil();
            MockName mockName = mockUtil.getMockName(mockitoMock);
            String mockedType = mockUtil.getMockSettings(mockitoMock).getTypeToMock().getCanonicalName();
            throw new MockitoSerializationIssue(StringJoiner.join((Object[])new Object[]{"The mock '" + mockName + "' of type '" + mockedType + "'", "The Java Standard Serialization reported an '" + ioe.getClass().getSimpleName() + "' saying :", "  " + ioe.getMessage()}), (Exception)ioe);
        }
        finally {
            this.mockReplacementCompleted();
            this.mutex.unlock();
        }
    }

    private void mockReplacementCompleted() {
        this.instanceLocalCurrentlySerializingFlag = false;
    }

    private void mockReplacementStarted() {
        this.instanceLocalCurrentlySerializingFlag = true;
    }

    private boolean mockIsCurrentlyBeingReplaced() {
        return this.instanceLocalCurrentlySerializingFlag;
    }

    public <T> void enableSerializationAcrossJVM(MockCreationSettings<T> settings) {
        if (settings.getSerializableMode() == SerializableMode.ACROSS_CLASSLOADERS) {
            settings.getExtraInterfaces().add(AcrossJVMMockitoMockSerializable.class);
        }
    }

    private static class MockitoMockObjectOutputStream
    extends ObjectOutputStream {
        private static final String NOTHING = "";

        public MockitoMockObjectOutputStream(ByteArrayOutputStream out) throws IOException {
            super(out);
        }

        @Override
        protected void annotateClass(Class<?> cl) throws IOException {
            this.writeObject(this.mockitoProxyClassMarker(cl));
        }

        private String mockitoProxyClassMarker(Class<?> cl) {
            if (AcrossJVMMockitoMockSerializable.class.isAssignableFrom(cl)) {
                return AcrossJVMSerializationFeature.MOCKITO_PROXY_MARKER;
            }
            return NOTHING;
        }
    }

    public static class MockitoMockObjectInputStream
    extends ObjectInputStream {
        private final Class typeToMock;
        private final Set<Class> extraInterfaces;

        public MockitoMockObjectInputStream(InputStream in, Class typeToMock, Set<Class> extraInterfaces) throws IOException {
            super(in);
            this.typeToMock = typeToMock;
            this.extraInterfaces = extraInterfaces;
            this.enableResolveObject(true);
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            if (this.notMarkedAsAMockitoMock(this.readObject())) {
                return super.resolveClass(desc);
            }
            ClassImposterizer imposterizer = new ClassImposterizer(new DefaultInstantiatorProvider().getInstantiator((MockCreationSettings)new CreationSettings()));
            imposterizer.setConstructorsAccessible(this.typeToMock, true);
            Class<Factory> proxyClass = imposterizer.createProxyClass(this.typeToMock, this.extraInterfaces.toArray(new Class[this.extraInterfaces.size()]));
            this.hackClassNameToMatchNewlyCreatedClass(desc, proxyClass);
            return proxyClass;
        }

        private void hackClassNameToMatchNewlyCreatedClass(ObjectStreamClass descInstance, Class<?> proxyClass) throws ObjectStreamException {
            try {
                Field classNameField = descInstance.getClass().getDeclaredField("name");
                new FieldSetter((Object)descInstance, classNameField).set((Object)proxyClass.getCanonicalName());
            }
            catch (NoSuchFieldException nsfe) {
                throw new MockitoSerializationIssue(StringJoiner.join((Object[])new Object[]{"Wow, the class 'ObjectStreamClass' in the JDK don't have the field 'name',", "this is definitely a bug in our code as it means the JDK team changed a few internal things.", "", "Please report an issue with the JDK used, a code sample and a link to download the JDK would be welcome."}), (Exception)nsfe);
            }
        }

        private boolean notMarkedAsAMockitoMock(Object marker) throws IOException, ClassNotFoundException {
            return !AcrossJVMSerializationFeature.MOCKITO_PROXY_MARKER.equals(marker);
        }
    }

    public static class AcrossJVMMockSerializationProxy
    implements Serializable {
        private static final long serialVersionUID = -7600267929109286514L;
        private final byte[] serializedMock;
        private final Class typeToMock;
        private final Set<Class> extraInterfaces;

        public AcrossJVMMockSerializationProxy(Object mockitoMock) throws IOException {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            MockitoMockObjectOutputStream objectOutputStream = new MockitoMockObjectOutputStream(out);
            objectOutputStream.writeObject(mockitoMock);
            objectOutputStream.close();
            out.close();
            MockCreationSettings mockSettings = new MockUtil().getMockSettings(mockitoMock);
            this.serializedMock = out.toByteArray();
            this.typeToMock = mockSettings.getTypeToMock();
            this.extraInterfaces = mockSettings.getExtraInterfaces();
        }

        private Object readResolve() throws ObjectStreamException {
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(this.serializedMock);
                MockitoMockObjectInputStream objectInputStream = new MockitoMockObjectInputStream(bis, this.typeToMock, this.extraInterfaces);
                Object deserializedMock = objectInputStream.readObject();
                bis.close();
                objectInputStream.close();
                return deserializedMock;
            }
            catch (IOException ioe) {
                throw new MockitoSerializationIssue(StringJoiner.join((Object[])new Object[]{"Mockito mock cannot be deserialized to a mock of '" + this.typeToMock.getCanonicalName() + "'. The error was :", "  " + ioe.getMessage(), "If you are unsure what is the reason of this exception, feel free to contact us on the mailing list."}), (Exception)ioe);
            }
            catch (ClassNotFoundException cce) {
                throw new MockitoSerializationIssue(StringJoiner.join((Object[])new Object[]{"A class couldn't be found while deserializing a Mockito mock, you should check your classpath. The error was :", "  " + cce.getMessage(), "If you are still unsure what is the reason of this exception, feel free to contact us on the mailing list."}), (Exception)cce);
            }
        }
    }

    public static interface AcrossJVMMockitoMockSerializable {
        public Object writeReplace() throws ObjectStreamException;
    }
}

