/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.mockito.repackaged.cglib.proxy;

import org.powermock.api.mockito.repackaged.asm.Type;
import org.powermock.api.mockito.repackaged.cglib.proxy.Callback;
import org.powermock.api.mockito.repackaged.cglib.proxy.CallbackGenerator;
import org.powermock.api.mockito.repackaged.cglib.proxy.Dispatcher;
import org.powermock.api.mockito.repackaged.cglib.proxy.DispatcherGenerator;
import org.powermock.api.mockito.repackaged.cglib.proxy.FixedValue;
import org.powermock.api.mockito.repackaged.cglib.proxy.FixedValueGenerator;
import org.powermock.api.mockito.repackaged.cglib.proxy.InvocationHandler;
import org.powermock.api.mockito.repackaged.cglib.proxy.InvocationHandlerGenerator;
import org.powermock.api.mockito.repackaged.cglib.proxy.LazyLoader;
import org.powermock.api.mockito.repackaged.cglib.proxy.LazyLoaderGenerator;
import org.powermock.api.mockito.repackaged.cglib.proxy.MethodInterceptor;
import org.powermock.api.mockito.repackaged.cglib.proxy.MethodInterceptorGenerator;
import org.powermock.api.mockito.repackaged.cglib.proxy.NoOp;
import org.powermock.api.mockito.repackaged.cglib.proxy.NoOpGenerator;
import org.powermock.api.mockito.repackaged.cglib.proxy.ProxyRefDispatcher;

class CallbackInfo {
    private static final CallbackInfo[] CALLBACKS = new CallbackInfo[]{new CallbackInfo(NoOp.class, NoOpGenerator.INSTANCE), new CallbackInfo(MethodInterceptor.class, MethodInterceptorGenerator.INSTANCE), new CallbackInfo(InvocationHandler.class, InvocationHandlerGenerator.INSTANCE), new CallbackInfo(LazyLoader.class, LazyLoaderGenerator.INSTANCE), new CallbackInfo(Dispatcher.class, DispatcherGenerator.INSTANCE), new CallbackInfo(FixedValue.class, FixedValueGenerator.INSTANCE), new CallbackInfo(ProxyRefDispatcher.class, DispatcherGenerator.PROXY_REF_INSTANCE)};
    private Class cls;
    private CallbackGenerator generator;
    private Type type;

    private CallbackInfo(Class cls, CallbackGenerator generator) {
        this.cls = cls;
        this.generator = generator;
        this.type = Type.getType(cls);
    }

    public static Type[] determineTypes(Class[] callbackTypes) {
        Type[] types = new Type[callbackTypes.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = CallbackInfo.determineType(callbackTypes[i]);
        }
        return types;
    }

    public static Type[] determineTypes(Callback[] callbacks) {
        Type[] types = new Type[callbacks.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = CallbackInfo.determineType(callbacks[i]);
        }
        return types;
    }

    public static CallbackGenerator[] getGenerators(Type[] callbackTypes) {
        CallbackGenerator[] generators = new CallbackGenerator[callbackTypes.length];
        for (int i = 0; i < generators.length; ++i) {
            generators[i] = CallbackInfo.getGenerator(callbackTypes[i]);
        }
        return generators;
    }

    private static Type determineType(Callback callback) {
        if (callback == null) {
            throw new IllegalStateException("Callback is null");
        }
        return CallbackInfo.determineType(callback.getClass());
    }

    private static Type determineType(Class callbackType) {
        Class cur = null;
        for (int i = 0; i < CALLBACKS.length; ++i) {
            CallbackInfo info = CALLBACKS[i];
            if (!info.cls.isAssignableFrom(callbackType)) continue;
            if (cur != null) {
                throw new IllegalStateException("Callback implements both " + cur + " and " + info.cls);
            }
            cur = info.cls;
        }
        if (cur == null) {
            throw new IllegalStateException("Unknown callback type " + callbackType);
        }
        return Type.getType(cur);
    }

    private static CallbackGenerator getGenerator(Type callbackType) {
        for (int i = 0; i < CALLBACKS.length; ++i) {
            CallbackInfo info = CALLBACKS[i];
            if (!info.type.equals(callbackType)) continue;
            return info.generator;
        }
        throw new IllegalStateException("Unknown callback type " + callbackType);
    }
}

