/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.mockito.internal.verification;

import org.mockito.Mockito;
import org.powermock.api.mockito.internal.invocation.MockitoNewInvocationControl;
import org.powermock.api.mockito.invocation.MockitoMethodInvocationControl;
import org.powermock.core.MockRepository;

public class VerifyNoMoreInteractions {
    public static void verifyNoMoreInteractions(Object ... objects) {
        for (Object mock : objects) {
            if (mock instanceof Class) {
                VerifyNoMoreInteractions.verifyNoMoreInteractions((Class)mock);
                continue;
            }
            MockitoMethodInvocationControl invocationControl = (MockitoMethodInvocationControl)MockRepository.getInstanceMethodInvocationControl((Object)mock);
            if (invocationControl != null) {
                invocationControl.verifyNoMoreInteractions();
                continue;
            }
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{mock});
        }
    }

    private static void verifyNoMoreInteractions(Class<?> ... types) {
        for (Class<?> type : types) {
            MockitoNewInvocationControl newInvocationControl;
            MockitoMethodInvocationControl invocationHandler = (MockitoMethodInvocationControl)MockRepository.getStaticMethodInvocationControl(type);
            if (invocationHandler != null) {
                invocationHandler.verifyNoMoreInteractions();
            }
            if ((newInvocationControl = (MockitoNewInvocationControl)MockRepository.getNewInstanceControl(type)) == null) continue;
            newInvocationControl.verifyNoMoreInteractions();
        }
    }
}

