/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.modules.agent.support;

import org.powermock.core.MockRepository;
import org.powermock.core.agent.JavaAgentClassRegister;
import org.powermock.modules.agent.PowerMockClassRedefiner;
import org.powermock.tests.utils.impl.MockPolicyInitializerImpl;
import org.powermock.tests.utils.impl.PowerMockIgnorePackagesExtractorImpl;
import org.powermock.tests.utils.impl.PrepareForTestExtractorImpl;
import org.powermock.tests.utils.impl.StaticConstructorSuppressExtractorImpl;

public class PowerMockAgentTestInitializer {
    public static void initialize(Class<?> testClass, JavaAgentClassRegister agentClassRegister) {
        MockRepository.clear();
        PowerMockAgentTestInitializer.redefineClasses(testClass, agentClassRegister);
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        new MockPolicyInitializerImpl(testClass).initialize(contextClassLoader);
    }

    private static void redefineClasses(Class<?> testClass, JavaAgentClassRegister agentClassRegister) {
        String[] packagesToIgnore = new PowerMockIgnorePackagesExtractorImpl().getPackagesToIgnore(testClass);
        PowerMockAgentTestInitializer.redefineClassesToPrepare(testClass, packagesToIgnore, agentClassRegister);
        PowerMockAgentTestInitializer.redefineClassesToSuppress(testClass, packagesToIgnore, agentClassRegister);
    }

    private static void redefineClassesToSuppress(Class<?> testClass, String[] packagesToIgnore, JavaAgentClassRegister agentClassRegister) {
        String[] classesToSuppress = new StaticConstructorSuppressExtractorImpl().getTestClasses(testClass);
        PowerMockAgentTestInitializer.redefine(classesToSuppress, packagesToIgnore, agentClassRegister);
    }

    private static void redefineClassesToPrepare(Class<?> testClass, String[] packagesToIgnore, JavaAgentClassRegister agentClassRegister) {
        String[] classesToPrepare = new PrepareForTestExtractorImpl(true).getTestClasses(testClass);
        PowerMockAgentTestInitializer.redefine(classesToPrepare, packagesToIgnore, agentClassRegister);
    }

    private static void redefine(String[] classes, String[] packagesToIgnore, JavaAgentClassRegister agentClassRegister) {
        PowerMockClassRedefiner.redefine(classes, packagesToIgnore, agentClassRegister);
    }
}

