/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.modules.agent;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javassist.ClassPool;
import javassist.CtClass;
import org.powermock.core.agent.JavaAgentClassRegister;
import org.powermock.core.transformers.ClassWrapper;
import org.powermock.core.transformers.ClassWrapperFactory;
import org.powermock.core.transformers.MockTransformerChain;
import org.powermock.core.transformers.TransformStrategy;
import org.powermock.core.transformers.javassist.JavassistMockTransformerChainFactory;
import org.powermock.core.transformers.javassist.support.JavaAssistClassWrapperFactory;
import org.powermock.modules.agent.AbstractClassTransformer;

class PowerMockClassTransformer
extends AbstractClassTransformer
implements ClassFileTransformer {
    private static final MockTransformerChain MOCK_TRANSFORMER_CHAIN = new JavassistMockTransformerChainFactory().createDefaultChain(TransformStrategy.INST_REDEFINE);
    private final ClassWrapperFactory wrapperFactory = new JavaAssistClassWrapperFactory();
    private volatile Set<String> classesToTransform;
    private volatile JavaAgentClassRegister javaAgentClassRegister;

    PowerMockClassTransformer() {
    }

    public void setClassesToTransform(Collection<String> classesToTransform) {
        this.classesToTransform = new HashSet<String>(classesToTransform);
    }

    public void setJavaAgentClassRegister(JavaAgentClassRegister javaAgentClassRegister) {
        this.javaAgentClassRegister = javaAgentClassRegister;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        if (loader == null || this.shouldIgnore(className)) {
            return null;
        }
        try {
            String normalizedClassName = className.replace("/", ".");
            if (this.classesToTransform != null && this.classesToTransform.contains(normalizedClassName)) {
                CtClass ctClass = this.getCtClass(classfileBuffer);
                ctClass = this.transform(ctClass);
                ctClass.detach();
                this.javaAgentClassRegister.registerClass(loader, normalizedClassName);
                return ctClass.toBytecode();
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to redefine class " + className, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CtClass getCtClass(byte[] classfileBuffer) throws IOException {
        CtClass ctClass;
        ByteArrayInputStream is = new ByteArrayInputStream(classfileBuffer);
        try {
            ctClass = ClassPool.getDefault().makeClass((InputStream)is);
        }
        finally {
            is.close();
        }
        return ctClass;
    }

    private CtClass transform(CtClass ctClass) throws Exception {
        ClassWrapper wrapped = this.wrapperFactory.wrap((Object)ctClass);
        wrapped = MOCK_TRANSFORMER_CHAIN.transform(wrapped);
        return (CtClass)wrapped.unwrap();
    }
}

