/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.modules.junit4.common.internal.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.junit.Test;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.manipulation.Sortable;
import org.junit.runner.manipulation.Sorter;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.powermock.core.reporter.MockingFrameworkReporter;
import org.powermock.core.spi.PowerMockTestListener;
import org.powermock.core.spi.testresult.TestSuiteResult;
import org.powermock.core.spi.testresult.impl.TestSuiteResultImpl;
import org.powermock.modules.junit4.common.internal.JUnit4TestSuiteChunker;
import org.powermock.modules.junit4.common.internal.PowerMockJUnitRunnerDelegate;
import org.powermock.modules.junit4.common.internal.impl.JUnit4TestMethodChecker;
import org.powermock.modules.junit4.common.internal.impl.PowerMockJUnit4RunListener;
import org.powermock.tests.utils.PowerMockTestNotifier;
import org.powermock.tests.utils.TestChunk;
import org.powermock.tests.utils.impl.AbstractTestSuiteChunkerImpl;
import org.powermock.tests.utils.impl.PowerMockTestNotifierImpl;

public class JUnit4TestSuiteChunkerImpl
extends AbstractTestSuiteChunkerImpl<PowerMockJUnitRunnerDelegate>
implements JUnit4TestSuiteChunker,
Filterable,
Sortable {
    private static final Class<? extends Annotation> testMethodAnnotation = Test.class;
    private Description description;
    private final Class<? extends PowerMockJUnitRunnerDelegate> runnerDelegateImplementationType;

    public JUnit4TestSuiteChunkerImpl(Class<?> testClass, Class<? extends PowerMockJUnitRunnerDelegate> runnerDelegateImplementationType) throws Exception {
        super(testClass);
        if (testClass == null) {
            throw new IllegalArgumentException("You must supply a test class");
        }
        if (runnerDelegateImplementationType == null) {
            throw new IllegalArgumentException("Runner delegate type cannot be null.");
        }
        this.runnerDelegateImplementationType = runnerDelegateImplementationType;
        try {
            this.createTestDelegators(testClass, this.getTestChunksEntries(testClass));
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(RunNotifier notifier) {
        List chunkEntries = this.getTestChunks();
        Iterator iterator = chunkEntries.iterator();
        if (this.delegates.size() != this.getChunkSize()) {
            throw new IllegalStateException("Internal error: There must be an equal number of suites and delegates.");
        }
        Class testClass = this.getTestClasses()[0];
        PowerMockTestListener[] powerMockTestListeners = (PowerMockTestListener[])this.getPowerMockTestListenersLoadedByASpecificClassLoader(testClass, this.getClass().getClassLoader());
        LinkedHashSet allMethods = new LinkedHashSet();
        for (TestChunk testChunk : this.getTestChunks()) {
            allMethods.addAll(testChunk.getTestMethodsToBeExecutedByThisClassloader());
        }
        Method[] allMethodsAsArray = allMethods.toArray(new Method[allMethods.size()]);
        PowerMockTestNotifierImpl powerMockTestNotifier = new PowerMockTestNotifierImpl(powerMockTestListeners);
        powerMockTestNotifier.notifyBeforeTestSuiteStarted(testClass, allMethodsAsArray);
        int failureCount = 0;
        int successCount = 0;
        int ignoreCount = 0;
        for (PowerMockJUnitRunnerDelegate delegate : this.delegates) {
            TestChunk next = (TestChunk)iterator.next();
            ClassLoader key = next.getClassLoader();
            PowerMockJUnit4RunListener powerMockListener = new PowerMockJUnit4RunListener(key, (PowerMockTestNotifier)powerMockTestNotifier);
            notifier.addListener((RunListener)powerMockListener);
            ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(key);
            try {
                MockingFrameworkReporter mockingFrameworkReporter = this.getMockingFrameworkReporter();
                mockingFrameworkReporter.enable();
                delegate.run(notifier);
                mockingFrameworkReporter.disable();
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
            int failureCountForThisPowerMockListener = powerMockListener.getFailureCount();
            int ignoreCountForThisPowerMockListener = powerMockListener.getIgnoreCount();
            failureCount += failureCountForThisPowerMockListener;
            ignoreCount += ignoreCountForThisPowerMockListener;
            successCount += delegate.getTestCount() - failureCountForThisPowerMockListener - ignoreCountForThisPowerMockListener;
            notifier.removeListener((RunListener)powerMockListener);
        }
        TestSuiteResultImpl testSuiteResult = new TestSuiteResultImpl(failureCount, successCount, this.getTestCount(), ignoreCount);
        powerMockTestNotifier.notifyAfterTestSuiteEnded(testClass, allMethodsAsArray, (TestSuiteResult)testSuiteResult);
    }

    private MockingFrameworkReporter getMockingFrameworkReporter() {
        return this.getFrameworkReporterFactory().create();
    }

    public boolean shouldExecuteTestForMethod(Class<?> testClass, Method potentialTestMethod) {
        return new JUnit4TestMethodChecker(testClass, potentialTestMethod).isTestMethod();
    }

    protected Class<? extends Annotation> testMethodAnnotation() {
        return testMethodAnnotation;
    }

    protected PowerMockJUnitRunnerDelegate createDelegatorFromClassloader(ClassLoader classLoader, Class<?> testClass, List<Method> methodsToTest) throws Exception {
        HashSet<String> methodNames = new HashSet<String>();
        for (Method method : methodsToTest) {
            methodNames.add(method.getName());
        }
        Class<?> testClassLoadedByMockedClassLoader = Class.forName(testClass.getName(), false, classLoader);
        Class<?> powerMockTestListenerArrayType = Class.forName(PowerMockTestListener[].class.getName(), false, classLoader);
        Class<?> delegateClass = Class.forName(this.runnerDelegateImplementationType.getName(), false, classLoader);
        Constructor<?> con = delegateClass.getConstructor(Class.class, String[].class, powerMockTestListenerArrayType);
        return (PowerMockJUnitRunnerDelegate)con.newInstance(testClassLoadedByMockedClassLoader, methodNames.toArray(new String[methodNames.size()]), this.getPowerMockTestListenersLoadedByASpecificClassLoader(testClass, classLoader));
    }

    public synchronized int getTestCount() {
        if (this.testCount == -1) {
            this.testCount = 0;
            for (PowerMockJUnitRunnerDelegate delegate : this.delegates) {
                this.testCount += delegate.getTestCount();
            }
        }
        return this.testCount;
    }

    @Override
    public Description getDescription() {
        if (this.description == null) {
            if (this.delegates.size() == 0) {
                return Description.createTestDescription(this.getClass(), (String)"no tests in this class");
            }
            PowerMockJUnitRunnerDelegate delegate = (PowerMockJUnitRunnerDelegate)this.delegates.get(0);
            this.description = delegate.getDescription();
            for (int i = 1; i < this.delegates.size(); ++i) {
                ArrayList children = ((PowerMockJUnitRunnerDelegate)this.delegates.get(i)).getDescription().getChildren();
                for (Description methodDescription : children) {
                    this.description.addChild(methodDescription);
                }
            }
        }
        return this.description;
    }

    public void filter(Filter filter) throws NoTestsRemainException {
        for (Object delegate : this.delegates) {
            if (!(delegate instanceof Filterable)) continue;
            ((Filterable)delegate).filter(filter);
        }
    }

    public void sort(Sorter sorter) {
        for (Object delegate : this.delegates) {
            if (!(delegate instanceof Sortable)) continue;
            ((Sortable)delegate).sort(sorter);
        }
    }
}

