/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.reflect.internal.primitivesupport;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimitiveWrapper {
    private static final Map<Class<?>, Class<?>> primitiveWrapper = new HashMap();

    public static Class<?>[] toPrimitiveType(Class<?>[] types) {
        if (types == null) {
            throw new IllegalArgumentException("types cannot be null");
        }
        Class[] convertedTypes = new Class[types.length];
        for (int i = 0; i < types.length; ++i) {
            Class<?> originalType = types[i];
            Class<?> primitiveType = primitiveWrapper.get(originalType);
            convertedTypes[i] = primitiveType == null ? originalType : primitiveType;
        }
        return convertedTypes;
    }

    public static Class<?> getPrimitiveFromWrapperType(Class<?> wrapperType) {
        return primitiveWrapper.get(wrapperType);
    }

    public static boolean hasPrimitiveCounterPart(Class<?> type) {
        return primitiveWrapper.containsKey(type);
    }

    static {
        primitiveWrapper.put(Integer.class, Integer.TYPE);
        primitiveWrapper.put(Long.class, Long.TYPE);
        primitiveWrapper.put(Float.class, Float.TYPE);
        primitiveWrapper.put(Double.class, Double.TYPE);
        primitiveWrapper.put(Boolean.class, Boolean.TYPE);
        primitiveWrapper.put(Byte.class, Byte.TYPE);
        primitiveWrapper.put(Short.class, Short.TYPE);
        primitiveWrapper.put(Character.class, Character.TYPE);
    }
}

