/*
 * Decompiled with CFR 0.152.
 */
package lombok.eclipse.handlers;

import lombok.AccessLevel;
import lombok.core.AnnotationValues;
import lombok.core.HandlerPriority;
import lombok.eclipse.EclipseAnnotationHandler;
import lombok.eclipse.EclipseNode;
import lombok.eclipse.handlers.EclipseHandlerUtil;
import lombok.eclipse.handlers.HandleConstructor;
import lombok.eclipse.handlers.HandleEqualsAndHashCode;
import lombok.eclipse.handlers.HandleFieldDefaults;
import lombok.eclipse.handlers.HandleGetter;
import lombok.eclipse.handlers.HandleToString;
import lombok.eclipse.handlers.HandleWither;
import lombok.experimental.NonFinal;
import lombok.experimental.Value;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@HandlerPriority(value=-512)
public class HandleValue
extends EclipseAnnotationHandler<Value> {
    @Override
    public void handle(AnnotationValues<Value> annotation, Annotation ast, EclipseNode annotationNode) {
        boolean notAClass;
        Value ann = annotation.getInstance();
        EclipseNode typeNode = (EclipseNode)annotationNode.up();
        TypeDeclaration typeDecl = null;
        if (typeNode.get() instanceof TypeDeclaration) {
            typeDecl = (TypeDeclaration)typeNode.get();
        }
        int modifiers = typeDecl == null ? 0 : typeDecl.modifiers;
        boolean bl = notAClass = (modifiers & 0x6200) != 0;
        if (typeDecl == null || notAClass) {
            annotationNode.addError("@Value is only supported on a class.");
            return;
        }
        if (!EclipseHandlerUtil.hasAnnotation(NonFinal.class, typeNode) && (typeDecl.modifiers & 0x10) == 0) {
            typeDecl.modifiers |= 0x10;
            typeNode.rebuild();
        }
        new HandleFieldDefaults().generateFieldDefaultsForType(typeNode, annotationNode, AccessLevel.PRIVATE, true, true);
        new HandleGetter().generateGetterForType(typeNode, annotationNode, AccessLevel.PUBLIC, true);
        new HandleWither().generateWitherForType(typeNode, annotationNode, AccessLevel.PUBLIC, true);
        new HandleEqualsAndHashCode().generateEqualsAndHashCodeForType(typeNode, annotationNode);
        new HandleToString().generateToStringForType(typeNode, annotationNode);
        new HandleConstructor().generateAllArgsConstructor(typeNode, AccessLevel.PUBLIC, ann.staticConstructor(), true, (ASTNode)ast);
    }
}

