/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.circuitbreaker.jmx;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.text.DateFormat;
import java.util.Date;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import org.qi4j.library.circuitbreaker.CircuitBreaker;
import org.qi4j.library.circuitbreaker.jmx.CircuitBreakerJMXMBean;

public class CircuitBreakerJMX
extends NotificationBroadcasterSupport
implements CircuitBreakerJMXMBean {
    CircuitBreaker circuitBreaker;

    public CircuitBreakerJMX(CircuitBreaker circuitBreaker, final ObjectName mbeanObjectName) {
        super(new MBeanNotificationInfo(new String[]{"serviceLevel", "status"}, Notification.class.getName(), "Circuit breaker notifications"));
        this.circuitBreaker = circuitBreaker;
        circuitBreaker.addPropertyChangeListener(new PropertyChangeListener(){
            long sequenceNr = System.currentTimeMillis();

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Notification notification = new Notification(evt.getPropertyName(), mbeanObjectName, this.sequenceNr++, System.currentTimeMillis(), evt.getNewValue().toString());
                CircuitBreakerJMX.this.sendNotification(notification);
            }
        });
    }

    @Override
    public String getStatus() {
        return this.circuitBreaker.status().name();
    }

    @Override
    public int getThreshold() {
        return this.circuitBreaker.threshold();
    }

    @Override
    public double getServiceLevel() {
        return this.circuitBreaker.serviceLevel();
    }

    @Override
    public String getLastErrorMessage() {
        return this.circuitBreaker.lastThrowable() == null ? "" : this.errorMessage(this.circuitBreaker.lastThrowable());
    }

    private String errorMessage(Throwable throwable) {
        String message = throwable.getMessage();
        if (message == null) {
            message = throwable.getClass().getSimpleName();
        }
        if (throwable.getCause() != null) {
            return message + ":" + this.errorMessage(throwable.getCause());
        }
        return message;
    }

    @Override
    public String getTrippedOn() {
        Date trippedOn = this.circuitBreaker.trippedOn();
        return trippedOn == null ? "" : DateFormat.getDateTimeInstance().format(trippedOn);
    }

    @Override
    public String getEnableOn() {
        Date trippedOn = this.circuitBreaker.enabledOn();
        return trippedOn == null ? "" : DateFormat.getDateTimeInstance().format(trippedOn);
    }

    @Override
    public String turnOn() {
        try {
            this.circuitBreaker.turnOn();
            return "Circuit breaker has been turned on";
        }
        catch (PropertyVetoException e) {
            return "Could not turn on circuit breaker:" + this.getLastErrorMessage();
        }
    }

    @Override
    public void trip() {
        this.circuitBreaker.trip();
    }
}

