/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SchedulerDetailsSetter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchedulerDetailsSetter.class);

    private SchedulerDetailsSetter() {
    }

    static void setDetails(Object target, String schedulerName, String schedulerId) throws SchedulerException {
        SchedulerDetailsSetter.set(target, "setInstanceName", schedulerName);
        SchedulerDetailsSetter.set(target, "setInstanceId", schedulerId);
    }

    private static void set(Object target, String method, String value) throws SchedulerException {
        Method setter;
        try {
            setter = target.getClass().getMethod(method, String.class);
        }
        catch (SecurityException e) {
            LOGGER.error("A SecurityException occured: {}", (Object)e.getMessage(), (Object)e);
            return;
        }
        catch (NoSuchMethodException e) {
            LOGGER.warn("{} does not contain public method {}(String)", (Object)target.getClass().getName(), (Object)method);
            return;
        }
        if (Modifier.isAbstract(setter.getModifiers())) {
            LOGGER.warn("{} does not implement {}(String)", (Object)target.getClass().getName(), (Object)method);
            return;
        }
        try {
            setter.invoke(target, value);
        }
        catch (InvocationTargetException ite) {
            throw new SchedulerException(ite.getTargetException());
        }
        catch (Exception e) {
            throw new SchedulerException(e);
        }
    }
}

