/*
 * Decompiled with CFR 0.152.
 */
package org.raml.yagi.framework.util;

import org.joda.time.DateTimeFieldType;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.ISODateTimeFormat;
import org.raml.yagi.framework.util.DateType;

public class DateUtils {
    public static final String DATE_ONLY_FOUR_DIGITS_YEAR_LENGTH_VALIDATION = "yagi.date_only_four_digits_year_length_validation";
    public static boolean FOUR_YEARS_VALIDATION = Boolean.valueOf(System.getProperty("yagi.date_only_four_digits_year_length_validation", "true"));
    private static DateTimeFormatter dateOnlyFormatter;
    private static DateTimeFormatter timeOnlyFormatter;
    private static DateTimeFormatter dateTimeOnlyFormatterNoMillis;
    private static DateTimeFormatter dateTimeOnlyFormatterMillis;
    private static DateTimeFormatter rfc2616Formatter;
    private static DateTimeFormatter rfc3339FormatterMillis;
    private static DateTimeFormatter rfc3339FormatterNoMillis;

    public static void setFormatters() {
        dateOnlyFormatter = DateUtils.yearFormat().append(DateTimeFormat.forPattern((String)"-MM-dd")).toFormatter();
        timeOnlyFormatter = DateTimeFormat.forPattern((String)"HH:mm:ss");
        String dateTimePattern = "-MM-DD'T'HH:mm:ss";
        dateTimeOnlyFormatterNoMillis = DateUtils.yearFormat().append(DateTimeFormat.forPattern((String)dateTimePattern)).toFormatter();
        dateTimeOnlyFormatterMillis = DateUtils.yearFormat().append(DateTimeFormat.forPattern((String)dateTimePattern)).appendLiteral(".").appendFractionOfSecond(1, 9).toFormatter();
        rfc2616Formatter = DateTimeFormat.forPattern((String)"EEE, dd MMM yyyy HH:mm:ss zzz");
        rfc3339FormatterMillis = new DateTimeFormatterBuilder().append(DateUtils.yearFormat().append(DateTimeFormat.forPattern((String)"-MM-dd")).toFormatter()).append(ISODateTimeFormat.tTime()).toFormatter();
        rfc3339FormatterNoMillis = new DateTimeFormatterBuilder().append(DateUtils.yearFormat().append(DateTimeFormat.forPattern((String)"-MM-dd")).toFormatter()).append(ISODateTimeFormat.tTimeNoMillis()).toFormatter();
    }

    public static boolean isValidDate(String date, DateType format, String rfc) {
        try {
            switch (format) {
                case date_only: {
                    dateOnlyFormatter.parseLocalDate(date);
                    break;
                }
                case time_only: {
                    timeOnlyFormatter.parseLocalTime(date);
                    break;
                }
                case datetime_only: {
                    try {
                        dateTimeOnlyFormatterNoMillis.parseLocalDateTime(date);
                    }
                    catch (Exception e) {
                        dateTimeOnlyFormatterMillis.parseLocalDateTime(date);
                    }
                    break;
                }
                case datetime: {
                    if (rfc != null && "rfc2616".equals(rfc)) {
                        rfc2616Formatter.parseLocalDateTime(date);
                        break;
                    }
                    try {
                        rfc3339FormatterMillis.parseLocalDateTime(date);
                    }
                    catch (Exception e) {
                        rfc3339FormatterNoMillis.parseLocalDateTime(date);
                    }
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static DateTimeFormatterBuilder yearFormat() {
        if (FOUR_YEARS_VALIDATION) {
            return new DateTimeFormatterBuilder().appendFixedSignedDecimal(DateTimeFieldType.year(), 4);
        }
        return new DateTimeFormatterBuilder().append(DateTimeFormat.forPattern((String)"YYYY"));
    }

    static {
        DateUtils.setFormatters();
    }
}

