/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.hibernate;

import java.util.Map;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.cache.CacheException;
import org.hibernate.engine.jndi.JndiException;
import org.hibernate.engine.jndi.spi.JndiService;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.redisson.api.RedissonClient;
import org.redisson.hibernate.RedissonRegionNativeFactory;

public class JndiRedissonRegionNativeFactory
extends RedissonRegionNativeFactory {
    private static final long serialVersionUID = -4814502675083325567L;
    public static final String JNDI_NAME = "hibernate.cache.redisson.jndi_name";

    @Override
    protected RedissonClient createRedissonClient(StandardServiceRegistry registry, Map properties) {
        String jndiName = ConfigurationHelper.getString((String)JNDI_NAME, (Map)properties);
        if (jndiName == null) {
            throw new CacheException("hibernate.cache.redisson.jndi_name property not set");
        }
        try {
            return (RedissonClient)((JndiService)registry.getService(JndiService.class)).locate(jndiName);
        }
        catch (JndiException e) {
            throw new CacheException((Throwable)e);
        }
    }

    @Override
    protected void releaseFromUse() {
    }
}

