/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bpel.ui.bpel2svg.impl;

import java.util.Iterator;
import org.apache.axiom.om.OMElement;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;
import org.wso2.carbon.bpel.ui.bpel2svg.ActivityInterface;
import org.wso2.carbon.bpel.ui.bpel2svg.BPEL2SVGFactory;
import org.wso2.carbon.bpel.ui.bpel2svg.FlowInterface;
import org.wso2.carbon.bpel.ui.bpel2svg.SVGCoordinates;
import org.wso2.carbon.bpel.ui.bpel2svg.SVGDimension;
import org.wso2.carbon.bpel.ui.bpel2svg.impl.ActivityImpl;

public class FlowImpl
extends ActivityImpl
implements FlowInterface {
    public FlowImpl(String token) {
        super(token);
        this.startIconPath = BPEL2SVGFactory.getInstance().getIconPath(this.getClass().getName());
        this.endIconPath = BPEL2SVGFactory.getInstance().getEndIconPath(this.getClass().getName());
        this.setVerticalChildLayout(false);
    }

    public FlowImpl(OMElement omElement) {
        super(omElement);
        this.startIconPath = BPEL2SVGFactory.getInstance().getIconPath(this.getClass().getName());
        this.endIconPath = BPEL2SVGFactory.getInstance().getEndIconPath(this.getClass().getName());
        this.setVerticalChildLayout(false);
    }

    public FlowImpl(OMElement omElement, ActivityInterface parent) {
        super(omElement);
        this.setParent(parent);
        this.startIconPath = BPEL2SVGFactory.getInstance().getIconPath(this.getClass().getName());
        this.endIconPath = BPEL2SVGFactory.getInstance().getEndIconPath(this.getClass().getName());
    }

    public String getId() {
        return this.getName();
    }

    public String getEndTag() {
        return "/flow";
    }

    public SVGDimension getDimensions() {
        if (this.dimensions == null) {
            int width = 0;
            int height = 0;
            this.dimensions = new SVGDimension(width, height);
            SVGDimension subActivityDim = null;
            ActivityInterface activity2 = null;
            for (ActivityInterface activity2 : this.getSubActivities()) {
                subActivityDim = activity2.getDimensions();
                if (subActivityDim.getHeight() > height) {
                    height += subActivityDim.getHeight();
                }
                width += subActivityDim.getWidth();
            }
            this.dimensions.setWidth(width += this.getXSpacing());
            this.dimensions.setHeight(height += this.getYSpacing() * 2 + this.getStartIconHeight() + this.getEndIconHeight());
        }
        return this.dimensions;
    }

    public void layout(int startXLeft, int startYTop) {
        if (this.layoutManager.isVerticalLayout()) {
            this.layoutVertical(startXLeft, startYTop);
        } else {
            this.layoutHorizontal(startXLeft, startYTop);
        }
    }

    public void layoutVertical(int startXLeft, int startYTop) {
        int centreOfMyLayout = startXLeft + this.dimensions.getWidth() / 2;
        int xLeft = centreOfMyLayout - this.getStartIconWidth() / 2;
        int yTop = startYTop + this.getYSpacing() / 2;
        int endXLeft = centreOfMyLayout - this.getEndIconWidth() / 2;
        int endYTop = startYTop + this.dimensions.getHeight() - this.getEndIconHeight() - this.getYSpacing() / 2;
        ActivityInterface activity = null;
        Iterator<ActivityInterface> itr = this.getSubActivities().iterator();
        int childYTop = yTop + this.getStartIconHeight() + this.getYSpacing() / 2;
        int childXLeft = startXLeft + this.getXSpacing() / 2;
        while (itr.hasNext()) {
            activity = itr.next();
            activity.layout(childXLeft, childYTop);
            childXLeft += activity.getDimensions().getWidth();
        }
        this.setStartIconXLeft(xLeft);
        this.setStartIconYTop(yTop);
        this.setEndIconXLeft(endXLeft);
        this.setEndIconYTop(endYTop);
        this.setStartIconTextXLeft(startXLeft + 10);
        this.setStartIconTextYTop(startYTop + 10 + 10);
        this.getDimensions().setXLeft(startXLeft);
        this.getDimensions().setYTop(startYTop);
    }

    private void layoutHorizontal(int startXLeft, int startYTop) {
        int centreOfMyLayout = startYTop + this.dimensions.getHeight() / 2;
        int xLeft = startXLeft + this.getYSpacing() / 2;
        int yTop = centreOfMyLayout - this.getStartIconHeight() / 2;
        int endXLeft = startXLeft + this.dimensions.getWidth() - this.getEndIconWidth() - this.getYSpacing() / 2;
        int endYTop = centreOfMyLayout - this.getEndIconHeight() / 2;
        ActivityInterface activity = null;
        Iterator<ActivityInterface> itr = this.getSubActivities().iterator();
        int childXLeft = xLeft + this.getStartIconWidth() + this.getYSpacing() / 2;
        int childYTop = startYTop + this.getXSpacing() / 2;
        while (itr.hasNext()) {
            activity = itr.next();
            activity.layout(childXLeft, childYTop);
            childYTop += activity.getDimensions().getHeight();
        }
        this.setStartIconXLeft(xLeft);
        this.setStartIconYTop(yTop);
        this.setEndIconXLeft(endXLeft);
        this.setEndIconYTop(endYTop);
        this.setStartIconTextXLeft(startXLeft + 10);
        this.setStartIconTextYTop(startYTop + 10 + 10);
        this.getDimensions().setXLeft(startXLeft);
        this.getDimensions().setYTop(startYTop);
    }

    public SVGCoordinates getEntryArrowCoords() {
        int xLeft = 0;
        int yTop = 0;
        if (this.layoutManager.isVerticalLayout()) {
            xLeft = this.getStartIconXLeft() + this.getStartIconWidth() / 2;
            yTop = this.getStartIconYTop();
        } else {
            xLeft = this.getStartIconXLeft();
            yTop = this.getStartIconYTop() + this.getStartIconHeight() / 2;
        }
        SVGCoordinates coords = new SVGCoordinates(xLeft, yTop);
        return coords;
    }

    public SVGCoordinates getExitArrowCoords() {
        int xLeft = 0;
        int yTop = 0;
        if (this.layoutManager.isVerticalLayout()) {
            xLeft = this.getEndIconXLeft() + this.getEndIconWidth() / 2;
            yTop = this.getEndIconYTop() + this.getEndIconHeight();
        } else {
            xLeft = this.getEndIconXLeft() + this.getEndIconWidth();
            yTop = this.getEndIconYTop() + this.getEndIconHeight() / 2;
        }
        SVGCoordinates coords = new SVGCoordinates(xLeft, yTop);
        return coords;
    }

    protected SVGCoordinates getStartIconExitArrowCoords() {
        int xLeft = 0;
        int yTop = 0;
        if (this.layoutManager.isVerticalLayout()) {
            xLeft = this.getStartIconXLeft() + this.getStartIconWidth() / 2;
            yTop = this.getStartIconYTop() + this.getStartIconHeight();
        } else {
            xLeft = this.getStartIconXLeft() + this.getStartIconWidth();
            yTop = this.getStartIconYTop() + this.getStartIconHeight() / 2;
        }
        SVGCoordinates coords = new SVGCoordinates(xLeft, yTop);
        return coords;
    }

    protected SVGCoordinates getEndIconEntryArrowCoords() {
        int xLeft = 0;
        int yTop = 0;
        if (this.layoutManager.isVerticalLayout()) {
            xLeft = this.getEndIconXLeft() + this.getEndIconWidth() / 2;
            yTop = this.getEndIconYTop();
        } else {
            xLeft = this.getEndIconXLeft();
            yTop = this.getEndIconYTop() + this.getEndIconHeight() / 2;
        }
        SVGCoordinates coords = new SVGCoordinates(xLeft, yTop);
        return coords;
    }

    public Element getSVGString(SVGDocument doc) {
        Element group = null;
        group = doc.createElementNS("http://www.w3.org/2000/svg", "g");
        group.setAttributeNS(null, "id", this.getLayerId());
        if (this.isAddOpacity()) {
            group.setAttributeNS(null, "style", "opacity:" + this.getOpacity());
        }
        group.appendChild(this.getBoxDefinition(doc));
        group.appendChild(this.getImageDefinition(doc));
        group.appendChild(this.getStartImageText(doc));
        group.appendChild(this.getSubActivitiesSVGString(doc));
        group.appendChild(this.getEndImageDefinition(doc));
        group.appendChild(this.getArrows(doc));
        return group;
    }

    protected Element getArrows(SVGDocument doc) {
        Element subGroup = null;
        subGroup = doc.createElementNS("http://www.w3.org/2000/svg", "g");
        SVGCoordinates myStartCoords = this.getStartIconExitArrowCoords();
        SVGCoordinates myExitCoords = this.getEndIconEntryArrowCoords();
        subGroup.appendChild(this.getArrowDefinition(doc, myStartCoords.getXLeft(), myStartCoords.getYTop(), myStartCoords.getXLeft(), myStartCoords.getYTop() + 30, "Flow_Top", true));
        subGroup.appendChild(this.getArrowDefinition(doc, myStartCoords.getXLeft() - this.dimensions.getWidth() / 2 + this.getXSpacing(), myStartCoords.getYTop() + 30, myStartCoords.getXLeft() + this.dimensions.getWidth() / 2 - this.getXSpacing(), myStartCoords.getYTop() + 30, "Flow_TopH", true));
        subGroup.appendChild(this.getArrowDefinition(doc, myStartCoords.getXLeft() - this.dimensions.getWidth() / 2 + this.getXSpacing(), myExitCoords.getYTop() - 20, myStartCoords.getXLeft() + this.dimensions.getWidth() / 2 - this.getXSpacing(), myExitCoords.getYTop() - 20, "Flow_DownH", true));
        subGroup.appendChild(this.getArrowDefinition(doc, myExitCoords.getXLeft(), myExitCoords.getYTop() - 20, myExitCoords.getXLeft(), myExitCoords.getYTop(), "Flow_Top", false));
        return subGroup;
    }

    public Element getArrowDefinition(SVGDocument doc, int startX, int startY, int endX, int endY, String id, boolean to) {
        Element path = doc.createElementNS("http://www.w3.org/2000/svg", "path");
        if (startX == endX || startY == endY) {
            path.setAttributeNS(null, "d", "M " + startX + "," + startY + " L " + endX + "," + endY);
        } else if (to) {
            if (this.layoutManager.isVerticalLayout()) {
                path.setAttributeNS(null, "d", "M " + startX + "," + startY + " L " + startX + "," + (startY + 2 * endY) / 3 + " L " + endX + "," + (startY + 2 * endY) / 3);
            } else {
                path.setAttributeNS(null, "d", "M " + startX + "," + startY + " L " + (startX + 1 * endX) / 2 + "," + startY + " L " + (startX + 1 * endX) / 2 + "," + endY);
            }
        } else if (this.layoutManager.isVerticalLayout()) {
            path.setAttributeNS(null, "d", "M " + startX + "," + (startY + 2 * endY) / 3 + " L " + endX + "," + (startY + 2 * endY) / 3 + " L " + endX + "," + endY);
        } else {
            path.setAttributeNS(null, "d", "M " + (startX + 1 * endX) / 2 + "," + startY + " L " + (startX + 1 * endX) / 2 + "," + endY + " L " + endX + "," + endY);
        }
        path.setAttributeNS(null, "id", id);
        path.setAttributeNS(null, "style", this.getArrowStyle(to));
        return path;
    }

    private String getArrowStyle(boolean to) {
        if (to) {
            String largeArrowStr = "fill:none;fill-rule:evenodd;stroke:#000000;stroke-width:1.0;stroke-linecap:butt;stroke-linejoin:round;stroke-miterlimit:4;stroke-dasharray:none;stroke-opacity:1";
            String mediumArrowStr = "fill:none;fill-rule:evenodd;stroke:#000000;stroke-width:1.0;stroke-linecap:butt;stroke-linejoin:round;stroke-miterlimit:4;stroke-dasharray:none;stroke-opacity:1";
            if (this.isLargeArrow()) {
                return largeArrowStr;
            }
            return mediumArrowStr;
        }
        String largeArrowStr = "fill:none;fill-rule:evenodd;stroke:#000000;stroke-width:1.0;stroke-linecap:butt;stroke-linejoin:round;marker-end:url(#Arrow1Lend);stroke-miterlimit:4;stroke-dasharray:none;stroke-opacity:1";
        String mediumArrowStr = "fill:none;fill-rule:evenodd;stroke:#000000;stroke-width:1.0;stroke-linecap:butt;stroke-linejoin:round;marker-end:url(#Arrow1Mend);stroke-miterlimit:4;stroke-dasharray:none;stroke-opacity:1";
        if (this.isLargeArrow()) {
            return largeArrowStr;
        }
        return mediumArrowStr;
    }

    public boolean isAddOpacity() {
        return this.isAddCompositeActivityOpacity();
    }

    public double getOpacity() {
        return this.getCompositeOpacity();
    }
}

