/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bpel.ui.bpel2svg.impl;

import java.util.Iterator;
import org.apache.axiom.om.OMElement;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;
import org.wso2.carbon.bpel.ui.bpel2svg.ActivityInterface;
import org.wso2.carbon.bpel.ui.bpel2svg.BPEL2SVGFactory;
import org.wso2.carbon.bpel.ui.bpel2svg.ElseIfInterface;
import org.wso2.carbon.bpel.ui.bpel2svg.SVGCoordinates;
import org.wso2.carbon.bpel.ui.bpel2svg.SVGDimension;
import org.wso2.carbon.bpel.ui.bpel2svg.impl.ActivityImpl;

public class ElseIfImpl
extends ActivityImpl
implements ElseIfInterface {
    public ElseIfImpl(String token) {
        super(token);
        this.startIconPath = BPEL2SVGFactory.getInstance().getIconPath(this.getClass().getName());
        this.endIconPath = BPEL2SVGFactory.getInstance().getEndIconPath(this.getClass().getName());
    }

    public ElseIfImpl(OMElement omElement) {
        super(omElement);
        this.startIconPath = BPEL2SVGFactory.getInstance().getIconPath(this.getClass().getName());
        this.endIconPath = BPEL2SVGFactory.getInstance().getEndIconPath(this.getClass().getName());
    }

    public ElseIfImpl(OMElement omElement, ActivityInterface parent) {
        super(omElement);
        this.setParent(parent);
        this.startIconPath = BPEL2SVGFactory.getInstance().getIconPath(this.getClass().getName());
        this.endIconPath = BPEL2SVGFactory.getInstance().getEndIconPath(this.getClass().getName());
    }

    public String getId() {
        return this.getName();
    }

    public String getEndTag() {
        return "/elseif";
    }

    public SVGDimension getDimensions() {
        if (this.dimensions == null) {
            int width = 0;
            int height = 0;
            this.dimensions = new SVGDimension(width, height);
            SVGDimension subActivityDim = null;
            ActivityInterface activity2 = null;
            for (ActivityInterface activity2 : this.getSubActivities()) {
                subActivityDim = activity2.getDimensions();
                if (subActivityDim.getWidth() > width) {
                    width += subActivityDim.getWidth();
                }
                height += subActivityDim.getHeight();
            }
            this.dimensions.setWidth(width += this.getXSpacing());
            this.dimensions.setHeight(height += this.getYSpacing() + this.getStartIconHeight());
        }
        return this.dimensions;
    }

    public void layout(int startXLeft, int startYTop) {
        if (this.layoutManager.isVerticalLayout()) {
            this.layoutVertical(startXLeft, startYTop);
        } else {
            this.layoutHorizontal(startXLeft, startYTop);
        }
    }

    public void layoutVertical(int startXLeft, int startYTop) {
        int centreOfMyLayout = startXLeft + this.dimensions.getWidth() / 2;
        int xLeft = centreOfMyLayout - this.getStartIconWidth() / 2;
        int yTop = startYTop + this.getYSpacing() / 2;
        ActivityInterface activity = null;
        Iterator<ActivityInterface> itr = this.getSubActivities().iterator();
        int childYTop = yTop + this.getStartIconHeight() + this.getYSpacing() / 2;
        int childXLeft = startXLeft;
        while (itr.hasNext()) {
            activity = itr.next();
            childXLeft = centreOfMyLayout - activity.getDimensions().getWidth() / 2;
            activity.layout(childXLeft, childYTop);
            childYTop += activity.getDimensions().getHeight();
        }
        this.setStartIconXLeft(xLeft);
        this.setStartIconYTop(yTop);
        this.setStartIconTextXLeft(startXLeft + 10);
        this.setStartIconTextYTop(startYTop + 10 + 10);
        this.getDimensions().setXLeft(startXLeft);
        this.getDimensions().setYTop(startYTop);
    }

    public void layoutHorizontal(int startXLeft, int startYTop) {
        int centreOfMyLayout = startYTop + this.dimensions.getHeight() / 2;
        int xLeft = startXLeft + this.getYSpacing() / 2;
        int yTop = centreOfMyLayout - this.getStartIconHeight() / 2;
        ActivityInterface activity = null;
        Iterator<ActivityInterface> itr = this.getSubActivities().iterator();
        int childYTop = yTop;
        int childXLeft = xLeft + this.getStartIconWidth() + this.getYSpacing() / 2;
        while (itr.hasNext()) {
            activity = itr.next();
            childYTop = centreOfMyLayout - activity.getDimensions().getHeight() / 2;
            activity.layout(childXLeft, childYTop);
            childXLeft += activity.getDimensions().getWidth();
        }
        this.setStartIconXLeft(xLeft);
        this.setStartIconYTop(yTop);
        this.setStartIconTextXLeft(startXLeft + 10);
        this.setStartIconTextYTop(startYTop + 10 + 10);
        this.getDimensions().setXLeft(startXLeft);
        this.getDimensions().setYTop(startYTop);
    }

    public SVGCoordinates getEntryArrowCoords() {
        int xLeft = 0;
        int yTop = 0;
        if (this.layoutManager.isVerticalLayout()) {
            xLeft = this.getStartIconXLeft();
            yTop = this.getStartIconYTop() + this.getStartIconHeight() / 2;
        } else {
            xLeft = this.getStartIconXLeft() + this.getStartIconWidth() / 2;
            yTop = this.getStartIconYTop();
        }
        SVGCoordinates coords = new SVGCoordinates(xLeft, yTop);
        return coords;
    }

    public SVGCoordinates getExitArrowCoords() {
        SVGCoordinates coords = this.getStartIconExitArrowCoords();
        if (this.subActivities != null && this.subActivities.size() > 0) {
            ActivityInterface activity = (ActivityInterface)this.subActivities.get(this.subActivities.size() - 1);
            coords = activity.getExitArrowCoords();
        }
        return coords;
    }

    protected SVGCoordinates getStartIconExitArrowCoords() {
        int xLeft = 0;
        int yTop = 0;
        if (this.layoutManager.isVerticalLayout()) {
            xLeft = this.getStartIconXLeft() + this.getStartIconWidth() / 2;
            yTop = this.getStartIconYTop() + this.getStartIconHeight();
        } else {
            xLeft = this.getStartIconXLeft() + this.getStartIconWidth();
            yTop = this.getStartIconYTop() + this.getStartIconHeight() / 2;
        }
        SVGCoordinates coords = new SVGCoordinates(xLeft, yTop);
        return coords;
    }

    public SVGCoordinates getNextElseExitArrowCoords() {
        int xLeft = 0;
        int yTop = 0;
        if (this.layoutManager.isVerticalLayout()) {
            xLeft = this.getStartIconXLeft() + this.getStartIconWidth();
            yTop = this.getStartIconYTop() + this.getStartIconHeight() / 2;
        } else {
            xLeft = this.getStartIconXLeft() + this.getStartIconWidth() / 2;
            yTop = this.getStartIconYTop() + this.getStartIconHeight();
        }
        SVGCoordinates coords = new SVGCoordinates(xLeft, yTop);
        return coords;
    }

    public Element getSVGString(SVGDocument doc) {
        Element group1 = null;
        group1 = doc.createElementNS("http://www.w3.org/2000/svg", "g");
        group1.setAttributeNS(null, "id", this.getLayerId());
        if (this.isAddOpacity()) {
            group1.setAttributeNS(null, "style", "opacity:" + this.getOpacity());
        }
        group1.appendChild(this.getBoxDefinition(doc));
        group1.appendChild(this.getImageDefinition(doc));
        group1.appendChild(this.getSubActivitiesSVGString(doc));
        group1.appendChild(this.getArrows(doc));
        return group1;
    }

    protected Element getArrows(SVGDocument doc) {
        if (this.subActivities != null) {
            ActivityInterface prevActivity = null;
            ActivityInterface activity = null;
            String id = null;
            SVGCoordinates myStartCoords = this.getStartIconExitArrowCoords();
            SVGCoordinates exitCoords = null;
            SVGCoordinates entryCoords = null;
            Iterator itr = this.subActivities.iterator();
            if (itr.hasNext()) {
                activity = (ActivityInterface)itr.next();
                if (prevActivity != null) {
                    exitCoords = prevActivity.getExitArrowCoords();
                    entryCoords = activity.getEntryArrowCoords();
                    id = prevActivity.getId() + "-" + activity.getId();
                    return this.getArrowDefinition(doc, exitCoords.getXLeft(), exitCoords.getYTop(), entryCoords.getXLeft(), entryCoords.getYTop(), id, prevActivity, activity);
                }
                entryCoords = activity.getExitArrowCoords();
                return this.getArrowDefinition(doc, myStartCoords.getXLeft(), myStartCoords.getYTop(), entryCoords.getXLeft(), entryCoords.getYTop(), id, this, activity);
            }
        }
        return null;
    }

    public boolean isAddOpacity() {
        return this.isAddCompositeActivityOpacity();
    }

    public double getOpacity() {
        return this.getCompositeOpacity();
    }
}

