/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bpel.ui.bpel2svg.impl;

import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;
import org.wso2.carbon.bpel.ui.bpel2svg.ActivityInterface;
import org.wso2.carbon.bpel.ui.bpel2svg.BPEL2SVGFactory;
import org.wso2.carbon.bpel.ui.bpel2svg.OnMessageInterface;
import org.wso2.carbon.bpel.ui.bpel2svg.SVGCoordinates;
import org.wso2.carbon.bpel.ui.bpel2svg.SVGDimension;
import org.wso2.carbon.bpel.ui.bpel2svg.impl.ActivityImpl;

public class OnMessageImpl
extends ActivityImpl
implements OnMessageInterface {
    public OnMessageImpl(String token) {
        int opIndex;
        String partnerLink = "";
        String operation = "";
        int plIndex = token.indexOf("partnerLink");
        int firstQuoteIndex = 0;
        int lastQuoteIndex = 0;
        if (plIndex >= 0 && (firstQuoteIndex = token.indexOf("\"", plIndex + 1)) >= 0 && (lastQuoteIndex = token.indexOf("\"", firstQuoteIndex + 1)) > firstQuoteIndex) {
            partnerLink = token.substring(firstQuoteIndex + 1, lastQuoteIndex);
        }
        if ((opIndex = token.indexOf("operation")) >= 0 && (firstQuoteIndex = token.indexOf("\"", opIndex + 1)) >= 0 && (lastQuoteIndex = token.indexOf("\"", firstQuoteIndex + 1)) > firstQuoteIndex) {
            operation = token.substring(firstQuoteIndex + 1, lastQuoteIndex);
            this.setDisplayName(operation);
        }
        this.setName(partnerLink + "." + operation);
        this.startIconPath = BPEL2SVGFactory.getInstance().getIconPath(this.getClass().getName());
        this.endIconPath = BPEL2SVGFactory.getInstance().getEndIconPath(this.getClass().getName());
    }

    public OnMessageImpl(OMElement omElement) {
        super(omElement);
        String partnerLink = null;
        String operation = null;
        if (omElement.getAttribute(new QName("partnerLink")) != null) {
            partnerLink = new String(omElement.getAttribute(new QName("partnerLink")).getAttributeValue());
        }
        if (omElement.getAttribute(new QName("operation")) != null) {
            operation = new String(omElement.getAttribute(new QName("operation")).getAttributeValue());
        }
        this.setName(partnerLink + "." + operation);
        this.startIconPath = BPEL2SVGFactory.getInstance().getIconPath(this.getClass().getName());
        this.endIconPath = BPEL2SVGFactory.getInstance().getEndIconPath(this.getClass().getName());
    }

    public OnMessageImpl(OMElement omElement, ActivityInterface parent) {
        super(omElement);
        this.setParent(parent);
        String partnerLink = null;
        String operation = null;
        if (omElement.getAttribute(new QName("partnerLink")) != null) {
            partnerLink = new String(omElement.getAttribute(new QName("partnerLink")).getAttributeValue());
        }
        if (omElement.getAttribute(new QName("operation")) != null) {
            operation = new String(omElement.getAttribute(new QName("operation")).getAttributeValue());
        }
        this.setName(partnerLink + "." + operation);
        this.startIconPath = BPEL2SVGFactory.getInstance().getIconPath(this.getClass().getName());
        this.endIconPath = BPEL2SVGFactory.getInstance().getEndIconPath(this.getClass().getName());
    }

    public String getId() {
        return this.getName();
    }

    public String getEndTag() {
        return "/onMessage";
    }

    public SVGDimension getDimensions() {
        if (this.dimensions == null) {
            int width = 0;
            int height = 0;
            this.dimensions = new SVGDimension(width, height);
            SVGDimension subActivityDim = null;
            ActivityInterface activity2 = null;
            for (ActivityInterface activity2 : this.getSubActivities()) {
                subActivityDim = activity2.getDimensions();
                if (subActivityDim.getWidth() > width) {
                    width += subActivityDim.getWidth();
                }
                height += subActivityDim.getHeight();
            }
            this.dimensions.setWidth(width += this.getXSpacing());
            this.dimensions.setHeight(height += this.getYSpacing() + this.getStartIconHeight() + this.getYSpacing() / 2);
        }
        return this.dimensions;
    }

    public void layout(int startXLeft, int startYTop) {
        if (this.layoutManager.isVerticalLayout()) {
            this.layoutVertical(startXLeft, startYTop);
        } else {
            this.layoutHorizontal(startXLeft, startYTop);
        }
    }

    public void layoutVertical(int startXLeft, int startYTop) {
        int centreOfMyLayout = startXLeft + this.dimensions.getWidth() / 2;
        int xLeft = centreOfMyLayout - this.getStartIconWidth() / 2;
        int yTop = startYTop + this.getYSpacing() / 2;
        ActivityInterface activity = null;
        Iterator<ActivityInterface> itr = this.getSubActivities().iterator();
        int childYTop = yTop + this.getStartIconHeight() + this.getYSpacing() / 2;
        int childXLeft = startXLeft;
        while (itr.hasNext()) {
            activity = itr.next();
            childXLeft = centreOfMyLayout - activity.getDimensions().getWidth() / 2;
            activity.layout(childXLeft, childYTop);
            childYTop += activity.getDimensions().getHeight();
        }
        this.setStartIconXLeft(xLeft);
        this.setStartIconYTop(yTop);
        this.setStartIconTextXLeft(startXLeft + 10);
        this.setStartIconTextYTop(startYTop + 10 + 10);
        this.getDimensions().setXLeft(startXLeft);
        this.getDimensions().setYTop(startYTop);
    }

    public void layoutHorizontal(int startXLeft, int startYTop) {
        int centreOfMyLayout = startYTop + this.dimensions.getHeight() / 2;
        int xLeft = startXLeft + this.getYSpacing() / 2;
        int yTop = centreOfMyLayout - this.getStartIconHeight() / 2;
        ActivityInterface activity = null;
        Iterator<ActivityInterface> itr = this.getSubActivities().iterator();
        int childYTop = yTop;
        int childXLeft = xLeft + this.getStartIconWidth() + this.getYSpacing() / 2;
        while (itr.hasNext()) {
            activity = itr.next();
            childYTop = centreOfMyLayout - activity.getDimensions().getHeight() / 2;
            activity.layout(childXLeft, childYTop);
            childXLeft += activity.getDimensions().getWidth();
        }
        this.setStartIconXLeft(xLeft);
        this.setStartIconYTop(yTop);
        this.setStartIconTextXLeft(startXLeft + 10);
        this.setStartIconTextYTop(startYTop + 10 + 10);
        this.getDimensions().setXLeft(startXLeft);
        this.getDimensions().setYTop(startYTop);
    }

    public SVGCoordinates getEntryArrowCoords() {
        int xLeft = 0;
        int yTop = 0;
        if (this.layoutManager.isVerticalLayout()) {
            xLeft = this.getStartIconXLeft() + this.getStartIconWidth() / 2;
            yTop = this.getStartIconYTop();
        } else {
            xLeft = this.getStartIconXLeft();
            yTop = this.getStartIconYTop() + this.getStartIconHeight() / 2;
        }
        SVGCoordinates coords = new SVGCoordinates(xLeft, yTop);
        return coords;
    }

    public SVGCoordinates getExitArrowCoords() {
        SVGCoordinates coords = this.getStartIconExitArrowCoords();
        if (this.subActivities != null && this.subActivities.size() > 0) {
            ActivityInterface activity = (ActivityInterface)this.subActivities.get(this.subActivities.size() - 1);
            coords = activity.getExitArrowCoords();
        }
        return coords;
    }

    protected SVGCoordinates getStartIconExitArrowCoords() {
        int xLeft = 0;
        int yTop = 0;
        if (this.layoutManager.isVerticalLayout()) {
            xLeft = this.getStartIconXLeft() + this.getStartIconWidth() / 2;
            yTop = this.getStartIconYTop() + this.getStartIconHeight();
        } else {
            xLeft = this.getStartIconXLeft() + this.getStartIconWidth();
            yTop = this.getStartIconYTop() + this.getStartIconHeight() / 2;
        }
        SVGCoordinates coords = new SVGCoordinates(xLeft, yTop);
        return coords;
    }

    public Element getSVGString(SVGDocument doc) {
        Element group = null;
        group = doc.createElementNS("http://www.w3.org/2000/svg", "g");
        group.setAttributeNS(null, "id", this.getLayerId());
        if (this.isAddOpacity()) {
            group.setAttributeNS(null, "style", "opacity:" + this.getOpacity());
        }
        group.appendChild(this.getBoxDefinition(doc));
        group.appendChild(this.getImageDefinition(doc));
        group.appendChild(this.getStartImageText(doc));
        group.appendChild(this.getSubActivitiesSVGString(doc));
        group.appendChild(this.getArrows(doc));
        return group;
    }

    protected Element getArrows(SVGDocument doc) {
        Element subGroup = null;
        subGroup = doc.createElementNS("http://www.w3.org/2000/svg", "g");
        if (this.subActivities != null) {
            ActivityInterface prevActivity = null;
            ActivityInterface activity2 = null;
            String id = null;
            SVGCoordinates myStartCoords = this.getStartIconExitArrowCoords();
            SVGCoordinates exitCoords = null;
            SVGCoordinates entryCoords = null;
            for (ActivityInterface activity2 : this.subActivities) {
                if (prevActivity != null) {
                    exitCoords = prevActivity.getExitArrowCoords();
                    entryCoords = activity2.getEntryArrowCoords();
                    id = prevActivity.getId() + "-" + activity2.getId();
                    subGroup.appendChild(this.getArrowDefinition(doc, exitCoords.getXLeft(), exitCoords.getYTop(), entryCoords.getXLeft(), entryCoords.getYTop(), id, prevActivity, activity2));
                } else {
                    entryCoords = activity2.getEntryArrowCoords();
                    subGroup.appendChild(this.getArrowDefinition(doc, myStartCoords.getXLeft(), myStartCoords.getYTop(), entryCoords.getXLeft(), entryCoords.getYTop(), id, prevActivity, activity2));
                }
                prevActivity = activity2;
            }
        }
        return subGroup;
    }

    public boolean isAddOpacity() {
        return this.isAddCompositeActivityOpacity();
    }

    public double getOpacity() {
        return this.getCompositeOpacity();
    }
}

