/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bpel.ui.bpel2svg.impl;

import java.util.Iterator;
import org.apache.axiom.om.OMElement;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;
import org.wso2.carbon.bpel.ui.bpel2svg.ActivityInterface;
import org.wso2.carbon.bpel.ui.bpel2svg.BPEL2SVGFactory;
import org.wso2.carbon.bpel.ui.bpel2svg.SVGCoordinates;
import org.wso2.carbon.bpel.ui.bpel2svg.SVGDimension;
import org.wso2.carbon.bpel.ui.bpel2svg.SequenceInterface;
import org.wso2.carbon.bpel.ui.bpel2svg.impl.ActivityImpl;

public class SequenceImpl
extends ActivityImpl
implements SequenceInterface {
    public SequenceImpl(String token) {
        super(token);
        if (this.name == null) {
            this.name = "SEQUENCE";
            this.displayName = null;
        }
        this.startIconPath = BPEL2SVGFactory.getInstance().getIconPath(this.getClass().getName());
        this.endIconPath = BPEL2SVGFactory.getInstance().getEndIconPath(this.getClass().getName());
    }

    public SequenceImpl(OMElement omElement) {
        super(omElement);
        if (this.name == null) {
            this.name = "SEQUENCE";
            this.displayName = null;
        }
        this.startIconPath = BPEL2SVGFactory.getInstance().getIconPath(this.getClass().getName());
        this.endIconPath = BPEL2SVGFactory.getInstance().getEndIconPath(this.getClass().getName());
    }

    public SequenceImpl(OMElement omElement, ActivityInterface parent) {
        super(omElement);
        this.setParent(parent);
        if (this.name == null) {
            this.displayName = this.name = "SEQUENCE";
        }
        this.startIconPath = BPEL2SVGFactory.getInstance().getIconPath(this.getClass().getName());
        this.endIconPath = BPEL2SVGFactory.getInstance().getEndIconPath(this.getClass().getName());
    }

    public String getId() {
        return this.getName();
    }

    public String getEndTag() {
        return "/sequence";
    }

    public SVGDimension getDimensions() {
        if (this.dimensions == null) {
            int width = 0;
            int height = 0;
            this.dimensions = new SVGDimension(width, height);
            SVGDimension subActivityDim = null;
            ActivityInterface activity2 = null;
            for (ActivityInterface activity2 : this.getSubActivities()) {
                subActivityDim = activity2.getDimensions();
                if (subActivityDim.getWidth() > width) {
                    width += subActivityDim.getWidth();
                }
                height += subActivityDim.getHeight();
            }
            this.dimensions.setWidth(width += this.getXSpacing());
            this.dimensions.setHeight(height += this.getYSpacing());
        }
        return this.dimensions;
    }

    public void layout(int startXLeft, int startYTop) {
        if (this.layoutManager.isVerticalLayout()) {
            this.layoutVertical(startXLeft, startYTop);
        } else {
            this.layoutHorizontal(startXLeft, startYTop);
        }
    }

    public void layoutVertical(int startXLeft, int startYTop) {
        int centreOfMyLayout = startXLeft + this.dimensions.getWidth() / 2;
        int xLeft = centreOfMyLayout - this.getStartIconWidth() / 2;
        int yTop = startYTop + this.getYSpacing() / 2;
        ActivityInterface activity = null;
        Iterator<ActivityInterface> itr = this.getSubActivities().iterator();
        int childYTop = yTop;
        int childXLeft = startXLeft;
        while (itr.hasNext()) {
            activity = itr.next();
            childXLeft = centreOfMyLayout - activity.getDimensions().getWidth() / 2;
            activity.layout(childXLeft, childYTop);
            childYTop += activity.getDimensions().getHeight();
        }
        this.setStartIconXLeft(xLeft);
        this.setStartIconYTop(yTop);
        this.setStartIconTextXLeft(startXLeft + 10);
        this.setStartIconTextYTop(startYTop + 10 + 10);
        this.getDimensions().setXLeft(startXLeft);
        this.getDimensions().setYTop(startYTop);
    }

    public void layoutHorizontal(int startXLeft, int startYTop) {
        int centreOfMyLayout = startYTop + this.dimensions.getHeight() / 2;
        int xLeft = startXLeft + this.getXSpacing() / 2;
        int yTop = centreOfMyLayout - this.getStartIconHeight() / 2;
        ActivityInterface activity = null;
        Iterator<ActivityInterface> itr = this.getSubActivities().iterator();
        int childYTop = yTop;
        int childXLeft = xLeft;
        while (itr.hasNext()) {
            activity = itr.next();
            childYTop = centreOfMyLayout - activity.getDimensions().getHeight() / 2;
            activity.layout(childXLeft, childYTop);
            childXLeft += activity.getDimensions().getWidth();
        }
        this.setStartIconXLeft(xLeft);
        this.setStartIconYTop(yTop);
        this.setStartIconTextXLeft(startXLeft + 10);
        this.setStartIconTextYTop(startYTop + 10 + 10);
        this.getDimensions().setXLeft(startXLeft);
        this.getDimensions().setYTop(startYTop);
    }

    public SVGCoordinates getEntryArrowCoords() {
        int xLeft = this.getStartIconXLeft() + this.getStartIconWidth() / 2;
        int yTop = this.getStartIconYTop();
        SVGCoordinates coords = null;
        coords = this.layoutManager.isVerticalLayout() ? new SVGCoordinates(xLeft, yTop) : new SVGCoordinates(yTop, xLeft);
        if (this.subActivities != null && this.subActivities.size() > 0) {
            ActivityInterface activity = (ActivityInterface)this.subActivities.get(0);
            coords = activity.getEntryArrowCoords();
        }
        return coords;
    }

    public SVGCoordinates getExitArrowCoords() {
        int xLeft = this.getStartIconXLeft() + this.getStartIconWidth() / 2;
        int yTop = this.getStartIconYTop();
        SVGCoordinates coords = null;
        coords = this.layoutManager.isVerticalLayout() ? new SVGCoordinates(xLeft, yTop) : new SVGCoordinates(yTop, xLeft);
        if (this.subActivities != null && this.subActivities.size() > 0) {
            ActivityInterface activity = (ActivityInterface)this.subActivities.get(this.subActivities.size() - 1);
            coords = activity.getExitArrowCoords();
        }
        return coords;
    }

    public Element getSVGString(SVGDocument doc) {
        Element group = null;
        group = doc.createElementNS("http://www.w3.org/2000/svg", "g");
        group.setAttributeNS(null, "id", this.getLayerId());
        if (this.isAddOpacity()) {
            group.setAttributeNS(null, "style", "opacity:" + this.getOpacity());
        }
        group.appendChild(this.getArrows(doc));
        group.appendChild(this.getBoxDefinition(doc));
        group.appendChild(this.getStartImageText(doc));
        group.appendChild(this.getSubActivitiesSVGString(doc));
        return group;
    }

    protected Element getArrows(SVGDocument doc) {
        Element subGroup = null;
        subGroup = doc.createElementNS("http://www.w3.org/2000/svg", "g");
        if (this.subActivities != null) {
            ActivityInterface prevActivity = null;
            ActivityInterface activity2 = null;
            String id = null;
            SVGCoordinates exitCoords = null;
            SVGCoordinates entryCoords = null;
            for (ActivityInterface activity2 : this.subActivities) {
                if (prevActivity != null) {
                    exitCoords = prevActivity.getExitArrowCoords();
                    entryCoords = activity2.getEntryArrowCoords();
                    id = prevActivity.getId() + "-" + activity2.getId();
                    subGroup.appendChild(this.getArrowDefinition(doc, exitCoords.getXLeft(), exitCoords.getYTop(), entryCoords.getXLeft(), entryCoords.getYTop(), id, prevActivity, activity2));
                }
                prevActivity = activity2;
            }
        }
        return subGroup;
    }

    public boolean isAddOpacity() {
        return this.isAddCompositeActivityOpacity();
    }

    public double getOpacity() {
        return this.getCompositeOpacity();
    }
}

