/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bpel.ui.bpel2svg.impl;

import org.apache.axiom.om.OMElement;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;
import org.wso2.carbon.bpel.ui.bpel2svg.ActivityInterface;
import org.wso2.carbon.bpel.ui.bpel2svg.BPEL2SVGFactory;
import org.wso2.carbon.bpel.ui.bpel2svg.ReceiveInterface;
import org.wso2.carbon.bpel.ui.bpel2svg.SVGCoordinates;
import org.wso2.carbon.bpel.ui.bpel2svg.SVGDimension;
import org.wso2.carbon.bpel.ui.bpel2svg.impl.ActivityImpl;

public class SimpleActivityImpl
extends ActivityImpl
implements ReceiveInterface {
    public SimpleActivityImpl(String token) {
        super(token);
        this.startIconPath = BPEL2SVGFactory.getInstance().getIconPath(this.getClass().getName());
        this.endIconPath = BPEL2SVGFactory.getInstance().getEndIconPath(this.getClass().getName());
    }

    public SimpleActivityImpl(OMElement omElement) {
        super(omElement);
        this.startIconPath = BPEL2SVGFactory.getInstance().getIconPath(this.getClass().getName());
        this.endIconPath = BPEL2SVGFactory.getInstance().getEndIconPath(this.getClass().getName());
    }

    public SimpleActivityImpl(OMElement omElement, ActivityInterface parent) {
        super(omElement);
        this.setParent(parent);
        this.startIconPath = BPEL2SVGFactory.getInstance().getIconPath(this.getClass().getName());
        this.endIconPath = BPEL2SVGFactory.getInstance().getEndIconPath(this.getClass().getName());
    }

    public String getId() {
        return this.getName();
    }

    public SVGDimension getDimensions() {
        if (this.dimensions == null) {
            int width = this.getStartIconWidth() + this.getXSpacing();
            int height = this.getStartIconHeight() + this.getYSpacing();
            this.dimensions = new SVGDimension(width, height);
        }
        return this.dimensions;
    }

    public void layout(int startXLeft, int startYTop) {
        if (this.layoutManager.isVerticalLayout()) {
            this.layoutVertical(startXLeft, startYTop);
        } else {
            this.layoutHorizontal(startXLeft, startYTop);
        }
    }

    public void layoutVertical(int startXLeft, int startYTop) {
        int xLeft = startXLeft + this.getXSpacing() / 2;
        int yTop = startYTop + this.getYSpacing() / 2;
        this.setStartIconXLeft(xLeft);
        this.setStartIconYTop(yTop);
        this.setStartIconTextXLeft(xLeft);
        this.setStartIconTextYTop(yTop + this.getStartIconHeight() + 10);
        this.getDimensions().setXLeft(startXLeft);
        this.getDimensions().setYTop(startYTop);
    }

    public void layoutHorizontal(int startXLeft, int startYTop) {
        int xLeft = startXLeft + this.getYSpacing() / 2;
        int yTop = startYTop + this.getXSpacing() / 2;
        this.setStartIconXLeft(xLeft);
        this.setStartIconYTop(yTop);
        this.setStartIconTextXLeft(xLeft);
        this.setStartIconTextYTop(yTop + this.getStartIconHeight() + 10);
        this.getDimensions().setXLeft(startXLeft);
        this.getDimensions().setYTop(startYTop);
    }

    public Element getSVGString(SVGDocument doc) {
        Element group = null;
        group = doc.createElementNS("http://www.w3.org/2000/svg", "g");
        group.setAttributeNS(null, "id", this.getLayerId());
        if (this.isAddOpacity()) {
            double op = this.getOpacity();
            group.setAttributeNS(null, "style", "opacity:" + this.getOpacity());
            group.setAttributeNS(null, "onmouseover", "this.style.opacity=1;this.filters.alpha.opacity=100");
            group.setAttributeNS(null, "onmouseout", "this.style.opacity=" + op + ";this.filters.alpha.opacity=40");
            group.setAttributeNS("xlink", "title", this.getActivityInfoString());
        }
        if (this.getState() == ActivityInterface.ActivityState.Failed) {
            group.appendChild(this.getBoxDefinition(doc));
        }
        group.appendChild(this.getImageDefinition(doc));
        group.appendChild(this.getStartImageText(doc));
        return group;
    }

    public SVGCoordinates getEntryArrowCoords() {
        int xLeft = this.getStartIconXLeft() + this.getStartIconWidth() / 2;
        int yTop = this.getStartIconYTop();
        if (!this.layoutManager.isVerticalLayout()) {
            xLeft = this.getStartIconXLeft();
            yTop = this.getStartIconYTop() + this.getStartIconHeight() / 2;
        }
        SVGCoordinates coords = new SVGCoordinates(xLeft, yTop);
        return coords;
    }

    public SVGCoordinates getExitArrowCoords() {
        int xLeft = this.getStartIconXLeft() + this.getStartIconWidth() / 2;
        int yTop = this.getStartIconYTop() + this.getStartIconHeight();
        if (!this.layoutManager.isVerticalLayout()) {
            xLeft = this.getStartIconXLeft() + this.getStartIconWidth();
            yTop = this.getStartIconYTop() + this.getStartIconHeight() / 2;
        }
        SVGCoordinates coords = new SVGCoordinates(xLeft, yTop);
        return coords;
    }

    public boolean isAddOpacity() {
        return this.isAddSimpleActivityOpacity();
    }

    public double getOpacity() {
        return this.getSimpleActivityOpacity();
    }
}

