/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bpel.ui.bpel2svg.impl;

import java.io.StringReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bpel.ui.bpel2svg.ActivityInterface;
import org.wso2.carbon.bpel.ui.bpel2svg.BPELInterface;
import org.wso2.carbon.bpel.ui.bpel2svg.Link;
import org.wso2.carbon.bpel.ui.bpel2svg.ProcessInterface;
import org.wso2.carbon.bpel.ui.bpel2svg.impl.ProcessImpl;

public class BPELImpl
implements BPELInterface {
    private Log log = LogFactory.getLog(BPELImpl.class);
    private ProcessInterface processActivity = null;
    private boolean vertical = true;
    private boolean includeAssign = true;
    public Map<String, Link> links = new HashMap<String, Link>();
    public Set<ActivityInterface> sources = new HashSet<ActivityInterface>();
    public Set<ActivityInterface> targets = new HashSet<ActivityInterface>();
    private XMLStreamReader parser = null;
    private StAXOMBuilder builder = null;
    private OMElement bpelElement = null;

    @Override
    public void processBpelString(OMElement om) {
        if (om != null) {
            OMElement startElement = this.bpelElement.getFirstChildWithName(new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "sequence"));
            if (startElement != null) {
                this.processActivity = new ProcessImpl(this.bpelElement);
                this.processActivity.setLinkProperties(this.links, this.sources, this.targets);
                this.processActivity.processSubActivities(this.bpelElement);
            } else {
                startElement = this.bpelElement.getFirstChildWithName(new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "flow"));
                if (startElement != null) {
                    this.processActivity = new ProcessImpl(this.bpelElement);
                    this.processActivity.setLinkProperties(this.links, this.sources, this.targets);
                    this.processActivity.processSubActivities(this.bpelElement);
                } else {
                    startElement = this.bpelElement.getFirstChildWithName(new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "scope"));
                    if (startElement != null) {
                        this.processActivity = new ProcessImpl(this.bpelElement);
                        this.processActivity.setLinkProperties(this.links, this.sources, this.targets);
                        this.processActivity.processSubActivities(this.bpelElement);
                    } else {
                        this.processActivity = new ProcessImpl(this.bpelElement);
                        this.processActivity.setLinkProperties(this.links, this.sources, this.targets);
                        this.processActivity.processSubActivities(this.bpelElement);
                    }
                }
            }
        }
    }

    @Override
    public OMElement load(String bpelStr) {
        try {
            this.parser = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(bpelStr));
            this.builder = new StAXOMBuilder(this.parser);
            this.bpelElement = this.builder.getDocumentElement();
            return this.bpelElement;
        }
        catch (XMLStreamException e) {
            this.log.error((Object)"XMLStreamReader creation failed", (Throwable)e);
            throw new NullPointerException("Document Element is NULL");
        }
    }

    @Override
    public ProcessInterface getRootActivity() {
        return this.processActivity;
    }

    @Override
    public boolean isVertical() {
        return this.vertical;
    }

    @Override
    public void setVertical(boolean vertical) {
        this.vertical = vertical;
    }

    @Override
    public boolean isIncludeAssign() {
        return this.includeAssign;
    }

    @Override
    public void setIncludeAssign(boolean includeAssign) {
        this.includeAssign = includeAssign;
    }

    @Override
    public OMElement getBpelElement() {
        return this.bpelElement;
    }

    @Override
    public void setBpelElement(OMElement bpelElement) {
        this.bpelElement = bpelElement;
    }
}

