/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bpel.ui.bpel2svg.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.JPEGTranscoder;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.svg.SVGDocument;
import org.wso2.carbon.bpel.ui.bpel2svg.ActivityInterface;
import org.wso2.carbon.bpel.ui.bpel2svg.ProcessInterface;
import org.wso2.carbon.bpel.ui.bpel2svg.SVGInterface;

public class SVGImpl
implements SVGInterface {
    private ProcessInterface rootActivity = null;
    private Log log = LogFactory.getLog(SVGImpl.class);
    private String svgStr = null;
    private SVGDocument svgDoc = null;

    @Override
    public ProcessInterface getRootActivity() {
        return this.rootActivity;
    }

    @Override
    public void setRootActivity(ProcessInterface rootActivity) {
        this.rootActivity = rootActivity;
    }

    @Override
    public ActivityInterface getActivityAtLineNumber(int lineNumber) {
        ActivityInterface ret = null;
        if (this.rootActivity != null) {
            ret = this.rootActivity.getActivityAtLineNumber(lineNumber);
        }
        return ret;
    }

    @Override
    public String generateSVGString() {
        try {
            SVGDocument svgDoc;
            StringWriter writer = new StringWriter();
            this.svgDoc = svgDoc = this.getRootActivity().getSVGDocument();
            DOMUtilities.writeDocument((Document)svgDoc, (Writer)writer);
            writer.close();
            this.svgStr = writer.toString();
            return this.svgStr;
        }
        catch (IOException ioe) {
            this.log.error((Object)"Error Generating SVG String", (Throwable)ioe);
            return null;
        }
    }

    @Override
    public String toPNGBase64String() {
        JPEGTranscoder jpegTranscoder = new JPEGTranscoder();
        jpegTranscoder.addTranscodingHint(JPEGTranscoder.KEY_QUALITY, (Object)new Float(0.8));
        String inputString = this.getHeaders() + this.generateSVGString();
        TranscoderInput transcoderInput = new TranscoderInput((Document)this.svgDoc);
        StringReader stringReader = new StringReader(inputString);
        TranscoderInput transcoderInput2 = new TranscoderInput((Reader)stringReader);
        ByteArrayOutputStream osByteArray = new ByteArrayOutputStream();
        TranscoderOutput transcoderOutput = new TranscoderOutput((OutputStream)osByteArray);
        try {
            jpegTranscoder.transcode(transcoderInput2, transcoderOutput);
        }
        catch (TranscoderException e) {
            this.log.error((Object)"JPEGTranscoder error", (Throwable)e);
            return null;
        }
        try {
            osByteArray.flush();
        }
        catch (IOException e) {
            this.log.error((Object)"Error while flushing OutputStreamByteArray", (Throwable)e);
            return null;
        }
        String base64 = new String(Base64.encodeBase64((byte[])osByteArray.toByteArray()));
        return base64;
    }

    @Override
    public byte[] toPNGBytes() {
        JPEGTranscoder jpegTranscoder = new JPEGTranscoder();
        jpegTranscoder.addTranscodingHint(JPEGTranscoder.KEY_QUALITY, (Object)new Float(0.8));
        String inputString = this.getHeaders() + this.generateSVGString();
        TranscoderInput transcoderInput = new TranscoderInput((Document)this.svgDoc);
        StringReader stringReader = new StringReader(inputString);
        TranscoderInput transcoderInput2 = new TranscoderInput((Reader)stringReader);
        ByteArrayOutputStream osByteArray = new ByteArrayOutputStream();
        TranscoderOutput transcoderOutput = new TranscoderOutput((OutputStream)osByteArray);
        try {
            jpegTranscoder.transcode(transcoderInput2, transcoderOutput);
        }
        catch (TranscoderException e) {
            this.log.error((Object)"JPEGTranscoder transcode error", (Throwable)e);
            return null;
        }
        try {
            osByteArray.flush();
        }
        catch (IOException e) {
            this.log.error((Object)"Error while flushing OutputStreamByteArray", (Throwable)e);
            return null;
        }
        return osByteArray.toByteArray();
    }

    @Override
    public String getHeaders() {
        return "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<!DOCTYPE svg PUBLIC '-//W3C//DTD SVG 1.0//EN' 'http://www.w3.org/TR/2001/REC-SVG-20010904/DTD/svg10.dtd'>\n\n";
    }
}

