/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.bpel.console;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.jboss.bpm.console.client.model.ActiveNodeInfo;
import org.jboss.bpm.console.client.model.DiagramInfo;
import org.jboss.bpm.console.server.plugin.GraphViewerPlugin;
import org.jboss.bpm.console.server.plugin.ProcessActivityPlugin;
import org.jboss.bpm.monitor.model.BPAFDataSource;
import org.jboss.bpm.monitor.model.DataSourceFactory;
import org.jboss.bpm.monitor.model.bpaf.Event;
import org.jboss.bpm.monitor.model.bpaf.Tuple;
import org.jboss.soa.bpel.bpel2svg.BPEL2SVGUtil;
import org.jboss.soa.bpel.console.ModelAdaptor;
import org.riftsaw.engine.BPELEngine;
import org.riftsaw.engine.internal.BPELEngineImpl;
import org.wso2.carbon.bpel.ui.bpel2svg.ActivityInterface;
import org.wso2.carbon.bpel.ui.bpel2svg.SVGInterface;

public class SVGPlugin
implements GraphViewerPlugin,
ProcessActivityPlugin {
    protected static final Log log = LogFactory.getLog(SVGPlugin.class);
    protected static final String WEB_CONTEXT = "/gwt-console-server/rs";
    protected String webServiceHost = null;
    protected int webServicePort = 8080;
    private BPELEngine engine;
    private BPAFDataSource bpafDataSource;

    public SVGPlugin() {
        try {
            InitialContext ctx = new InitialContext();
            this.engine = (BPELEngine)ctx.lookup("java:jboss/BPELEngine");
        }
        catch (NamingException e) {
            throw new RuntimeException("Failed to initialize BPEL engine");
        }
        this.bpafDataSource = DataSourceFactory.createDataSource();
    }

    protected StringBuilder getBaseUrl() {
        StringBuilder spec = new StringBuilder();
        spec.append("http://");
        spec.append(this.webServiceHost);
        spec.append(":");
        spec.append(this.webServicePort);
        spec.append(WEB_CONTEXT);
        return spec;
    }

    public byte[] getProcessInstanceImage(String definitionId, String instanceId) {
        QName qName = SVGPlugin.decode(definitionId);
        SVGInterface svg = this.createSVG(qName);
        List executionHistory = this.bpafDataSource.getPastActivities(instanceId);
        for (Event event : executionHistory) {
            for (Tuple t : event.getDataElement()) {
                Integer line;
                if (!"line-number".equals(t.getName()) || (line = Integer.valueOf(t.getValue())) <= 0) continue;
                ActivityInterface activity = svg.getActivityAtLineNumber(line.intValue());
                if (null == activity) {
                    throw new RuntimeException("No activity matching line number " + t.getValue() + " in process " + qName);
                }
                activity.setState(ActivityInterface.ActivityState.Completed);
            }
        }
        return svg.toPNGBytes();
    }

    public byte[] getProcessImage(String processId) {
        QName qName = SVGPlugin.decode(processId);
        SVGInterface svg = this.createSVG(qName);
        return svg.toPNGBytes();
    }

    private SVGInterface createSVG(QName qName) {
        InputStream in = this.getBpelDescriptor(qName);
        SVGInterface svg = null;
        try {
            svg = BPEL2SVGUtil.generate((InputStream)in);
            if (svg == null) {
                log.error((Object)"Failed to get SVGInterface");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to render process image", e);
        }
        return svg;
    }

    private static QName decode(String processId) {
        String actualId = ModelAdaptor.decodeId(processId);
        QName qName = QName.valueOf(actualId);
        return qName;
    }

    private InputStream getBpelDescriptor(QName qName) {
        ProcessConf pconf = ((BPELEngineImpl)this.engine).getStore().getProcessConfiguration(qName);
        try {
            File deployDir = new File(pconf.getBaseURI());
            File bpelDoc = new File(deployDir, pconf.getBpelDocument());
            return new FileInputStream(bpelDoc);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Faile to load bpel file", e);
        }
    }

    public DiagramInfo getDiagramInfo(String processId) {
        throw new RuntimeException("Not implemented");
    }

    public List<ActiveNodeInfo> getActiveNodeInfo(String instanceId) {
        return Collections.EMPTY_LIST;
    }

    public URL getDiagramURL(String id) {
        URL result = null;
        StringBuilder sb = this.getBaseUrl().append("/process/definition/");
        sb.append(id);
        sb.append("/image");
        try {
            result = new URL(sb.toString());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Failed to create url", e);
        }
        return result;
    }

    public List<ActiveNodeInfo> getNodeInfoForActivities(String processDefinitionId, List<String> activities) {
        return Collections.EMPTY_LIST;
    }
}

