/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.bpel.console;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.pmapi.BpelManagementFacade;
import org.jboss.bpm.console.client.model.DeploymentRef;
import org.jboss.bpm.console.client.model.JobRef;
import org.jboss.bpm.console.client.model.ProcessDefinitionRef;
import org.jboss.bpm.console.server.plugin.ProcessEnginePlugin;
import org.jboss.soa.bpel.console.ModelAdaptor;
import org.jboss.soa.bpel.console.ProcessMgmtImpl;
import org.riftsaw.engine.BPELEngine;
import org.riftsaw.engine.BPELEngineFactory;

public class ProcessEnginePluginImpl
implements ProcessEnginePlugin {
    private Log log = LogFactory.getLog(ProcessEnginePluginImpl.class);
    private BPELEngine engine;
    private ProcessMgmtImpl processManagement;

    public ProcessEnginePluginImpl(BPELEngine engine) {
        this.engine = engine;
        this.processManagement = new ProcessMgmtImpl(engine);
    }

    public ProcessEnginePluginImpl() {
        try {
            this.engine = BPELEngineFactory.getEngine();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize BPEL engine");
        }
        this.processManagement = new ProcessMgmtImpl();
    }

    private BpelManagementFacade getMgmtFacade() {
        return this.engine.getManagementInterface();
    }

    public List<DeploymentRef> getDeployments() {
        ArrayList<DeploymentRef> deployments = new ArrayList<DeploymentRef>();
        List<ProcessDefinitionRef> definitions = this.processManagement.getProcessDefinitions();
        for (ProcessDefinitionRef def : definitions) {
            DeploymentRef dref = new DeploymentRef(def.getId(), def.isSuspended());
            dref.setName(ModelAdaptor.decodeId(def.getId()));
            dref.getDefinitions().add(def.getName());
            deployments.add(dref);
        }
        return deployments;
    }

    public void deleteDeployment(String s) {
        throw new IllegalArgumentException("Not implemented");
    }

    public void suspendDeployment(String definitionId, boolean b) {
        String actualId = ModelAdaptor.decodeId(definitionId);
        try {
            this.getMgmtFacade().setRetired(QName.valueOf(actualId), b);
        }
        catch (Exception e) {
            this.log.warn((Object)("Error on suspending process " + actualId), (Throwable)e);
        }
    }

    public List<JobRef> getJobs() {
        throw new IllegalArgumentException("Not implemented");
    }

    public void executeJob(String s) {
        throw new IllegalArgumentException("Not implemented");
    }
}

