/*
 * Decompiled with CFR 0.152.
 */
package android.accessibilityservice;

import android.accessibilityservice.AccessibilityButtonController;
import android.accessibilityservice.AccessibilityServiceInfo;
import android.accessibilityservice.FingerprintGestureController;
import android.accessibilityservice.GestureDescription;
import android.accessibilityservice.IAccessibilityServiceClient;
import android.accessibilityservice.IAccessibilityServiceConnection;
import android.annotation.UnsupportedAppUsage;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ParceledListSlice;
import android.graphics.Region;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.ArrayMap;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import android.view.KeyEvent;
import android.view.WindowManager;
import android.view.WindowManagerImpl;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityInteractionClient;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityWindowInfo;
import com.android.internal.os.HandlerCaller;
import com.android.internal.os.SomeArgs;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;

public abstract class AccessibilityService
extends Service {
    public static final int GESTURE_SWIPE_UP = 1;
    public static final int GESTURE_SWIPE_DOWN = 2;
    public static final int GESTURE_SWIPE_LEFT = 3;
    public static final int GESTURE_SWIPE_RIGHT = 4;
    public static final int GESTURE_SWIPE_LEFT_AND_RIGHT = 5;
    public static final int GESTURE_SWIPE_RIGHT_AND_LEFT = 6;
    public static final int GESTURE_SWIPE_UP_AND_DOWN = 7;
    public static final int GESTURE_SWIPE_DOWN_AND_UP = 8;
    public static final int GESTURE_SWIPE_LEFT_AND_UP = 9;
    public static final int GESTURE_SWIPE_LEFT_AND_DOWN = 10;
    public static final int GESTURE_SWIPE_RIGHT_AND_UP = 11;
    public static final int GESTURE_SWIPE_RIGHT_AND_DOWN = 12;
    public static final int GESTURE_SWIPE_UP_AND_LEFT = 13;
    public static final int GESTURE_SWIPE_UP_AND_RIGHT = 14;
    public static final int GESTURE_SWIPE_DOWN_AND_LEFT = 15;
    public static final int GESTURE_SWIPE_DOWN_AND_RIGHT = 16;
    public static final String SERVICE_INTERFACE = "android.accessibilityservice.AccessibilityService";
    public static final String SERVICE_META_DATA = "android.accessibilityservice";
    public static final int GLOBAL_ACTION_BACK = 1;
    public static final int GLOBAL_ACTION_HOME = 2;
    public static final int GLOBAL_ACTION_RECENTS = 3;
    public static final int GLOBAL_ACTION_NOTIFICATIONS = 4;
    public static final int GLOBAL_ACTION_QUICK_SETTINGS = 5;
    public static final int GLOBAL_ACTION_POWER_DIALOG = 6;
    public static final int GLOBAL_ACTION_TOGGLE_SPLIT_SCREEN = 7;
    public static final int GLOBAL_ACTION_LOCK_SCREEN = 8;
    public static final int GLOBAL_ACTION_TAKE_SCREENSHOT = 9;
    private static final String LOG_TAG = "AccessibilityService";
    public static final int SHOW_MODE_AUTO = 0;
    public static final int SHOW_MODE_HIDDEN = 1;
    public static final int SHOW_MODE_IGNORE_HARD_KEYBOARD = 2;
    public static final int SHOW_MODE_MASK = 3;
    public static final int SHOW_MODE_HARD_KEYBOARD_ORIGINAL_VALUE = 0x20000000;
    public static final int SHOW_MODE_HARD_KEYBOARD_OVERRIDDEN = 0x40000000;
    private int mConnectionId = -1;
    @UnsupportedAppUsage
    private AccessibilityServiceInfo mInfo;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private IBinder mWindowToken;
    private WindowManager mWindowManager;
    private final SparseArray<MagnificationController> mMagnificationControllers = new SparseArray(0);
    private SoftKeyboardController mSoftKeyboardController;
    private AccessibilityButtonController mAccessibilityButtonController;
    private int mGestureStatusCallbackSequence;
    private SparseArray<GestureResultCallbackInfo> mGestureStatusCallbackInfos;
    private final Object mLock = new Object();
    private FingerprintGestureController mFingerprintGestureController;

    public abstract void onAccessibilityEvent(AccessibilityEvent var1);

    public abstract void onInterrupt();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchServiceConnected() {
        Object object = this.mLock;
        synchronized (object) {
            for (int i = 0; i < this.mMagnificationControllers.size(); ++i) {
                this.mMagnificationControllers.valueAt(i).onServiceConnectedLocked();
            }
        }
        if (this.mSoftKeyboardController != null) {
            this.mSoftKeyboardController.onServiceConnected();
        }
        this.onServiceConnected();
    }

    protected void onServiceConnected() {
    }

    protected boolean onGesture(int gestureId) {
        return false;
    }

    protected boolean onKeyEvent(KeyEvent event) {
        return false;
    }

    public List<AccessibilityWindowInfo> getWindows() {
        return AccessibilityInteractionClient.getInstance().getWindows(this.mConnectionId);
    }

    public AccessibilityNodeInfo getRootInActiveWindow() {
        return AccessibilityInteractionClient.getInstance().getRootInActiveWindow(this.mConnectionId);
    }

    public final void disableSelf() {
        AccessibilityInteractionClient.getInstance();
        IAccessibilityServiceConnection connection = AccessibilityInteractionClient.getConnection(this.mConnectionId);
        if (connection != null) {
            try {
                connection.disableSelf();
            }
            catch (RemoteException re) {
                throw new RuntimeException(re);
            }
        }
    }

    public final MagnificationController getMagnificationController() {
        return this.getMagnificationController(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final MagnificationController getMagnificationController(int displayId) {
        Object object = this.mLock;
        synchronized (object) {
            MagnificationController controller = this.mMagnificationControllers.get(displayId);
            if (controller == null) {
                controller = new MagnificationController(this, this.mLock, displayId);
                this.mMagnificationControllers.put(displayId, controller);
            }
            return controller;
        }
    }

    public final FingerprintGestureController getFingerprintGestureController() {
        if (this.mFingerprintGestureController == null) {
            AccessibilityInteractionClient.getInstance();
            this.mFingerprintGestureController = new FingerprintGestureController(AccessibilityInteractionClient.getConnection(this.mConnectionId));
        }
        return this.mFingerprintGestureController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean dispatchGesture(GestureDescription gesture, GestureResultCallback callback, Handler handler) {
        AccessibilityInteractionClient.getInstance();
        IAccessibilityServiceConnection connection = AccessibilityInteractionClient.getConnection(this.mConnectionId);
        if (connection == null) {
            return false;
        }
        List<GestureDescription.GestureStep> steps = GestureDescription.MotionEventGenerator.getGestureStepsFromGestureDescription(gesture, 100);
        try {
            Object object = this.mLock;
            synchronized (object) {
                ++this.mGestureStatusCallbackSequence;
                if (callback != null) {
                    if (this.mGestureStatusCallbackInfos == null) {
                        this.mGestureStatusCallbackInfos = new SparseArray();
                    }
                    GestureResultCallbackInfo callbackInfo = new GestureResultCallbackInfo(gesture, callback, handler);
                    this.mGestureStatusCallbackInfos.put(this.mGestureStatusCallbackSequence, callbackInfo);
                }
                connection.sendGesture(this.mGestureStatusCallbackSequence, new ParceledListSlice<GestureDescription.GestureStep>(steps));
            }
        }
        catch (RemoteException re) {
            throw new RuntimeException(re);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onPerformGestureResult(int sequence, final boolean completedSuccessfully) {
        GestureResultCallbackInfo callbackInfo;
        if (this.mGestureStatusCallbackInfos == null) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            callbackInfo = this.mGestureStatusCallbackInfos.get(sequence);
        }
        final GestureResultCallbackInfo finalCallbackInfo = callbackInfo;
        if (callbackInfo != null && callbackInfo.gestureDescription != null && callbackInfo.callback != null) {
            if (callbackInfo.handler != null) {
                callbackInfo.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (completedSuccessfully) {
                            finalCallbackInfo.callback.onCompleted(finalCallbackInfo.gestureDescription);
                        } else {
                            finalCallbackInfo.callback.onCancelled(finalCallbackInfo.gestureDescription);
                        }
                    }
                });
                return;
            }
            if (completedSuccessfully) {
                callbackInfo.callback.onCompleted(callbackInfo.gestureDescription);
            } else {
                callbackInfo.callback.onCancelled(callbackInfo.gestureDescription);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onMagnificationChanged(int displayId, Region region, float scale, float centerX, float centerY) {
        MagnificationController controller;
        Object object = this.mLock;
        synchronized (object) {
            controller = this.mMagnificationControllers.get(displayId);
        }
        if (controller != null) {
            controller.dispatchMagnificationChanged(region, scale, centerX, centerY);
        }
    }

    private void onFingerprintCapturingGesturesChanged(boolean active) {
        this.getFingerprintGestureController().onGestureDetectionActiveChanged(active);
    }

    private void onFingerprintGesture(int gesture) {
        this.getFingerprintGestureController().onGesture(gesture);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SoftKeyboardController getSoftKeyboardController() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSoftKeyboardController == null) {
                this.mSoftKeyboardController = new SoftKeyboardController(this, this.mLock);
            }
            return this.mSoftKeyboardController;
        }
    }

    private void onSoftKeyboardShowModeChanged(int showMode) {
        if (this.mSoftKeyboardController != null) {
            this.mSoftKeyboardController.dispatchSoftKeyboardShowModeChanged(showMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final AccessibilityButtonController getAccessibilityButtonController() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mAccessibilityButtonController == null) {
                AccessibilityInteractionClient.getInstance();
                this.mAccessibilityButtonController = new AccessibilityButtonController(AccessibilityInteractionClient.getConnection(this.mConnectionId));
            }
            return this.mAccessibilityButtonController;
        }
    }

    private void onAccessibilityButtonClicked() {
        this.getAccessibilityButtonController().dispatchAccessibilityButtonClicked();
    }

    private void onAccessibilityButtonAvailabilityChanged(boolean available) {
        this.getAccessibilityButtonController().dispatchAccessibilityButtonAvailabilityChanged(available);
    }

    public final boolean performGlobalAction(int action) {
        AccessibilityInteractionClient.getInstance();
        IAccessibilityServiceConnection connection = AccessibilityInteractionClient.getConnection(this.mConnectionId);
        if (connection != null) {
            try {
                return connection.performGlobalAction(action);
            }
            catch (RemoteException re) {
                Log.w(LOG_TAG, "Error while calling performGlobalAction", re);
                re.rethrowFromSystemServer();
            }
        }
        return false;
    }

    public AccessibilityNodeInfo findFocus(int focus) {
        return AccessibilityInteractionClient.getInstance().findFocus(this.mConnectionId, -2, AccessibilityNodeInfo.ROOT_NODE_ID, focus);
    }

    public final AccessibilityServiceInfo getServiceInfo() {
        AccessibilityInteractionClient.getInstance();
        IAccessibilityServiceConnection connection = AccessibilityInteractionClient.getConnection(this.mConnectionId);
        if (connection != null) {
            try {
                return connection.getServiceInfo();
            }
            catch (RemoteException re) {
                Log.w(LOG_TAG, "Error while getting AccessibilityServiceInfo", re);
                re.rethrowFromSystemServer();
            }
        }
        return null;
    }

    public final void setServiceInfo(AccessibilityServiceInfo info) {
        this.mInfo = info;
        this.sendServiceInfo();
    }

    private void sendServiceInfo() {
        AccessibilityInteractionClient.getInstance();
        IAccessibilityServiceConnection connection = AccessibilityInteractionClient.getConnection(this.mConnectionId);
        if (this.mInfo != null && connection != null) {
            try {
                connection.setServiceInfo(this.mInfo);
                this.mInfo = null;
                AccessibilityInteractionClient.getInstance().clearCache();
            }
            catch (RemoteException re) {
                Log.w(LOG_TAG, "Error while setting AccessibilityServiceInfo", re);
                re.rethrowFromSystemServer();
            }
        }
    }

    @Override
    public Object getSystemService(String name) {
        if (this.getBaseContext() == null) {
            throw new IllegalStateException("System services not available to Activities before onCreate()");
        }
        if ("window".equals(name)) {
            if (this.mWindowManager == null) {
                this.mWindowManager = (WindowManager)this.getBaseContext().getSystemService(name);
            }
            return this.mWindowManager;
        }
        return super.getSystemService(name);
    }

    @Override
    public final IBinder onBind(Intent intent) {
        return new IAccessibilityServiceClientWrapper(this, this.getMainLooper(), new Callbacks(){

            @Override
            public void onServiceConnected() {
                AccessibilityService.this.dispatchServiceConnected();
            }

            @Override
            public void onInterrupt() {
                AccessibilityService.this.onInterrupt();
            }

            @Override
            public void onAccessibilityEvent(AccessibilityEvent event) {
                AccessibilityService.this.onAccessibilityEvent(event);
            }

            @Override
            public void init(int connectionId, IBinder windowToken) {
                AccessibilityService.this.mConnectionId = connectionId;
                AccessibilityService.this.mWindowToken = windowToken;
                WindowManagerImpl wm = (WindowManagerImpl)AccessibilityService.this.getSystemService("window");
                wm.setDefaultToken(windowToken);
            }

            @Override
            public boolean onGesture(int gestureId) {
                return AccessibilityService.this.onGesture(gestureId);
            }

            @Override
            public boolean onKeyEvent(KeyEvent event) {
                return AccessibilityService.this.onKeyEvent(event);
            }

            @Override
            public void onMagnificationChanged(int displayId, Region region, float scale, float centerX, float centerY) {
                AccessibilityService.this.onMagnificationChanged(displayId, region, scale, centerX, centerY);
            }

            @Override
            public void onSoftKeyboardShowModeChanged(int showMode) {
                AccessibilityService.this.onSoftKeyboardShowModeChanged(showMode);
            }

            @Override
            public void onPerformGestureResult(int sequence, boolean completedSuccessfully) {
                AccessibilityService.this.onPerformGestureResult(sequence, completedSuccessfully);
            }

            @Override
            public void onFingerprintCapturingGesturesChanged(boolean active) {
                AccessibilityService.this.onFingerprintCapturingGesturesChanged(active);
            }

            @Override
            public void onFingerprintGesture(int gesture) {
                AccessibilityService.this.onFingerprintGesture(gesture);
            }

            @Override
            public void onAccessibilityButtonClicked() {
                AccessibilityService.this.onAccessibilityButtonClicked();
            }

            @Override
            public void onAccessibilityButtonAvailabilityChanged(boolean available) {
                AccessibilityService.this.onAccessibilityButtonAvailabilityChanged(available);
            }
        });
    }

    private static class GestureResultCallbackInfo {
        GestureDescription gestureDescription;
        GestureResultCallback callback;
        Handler handler;

        GestureResultCallbackInfo(GestureDescription gestureDescription, GestureResultCallback callback, Handler handler) {
            this.gestureDescription = gestureDescription;
            this.callback = callback;
            this.handler = handler;
        }
    }

    public static abstract class GestureResultCallback {
        public void onCompleted(GestureDescription gestureDescription) {
        }

        public void onCancelled(GestureDescription gestureDescription) {
        }
    }

    public static class IAccessibilityServiceClientWrapper
    extends IAccessibilityServiceClient.Stub
    implements HandlerCaller.Callback {
        private static final int DO_INIT = 1;
        private static final int DO_ON_INTERRUPT = 2;
        private static final int DO_ON_ACCESSIBILITY_EVENT = 3;
        private static final int DO_ON_GESTURE = 4;
        private static final int DO_CLEAR_ACCESSIBILITY_CACHE = 5;
        private static final int DO_ON_KEY_EVENT = 6;
        private static final int DO_ON_MAGNIFICATION_CHANGED = 7;
        private static final int DO_ON_SOFT_KEYBOARD_SHOW_MODE_CHANGED = 8;
        private static final int DO_GESTURE_COMPLETE = 9;
        private static final int DO_ON_FINGERPRINT_ACTIVE_CHANGED = 10;
        private static final int DO_ON_FINGERPRINT_GESTURE = 11;
        private static final int DO_ACCESSIBILITY_BUTTON_CLICKED = 12;
        private static final int DO_ACCESSIBILITY_BUTTON_AVAILABILITY_CHANGED = 13;
        private final HandlerCaller mCaller;
        private final Callbacks mCallback;
        private int mConnectionId = -1;

        public IAccessibilityServiceClientWrapper(Context context, Looper looper, Callbacks callback) {
            this.mCallback = callback;
            this.mCaller = new HandlerCaller(context, looper, this, true);
        }

        @Override
        public void init(IAccessibilityServiceConnection connection, int connectionId, IBinder windowToken) {
            Message message = this.mCaller.obtainMessageIOO(1, connectionId, connection, windowToken);
            this.mCaller.sendMessage(message);
        }

        @Override
        public void onInterrupt() {
            Message message = this.mCaller.obtainMessage(2);
            this.mCaller.sendMessage(message);
        }

        @Override
        public void onAccessibilityEvent(AccessibilityEvent event, boolean serviceWantsEvent) {
            Message message = this.mCaller.obtainMessageBO(3, serviceWantsEvent, event);
            this.mCaller.sendMessage(message);
        }

        @Override
        public void onGesture(int gestureId) {
            Message message = this.mCaller.obtainMessageI(4, gestureId);
            this.mCaller.sendMessage(message);
        }

        @Override
        public void clearAccessibilityCache() {
            Message message = this.mCaller.obtainMessage(5);
            this.mCaller.sendMessage(message);
        }

        @Override
        public void onKeyEvent(KeyEvent event, int sequence) {
            Message message = this.mCaller.obtainMessageIO(6, sequence, event);
            this.mCaller.sendMessage(message);
        }

        @Override
        public void onMagnificationChanged(int displayId, Region region, float scale, float centerX, float centerY) {
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = region;
            args.arg2 = Float.valueOf(scale);
            args.arg3 = Float.valueOf(centerX);
            args.arg4 = Float.valueOf(centerY);
            args.argi1 = displayId;
            Message message = this.mCaller.obtainMessageO(7, args);
            this.mCaller.sendMessage(message);
        }

        @Override
        public void onSoftKeyboardShowModeChanged(int showMode) {
            Message message = this.mCaller.obtainMessageI(8, showMode);
            this.mCaller.sendMessage(message);
        }

        @Override
        public void onPerformGestureResult(int sequence, boolean successfully) {
            Message message = this.mCaller.obtainMessageII(9, sequence, successfully ? 1 : 0);
            this.mCaller.sendMessage(message);
        }

        @Override
        public void onFingerprintCapturingGesturesChanged(boolean active) {
            this.mCaller.sendMessage(this.mCaller.obtainMessageI(10, active ? 1 : 0));
        }

        @Override
        public void onFingerprintGesture(int gesture) {
            this.mCaller.sendMessage(this.mCaller.obtainMessageI(11, gesture));
        }

        @Override
        public void onAccessibilityButtonClicked() {
            Message message = this.mCaller.obtainMessage(12);
            this.mCaller.sendMessage(message);
        }

        @Override
        public void onAccessibilityButtonAvailabilityChanged(boolean available) {
            Message message = this.mCaller.obtainMessageI(13, available ? 1 : 0);
            this.mCaller.sendMessage(message);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void executeMessage(Message message) {
            switch (message.what) {
                case 3: {
                    boolean serviceWantsEvent;
                    AccessibilityEvent event = (AccessibilityEvent)message.obj;
                    boolean bl = serviceWantsEvent = message.arg1 != 0;
                    if (event != null) {
                        AccessibilityInteractionClient.getInstance().onAccessibilityEvent(event);
                        if (serviceWantsEvent && this.mConnectionId != -1) {
                            this.mCallback.onAccessibilityEvent(event);
                        }
                        try {
                            event.recycle();
                        }
                        catch (IllegalStateException illegalStateException) {
                            // empty catch block
                        }
                    }
                    return;
                }
                case 2: {
                    if (this.mConnectionId != -1) {
                        this.mCallback.onInterrupt();
                    }
                    return;
                }
                case 1: {
                    this.mConnectionId = message.arg1;
                    SomeArgs args = (SomeArgs)message.obj;
                    IAccessibilityServiceConnection connection = (IAccessibilityServiceConnection)args.arg1;
                    IBinder windowToken = (IBinder)args.arg2;
                    args.recycle();
                    if (connection != null) {
                        AccessibilityInteractionClient.getInstance();
                        AccessibilityInteractionClient.addConnection(this.mConnectionId, connection);
                        this.mCallback.init(this.mConnectionId, windowToken);
                        this.mCallback.onServiceConnected();
                    } else {
                        AccessibilityInteractionClient.getInstance();
                        AccessibilityInteractionClient.removeConnection(this.mConnectionId);
                        this.mConnectionId = -1;
                        AccessibilityInteractionClient.getInstance().clearCache();
                        this.mCallback.init(-1, null);
                    }
                    return;
                }
                case 4: {
                    if (this.mConnectionId != -1) {
                        int gestureId = message.arg1;
                        this.mCallback.onGesture(gestureId);
                    }
                    return;
                }
                case 5: {
                    AccessibilityInteractionClient.getInstance().clearCache();
                    return;
                }
                case 6: {
                    KeyEvent event = (KeyEvent)message.obj;
                    try {
                        AccessibilityInteractionClient.getInstance();
                        IAccessibilityServiceConnection connection = AccessibilityInteractionClient.getConnection(this.mConnectionId);
                        if (connection != null) {
                            boolean result = this.mCallback.onKeyEvent(event);
                            int sequence = message.arg1;
                            try {
                                connection.setOnKeyEventResult(result, sequence);
                            }
                            catch (RemoteException remoteException) {
                                // empty catch block
                            }
                        }
                    }
                    finally {
                        try {
                            event.recycle();
                        }
                        catch (IllegalStateException connection) {}
                    }
                    return;
                }
                case 7: {
                    if (this.mConnectionId != -1) {
                        SomeArgs args = (SomeArgs)message.obj;
                        Region region = (Region)args.arg1;
                        float scale = ((Float)args.arg2).floatValue();
                        float centerX = ((Float)args.arg3).floatValue();
                        float centerY = ((Float)args.arg4).floatValue();
                        int displayId = args.argi1;
                        args.recycle();
                        this.mCallback.onMagnificationChanged(displayId, region, scale, centerX, centerY);
                    }
                    return;
                }
                case 8: {
                    if (this.mConnectionId != -1) {
                        int showMode = message.arg1;
                        this.mCallback.onSoftKeyboardShowModeChanged(showMode);
                    }
                    return;
                }
                case 9: {
                    if (this.mConnectionId != -1) {
                        boolean successfully = message.arg2 == 1;
                        this.mCallback.onPerformGestureResult(message.arg1, successfully);
                    }
                    return;
                }
                case 10: {
                    if (this.mConnectionId != -1) {
                        this.mCallback.onFingerprintCapturingGesturesChanged(message.arg1 == 1);
                    }
                    return;
                }
                case 11: {
                    if (this.mConnectionId != -1) {
                        this.mCallback.onFingerprintGesture(message.arg1);
                    }
                    return;
                }
                case 12: {
                    if (this.mConnectionId != -1) {
                        this.mCallback.onAccessibilityButtonClicked();
                    }
                    return;
                }
                case 13: {
                    if (this.mConnectionId != -1) {
                        boolean available = message.arg1 != 0;
                        this.mCallback.onAccessibilityButtonAvailabilityChanged(available);
                    }
                    return;
                }
            }
            Log.w(AccessibilityService.LOG_TAG, "Unknown message type " + message.what);
        }
    }

    public static final class SoftKeyboardController {
        private final AccessibilityService mService;
        private ArrayMap<OnShowModeChangedListener, Handler> mListeners;
        private final Object mLock;

        SoftKeyboardController(AccessibilityService service, Object lock) {
            this.mService = service;
            this.mLock = lock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void onServiceConnected() {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mListeners != null && !this.mListeners.isEmpty()) {
                    this.setSoftKeyboardCallbackEnabled(true);
                }
            }
        }

        public void addOnShowModeChangedListener(OnShowModeChangedListener listener) {
            this.addOnShowModeChangedListener(listener, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addOnShowModeChangedListener(OnShowModeChangedListener listener, Handler handler) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mListeners == null) {
                    this.mListeners = new ArrayMap();
                }
                boolean shouldEnableCallback = this.mListeners.isEmpty();
                this.mListeners.put(listener, handler);
                if (shouldEnableCallback) {
                    this.setSoftKeyboardCallbackEnabled(true);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeOnShowModeChangedListener(OnShowModeChangedListener listener) {
            if (this.mListeners == null) {
                return false;
            }
            Object object = this.mLock;
            synchronized (object) {
                boolean hasKey;
                int keyIndex = this.mListeners.indexOfKey(listener);
                boolean bl = hasKey = keyIndex >= 0;
                if (hasKey) {
                    this.mListeners.removeAt(keyIndex);
                }
                if (hasKey && this.mListeners.isEmpty()) {
                    this.setSoftKeyboardCallbackEnabled(false);
                }
                return hasKey;
            }
        }

        private void setSoftKeyboardCallbackEnabled(boolean enabled) {
            AccessibilityInteractionClient.getInstance();
            IAccessibilityServiceConnection connection = AccessibilityInteractionClient.getConnection(this.mService.mConnectionId);
            if (connection != null) {
                try {
                    connection.setSoftKeyboardCallbackEnabled(enabled);
                }
                catch (RemoteException re) {
                    throw new RuntimeException(re);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void dispatchSoftKeyboardShowModeChanged(final int showMode) {
            ArrayMap<OnShowModeChangedListener, Handler> entries;
            Object object = this.mLock;
            synchronized (object) {
                if (this.mListeners == null || this.mListeners.isEmpty()) {
                    Slog.w(AccessibilityService.LOG_TAG, "Received soft keyboard show mode changed callback with no listeners registered!");
                    this.setSoftKeyboardCallbackEnabled(false);
                    return;
                }
                entries = new ArrayMap<OnShowModeChangedListener, Handler>(this.mListeners);
            }
            int count = entries.size();
            for (int i = 0; i < count; ++i) {
                final OnShowModeChangedListener listener = entries.keyAt(i);
                Handler handler = entries.valueAt(i);
                if (handler != null) {
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            listener.onShowModeChanged(this, showMode);
                        }
                    });
                    continue;
                }
                listener.onShowModeChanged(this, showMode);
            }
        }

        public int getShowMode() {
            AccessibilityInteractionClient.getInstance();
            IAccessibilityServiceConnection connection = AccessibilityInteractionClient.getConnection(this.mService.mConnectionId);
            if (connection != null) {
                try {
                    return connection.getSoftKeyboardShowMode();
                }
                catch (RemoteException re) {
                    Log.w(AccessibilityService.LOG_TAG, "Failed to set soft keyboard behavior", re);
                    re.rethrowFromSystemServer();
                }
            }
            return 0;
        }

        public boolean setShowMode(int showMode) {
            AccessibilityInteractionClient.getInstance();
            IAccessibilityServiceConnection connection = AccessibilityInteractionClient.getConnection(this.mService.mConnectionId);
            if (connection != null) {
                try {
                    return connection.setSoftKeyboardShowMode(showMode);
                }
                catch (RemoteException re) {
                    Log.w(AccessibilityService.LOG_TAG, "Failed to set soft keyboard behavior", re);
                    re.rethrowFromSystemServer();
                }
            }
            return false;
        }

        public static interface OnShowModeChangedListener {
            public void onShowModeChanged(SoftKeyboardController var1, int var2);
        }
    }

    public static final class MagnificationController {
        private final AccessibilityService mService;
        private final int mDisplayId;
        private ArrayMap<OnMagnificationChangedListener, Handler> mListeners;
        private final Object mLock;

        MagnificationController(AccessibilityService service, Object lock, int displayId) {
            this.mService = service;
            this.mLock = lock;
            this.mDisplayId = displayId;
        }

        void onServiceConnectedLocked() {
            if (this.mListeners != null && !this.mListeners.isEmpty()) {
                this.setMagnificationCallbackEnabled(true);
            }
        }

        public void addListener(OnMagnificationChangedListener listener) {
            this.addListener(listener, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addListener(OnMagnificationChangedListener listener, Handler handler) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mListeners == null) {
                    this.mListeners = new ArrayMap();
                }
                boolean shouldEnableCallback = this.mListeners.isEmpty();
                this.mListeners.put(listener, handler);
                if (shouldEnableCallback) {
                    this.setMagnificationCallbackEnabled(true);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeListener(OnMagnificationChangedListener listener) {
            if (this.mListeners == null) {
                return false;
            }
            Object object = this.mLock;
            synchronized (object) {
                boolean hasKey;
                int keyIndex = this.mListeners.indexOfKey(listener);
                boolean bl = hasKey = keyIndex >= 0;
                if (hasKey) {
                    this.mListeners.removeAt(keyIndex);
                }
                if (hasKey && this.mListeners.isEmpty()) {
                    this.setMagnificationCallbackEnabled(false);
                }
                return hasKey;
            }
        }

        private void setMagnificationCallbackEnabled(boolean enabled) {
            AccessibilityInteractionClient.getInstance();
            IAccessibilityServiceConnection connection = AccessibilityInteractionClient.getConnection(this.mService.mConnectionId);
            if (connection != null) {
                try {
                    connection.setMagnificationCallbackEnabled(this.mDisplayId, enabled);
                }
                catch (RemoteException re) {
                    throw new RuntimeException(re);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void dispatchMagnificationChanged(final Region region, final float scale, final float centerX, final float centerY) {
            ArrayMap<OnMagnificationChangedListener, Handler> entries;
            Object object = this.mLock;
            synchronized (object) {
                if (this.mListeners == null || this.mListeners.isEmpty()) {
                    Slog.d(AccessibilityService.LOG_TAG, "Received magnification changed callback with no listeners registered!");
                    this.setMagnificationCallbackEnabled(false);
                    return;
                }
                entries = new ArrayMap<OnMagnificationChangedListener, Handler>(this.mListeners);
            }
            int count = entries.size();
            for (int i = 0; i < count; ++i) {
                final OnMagnificationChangedListener listener = entries.keyAt(i);
                Handler handler = entries.valueAt(i);
                if (handler != null) {
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            listener.onMagnificationChanged(this, region, scale, centerX, centerY);
                        }
                    });
                    continue;
                }
                listener.onMagnificationChanged(this, region, scale, centerX, centerY);
            }
        }

        public float getScale() {
            AccessibilityInteractionClient.getInstance();
            IAccessibilityServiceConnection connection = AccessibilityInteractionClient.getConnection(this.mService.mConnectionId);
            if (connection != null) {
                try {
                    return connection.getMagnificationScale(this.mDisplayId);
                }
                catch (RemoteException re) {
                    Log.w(AccessibilityService.LOG_TAG, "Failed to obtain scale", re);
                    re.rethrowFromSystemServer();
                }
            }
            return 1.0f;
        }

        public float getCenterX() {
            AccessibilityInteractionClient.getInstance();
            IAccessibilityServiceConnection connection = AccessibilityInteractionClient.getConnection(this.mService.mConnectionId);
            if (connection != null) {
                try {
                    return connection.getMagnificationCenterX(this.mDisplayId);
                }
                catch (RemoteException re) {
                    Log.w(AccessibilityService.LOG_TAG, "Failed to obtain center X", re);
                    re.rethrowFromSystemServer();
                }
            }
            return 0.0f;
        }

        public float getCenterY() {
            AccessibilityInteractionClient.getInstance();
            IAccessibilityServiceConnection connection = AccessibilityInteractionClient.getConnection(this.mService.mConnectionId);
            if (connection != null) {
                try {
                    return connection.getMagnificationCenterY(this.mDisplayId);
                }
                catch (RemoteException re) {
                    Log.w(AccessibilityService.LOG_TAG, "Failed to obtain center Y", re);
                    re.rethrowFromSystemServer();
                }
            }
            return 0.0f;
        }

        public Region getMagnificationRegion() {
            AccessibilityInteractionClient.getInstance();
            IAccessibilityServiceConnection connection = AccessibilityInteractionClient.getConnection(this.mService.mConnectionId);
            if (connection != null) {
                try {
                    return connection.getMagnificationRegion(this.mDisplayId);
                }
                catch (RemoteException re) {
                    Log.w(AccessibilityService.LOG_TAG, "Failed to obtain magnified region", re);
                    re.rethrowFromSystemServer();
                }
            }
            return Region.obtain();
        }

        public boolean reset(boolean animate) {
            AccessibilityInteractionClient.getInstance();
            IAccessibilityServiceConnection connection = AccessibilityInteractionClient.getConnection(this.mService.mConnectionId);
            if (connection != null) {
                try {
                    return connection.resetMagnification(this.mDisplayId, animate);
                }
                catch (RemoteException re) {
                    Log.w(AccessibilityService.LOG_TAG, "Failed to reset", re);
                    re.rethrowFromSystemServer();
                }
            }
            return false;
        }

        public boolean setScale(float scale, boolean animate) {
            AccessibilityInteractionClient.getInstance();
            IAccessibilityServiceConnection connection = AccessibilityInteractionClient.getConnection(this.mService.mConnectionId);
            if (connection != null) {
                try {
                    return connection.setMagnificationScaleAndCenter(this.mDisplayId, scale, Float.NaN, Float.NaN, animate);
                }
                catch (RemoteException re) {
                    Log.w(AccessibilityService.LOG_TAG, "Failed to set scale", re);
                    re.rethrowFromSystemServer();
                }
            }
            return false;
        }

        public boolean setCenter(float centerX, float centerY, boolean animate) {
            AccessibilityInteractionClient.getInstance();
            IAccessibilityServiceConnection connection = AccessibilityInteractionClient.getConnection(this.mService.mConnectionId);
            if (connection != null) {
                try {
                    return connection.setMagnificationScaleAndCenter(this.mDisplayId, Float.NaN, centerX, centerY, animate);
                }
                catch (RemoteException re) {
                    Log.w(AccessibilityService.LOG_TAG, "Failed to set center", re);
                    re.rethrowFromSystemServer();
                }
            }
            return false;
        }

        public static interface OnMagnificationChangedListener {
            public void onMagnificationChanged(MagnificationController var1, Region var2, float var3, float var4, float var5);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SoftKeyboardShowMode {
    }

    public static interface Callbacks {
        public void onAccessibilityEvent(AccessibilityEvent var1);

        public void onInterrupt();

        public void onServiceConnected();

        public void init(int var1, IBinder var2);

        public boolean onGesture(int var1);

        public boolean onKeyEvent(KeyEvent var1);

        public void onMagnificationChanged(int var1, Region var2, float var3, float var4, float var5);

        public void onSoftKeyboardShowModeChanged(int var1);

        public void onPerformGestureResult(int var1, boolean var2);

        public void onFingerprintCapturingGesturesChanged(boolean var1);

        public void onFingerprintGesture(int var1);

        public void onAccessibilityButtonClicked();

        public void onAccessibilityButtonAvailabilityChanged(boolean var1);
    }
}

