/*
 * Decompiled with CFR 0.152.
 */
package android.accessibilityservice;

import android.accessibilityservice.IAccessibilityServiceConnection;
import android.os.Handler;
import android.os.RemoteException;
import android.util.ArrayMap;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;

public final class FingerprintGestureController {
    public static final int FINGERPRINT_GESTURE_SWIPE_RIGHT = 1;
    public static final int FINGERPRINT_GESTURE_SWIPE_LEFT = 2;
    public static final int FINGERPRINT_GESTURE_SWIPE_UP = 4;
    public static final int FINGERPRINT_GESTURE_SWIPE_DOWN = 8;
    private static final String LOG_TAG = "FingerprintGestureController";
    private final Object mLock = new Object();
    private final IAccessibilityServiceConnection mAccessibilityServiceConnection;
    private final ArrayMap<FingerprintGestureCallback, Handler> mCallbackHandlerMap = new ArrayMap(1);

    @VisibleForTesting
    public FingerprintGestureController(IAccessibilityServiceConnection connection) {
        this.mAccessibilityServiceConnection = connection;
    }

    public boolean isGestureDetectionAvailable() {
        try {
            return this.mAccessibilityServiceConnection.isFingerprintGestureDetectionAvailable();
        }
        catch (RemoteException re) {
            Log.w(LOG_TAG, "Failed to check if fingerprint gestures are active", re);
            re.rethrowFromSystemServer();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFingerprintGestureCallback(FingerprintGestureCallback callback, Handler handler) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCallbackHandlerMap.put(callback, handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterFingerprintGestureCallback(FingerprintGestureCallback callback) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCallbackHandlerMap.remove(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onGestureDetectionActiveChanged(boolean active) {
        ArrayMap<FingerprintGestureCallback, Handler> handlerMap;
        Object object = this.mLock;
        synchronized (object) {
            handlerMap = new ArrayMap<FingerprintGestureCallback, Handler>(this.mCallbackHandlerMap);
        }
        int numListeners = handlerMap.size();
        for (int i = 0; i < numListeners; ++i) {
            FingerprintGestureCallback callback = handlerMap.keyAt(i);
            Handler handler = handlerMap.valueAt(i);
            if (handler != null) {
                handler.post(() -> callback.onGestureDetectionAvailabilityChanged(active));
                continue;
            }
            callback.onGestureDetectionAvailabilityChanged(active);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onGesture(int gesture) {
        ArrayMap<FingerprintGestureCallback, Handler> handlerMap;
        Object object = this.mLock;
        synchronized (object) {
            handlerMap = new ArrayMap<FingerprintGestureCallback, Handler>(this.mCallbackHandlerMap);
        }
        int numListeners = handlerMap.size();
        for (int i = 0; i < numListeners; ++i) {
            FingerprintGestureCallback callback = handlerMap.keyAt(i);
            Handler handler = handlerMap.valueAt(i);
            if (handler != null) {
                handler.post(() -> callback.onGestureDetected(gesture));
                continue;
            }
            callback.onGestureDetected(gesture);
        }
    }

    public static abstract class FingerprintGestureCallback {
        public void onGestureDetectionAvailabilityChanged(boolean available) {
        }

        public void onGestureDetected(int gesture) {
        }
    }
}

