/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.SystemApi;
import android.app.IInstantAppResolver;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.pm.InstantAppResolveInfo;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.IRemoteCallback;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.Log;
import android.util.Slog;
import com.android.internal.os.SomeArgs;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@SystemApi
public abstract class InstantAppResolverService
extends Service {
    private static final boolean DEBUG_INSTANT = Build.IS_DEBUGGABLE;
    private static final String TAG = "PackageManager";
    public static final String EXTRA_RESOLVE_INFO = "android.app.extra.RESOLVE_INFO";
    public static final String EXTRA_SEQUENCE = "android.app.extra.SEQUENCE";
    Handler mHandler;

    @Deprecated
    public void onGetInstantAppResolveInfo(int[] digestPrefix, String token, InstantAppResolutionCallback callback) {
        throw new IllegalStateException("Must define onGetInstantAppResolveInfo");
    }

    @Deprecated
    public void onGetInstantAppIntentFilter(int[] digestPrefix, String token, InstantAppResolutionCallback callback) {
        throw new IllegalStateException("Must define onGetInstantAppIntentFilter");
    }

    @Deprecated
    public void onGetInstantAppResolveInfo(Intent sanitizedIntent, int[] hostDigestPrefix, String token, InstantAppResolutionCallback callback) {
        if (sanitizedIntent.isWebIntent()) {
            this.onGetInstantAppResolveInfo(hostDigestPrefix, token, callback);
        } else {
            callback.onInstantAppResolveInfo(Collections.emptyList());
        }
    }

    @Deprecated
    public void onGetInstantAppIntentFilter(Intent sanitizedIntent, int[] hostDigestPrefix, String token, InstantAppResolutionCallback callback) {
        Log.e(TAG, "New onGetInstantAppIntentFilter is not overridden");
        if (sanitizedIntent.isWebIntent()) {
            this.onGetInstantAppIntentFilter(hostDigestPrefix, token, callback);
        } else {
            callback.onInstantAppResolveInfo(Collections.emptyList());
        }
    }

    public void onGetInstantAppResolveInfo(Intent sanitizedIntent, int[] hostDigestPrefix, UserHandle userHandle, String token, InstantAppResolutionCallback callback) {
        this.onGetInstantAppResolveInfo(sanitizedIntent, hostDigestPrefix, token, callback);
    }

    public void onGetInstantAppIntentFilter(Intent sanitizedIntent, int[] hostDigestPrefix, UserHandle userHandle, String token, InstantAppResolutionCallback callback) {
        this.onGetInstantAppIntentFilter(sanitizedIntent, hostDigestPrefix, token, callback);
    }

    Looper getLooper() {
        return this.getBaseContext().getMainLooper();
    }

    @Override
    public final void attachBaseContext(Context base) {
        super.attachBaseContext(base);
        this.mHandler = new ServiceHandler(this.getLooper());
    }

    @Override
    public final IBinder onBind(Intent intent) {
        return new IInstantAppResolver.Stub(){

            @Override
            public void getInstantAppResolveInfoList(Intent sanitizedIntent, int[] digestPrefix, int userId, String token, int sequence, IRemoteCallback callback) {
                if (DEBUG_INSTANT) {
                    Slog.v(InstantAppResolverService.TAG, "[" + token + "] Phase1 called; posting");
                }
                SomeArgs args = SomeArgs.obtain();
                args.arg1 = callback;
                args.arg2 = digestPrefix;
                args.arg3 = userId;
                args.arg4 = token;
                args.arg5 = sanitizedIntent;
                InstantAppResolverService.this.mHandler.obtainMessage(1, sequence, 0, args).sendToTarget();
            }

            @Override
            public void getInstantAppIntentFilterList(Intent sanitizedIntent, int[] digestPrefix, int userId, String token, IRemoteCallback callback) {
                if (DEBUG_INSTANT) {
                    Slog.v(InstantAppResolverService.TAG, "[" + token + "] Phase2 called; posting");
                }
                SomeArgs args = SomeArgs.obtain();
                args.arg1 = callback;
                args.arg2 = digestPrefix;
                args.arg3 = userId;
                args.arg4 = token;
                args.arg5 = sanitizedIntent;
                InstantAppResolverService.this.mHandler.obtainMessage(2, args).sendToTarget();
            }
        };
    }

    private final class ServiceHandler
    extends Handler {
        public static final int MSG_GET_INSTANT_APP_RESOLVE_INFO = 1;
        public static final int MSG_GET_INSTANT_APP_INTENT_FILTER = 2;

        public ServiceHandler(Looper looper) {
            super(looper, null, true);
        }

        @Override
        public void handleMessage(Message message) {
            int action = message.what;
            switch (action) {
                case 1: {
                    SomeArgs args = (SomeArgs)message.obj;
                    IRemoteCallback callback = (IRemoteCallback)args.arg1;
                    int[] digestPrefix = (int[])args.arg2;
                    int userId = (Integer)args.arg3;
                    String token = (String)args.arg4;
                    Intent intent = (Intent)args.arg5;
                    int sequence = message.arg1;
                    if (DEBUG_INSTANT) {
                        Slog.d(InstantAppResolverService.TAG, "[" + token + "] Phase1 request; prefix: " + Arrays.toString(digestPrefix) + ", userId: " + userId);
                    }
                    InstantAppResolverService.this.onGetInstantAppResolveInfo(intent, digestPrefix, UserHandle.of(userId), token, new InstantAppResolutionCallback(sequence, callback));
                    break;
                }
                case 2: {
                    SomeArgs args = (SomeArgs)message.obj;
                    IRemoteCallback callback = (IRemoteCallback)args.arg1;
                    int[] digestPrefix = (int[])args.arg2;
                    int userId = (Integer)args.arg3;
                    String token = (String)args.arg4;
                    Intent intent = (Intent)args.arg5;
                    if (DEBUG_INSTANT) {
                        Slog.d(InstantAppResolverService.TAG, "[" + token + "] Phase2 request; prefix: " + Arrays.toString(digestPrefix) + ", userId: " + userId);
                    }
                    InstantAppResolverService.this.onGetInstantAppIntentFilter(intent, digestPrefix, UserHandle.of(userId), token, new InstantAppResolutionCallback(-1, callback));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown message: " + action);
                }
            }
        }
    }

    public static final class InstantAppResolutionCallback {
        private final IRemoteCallback mCallback;
        private final int mSequence;

        InstantAppResolutionCallback(int sequence, IRemoteCallback callback) {
            this.mCallback = callback;
            this.mSequence = sequence;
        }

        public void onInstantAppResolveInfo(List<InstantAppResolveInfo> resolveInfo) {
            Bundle data = new Bundle();
            data.putParcelableList(InstantAppResolverService.EXTRA_RESOLVE_INFO, resolveInfo);
            data.putInt(InstantAppResolverService.EXTRA_SEQUENCE, this.mSequence);
            try {
                this.mCallback.sendResult(data);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }
}

