/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.UnsupportedAppUsage;
import android.app.Activity;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Bundle;
import android.os.Looper;
import android.os.MessageQueue;
import android.util.AttributeSet;
import android.view.InputQueue;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.inputmethod.InputMethodManager;
import dalvik.system.BaseDexClassLoader;
import java.io.File;

public class NativeActivity
extends Activity
implements SurfaceHolder.Callback2,
InputQueue.Callback,
ViewTreeObserver.OnGlobalLayoutListener {
    public static final String META_DATA_LIB_NAME = "android.app.lib_name";
    public static final String META_DATA_FUNC_NAME = "android.app.func_name";
    private static final String KEY_NATIVE_SAVED_STATE = "android:native_state";
    private NativeContentView mNativeContentView;
    private InputMethodManager mIMM;
    @UnsupportedAppUsage
    private long mNativeHandle;
    private InputQueue mCurInputQueue;
    private SurfaceHolder mCurSurfaceHolder;
    final int[] mLocation = new int[2];
    int mLastContentX;
    int mLastContentY;
    int mLastContentWidth;
    int mLastContentHeight;
    private boolean mDispatchingUnhandledKey;
    private boolean mDestroyed;

    @UnsupportedAppUsage
    private native long loadNativeCode(String var1, String var2, MessageQueue var3, String var4, String var5, String var6, int var7, AssetManager var8, byte[] var9, ClassLoader var10, String var11);

    private native String getDlError();

    private native void unloadNativeCode(long var1);

    private native void onStartNative(long var1);

    private native void onResumeNative(long var1);

    private native byte[] onSaveInstanceStateNative(long var1);

    private native void onPauseNative(long var1);

    private native void onStopNative(long var1);

    private native void onConfigurationChangedNative(long var1);

    private native void onLowMemoryNative(long var1);

    private native void onWindowFocusChangedNative(long var1, boolean var3);

    private native void onSurfaceCreatedNative(long var1, Surface var3);

    private native void onSurfaceChangedNative(long var1, Surface var3, int var4, int var5, int var6);

    private native void onSurfaceRedrawNeededNative(long var1, Surface var3);

    private native void onSurfaceDestroyedNative(long var1);

    private native void onInputQueueCreatedNative(long var1, long var3);

    private native void onInputQueueDestroyedNative(long var1, long var3);

    private native void onContentRectChangedNative(long var1, int var3, int var4, int var5, int var6);

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        String libname = "main";
        String funcname = "ANativeActivity_onCreate";
        this.mIMM = this.getSystemService(InputMethodManager.class);
        this.getWindow().takeSurface(this);
        this.getWindow().takeInputQueue(this);
        this.getWindow().setFormat(4);
        this.getWindow().setSoftInputMode(16);
        this.mNativeContentView = new NativeContentView(this);
        this.mNativeContentView.mActivity = this;
        this.setContentView(this.mNativeContentView);
        this.mNativeContentView.requestFocus();
        this.mNativeContentView.getViewTreeObserver().addOnGlobalLayoutListener(this);
        try {
            ActivityInfo ai = this.getPackageManager().getActivityInfo(this.getIntent().getComponent(), 128);
            if (ai.metaData != null) {
                String ln = ai.metaData.getString(META_DATA_LIB_NAME);
                if (ln != null) {
                    libname = ln;
                }
                if ((ln = ai.metaData.getString(META_DATA_FUNC_NAME)) != null) {
                    funcname = ln;
                }
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException("Error getting activity info", e);
        }
        BaseDexClassLoader classLoader = (BaseDexClassLoader)this.getClassLoader();
        String path = classLoader.findLibrary(libname);
        if (path == null) {
            throw new IllegalArgumentException("Unable to find native library " + libname + " using classloader: " + classLoader.toString());
        }
        byte[] nativeSavedState = savedInstanceState != null ? savedInstanceState.getByteArray(KEY_NATIVE_SAVED_STATE) : null;
        this.mNativeHandle = this.loadNativeCode(path, funcname, Looper.myQueue(), NativeActivity.getAbsolutePath(this.getFilesDir()), NativeActivity.getAbsolutePath(this.getObbDir()), NativeActivity.getAbsolutePath(this.getExternalFilesDir(null)), Build.VERSION.SDK_INT, this.getAssets(), nativeSavedState, classLoader, classLoader.getLdLibraryPath());
        if (this.mNativeHandle == 0L) {
            throw new UnsatisfiedLinkError("Unable to load native library \"" + path + "\": " + this.getDlError());
        }
        super.onCreate(savedInstanceState);
    }

    private static String getAbsolutePath(File file) {
        return file != null ? file.getAbsolutePath() : null;
    }

    @Override
    protected void onDestroy() {
        this.mDestroyed = true;
        if (this.mCurSurfaceHolder != null) {
            this.onSurfaceDestroyedNative(this.mNativeHandle);
            this.mCurSurfaceHolder = null;
        }
        if (this.mCurInputQueue != null) {
            this.onInputQueueDestroyedNative(this.mNativeHandle, this.mCurInputQueue.getNativePtr());
            this.mCurInputQueue = null;
        }
        this.unloadNativeCode(this.mNativeHandle);
        super.onDestroy();
    }

    @Override
    protected void onPause() {
        super.onPause();
        this.onPauseNative(this.mNativeHandle);
    }

    @Override
    protected void onResume() {
        super.onResume();
        this.onResumeNative(this.mNativeHandle);
    }

    @Override
    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        byte[] state = this.onSaveInstanceStateNative(this.mNativeHandle);
        if (state != null) {
            outState.putByteArray(KEY_NATIVE_SAVED_STATE, state);
        }
    }

    @Override
    protected void onStart() {
        super.onStart();
        this.onStartNative(this.mNativeHandle);
    }

    @Override
    protected void onStop() {
        super.onStop();
        this.onStopNative(this.mNativeHandle);
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (!this.mDestroyed) {
            this.onConfigurationChangedNative(this.mNativeHandle);
        }
    }

    @Override
    public void onLowMemory() {
        super.onLowMemory();
        if (!this.mDestroyed) {
            this.onLowMemoryNative(this.mNativeHandle);
        }
    }

    @Override
    public void onWindowFocusChanged(boolean hasFocus) {
        super.onWindowFocusChanged(hasFocus);
        if (!this.mDestroyed) {
            this.onWindowFocusChangedNative(this.mNativeHandle, hasFocus);
        }
    }

    @Override
    public void surfaceCreated(SurfaceHolder holder) {
        if (!this.mDestroyed) {
            this.mCurSurfaceHolder = holder;
            this.onSurfaceCreatedNative(this.mNativeHandle, holder.getSurface());
        }
    }

    @Override
    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        if (!this.mDestroyed) {
            this.mCurSurfaceHolder = holder;
            this.onSurfaceChangedNative(this.mNativeHandle, holder.getSurface(), format, width, height);
        }
    }

    @Override
    public void surfaceRedrawNeeded(SurfaceHolder holder) {
        if (!this.mDestroyed) {
            this.mCurSurfaceHolder = holder;
            this.onSurfaceRedrawNeededNative(this.mNativeHandle, holder.getSurface());
        }
    }

    @Override
    public void surfaceDestroyed(SurfaceHolder holder) {
        this.mCurSurfaceHolder = null;
        if (!this.mDestroyed) {
            this.onSurfaceDestroyedNative(this.mNativeHandle);
        }
    }

    @Override
    public void onInputQueueCreated(InputQueue queue) {
        if (!this.mDestroyed) {
            this.mCurInputQueue = queue;
            this.onInputQueueCreatedNative(this.mNativeHandle, queue.getNativePtr());
        }
    }

    @Override
    public void onInputQueueDestroyed(InputQueue queue) {
        if (!this.mDestroyed) {
            this.onInputQueueDestroyedNative(this.mNativeHandle, queue.getNativePtr());
            this.mCurInputQueue = null;
        }
    }

    @Override
    public void onGlobalLayout() {
        this.mNativeContentView.getLocationInWindow(this.mLocation);
        int w = this.mNativeContentView.getWidth();
        int h = this.mNativeContentView.getHeight();
        if (this.mLocation[0] != this.mLastContentX || this.mLocation[1] != this.mLastContentY || w != this.mLastContentWidth || h != this.mLastContentHeight) {
            this.mLastContentX = this.mLocation[0];
            this.mLastContentY = this.mLocation[1];
            this.mLastContentWidth = w;
            this.mLastContentHeight = h;
            if (!this.mDestroyed) {
                this.onContentRectChangedNative(this.mNativeHandle, this.mLastContentX, this.mLastContentY, this.mLastContentWidth, this.mLastContentHeight);
            }
        }
    }

    @UnsupportedAppUsage
    void setWindowFlags(int flags, int mask) {
        this.getWindow().setFlags(flags, mask);
    }

    @UnsupportedAppUsage
    void setWindowFormat(int format) {
        this.getWindow().setFormat(format);
    }

    @UnsupportedAppUsage
    void showIme(int mode) {
        this.mIMM.showSoftInput(this.mNativeContentView, mode);
    }

    @UnsupportedAppUsage
    void hideIme(int mode) {
        this.mIMM.hideSoftInputFromWindow(this.mNativeContentView.getWindowToken(), mode);
    }

    static class NativeContentView
    extends View {
        NativeActivity mActivity;

        public NativeContentView(Context context) {
            super(context);
        }

        public NativeContentView(Context context, AttributeSet attrs) {
            super(context, attrs);
        }
    }
}

