/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.SystemApi;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Size;
import com.android.internal.graphics.ColorUtils;
import com.android.internal.graphics.palette.Palette;
import com.android.internal.graphics.palette.VariationalKMeansQuantizer;
import com.android.internal.util.ContrastColorUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class WallpaperColors
implements Parcelable {
    private static final boolean DEBUG_DARK_PIXELS = false;
    @SystemApi
    public static final int HINT_SUPPORTS_DARK_TEXT = 1;
    @SystemApi
    public static final int HINT_SUPPORTS_DARK_THEME = 2;
    public static final int HINT_FROM_BITMAP = 4;
    private static final int MAX_BITMAP_SIZE = 112;
    private static final int MAX_WALLPAPER_EXTRACTION_AREA = 12544;
    private static final float MIN_COLOR_OCCURRENCE = 0.05f;
    private static final float DARK_THEME_MEAN_LUMINANCE = 0.25f;
    private static final float BRIGHT_IMAGE_MEAN_LUMINANCE = 0.75f;
    private static final float DARK_PIXEL_CONTRAST = 6.0f;
    private static final float MAX_DARK_AREA = 0.025f;
    private final ArrayList<Color> mMainColors;
    private int mColorHints;
    public static final Parcelable.Creator<WallpaperColors> CREATOR = new Parcelable.Creator<WallpaperColors>(){

        @Override
        public WallpaperColors createFromParcel(Parcel in) {
            return new WallpaperColors(in);
        }

        public WallpaperColors[] newArray(int size) {
            return new WallpaperColors[size];
        }
    };

    public WallpaperColors(Parcel parcel) {
        this.mMainColors = new ArrayList();
        int count = parcel.readInt();
        for (int i = 0; i < count; ++i) {
            int colorInt = parcel.readInt();
            Color color2 = Color.valueOf(colorInt);
            this.mMainColors.add(color2);
        }
        this.mColorHints = parcel.readInt();
    }

    public static WallpaperColors fromDrawable(Drawable drawable2) {
        if (drawable2 == null) {
            throw new IllegalArgumentException("Drawable cannot be null");
        }
        Rect initialBounds = drawable2.copyBounds();
        int width = drawable2.getIntrinsicWidth();
        int height = drawable2.getIntrinsicHeight();
        if (width <= 0 || height <= 0) {
            width = 112;
            height = 112;
        }
        Size optimalSize = WallpaperColors.calculateOptimalSize(width, height);
        Bitmap bitmap = Bitmap.createBitmap(optimalSize.getWidth(), optimalSize.getHeight(), Bitmap.Config.ARGB_8888);
        Canvas bmpCanvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, bitmap.getWidth(), bitmap.getHeight());
        drawable2.draw(bmpCanvas);
        WallpaperColors colors = WallpaperColors.fromBitmap(bitmap);
        bitmap.recycle();
        drawable2.setBounds(initialBounds);
        return colors;
    }

    public static WallpaperColors fromBitmap(Bitmap bitmap) {
        if (bitmap == null) {
            throw new IllegalArgumentException("Bitmap can't be null");
        }
        int bitmapArea = bitmap.getWidth() * bitmap.getHeight();
        boolean shouldRecycle = false;
        if (bitmapArea > 12544) {
            shouldRecycle = true;
            Size optimalSize = WallpaperColors.calculateOptimalSize(bitmap.getWidth(), bitmap.getHeight());
            bitmap = Bitmap.createScaledBitmap(bitmap, optimalSize.getWidth(), optimalSize.getHeight(), true);
        }
        Palette palette = Palette.from(bitmap).setQuantizer(new VariationalKMeansQuantizer()).maximumColorCount(5).clearFilters().resizeBitmapArea(12544).generate();
        ArrayList<Palette.Swatch> swatches = new ArrayList<Palette.Swatch>(palette.getSwatches());
        float minColorArea = (float)(bitmap.getWidth() * bitmap.getHeight()) * 0.05f;
        swatches.removeIf(s -> (float)s.getPopulation() < minColorArea);
        swatches.sort((a, b) -> b.getPopulation() - a.getPopulation());
        int swatchesSize = swatches.size();
        Color primary = null;
        Color secondary = null;
        Color tertiary = null;
        block5: for (int i = 0; i < swatchesSize; ++i) {
            Color color2 = Color.valueOf(swatches.get(i).getRgb());
            switch (i) {
                case 0: {
                    primary = color2;
                    continue block5;
                }
                case 1: {
                    secondary = color2;
                    continue block5;
                }
                case 2: {
                    tertiary = color2;
                    continue block5;
                }
            }
        }
        int hints = WallpaperColors.calculateDarkHints(bitmap);
        if (shouldRecycle) {
            bitmap.recycle();
        }
        return new WallpaperColors(primary, secondary, tertiary, 4 | hints);
    }

    public WallpaperColors(Color primaryColor, Color secondaryColor, Color tertiaryColor) {
        this(primaryColor, secondaryColor, tertiaryColor, 0);
    }

    @SystemApi
    public WallpaperColors(Color primaryColor, Color secondaryColor, Color tertiaryColor, int colorHints) {
        if (primaryColor == null) {
            throw new IllegalArgumentException("Primary color should never be null.");
        }
        this.mMainColors = new ArrayList(3);
        this.mMainColors.add(primaryColor);
        if (secondaryColor != null) {
            this.mMainColors.add(secondaryColor);
        }
        if (tertiaryColor != null) {
            if (secondaryColor == null) {
                throw new IllegalArgumentException("tertiaryColor can't be specified when secondaryColor is null");
            }
            this.mMainColors.add(tertiaryColor);
        }
        this.mColorHints = colorHints;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        List<Color> mainColors = this.getMainColors();
        int count = mainColors.size();
        dest.writeInt(count);
        for (int i = 0; i < count; ++i) {
            Color color2 = mainColors.get(i);
            dest.writeInt(color2.toArgb());
        }
        dest.writeInt(this.mColorHints);
    }

    public Color getPrimaryColor() {
        return this.mMainColors.get(0);
    }

    public Color getSecondaryColor() {
        return this.mMainColors.size() < 2 ? null : this.mMainColors.get(1);
    }

    public Color getTertiaryColor() {
        return this.mMainColors.size() < 3 ? null : this.mMainColors.get(2);
    }

    public List<Color> getMainColors() {
        return Collections.unmodifiableList(this.mMainColors);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WallpaperColors other = (WallpaperColors)o;
        return this.mMainColors.equals(other.mMainColors) && this.mColorHints == other.mColorHints;
    }

    public int hashCode() {
        return 31 * this.mMainColors.hashCode() + this.mColorHints;
    }

    @SystemApi
    public int getColorHints() {
        return this.mColorHints;
    }

    public void setColorHints(int colorHints) {
        this.mColorHints = colorHints;
    }

    private static int calculateDarkHints(Bitmap source) {
        if (source == null) {
            return 0;
        }
        int[] pixels = new int[source.getWidth() * source.getHeight()];
        double totalLuminance = 0.0;
        int maxDarkPixels = (int)((float)pixels.length * 0.025f);
        int darkPixels = 0;
        source.getPixels(pixels, 0, source.getWidth(), 0, 0, source.getWidth(), source.getHeight());
        float[] tmpHsl = new float[3];
        for (int i = 0; i < pixels.length; ++i) {
            boolean satisfiesTextContrast;
            ColorUtils.colorToHSL(pixels[i], tmpHsl);
            float luminance = tmpHsl[2];
            int alpha = Color.alpha(pixels[i]);
            boolean bl = satisfiesTextContrast = ContrastColorUtil.calculateContrast(pixels[i], -16777216) > 6.0;
            if (!satisfiesTextContrast && alpha != 0) {
                ++darkPixels;
            }
            totalLuminance += (double)luminance;
        }
        int hints = 0;
        double meanLuminance = totalLuminance / (double)pixels.length;
        if (meanLuminance > 0.75 && darkPixels < maxDarkPixels) {
            hints |= 1;
        }
        if (meanLuminance < 0.25) {
            hints |= 2;
        }
        return hints;
    }

    private static Size calculateOptimalSize(int width, int height) {
        int requestedArea = width * height;
        double scale = 1.0;
        if (requestedArea > 12544) {
            scale = Math.sqrt(12544.0 / (double)requestedArea);
        }
        int newWidth = (int)((double)width * scale);
        int newHeight = (int)((double)height * scale);
        if (newWidth == 0) {
            newWidth = 1;
        }
        if (newHeight == 0) {
            newHeight = 1;
        }
        return new Size(newWidth, newHeight);
    }

    public String toString() {
        StringBuilder colors = new StringBuilder();
        for (int i = 0; i < this.mMainColors.size(); ++i) {
            colors.append(Integer.toHexString(this.mMainColors.get(i).toArgb())).append(" ");
        }
        return "[WallpaperColors: " + colors.toString() + "h: " + this.mColorHints + "]";
    }
}

