/*
 * Decompiled with CFR 0.152.
 */
package android.app.admin;

import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class PasswordMetrics
implements Parcelable {
    public static final int MAX_ALLOWED_SEQUENCE = 3;
    public int quality = 0;
    public int length = 0;
    public int letters = 0;
    public int upperCase = 0;
    public int lowerCase = 0;
    public int numeric = 0;
    public int symbols = 0;
    public int nonLetter = 0;
    public static final Parcelable.Creator<PasswordMetrics> CREATOR = new Parcelable.Creator<PasswordMetrics>(){

        @Override
        public PasswordMetrics createFromParcel(Parcel in) {
            return new PasswordMetrics(in);
        }

        public PasswordMetrics[] newArray(int size) {
            return new PasswordMetrics[size];
        }
    };
    private static final int CHAR_LOWER_CASE = 0;
    private static final int CHAR_UPPER_CASE = 1;
    private static final int CHAR_DIGIT = 2;
    private static final int CHAR_SYMBOL = 3;

    public PasswordMetrics() {
    }

    public PasswordMetrics(int quality) {
        this.quality = quality;
    }

    public PasswordMetrics(int quality, int length) {
        this.quality = quality;
        this.length = length;
    }

    public PasswordMetrics(int quality, int length, int letters, int upperCase, int lowerCase, int numeric, int symbols, int nonLetter) {
        this(quality, length);
        this.letters = letters;
        this.upperCase = upperCase;
        this.lowerCase = lowerCase;
        this.numeric = numeric;
        this.symbols = symbols;
        this.nonLetter = nonLetter;
    }

    private PasswordMetrics(Parcel in) {
        this.quality = in.readInt();
        this.length = in.readInt();
        this.letters = in.readInt();
        this.upperCase = in.readInt();
        this.lowerCase = in.readInt();
        this.numeric = in.readInt();
        this.symbols = in.readInt();
        this.nonLetter = in.readInt();
    }

    public static int complexityLevelToMinQuality(int complexityLevel) {
        return ((PasswordComplexityBucket)PasswordComplexityBucket.complexityLevelToBucket((int)complexityLevel)).mMetrics[0].quality;
    }

    public static PasswordMetrics getMinimumMetrics(int complexityLevel, int userEnteredPasswordQuality, int requestedQuality, boolean requiresNumeric, boolean requiresLettersOrSymbols) {
        int targetQuality = Math.max(userEnteredPasswordQuality, PasswordMetrics.getActualRequiredQuality(requestedQuality, requiresNumeric, requiresLettersOrSymbols));
        return PasswordMetrics.getTargetQualityMetrics(complexityLevel, targetQuality);
    }

    @VisibleForTesting
    public static PasswordMetrics getTargetQualityMetrics(int complexityLevel, int targetQuality) {
        PasswordComplexityBucket targetBucket = PasswordComplexityBucket.complexityLevelToBucket(complexityLevel);
        for (PasswordMetrics metrics : targetBucket.mMetrics) {
            if (targetQuality != metrics.quality) continue;
            return metrics;
        }
        return targetBucket.mMetrics[0];
    }

    @VisibleForTesting
    public static int getActualRequiredQuality(int requestedQuality, boolean requiresNumeric, boolean requiresLettersOrSymbols) {
        if (requestedQuality != 393216) {
            return requestedQuality;
        }
        if (requiresNumeric && requiresLettersOrSymbols) {
            return 327680;
        }
        if (requiresLettersOrSymbols) {
            return 262144;
        }
        if (requiresNumeric) {
            return 131072;
        }
        return 0;
    }

    public static int sanitizeComplexityLevel(int complexityLevel) {
        return PasswordComplexityBucket.complexityLevelToBucket(complexityLevel).mComplexityLevel;
    }

    public boolean isDefault() {
        return this.quality == 0 && this.length == 0 && this.letters == 0 && this.upperCase == 0 && this.lowerCase == 0 && this.numeric == 0 && this.symbols == 0 && this.nonLetter == 0;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.quality);
        dest.writeInt(this.length);
        dest.writeInt(this.letters);
        dest.writeInt(this.upperCase);
        dest.writeInt(this.lowerCase);
        dest.writeInt(this.numeric);
        dest.writeInt(this.symbols);
        dest.writeInt(this.nonLetter);
    }

    public static PasswordMetrics computeForCredential(int type, byte[] credential) {
        if (type == 2) {
            Preconditions.checkNotNull(credential, "credential cannot be null");
            return PasswordMetrics.computeForPassword(credential);
        }
        if (type == 1) {
            return new PasswordMetrics(65536);
        }
        return new PasswordMetrics(0);
    }

    public static PasswordMetrics computeForPassword(byte[] password) {
        boolean hasNonNumeric;
        int letters = 0;
        int upperCase = 0;
        int lowerCase = 0;
        int numeric = 0;
        int symbols = 0;
        int nonLetter = 0;
        int length = password.length;
        block6: for (byte b : password) {
            switch (PasswordMetrics.categoryChar((char)b)) {
                case 0: {
                    ++letters;
                    ++lowerCase;
                    continue block6;
                }
                case 1: {
                    ++letters;
                    ++upperCase;
                    continue block6;
                }
                case 2: {
                    ++numeric;
                    ++nonLetter;
                    continue block6;
                }
                case 3: {
                    ++symbols;
                    ++nonLetter;
                }
            }
        }
        boolean hasNumeric = numeric > 0;
        boolean bl = hasNonNumeric = letters + symbols > 0;
        int quality = hasNonNumeric && hasNumeric ? 327680 : (hasNonNumeric ? 262144 : (hasNumeric ? (PasswordMetrics.maxLengthSequence(password) > 3 ? 131072 : 196608) : 0));
        return new PasswordMetrics(quality, length, letters, upperCase, lowerCase, numeric, symbols, nonLetter);
    }

    public boolean equals(Object other) {
        if (!(other instanceof PasswordMetrics)) {
            return false;
        }
        PasswordMetrics o = (PasswordMetrics)other;
        return this.quality == o.quality && this.length == o.length && this.letters == o.letters && this.upperCase == o.upperCase && this.lowerCase == o.lowerCase && this.numeric == o.numeric && this.symbols == o.symbols && this.nonLetter == o.nonLetter;
    }

    private boolean satisfiesBucket(PasswordMetrics ... bucket) {
        for (PasswordMetrics metrics : bucket) {
            if (this.quality != metrics.quality) continue;
            return this.length >= metrics.length;
        }
        return false;
    }

    public static int maxLengthSequence(byte[] bytes) {
        if (bytes.length == 0) {
            return 0;
        }
        char previousChar = (char)bytes[0];
        int category = PasswordMetrics.categoryChar(previousChar);
        int diff = 0;
        boolean hasDiff = false;
        int maxLength = 0;
        int startSequence = 0;
        for (int current = 1; current < bytes.length; ++current) {
            char currentChar = (char)bytes[current];
            int categoryCurrent = PasswordMetrics.categoryChar(currentChar);
            int currentDiff = currentChar - previousChar;
            if (categoryCurrent != category || Math.abs(currentDiff) > PasswordMetrics.maxDiffCategory(category)) {
                maxLength = Math.max(maxLength, current - startSequence);
                startSequence = current;
                hasDiff = false;
                category = categoryCurrent;
            } else {
                if (hasDiff && currentDiff != diff) {
                    maxLength = Math.max(maxLength, current - startSequence);
                    startSequence = current - 1;
                }
                diff = currentDiff;
                hasDiff = true;
            }
            previousChar = currentChar;
        }
        maxLength = Math.max(maxLength, bytes.length - startSequence);
        return maxLength;
    }

    private static int categoryChar(char c) {
        if ('a' <= c && c <= 'z') {
            return 0;
        }
        if ('A' <= c && c <= 'Z') {
            return 1;
        }
        if ('0' <= c && c <= '9') {
            return 2;
        }
        return 3;
    }

    private static int maxDiffCategory(int category) {
        switch (category) {
            case 0: 
            case 1: {
                return 1;
            }
            case 2: {
                return 10;
            }
        }
        return 0;
    }

    public int determineComplexity() {
        for (PasswordComplexityBucket bucket : PasswordComplexityBucket.BUCKETS) {
            if (!this.satisfiesBucket(bucket.mMetrics)) continue;
            return bucket.mComplexityLevel;
        }
        return 0;
    }

    private static class PasswordComplexityBucket {
        private static final PasswordComplexityBucket HIGH = new PasswordComplexityBucket(327680, new PasswordMetrics(196608, 8), new PasswordMetrics(262144, 6), new PasswordMetrics(327680, 6));
        private static final PasswordComplexityBucket MEDIUM = new PasswordComplexityBucket(196608, new PasswordMetrics(196608, 4), new PasswordMetrics(262144, 4), new PasswordMetrics(327680, 4));
        private static final PasswordComplexityBucket LOW = new PasswordComplexityBucket(65536, new PasswordMetrics(65536), new PasswordMetrics(131072), new PasswordMetrics(196608), new PasswordMetrics(262144), new PasswordMetrics(327680));
        private static final PasswordComplexityBucket NONE = new PasswordComplexityBucket(0, new PasswordMetrics());
        private static final PasswordComplexityBucket[] BUCKETS = new PasswordComplexityBucket[]{HIGH, MEDIUM, LOW};
        private final int mComplexityLevel;
        private final PasswordMetrics[] mMetrics;

        private PasswordComplexityBucket(int complexityLevel, PasswordMetrics ... metricsArray) {
            int previousQuality = 0;
            for (PasswordMetrics metrics : metricsArray) {
                if (metrics.quality < previousQuality) {
                    throw new IllegalArgumentException("metricsArray must be sorted in ascending order of quality");
                }
                previousQuality = metrics.quality;
            }
            this.mMetrics = metricsArray;
            this.mComplexityLevel = complexityLevel;
        }

        private static PasswordComplexityBucket complexityLevelToBucket(int complexityLevel) {
            for (PasswordComplexityBucket bucket : BUCKETS) {
                if (bucket.mComplexityLevel != complexityLevel) continue;
                return bucket;
            }
            return NONE;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface CharacterCatagory {
    }
}

