/*
 * Decompiled with CFR 0.152.
 */
package android.app.backup;

import android.app.IBackupAgent;
import android.app.QueuedWork;
import android.app.backup.BackupDataInput;
import android.app.backup.BackupDataOutput;
import android.app.backup.BackupUtils;
import android.app.backup.FullBackup;
import android.app.backup.FullBackupDataOutput;
import android.app.backup.IBackupCallback;
import android.app.backup.IBackupManager;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.pm.ApplicationInfo;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.os.RemoteException;
import android.os.UserHandle;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.system.StructStat;
import android.util.ArraySet;
import android.util.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import libcore.io.IoUtils;
import org.xmlpull.v1.XmlPullParserException;

public abstract class BackupAgent
extends ContextWrapper {
    private static final String TAG = "BackupAgent";
    private static final boolean DEBUG = false;
    public static final int RESULT_SUCCESS = 0;
    public static final int RESULT_ERROR = -1;
    public static final int TYPE_EOF = 0;
    public static final int TYPE_FILE = 1;
    public static final int TYPE_DIRECTORY = 2;
    public static final int TYPE_SYMLINK = 3;
    public static final int FLAG_CLIENT_SIDE_ENCRYPTION_ENABLED = 1;
    public static final int FLAG_DEVICE_TO_DEVICE_TRANSFER = 2;
    public static final int FLAG_FAKE_CLIENT_SIDE_ENCRYPTION_ENABLED = Integer.MIN_VALUE;
    Handler mHandler = null;
    private UserHandle mUser;
    private final IBinder mBinder = new BackupServiceBinder().asBinder();

    Handler getHandler() {
        if (this.mHandler == null) {
            this.mHandler = new Handler(Looper.getMainLooper());
        }
        return this.mHandler;
    }

    private void waitForSharedPrefs() {
        Handler h = this.getHandler();
        SharedPrefsSynchronizer s = new SharedPrefsSynchronizer();
        h.postAtFrontOfQueue(s);
        try {
            s.mLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public BackupAgent() {
        super(null);
    }

    public void onCreate() {
    }

    public void onCreate(UserHandle user) {
        this.onCreate();
        this.mUser = user;
    }

    public void onDestroy() {
    }

    public abstract void onBackup(ParcelFileDescriptor var1, BackupDataOutput var2, ParcelFileDescriptor var3) throws IOException;

    public abstract void onRestore(BackupDataInput var1, int var2, ParcelFileDescriptor var3) throws IOException;

    public void onRestore(BackupDataInput data, long appVersionCode, ParcelFileDescriptor newState) throws IOException {
        this.onRestore(data, (int)appVersionCode, newState);
    }

    public void onFullBackup(FullBackupDataOutput data) throws IOException {
        File efLocation;
        ArraySet<FullBackup.BackupScheme.PathWithRequiredFlags> manifestExcludeSet;
        Map<String, Set<FullBackup.BackupScheme.PathWithRequiredFlags>> manifestIncludeMap;
        FullBackup.BackupScheme backupScheme = FullBackup.getBackupScheme(this);
        if (!backupScheme.isFullBackupContentEnabled()) {
            return;
        }
        try {
            manifestIncludeMap = backupScheme.maybeParseAndGetCanonicalIncludePaths();
            manifestExcludeSet = backupScheme.maybeParseAndGetCanonicalExcludePaths();
        }
        catch (IOException | XmlPullParserException e) {
            if (Log.isLoggable("BackupXmlParserLogging", 2)) {
                Log.v("BackupXmlParserLogging", "Exception trying to parse fullBackupContent xml file! Aborting full backup.", e);
            }
            return;
        }
        String packageName = this.getPackageName();
        ApplicationInfo appInfo = this.getApplicationInfo();
        Context ceContext = this.createCredentialProtectedStorageContext();
        String rootDir = ceContext.getDataDir().getCanonicalPath();
        String filesDir = ceContext.getFilesDir().getCanonicalPath();
        String noBackupDir = ceContext.getNoBackupFilesDir().getCanonicalPath();
        String databaseDir = ceContext.getDatabasePath("foo").getParentFile().getCanonicalPath();
        String sharedPrefsDir = ceContext.getSharedPreferencesPath("foo").getParentFile().getCanonicalPath();
        String cacheDir = ceContext.getCacheDir().getCanonicalPath();
        String codeCacheDir = ceContext.getCodeCacheDir().getCanonicalPath();
        Context deContext = this.createDeviceProtectedStorageContext();
        String deviceRootDir = deContext.getDataDir().getCanonicalPath();
        String deviceFilesDir = deContext.getFilesDir().getCanonicalPath();
        String deviceNoBackupDir = deContext.getNoBackupFilesDir().getCanonicalPath();
        String deviceDatabaseDir = deContext.getDatabasePath("foo").getParentFile().getCanonicalPath();
        String deviceSharedPrefsDir = deContext.getSharedPreferencesPath("foo").getParentFile().getCanonicalPath();
        String deviceCacheDir = deContext.getCacheDir().getCanonicalPath();
        String deviceCodeCacheDir = deContext.getCodeCacheDir().getCanonicalPath();
        String libDir = appInfo.nativeLibraryDir != null ? new File(appInfo.nativeLibraryDir).getCanonicalPath() : null;
        ArraySet<String> traversalExcludeSet = new ArraySet<String>();
        traversalExcludeSet.add(filesDir);
        traversalExcludeSet.add(noBackupDir);
        traversalExcludeSet.add(databaseDir);
        traversalExcludeSet.add(sharedPrefsDir);
        traversalExcludeSet.add(cacheDir);
        traversalExcludeSet.add(codeCacheDir);
        traversalExcludeSet.add(deviceFilesDir);
        traversalExcludeSet.add(deviceNoBackupDir);
        traversalExcludeSet.add(deviceDatabaseDir);
        traversalExcludeSet.add(deviceSharedPrefsDir);
        traversalExcludeSet.add(deviceCacheDir);
        traversalExcludeSet.add(deviceCodeCacheDir);
        if (libDir != null) {
            traversalExcludeSet.add(libDir);
        }
        this.applyXmlFiltersAndDoFullBackupForDomain(packageName, "r", manifestIncludeMap, manifestExcludeSet, traversalExcludeSet, data);
        traversalExcludeSet.add(rootDir);
        this.applyXmlFiltersAndDoFullBackupForDomain(packageName, "d_r", manifestIncludeMap, manifestExcludeSet, traversalExcludeSet, data);
        traversalExcludeSet.add(deviceRootDir);
        traversalExcludeSet.remove(filesDir);
        this.applyXmlFiltersAndDoFullBackupForDomain(packageName, "f", manifestIncludeMap, manifestExcludeSet, traversalExcludeSet, data);
        traversalExcludeSet.add(filesDir);
        traversalExcludeSet.remove(deviceFilesDir);
        this.applyXmlFiltersAndDoFullBackupForDomain(packageName, "d_f", manifestIncludeMap, manifestExcludeSet, traversalExcludeSet, data);
        traversalExcludeSet.add(deviceFilesDir);
        traversalExcludeSet.remove(databaseDir);
        this.applyXmlFiltersAndDoFullBackupForDomain(packageName, "db", manifestIncludeMap, manifestExcludeSet, traversalExcludeSet, data);
        traversalExcludeSet.add(databaseDir);
        traversalExcludeSet.remove(deviceDatabaseDir);
        this.applyXmlFiltersAndDoFullBackupForDomain(packageName, "d_db", manifestIncludeMap, manifestExcludeSet, traversalExcludeSet, data);
        traversalExcludeSet.add(deviceDatabaseDir);
        traversalExcludeSet.remove(sharedPrefsDir);
        this.applyXmlFiltersAndDoFullBackupForDomain(packageName, "sp", manifestIncludeMap, manifestExcludeSet, traversalExcludeSet, data);
        traversalExcludeSet.add(sharedPrefsDir);
        traversalExcludeSet.remove(deviceSharedPrefsDir);
        this.applyXmlFiltersAndDoFullBackupForDomain(packageName, "d_sp", manifestIncludeMap, manifestExcludeSet, traversalExcludeSet, data);
        traversalExcludeSet.add(deviceSharedPrefsDir);
        if (Process.myUid() != 1000 && (efLocation = this.getExternalFilesDir(null)) != null) {
            this.applyXmlFiltersAndDoFullBackupForDomain(packageName, "ef", manifestIncludeMap, manifestExcludeSet, traversalExcludeSet, data);
        }
    }

    public void onQuotaExceeded(long backupDataBytes, long quotaBytes) {
    }

    private int getBackupUserId() {
        return this.mUser == null ? super.getUserId() : this.mUser.getIdentifier();
    }

    private void applyXmlFiltersAndDoFullBackupForDomain(String packageName, String domainToken, Map<String, Set<FullBackup.BackupScheme.PathWithRequiredFlags>> includeMap, ArraySet<FullBackup.BackupScheme.PathWithRequiredFlags> filterSet, ArraySet<String> traversalExcludeSet, FullBackupDataOutput data) throws IOException {
        if (includeMap == null || includeMap.size() == 0) {
            this.fullBackupFileTree(packageName, domainToken, FullBackup.getBackupScheme(this).tokenToDirectoryPath(domainToken), filterSet, traversalExcludeSet, data);
        } else if (includeMap.get(domainToken) != null) {
            for (FullBackup.BackupScheme.PathWithRequiredFlags includeFile : includeMap.get(domainToken)) {
                if (!this.areIncludeRequiredTransportFlagsSatisfied(includeFile.getRequiredFlags(), data.getTransportFlags())) continue;
                this.fullBackupFileTree(packageName, domainToken, includeFile.getPath(), filterSet, traversalExcludeSet, data);
            }
        }
    }

    private boolean areIncludeRequiredTransportFlagsSatisfied(int includeFlags, int transportFlags) {
        return (transportFlags & includeFlags) == includeFlags;
    }

    public final void fullBackupFile(File file, FullBackupDataOutput output) {
        String domain;
        String filePath;
        String libDir;
        String deviceCodeCacheDir;
        String deviceCacheDir;
        String deviceSpDir;
        String deviceDbDir;
        String deviceNbFilesDir;
        String deviceFilesDir;
        String deviceRootDir;
        String codeCacheDir;
        String cacheDir;
        String spDir;
        String dbDir;
        String nbFilesDir;
        String filesDir;
        String rootDir;
        String efDir = null;
        ApplicationInfo appInfo = this.getApplicationInfo();
        try {
            File efLocation;
            Context ceContext = this.createCredentialProtectedStorageContext();
            rootDir = ceContext.getDataDir().getCanonicalPath();
            filesDir = ceContext.getFilesDir().getCanonicalPath();
            nbFilesDir = ceContext.getNoBackupFilesDir().getCanonicalPath();
            dbDir = ceContext.getDatabasePath("foo").getParentFile().getCanonicalPath();
            spDir = ceContext.getSharedPreferencesPath("foo").getParentFile().getCanonicalPath();
            cacheDir = ceContext.getCacheDir().getCanonicalPath();
            codeCacheDir = ceContext.getCodeCacheDir().getCanonicalPath();
            Context deContext = this.createDeviceProtectedStorageContext();
            deviceRootDir = deContext.getDataDir().getCanonicalPath();
            deviceFilesDir = deContext.getFilesDir().getCanonicalPath();
            deviceNbFilesDir = deContext.getNoBackupFilesDir().getCanonicalPath();
            deviceDbDir = deContext.getDatabasePath("foo").getParentFile().getCanonicalPath();
            deviceSpDir = deContext.getSharedPreferencesPath("foo").getParentFile().getCanonicalPath();
            deviceCacheDir = deContext.getCacheDir().getCanonicalPath();
            deviceCodeCacheDir = deContext.getCodeCacheDir().getCanonicalPath();
            String string2 = libDir = appInfo.nativeLibraryDir == null ? null : new File(appInfo.nativeLibraryDir).getCanonicalPath();
            if (Process.myUid() != 1000 && (efLocation = this.getExternalFilesDir(null)) != null) {
                efDir = efLocation.getCanonicalPath();
            }
            filePath = file.getCanonicalPath();
        }
        catch (IOException e) {
            Log.w(TAG, "Unable to obtain canonical paths");
            return;
        }
        if (filePath.startsWith(cacheDir) || filePath.startsWith(codeCacheDir) || filePath.startsWith(nbFilesDir) || filePath.startsWith(deviceCacheDir) || filePath.startsWith(deviceCodeCacheDir) || filePath.startsWith(deviceNbFilesDir) || filePath.startsWith(libDir)) {
            Log.w(TAG, "lib, cache, code_cache, and no_backup files are not backed up");
            return;
        }
        String rootpath = null;
        if (filePath.startsWith(dbDir)) {
            domain = "db";
            rootpath = dbDir;
        } else if (filePath.startsWith(spDir)) {
            domain = "sp";
            rootpath = spDir;
        } else if (filePath.startsWith(filesDir)) {
            domain = "f";
            rootpath = filesDir;
        } else if (filePath.startsWith(rootDir)) {
            domain = "r";
            rootpath = rootDir;
        } else if (filePath.startsWith(deviceDbDir)) {
            domain = "d_db";
            rootpath = deviceDbDir;
        } else if (filePath.startsWith(deviceSpDir)) {
            domain = "d_sp";
            rootpath = deviceSpDir;
        } else if (filePath.startsWith(deviceFilesDir)) {
            domain = "d_f";
            rootpath = deviceFilesDir;
        } else if (filePath.startsWith(deviceRootDir)) {
            domain = "d_r";
            rootpath = deviceRootDir;
        } else if (efDir != null && filePath.startsWith(efDir)) {
            domain = "ef";
            rootpath = efDir;
        } else {
            Log.w(TAG, "File " + filePath + " is in an unsupported location; skipping");
            return;
        }
        FullBackup.backupToTar(this.getPackageName(), domain, null, rootpath, filePath, output);
    }

    protected final void fullBackupFileTree(String packageName, String domain, String startingPath, ArraySet<FullBackup.BackupScheme.PathWithRequiredFlags> manifestExcludes, ArraySet<String> systemExcludes, FullBackupDataOutput output) {
        String domainPath = FullBackup.getBackupScheme(this).tokenToDirectoryPath(domain);
        if (domainPath == null) {
            return;
        }
        File rootFile = new File(startingPath);
        if (rootFile.exists()) {
            LinkedList<File> scanQueue = new LinkedList<File>();
            scanQueue.add(rootFile);
            while (scanQueue.size() > 0) {
                String filePath;
                block7: {
                    File file = (File)scanQueue.remove(0);
                    try {
                        File[] contents;
                        StructStat stat = Os.lstat(file.getPath());
                        if (!OsConstants.S_ISREG(stat.st_mode) && !OsConstants.S_ISDIR(stat.st_mode)) continue;
                        filePath = file.getCanonicalPath();
                        if (manifestExcludes != null && this.manifestExcludesContainFilePath(manifestExcludes, filePath) || systemExcludes != null && systemExcludes.contains(filePath)) continue;
                        if (!OsConstants.S_ISDIR(stat.st_mode) || (contents = file.listFiles()) == null) break block7;
                        for (File entry : contents) {
                            scanQueue.add(0, entry);
                        }
                    }
                    catch (IOException e) {
                        if (!Log.isLoggable("BackupXmlParserLogging", 2)) continue;
                        Log.v("BackupXmlParserLogging", "Error canonicalizing path of " + file);
                        continue;
                    }
                    catch (ErrnoException e) {
                        if (!Log.isLoggable("BackupXmlParserLogging", 2)) continue;
                        Log.v("BackupXmlParserLogging", "Error scanning file " + file + " : " + e);
                        continue;
                    }
                }
                FullBackup.backupToTar(packageName, domain, null, domainPath, filePath, output);
            }
        }
    }

    private boolean manifestExcludesContainFilePath(ArraySet<FullBackup.BackupScheme.PathWithRequiredFlags> manifestExcludes, String filePath) {
        for (FullBackup.BackupScheme.PathWithRequiredFlags exclude : manifestExcludes) {
            String excludePath = exclude.getPath();
            if (excludePath == null || !excludePath.equals(filePath)) continue;
            return true;
        }
        return false;
    }

    public void onRestoreFile(ParcelFileDescriptor data, long size, File destination, int type, long mode, long mtime) throws IOException {
        boolean accept = this.isFileEligibleForRestore(destination);
        FullBackup.restoreFile(data, size, type, mode, mtime, accept ? destination : null);
    }

    private boolean isFileEligibleForRestore(File destination) throws IOException {
        FullBackup.BackupScheme bs = FullBackup.getBackupScheme(this);
        if (!bs.isFullBackupContentEnabled()) {
            if (Log.isLoggable("BackupXmlParserLogging", 2)) {
                Log.v("BackupXmlParserLogging", "onRestoreFile \"" + destination.getCanonicalPath() + "\" : fullBackupContent not enabled for " + this.getPackageName());
            }
            return false;
        }
        Map<String, Set<FullBackup.BackupScheme.PathWithRequiredFlags>> includes = null;
        ArraySet<FullBackup.BackupScheme.PathWithRequiredFlags> excludes = null;
        String destinationCanonicalPath = destination.getCanonicalPath();
        try {
            includes = bs.maybeParseAndGetCanonicalIncludePaths();
            excludes = bs.maybeParseAndGetCanonicalExcludePaths();
        }
        catch (XmlPullParserException e) {
            if (Log.isLoggable("BackupXmlParserLogging", 2)) {
                Log.v("BackupXmlParserLogging", "onRestoreFile \"" + destinationCanonicalPath + "\" : Exception trying to parse fullBackupContent xml file! Aborting onRestoreFile.", e);
            }
            return false;
        }
        if (excludes != null && BackupUtils.isFileSpecifiedInPathList(destination, excludes)) {
            if (Log.isLoggable("BackupXmlParserLogging", 2)) {
                Log.v("BackupXmlParserLogging", "onRestoreFile: \"" + destinationCanonicalPath + "\": listed in excludes; skipping.");
            }
            return false;
        }
        if (includes != null && !includes.isEmpty()) {
            boolean explicitlyIncluded = false;
            for (Set<FullBackup.BackupScheme.PathWithRequiredFlags> domainIncludes : includes.values()) {
                if (explicitlyIncluded |= BackupUtils.isFileSpecifiedInPathList(destination, domainIncludes)) break;
            }
            if (!explicitlyIncluded) {
                if (Log.isLoggable("BackupXmlParserLogging", 2)) {
                    Log.v("BackupXmlParserLogging", "onRestoreFile: Trying to restore \"" + destinationCanonicalPath + "\" but it isn't specified in the included files; skipping.");
                }
                return false;
            }
        }
        return true;
    }

    protected void onRestoreFile(ParcelFileDescriptor data, long size, int type, String domain, String path, long mode, long mtime) throws IOException {
        File outFile;
        String outPath;
        String basePath = null;
        basePath = FullBackup.getBackupScheme(this).tokenToDirectoryPath(domain);
        if (domain.equals("ef")) {
            mode = -1L;
        }
        if (basePath != null && (outPath = (outFile = new File(basePath, path)).getCanonicalPath()).startsWith(basePath + File.separatorChar)) {
            this.onRestoreFile(data, size, outFile, type, mode, mtime);
            return;
        }
        FullBackup.restoreFile(data, size, type, mode, mtime, null);
    }

    public void onRestoreFinished() {
    }

    public final IBinder onBind() {
        return this.mBinder;
    }

    public void attach(Context context) {
        this.attachBaseContext(context);
    }

    static class FailRunnable
    implements Runnable {
        private String mMessage;

        FailRunnable(String message) {
            this.mMessage = message;
        }

        @Override
        public void run() {
            throw new IllegalStateException(this.mMessage);
        }
    }

    private class BackupServiceBinder
    extends IBackupAgent.Stub {
        private static final String TAG = "BackupServiceBinder";

        private BackupServiceBinder() {
        }

        @Override
        public void doBackup(ParcelFileDescriptor oldState, ParcelFileDescriptor data, ParcelFileDescriptor newState, long quotaBytes, IBackupCallback callbackBinder, int transportFlags) throws RemoteException {
            long ident = Binder.clearCallingIdentity();
            BackupDataOutput output = new BackupDataOutput(data.getFileDescriptor(), quotaBytes, transportFlags);
            long result = -1L;
            try {
                BackupAgent.this.onBackup(oldState, output, newState);
                result = 0L;
            }
            catch (IOException ex) {
                Log.d(TAG, "onBackup (" + BackupAgent.this.getClass().getName() + ") threw", ex);
                throw new RuntimeException(ex);
            }
            catch (RuntimeException ex) {
                Log.d(TAG, "onBackup (" + BackupAgent.this.getClass().getName() + ") threw", ex);
                throw ex;
            }
            finally {
                BackupAgent.this.waitForSharedPrefs();
                Binder.restoreCallingIdentity(ident);
                try {
                    callbackBinder.operationComplete(result);
                }
                catch (RemoteException remoteException) {}
                if (Binder.getCallingPid() != Process.myPid()) {
                    IoUtils.closeQuietly(oldState);
                    IoUtils.closeQuietly(data);
                    IoUtils.closeQuietly(newState);
                }
            }
        }

        @Override
        public void doRestore(ParcelFileDescriptor data, long appVersionCode, ParcelFileDescriptor newState, int token, IBackupManager callbackBinder) throws RemoteException {
            long ident = Binder.clearCallingIdentity();
            BackupAgent.this.waitForSharedPrefs();
            BackupDataInput input = new BackupDataInput(data.getFileDescriptor());
            try {
                BackupAgent.this.onRestore(input, appVersionCode, newState);
            }
            catch (IOException ex) {
                Log.d(TAG, "onRestore (" + BackupAgent.this.getClass().getName() + ") threw", ex);
                throw new RuntimeException(ex);
            }
            catch (RuntimeException ex) {
                Log.d(TAG, "onRestore (" + BackupAgent.this.getClass().getName() + ") threw", ex);
                throw ex;
            }
            finally {
                BackupAgent.this.reloadSharedPreferences();
                Binder.restoreCallingIdentity(ident);
                try {
                    callbackBinder.opCompleteForUser(BackupAgent.this.getBackupUserId(), token, 0L);
                }
                catch (RemoteException remoteException) {}
                if (Binder.getCallingPid() != Process.myPid()) {
                    IoUtils.closeQuietly(data);
                    IoUtils.closeQuietly(newState);
                }
            }
        }

        @Override
        public void doFullBackup(ParcelFileDescriptor data, long quotaBytes, int token, IBackupManager callbackBinder, int transportFlags) {
            long ident = Binder.clearCallingIdentity();
            BackupAgent.this.waitForSharedPrefs();
            try {
                BackupAgent.this.onFullBackup(new FullBackupDataOutput(data, quotaBytes, transportFlags));
            }
            catch (IOException ex) {
                Log.d(TAG, "onFullBackup (" + BackupAgent.this.getClass().getName() + ") threw", ex);
                throw new RuntimeException(ex);
            }
            catch (RuntimeException ex) {
                Log.d(TAG, "onFullBackup (" + BackupAgent.this.getClass().getName() + ") threw", ex);
                throw ex;
            }
            finally {
                BackupAgent.this.waitForSharedPrefs();
                try {
                    FileOutputStream out = new FileOutputStream(data.getFileDescriptor());
                    byte[] buf = new byte[4];
                    out.write(buf);
                }
                catch (IOException e) {
                    Log.e(TAG, "Unable to finalize backup stream!");
                }
                Binder.restoreCallingIdentity(ident);
                try {
                    callbackBinder.opCompleteForUser(BackupAgent.this.getBackupUserId(), token, 0L);
                }
                catch (RemoteException remoteException) {}
                if (Binder.getCallingPid() != Process.myPid()) {
                    IoUtils.closeQuietly(data);
                }
            }
        }

        @Override
        public void doMeasureFullBackup(long quotaBytes, int token, IBackupManager callbackBinder, int transportFlags) {
            long ident = Binder.clearCallingIdentity();
            FullBackupDataOutput measureOutput = new FullBackupDataOutput(quotaBytes, transportFlags);
            BackupAgent.this.waitForSharedPrefs();
            try {
                BackupAgent.this.onFullBackup(measureOutput);
            }
            catch (IOException ex) {
                Log.d(TAG, "onFullBackup[M] (" + BackupAgent.this.getClass().getName() + ") threw", ex);
                throw new RuntimeException(ex);
            }
            catch (RuntimeException ex) {
                Log.d(TAG, "onFullBackup[M] (" + BackupAgent.this.getClass().getName() + ") threw", ex);
                throw ex;
            }
            finally {
                Binder.restoreCallingIdentity(ident);
                try {
                    callbackBinder.opCompleteForUser(BackupAgent.this.getBackupUserId(), token, measureOutput.getSize());
                }
                catch (RemoteException remoteException) {}
            }
        }

        @Override
        public void doRestoreFile(ParcelFileDescriptor data, long size, int type, String domain, String path, long mode, long mtime, int token, IBackupManager callbackBinder) throws RemoteException {
            long ident = Binder.clearCallingIdentity();
            try {
                BackupAgent.this.onRestoreFile(data, size, type, domain, path, mode, mtime);
            }
            catch (IOException e) {
                Log.d(TAG, "onRestoreFile (" + BackupAgent.this.getClass().getName() + ") threw", e);
                throw new RuntimeException(e);
            }
            finally {
                BackupAgent.this.waitForSharedPrefs();
                BackupAgent.this.reloadSharedPreferences();
                Binder.restoreCallingIdentity(ident);
                try {
                    callbackBinder.opCompleteForUser(BackupAgent.this.getBackupUserId(), token, 0L);
                }
                catch (RemoteException remoteException) {}
                if (Binder.getCallingPid() != Process.myPid()) {
                    IoUtils.closeQuietly(data);
                }
            }
        }

        @Override
        public void doRestoreFinished(int token, IBackupManager callbackBinder) {
            long ident = Binder.clearCallingIdentity();
            try {
                BackupAgent.this.onRestoreFinished();
            }
            catch (Exception e) {
                Log.d(TAG, "onRestoreFinished (" + BackupAgent.this.getClass().getName() + ") threw", e);
                throw e;
            }
            finally {
                BackupAgent.this.waitForSharedPrefs();
                Binder.restoreCallingIdentity(ident);
                try {
                    callbackBinder.opCompleteForUser(BackupAgent.this.getBackupUserId(), token, 0L);
                }
                catch (RemoteException remoteException) {}
            }
        }

        @Override
        public void fail(String message) {
            BackupAgent.this.getHandler().post(new FailRunnable(message));
        }

        @Override
        public void doQuotaExceeded(long backupDataBytes, long quotaBytes, IBackupCallback callbackBinder) {
            long ident = Binder.clearCallingIdentity();
            long result = -1L;
            try {
                BackupAgent.this.onQuotaExceeded(backupDataBytes, quotaBytes);
                result = 0L;
            }
            catch (Exception e) {
                Log.d(TAG, "onQuotaExceeded(" + BackupAgent.this.getClass().getName() + ") threw", e);
                throw e;
            }
            finally {
                BackupAgent.this.waitForSharedPrefs();
                Binder.restoreCallingIdentity(ident);
                try {
                    callbackBinder.operationComplete(result);
                }
                catch (RemoteException remoteException) {}
            }
        }
    }

    class SharedPrefsSynchronizer
    implements Runnable {
        public final CountDownLatch mLatch = new CountDownLatch(1);

        SharedPrefsSynchronizer() {
        }

        @Override
        public void run() {
            QueuedWork.waitToFinish();
            this.mLatch.countDown();
        }
    }
}

