/*
 * Decompiled with CFR 0.152.
 */
package android.app.backup;

import android.app.backup.BackupDataInputStream;
import android.app.backup.BackupDataOutput;
import android.app.backup.BackupHelper;
import android.app.backup.FileBackupHelperBase;
import android.content.Context;
import android.os.ParcelFileDescriptor;
import java.io.File;

public class FileBackupHelper
extends FileBackupHelperBase
implements BackupHelper {
    private static final String TAG = "FileBackupHelper";
    private static final boolean DEBUG = false;
    Context mContext;
    File mFilesDir;
    String[] mFiles;

    public FileBackupHelper(Context context, String ... files) {
        super(context);
        this.mContext = context;
        this.mFilesDir = context.getFilesDir();
        this.mFiles = files;
    }

    @Override
    public void performBackup(ParcelFileDescriptor oldState, BackupDataOutput data, ParcelFileDescriptor newState) {
        String[] files = this.mFiles;
        File base = this.mContext.getFilesDir();
        int N = files.length;
        String[] fullPaths = new String[N];
        for (int i = 0; i < N; ++i) {
            fullPaths[i] = new File(base, files[i]).getAbsolutePath();
        }
        FileBackupHelper.performBackup_checked(oldState, data, newState, fullPaths, files);
    }

    @Override
    public void restoreEntity(BackupDataInputStream data) {
        String key = data.getKey();
        if (this.isKeyInList(key, this.mFiles)) {
            File f = new File(this.mFilesDir, key);
            this.writeFile(f, data);
        }
    }
}

