/*
 * Decompiled with CFR 0.152.
 */
package android.app.role;

import android.annotation.SystemApi;
import android.app.Service;
import android.app.role.IRoleController;
import android.app.role.RoleManager;
import android.content.Intent;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.RemoteCallback;
import com.android.internal.util.Preconditions;
import com.android.internal.util.function.pooled.PooledLambda;

@SystemApi
public abstract class RoleControllerService
extends Service {
    public static final String SERVICE_INTERFACE = "android.app.role.RoleControllerService";
    private HandlerThread mWorkerThread;
    private Handler mWorkerHandler;

    @Override
    public void onCreate() {
        super.onCreate();
        this.mWorkerThread = new HandlerThread(RoleControllerService.class.getSimpleName());
        this.mWorkerThread.start();
        this.mWorkerHandler = new Handler(this.mWorkerThread.getLooper());
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mWorkerThread.quitSafely();
    }

    @Override
    public final IBinder onBind(Intent intent) {
        return new IRoleController.Stub(){

            @Override
            public void grantDefaultRoles(RemoteCallback callback) {
                this.enforceCallerSystemUid("grantDefaultRoles");
                Preconditions.checkNotNull(callback, "callback cannot be null");
                RoleControllerService.this.mWorkerHandler.sendMessage(PooledLambda.obtainMessage((rec$, x$0) -> ((RoleControllerService)rec$).grantDefaultRoles(x$0), RoleControllerService.this, callback));
            }

            @Override
            public void onAddRoleHolder(String roleName, String packageName, int flags, RemoteCallback callback) {
                this.enforceCallerSystemUid("onAddRoleHolder");
                Preconditions.checkStringNotEmpty(roleName, "roleName cannot be null or empty");
                Preconditions.checkStringNotEmpty(packageName, "packageName cannot be null or empty");
                Preconditions.checkNotNull(callback, "callback cannot be null");
                RoleControllerService.this.mWorkerHandler.sendMessage(PooledLambda.obtainMessage((rec$, x$0, x$1, x$2, x$3) -> ((RoleControllerService)rec$).onAddRoleHolder(x$0, x$1, x$2, x$3), RoleControllerService.this, roleName, packageName, flags, callback));
            }

            @Override
            public void onRemoveRoleHolder(String roleName, String packageName, int flags, RemoteCallback callback) {
                this.enforceCallerSystemUid("onRemoveRoleHolder");
                Preconditions.checkStringNotEmpty(roleName, "roleName cannot be null or empty");
                Preconditions.checkStringNotEmpty(packageName, "packageName cannot be null or empty");
                Preconditions.checkNotNull(callback, "callback cannot be null");
                RoleControllerService.this.mWorkerHandler.sendMessage(PooledLambda.obtainMessage((rec$, x$0, x$1, x$2, x$3) -> ((RoleControllerService)rec$).onRemoveRoleHolder(x$0, x$1, x$2, x$3), RoleControllerService.this, roleName, packageName, flags, callback));
            }

            @Override
            public void onClearRoleHolders(String roleName, int flags, RemoteCallback callback) {
                this.enforceCallerSystemUid("onClearRoleHolders");
                Preconditions.checkStringNotEmpty(roleName, "roleName cannot be null or empty");
                Preconditions.checkNotNull(callback, "callback cannot be null");
                RoleControllerService.this.mWorkerHandler.sendMessage(PooledLambda.obtainMessage((rec$, x$0, x$1, x$2) -> ((RoleControllerService)rec$).onClearRoleHolders(x$0, x$1, x$2), RoleControllerService.this, roleName, flags, callback));
            }

            private void enforceCallerSystemUid(String methodName) {
                if (Binder.getCallingUid() != 1000) {
                    throw new SecurityException("Only the system process can call " + methodName + "()");
                }
            }

            @Override
            public void isApplicationQualifiedForRole(String roleName, String packageName, RemoteCallback callback) {
                RoleControllerService.this.enforceCallingPermission("android.permission.MANAGE_ROLE_HOLDERS", null);
                Preconditions.checkStringNotEmpty(roleName, "roleName cannot be null or empty");
                Preconditions.checkStringNotEmpty(packageName, "packageName cannot be null or empty");
                Preconditions.checkNotNull(callback, "callback cannot be null");
                boolean qualified = RoleControllerService.this.onIsApplicationQualifiedForRole(roleName, packageName);
                callback.sendResult(qualified ? Bundle.EMPTY : null);
            }

            @Override
            public void isRoleVisible(String roleName, RemoteCallback callback) {
                RoleControllerService.this.enforceCallingPermission("android.permission.MANAGE_ROLE_HOLDERS", null);
                Preconditions.checkStringNotEmpty(roleName, "roleName cannot be null or empty");
                Preconditions.checkNotNull(callback, "callback cannot be null");
                boolean visible = RoleControllerService.this.onIsRoleVisible(roleName);
                callback.sendResult(visible ? Bundle.EMPTY : null);
            }
        };
    }

    private void grantDefaultRoles(RemoteCallback callback) {
        boolean successful = this.onGrantDefaultRoles();
        callback.sendResult(successful ? Bundle.EMPTY : null);
    }

    private void onAddRoleHolder(String roleName, String packageName, @RoleManager.ManageHoldersFlags int flags, RemoteCallback callback) {
        boolean successful = this.onAddRoleHolder(roleName, packageName, flags);
        callback.sendResult(successful ? Bundle.EMPTY : null);
    }

    private void onRemoveRoleHolder(String roleName, String packageName, @RoleManager.ManageHoldersFlags int flags, RemoteCallback callback) {
        boolean successful = this.onRemoveRoleHolder(roleName, packageName, flags);
        callback.sendResult(successful ? Bundle.EMPTY : null);
    }

    private void onClearRoleHolders(String roleName, @RoleManager.ManageHoldersFlags int flags, RemoteCallback callback) {
        boolean successful = this.onClearRoleHolders(roleName, flags);
        callback.sendResult(successful ? Bundle.EMPTY : null);
    }

    public abstract boolean onGrantDefaultRoles();

    public abstract boolean onAddRoleHolder(String var1, String var2, @RoleManager.ManageHoldersFlags int var3);

    public abstract boolean onRemoveRoleHolder(String var1, String var2, @RoleManager.ManageHoldersFlags int var3);

    public abstract boolean onClearRoleHolders(String var1, @RoleManager.ManageHoldersFlags int var2);

    public abstract boolean onIsApplicationQualifiedForRole(String var1, String var2);

    public abstract boolean onIsRoleVisible(String var1);
}

