/*
 * Decompiled with CFR 0.152.
 */
package android.app.slice;

import android.app.PendingIntent;
import android.app.slice.Slice;
import android.app.slice.SliceManager;
import android.app.slice.SliceSpec;
import android.content.ComponentName;
import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.database.Cursor;
import android.graphics.drawable.Icon;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.Handler;
import android.os.Process;
import android.os.StrictMode;
import android.util.ArraySet;
import android.util.Log;
import android.util.TypedValue;
import android.view.ContextThemeWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public abstract class SliceProvider
extends ContentProvider {
    public static final String SLICE_TYPE = "vnd.android.slice";
    private static final String TAG = "SliceProvider";
    public static final String EXTRA_BIND_URI = "slice_uri";
    public static final String EXTRA_SUPPORTED_SPECS = "supported_specs";
    public static final String METHOD_SLICE = "bind_slice";
    public static final String METHOD_MAP_INTENT = "map_slice";
    public static final String METHOD_MAP_ONLY_INTENT = "map_only";
    public static final String METHOD_PIN = "pin";
    public static final String METHOD_UNPIN = "unpin";
    public static final String METHOD_GET_DESCENDANTS = "get_descendants";
    public static final String METHOD_GET_PERMISSIONS = "get_permissions";
    public static final String EXTRA_INTENT = "slice_intent";
    public static final String EXTRA_SLICE = "slice";
    public static final String EXTRA_SLICE_DESCENDANTS = "slice_descendants";
    public static final String EXTRA_PKG = "pkg";
    public static final String EXTRA_PROVIDER_PKG = "provider_pkg";
    public static final String EXTRA_RESULT = "result";
    private static final boolean DEBUG = false;
    private static final long SLICE_BIND_ANR = 2000L;
    private final String[] mAutoGrantPermissions;
    private String mCallback;
    private SliceManager mSliceManager;
    private final Runnable mAnr = () -> {
        Process.sendSignal(Process.myPid(), 3);
        Log.wtf(TAG, "Timed out while handling slice callback " + this.mCallback);
    };

    public SliceProvider(String ... autoGrantPermissions) {
        this.mAutoGrantPermissions = autoGrantPermissions;
    }

    public SliceProvider() {
        this.mAutoGrantPermissions = new String[0];
    }

    @Override
    public void attachInfo(Context context, ProviderInfo info) {
        super.attachInfo(context, info);
        this.mSliceManager = context.getSystemService(SliceManager.class);
    }

    public Slice onBindSlice(Uri sliceUri, Set<SliceSpec> supportedSpecs) {
        return this.onBindSlice(sliceUri, new ArrayList<SliceSpec>(supportedSpecs));
    }

    @Deprecated
    public Slice onBindSlice(Uri sliceUri, List<SliceSpec> supportedSpecs) {
        return null;
    }

    public void onSlicePinned(Uri sliceUri) {
    }

    public void onSliceUnpinned(Uri sliceUri) {
    }

    public Collection<Uri> onGetSliceDescendants(Uri uri) {
        return Collections.emptyList();
    }

    public Uri onMapIntentToUri(Intent intent) {
        throw new UnsupportedOperationException("This provider has not implemented intent to uri mapping");
    }

    public PendingIntent onCreatePermissionRequest(Uri sliceUri) {
        return SliceProvider.createPermissionIntent(this.getContext(), sliceUri, this.getCallingPackage());
    }

    @Override
    public final int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        return 0;
    }

    @Override
    public final int delete(Uri uri, String selection, String[] selectionArgs) {
        return 0;
    }

    @Override
    public final Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        return null;
    }

    @Override
    public final Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder, CancellationSignal cancellationSignal) {
        return null;
    }

    @Override
    public final Cursor query(Uri uri, String[] projection, Bundle queryArgs, CancellationSignal cancellationSignal) {
        return null;
    }

    @Override
    public final Uri insert(Uri uri, ContentValues values) {
        return null;
    }

    @Override
    public final String getType(Uri uri) {
        return SLICE_TYPE;
    }

    @Override
    public Bundle call(String method, String arg, Bundle extras) {
        if (method.equals(METHOD_SLICE)) {
            Uri uri = SliceProvider.getUriWithoutUserId((Uri)extras.getParcelable(EXTRA_BIND_URI));
            ArrayList<SliceSpec> supportedSpecs = extras.getParcelableArrayList(EXTRA_SUPPORTED_SPECS);
            String callingPackage = this.getCallingPackage();
            int callingUid = Binder.getCallingUid();
            int callingPid = Binder.getCallingPid();
            Slice s = this.handleBindSlice(uri, supportedSpecs, callingPackage, callingUid, callingPid);
            Bundle b = new Bundle();
            b.putParcelable(EXTRA_SLICE, s);
            return b;
        }
        if (method.equals(METHOD_MAP_INTENT)) {
            Intent intent = (Intent)extras.getParcelable(EXTRA_INTENT);
            if (intent == null) {
                return null;
            }
            Uri uri = this.onMapIntentToUri(intent);
            ArrayList<SliceSpec> supportedSpecs = extras.getParcelableArrayList(EXTRA_SUPPORTED_SPECS);
            Bundle b = new Bundle();
            if (uri != null) {
                Slice s = this.handleBindSlice(uri, supportedSpecs, this.getCallingPackage(), Binder.getCallingUid(), Binder.getCallingPid());
                b.putParcelable(EXTRA_SLICE, s);
            } else {
                b.putParcelable(EXTRA_SLICE, null);
            }
            return b;
        }
        if (method.equals(METHOD_MAP_ONLY_INTENT)) {
            Intent intent = (Intent)extras.getParcelable(EXTRA_INTENT);
            if (intent == null) {
                return null;
            }
            Uri uri = this.onMapIntentToUri(intent);
            Bundle b = new Bundle();
            b.putParcelable(EXTRA_SLICE, uri);
            return b;
        }
        if (method.equals(METHOD_PIN)) {
            Uri uri = SliceProvider.getUriWithoutUserId((Uri)extras.getParcelable(EXTRA_BIND_URI));
            if (Binder.getCallingUid() != 1000) {
                throw new SecurityException("Only the system can pin/unpin slices");
            }
            this.handlePinSlice(uri);
        } else if (method.equals(METHOD_UNPIN)) {
            Uri uri = SliceProvider.getUriWithoutUserId((Uri)extras.getParcelable(EXTRA_BIND_URI));
            if (Binder.getCallingUid() != 1000) {
                throw new SecurityException("Only the system can pin/unpin slices");
            }
            this.handleUnpinSlice(uri);
        } else {
            if (method.equals(METHOD_GET_DESCENDANTS)) {
                Uri uri = SliceProvider.getUriWithoutUserId((Uri)extras.getParcelable(EXTRA_BIND_URI));
                Bundle b = new Bundle();
                b.putParcelableArrayList(EXTRA_SLICE_DESCENDANTS, new ArrayList<Uri>(this.handleGetDescendants(uri)));
                return b;
            }
            if (method.equals(METHOD_GET_PERMISSIONS)) {
                if (Binder.getCallingUid() != 1000) {
                    throw new SecurityException("Only the system can get permissions");
                }
                Bundle b = new Bundle();
                b.putStringArray(EXTRA_RESULT, this.mAutoGrantPermissions);
                return b;
            }
        }
        return super.call(method, arg, extras);
    }

    private Collection<Uri> handleGetDescendants(Uri uri) {
        this.mCallback = "onGetSliceDescendants";
        return this.onGetSliceDescendants(uri);
    }

    private void handlePinSlice(Uri sliceUri) {
        this.mCallback = "onSlicePinned";
        Handler.getMain().postDelayed(this.mAnr, 2000L);
        try {
            this.onSlicePinned(sliceUri);
        }
        finally {
            Handler.getMain().removeCallbacks(this.mAnr);
        }
    }

    private void handleUnpinSlice(Uri sliceUri) {
        this.mCallback = "onSliceUnpinned";
        Handler.getMain().postDelayed(this.mAnr, 2000L);
        try {
            this.onSliceUnpinned(sliceUri);
        }
        finally {
            Handler.getMain().removeCallbacks(this.mAnr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Slice handleBindSlice(Uri sliceUri, List<SliceSpec> supportedSpecs, String callingPkg, int callingUid, int callingPid) {
        String pkg = callingPkg != null ? callingPkg : this.getContext().getPackageManager().getNameForUid(callingUid);
        try {
            this.mSliceManager.enforceSlicePermission(sliceUri, pkg, callingPid, callingUid, this.mAutoGrantPermissions);
        }
        catch (SecurityException e) {
            return this.createPermissionSlice(this.getContext(), sliceUri, pkg);
        }
        this.mCallback = "onBindSlice";
        Handler.getMain().postDelayed(this.mAnr, 2000L);
        try {
            Slice slice = this.onBindSliceStrict(sliceUri, supportedSpecs);
            return slice;
        }
        finally {
            Handler.getMain().removeCallbacks(this.mAnr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Slice createPermissionSlice(Context context, Uri sliceUri, String callingPackage) {
        PendingIntent action;
        this.mCallback = "onCreatePermissionRequest";
        Handler.getMain().postDelayed(this.mAnr, 2000L);
        try {
            action = this.onCreatePermissionRequest(sliceUri);
        }
        finally {
            Handler.getMain().removeCallbacks(this.mAnr);
        }
        Slice.Builder parent = new Slice.Builder(sliceUri);
        Slice.Builder childAction = new Slice.Builder(parent).addIcon(Icon.createWithResource(context, 17302765), null, Collections.emptyList()).addHints(Arrays.asList("title", "shortcut")).addAction(action, new Slice.Builder(parent).build(), null);
        TypedValue tv = new TypedValue();
        new ContextThemeWrapper(context, 16974123).getTheme().resolveAttribute(16843829, tv, true);
        int deviceDefaultAccent = tv.data;
        parent.addSubSlice(new Slice.Builder(sliceUri.buildUpon().appendPath("permission").build()).addIcon(Icon.createWithResource(context, 17302286), null, Collections.emptyList()).addText(SliceProvider.getPermissionString(context, callingPackage), null, Collections.emptyList()).addInt(deviceDefaultAccent, "color", Collections.emptyList()).addSubSlice(childAction.build(), null).build(), null);
        return parent.addHints(Arrays.asList("permission_request")).build();
    }

    public static PendingIntent createPermissionIntent(Context context, Uri sliceUri, String callingPackage) {
        Intent intent = new Intent("com.android.intent.action.REQUEST_SLICE_PERMISSION");
        intent.setComponent(new ComponentName("com.android.systemui", "com.android.systemui.SlicePermissionActivity"));
        intent.putExtra(EXTRA_BIND_URI, sliceUri);
        intent.putExtra(EXTRA_PKG, callingPackage);
        intent.putExtra(EXTRA_PROVIDER_PKG, context.getPackageName());
        intent.setData(sliceUri.buildUpon().appendQueryParameter("package", callingPackage).build());
        return PendingIntent.getActivity(context, 0, intent, 0);
    }

    public static CharSequence getPermissionString(Context context, String callingPackage) {
        PackageManager pm = context.getPackageManager();
        try {
            return context.getString(17041039, pm.getApplicationInfo(callingPackage, 0).loadLabel(pm), context.getApplicationInfo().loadLabel(pm));
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException("Unknown calling app", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Slice onBindSliceStrict(Uri sliceUri, List<SliceSpec> supportedSpecs) {
        StrictMode.ThreadPolicy oldPolicy = StrictMode.getThreadPolicy();
        try {
            StrictMode.setThreadPolicy(new StrictMode.ThreadPolicy.Builder().detectAll().penaltyDeath().build());
            Slice slice = this.onBindSlice(sliceUri, new ArraySet<SliceSpec>(supportedSpecs));
            return slice;
        }
        finally {
            StrictMode.setThreadPolicy(oldPolicy);
        }
    }
}

