/*
 * Decompiled with CFR 0.152.
 */
package android.app.slice;

import android.app.slice.Slice;
import android.app.slice.SliceItem;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class SliceQuery {
    private static final String TAG = "SliceQuery";

    public static SliceItem getPrimaryIcon(Slice slice) {
        for (SliceItem item : slice.getItems()) {
            SliceItem icon;
            if (Objects.equals(item.getFormat(), "image")) {
                return item;
            }
            if (SliceQuery.compareTypes(item, "slice") && item.hasHint("list") || item.hasHint("actions") || item.hasHint("list_item") || SliceQuery.compareTypes(item, "action") || (icon = SliceQuery.find(item, "image")) == null) continue;
            return icon;
        }
        return null;
    }

    public static SliceItem findNotContaining(SliceItem container, List<SliceItem> list) {
        SliceItem ret = null;
        while (ret == null && list.size() != 0) {
            SliceItem remove = list.remove(0);
            if (SliceQuery.contains(container, remove)) continue;
            ret = remove;
        }
        return ret;
    }

    private static boolean contains(SliceItem container, SliceItem item) {
        if (container == null || item == null) {
            return false;
        }
        return SliceQuery.stream(container).filter(s -> s == item).findAny().isPresent();
    }

    public static List<SliceItem> findAll(SliceItem s, String type) {
        return SliceQuery.findAll(s, type, (String[])null, null);
    }

    public static List<SliceItem> findAll(SliceItem s, String type, String hints, String nonHints) {
        return SliceQuery.findAll(s, type, new String[]{hints}, new String[]{nonHints});
    }

    public static List<SliceItem> findAll(SliceItem s, String type, String[] hints, String[] nonHints) {
        return SliceQuery.stream(s).filter(item -> SliceQuery.compareTypes(item, type) && item.hasHints(hints) && !item.hasAnyHints(nonHints)).collect(Collectors.toList());
    }

    public static SliceItem find(Slice s, String type, String hints, String nonHints) {
        return SliceQuery.find(s, type, new String[]{hints}, new String[]{nonHints});
    }

    public static SliceItem find(Slice s, String type) {
        return SliceQuery.find(s, type, (String[])null, null);
    }

    public static SliceItem find(SliceItem s, String type) {
        return SliceQuery.find(s, type, (String[])null, null);
    }

    public static SliceItem find(SliceItem s, String type, String hints, String nonHints) {
        return SliceQuery.find(s, type, new String[]{hints}, new String[]{nonHints});
    }

    public static SliceItem find(Slice s, String type, String[] hints, String[] nonHints) {
        List<String> h = s.getHints();
        return SliceQuery.find(new SliceItem((Object)s, "slice", null, h.toArray(new String[h.size()])), type, hints, nonHints);
    }

    public static SliceItem find(SliceItem s, String type, String[] hints, String[] nonHints) {
        return SliceQuery.stream(s).filter(item -> SliceQuery.compareTypes(item, type) && item.hasHints(hints) && !item.hasAnyHints(nonHints)).findFirst().orElse(null);
    }

    public static Stream<SliceItem> stream(SliceItem slice) {
        final LinkedList<SliceItem> items = new LinkedList<SliceItem>();
        items.add(slice);
        Iterator<SliceItem> iterator = new Iterator<SliceItem>(){

            @Override
            public boolean hasNext() {
                return items.size() != 0;
            }

            @Override
            public SliceItem next() {
                SliceItem item = (SliceItem)items.poll();
                if (SliceQuery.compareTypes(item, "slice") || SliceQuery.compareTypes(item, "action")) {
                    items.addAll(item.getSlice().getItems());
                }
                return item;
            }
        };
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 0), false);
    }

    public static boolean compareTypes(SliceItem item, String desiredType) {
        int typeLength = desiredType.length();
        if (typeLength == 3 && desiredType.equals("*/*")) {
            return true;
        }
        if (item.getSubType() == null && desiredType.indexOf(47) < 0) {
            return item.getFormat().equals(desiredType);
        }
        return (item.getFormat() + "/" + item.getSubType()).matches(desiredType.replaceAll("\\*", ".*"));
    }
}

