/*
 * Decompiled with CFR 0.152.
 */
package android.app.usage;

import android.annotation.SystemApi;
import android.app.usage.UsageStats;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.Preconditions;
import java.util.Objects;

@SystemApi
public final class CacheQuotaHint
implements Parcelable {
    public static final long QUOTA_NOT_SET = -1L;
    private final String mUuid;
    private final int mUid;
    private final UsageStats mUsageStats;
    private final long mQuota;
    public static final Parcelable.Creator<CacheQuotaHint> CREATOR = new Parcelable.Creator<CacheQuotaHint>(){

        @Override
        public CacheQuotaHint createFromParcel(Parcel in) {
            Builder builder = new Builder();
            return builder.setVolumeUuid(in.readString()).setUid(in.readInt()).setQuota(in.readLong()).setUsageStats((UsageStats)in.readParcelable(UsageStats.class.getClassLoader())).build();
        }

        public CacheQuotaHint[] newArray(int size) {
            return new CacheQuotaHint[size];
        }
    };

    public CacheQuotaHint(Builder builder) {
        this.mUuid = builder.mUuid;
        this.mUid = builder.mUid;
        this.mUsageStats = builder.mUsageStats;
        this.mQuota = builder.mQuota;
    }

    public String getVolumeUuid() {
        return this.mUuid;
    }

    public int getUid() {
        return this.mUid;
    }

    public long getQuota() {
        return this.mQuota;
    }

    public UsageStats getUsageStats() {
        return this.mUsageStats;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mUuid);
        dest.writeInt(this.mUid);
        dest.writeLong(this.mQuota);
        dest.writeParcelable(this.mUsageStats, 0);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(Object o) {
        if (o instanceof CacheQuotaHint) {
            CacheQuotaHint other = (CacheQuotaHint)o;
            return Objects.equals(this.mUuid, other.mUuid) && Objects.equals(this.mUsageStats, other.mUsageStats) && this.mUid == other.mUid && this.mQuota == other.mQuota;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.mUuid, this.mUid, this.mUsageStats, this.mQuota);
    }

    public static final class Builder {
        private String mUuid;
        private int mUid;
        private UsageStats mUsageStats;
        private long mQuota;

        public Builder() {
        }

        public Builder(CacheQuotaHint hint) {
            this.setVolumeUuid(hint.getVolumeUuid());
            this.setUid(hint.getUid());
            this.setUsageStats(hint.getUsageStats());
            this.setQuota(hint.getQuota());
        }

        public Builder setVolumeUuid(String uuid) {
            this.mUuid = uuid;
            return this;
        }

        public Builder setUid(int uid) {
            Preconditions.checkArgumentNonnegative(uid, "Proposed uid was negative.");
            this.mUid = uid;
            return this;
        }

        public Builder setUsageStats(UsageStats stats) {
            this.mUsageStats = stats;
            return this;
        }

        public Builder setQuota(long quota) {
            Preconditions.checkArgument(quota >= -1L);
            this.mQuota = quota;
            return this;
        }

        public CacheQuotaHint build() {
            return new CacheQuotaHint(this);
        }
    }
}

