/*
 * Decompiled with CFR 0.152.
 */
package android.app.usage;

import android.app.usage.UsageEvents;
import java.util.ArrayList;

public class EventList {
    private final ArrayList<UsageEvents.Event> mEvents = new ArrayList();

    public int size() {
        return this.mEvents.size();
    }

    public void clear() {
        this.mEvents.clear();
    }

    public UsageEvents.Event get(int index) {
        return this.mEvents.get(index);
    }

    public void insert(UsageEvents.Event event) {
        int size = this.mEvents.size();
        if (size == 0 || event.mTimeStamp >= this.mEvents.get((int)(size - 1)).mTimeStamp) {
            this.mEvents.add(event);
            return;
        }
        int insertIndex = this.firstIndexOnOrAfter(event.mTimeStamp + 1L);
        this.mEvents.add(insertIndex, event);
    }

    public int firstIndexOnOrAfter(long timeStamp) {
        int size;
        int result = size = this.mEvents.size();
        int lo = 0;
        int hi = size - 1;
        while (lo <= hi) {
            int mid = lo + hi >>> 1;
            long midTimeStamp = this.mEvents.get((int)mid).mTimeStamp;
            if (midTimeStamp >= timeStamp) {
                hi = mid - 1;
                result = mid;
                continue;
            }
            lo = mid + 1;
        }
        return result;
    }

    public void merge(EventList events) {
        int size = events.size();
        for (int i = 0; i < size; ++i) {
            this.insert(events.get(i));
        }
    }
}

