/*
 * Decompiled with CFR 0.152.
 */
package android.app.usage;

import android.util.LongSparseArray;
import android.util.Slog;

public class TimeSparseArray<E>
extends LongSparseArray<E> {
    private static final String TAG = TimeSparseArray.class.getSimpleName();
    private boolean mWtfReported;

    public int closestIndexOnOrAfter(long time) {
        int size = this.size();
        int lo = 0;
        int hi = size - 1;
        int mid = -1;
        long key = -1L;
        while (lo <= hi) {
            mid = lo + (hi - lo) / 2;
            key = this.keyAt(mid);
            if (time > key) {
                lo = mid + 1;
                continue;
            }
            if (time < key) {
                hi = mid - 1;
                continue;
            }
            return mid;
        }
        if (time < key) {
            return mid;
        }
        if (time > key && lo < size) {
            return lo;
        }
        return -1;
    }

    @Override
    public void put(long key, E value) {
        if (this.indexOfKey(key) >= 0 && !this.mWtfReported) {
            Slog.wtf(TAG, "Overwriting value " + this.get(key) + " by " + value);
            this.mWtfReported = true;
        }
        super.put(key, value);
    }

    public int closestIndexOnOrBefore(long time) {
        int index = this.closestIndexOnOrAfter(time);
        if (index < 0) {
            return this.size() - 1;
        }
        if (this.keyAt(index) == time) {
            return index;
        }
        return index - 1;
    }
}

