/*
 * Decompiled with CFR 0.152.
 */
package android.appwidget;

import android.annotation.UnsupportedAppUsage;
import android.app.Activity;
import android.appwidget.AppWidgetHostView;
import android.appwidget.AppWidgetProviderInfo;
import android.appwidget.PendingHostUpdate;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.IntentSender;
import android.content.pm.PackageManager;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.DisplayMetrics;
import android.util.SparseArray;
import android.widget.RemoteViews;
import com.android.internal.appwidget.IAppWidgetHost;
import com.android.internal.appwidget.IAppWidgetService;
import java.lang.ref.WeakReference;
import java.util.List;

public class AppWidgetHost {
    static final int HANDLE_UPDATE = 1;
    static final int HANDLE_PROVIDER_CHANGED = 2;
    static final int HANDLE_PROVIDERS_CHANGED = 3;
    @UnsupportedAppUsage
    static final int HANDLE_VIEW_DATA_CHANGED = 4;
    static final Object sServiceLock = new Object();
    @UnsupportedAppUsage
    static IAppWidgetService sService;
    static boolean sServiceInitialized;
    private DisplayMetrics mDisplayMetrics;
    private String mContextOpPackageName;
    @UnsupportedAppUsage
    private final Handler mHandler;
    private final int mHostId;
    private final Callbacks mCallbacks;
    private final SparseArray<AppWidgetHostView> mViews = new SparseArray();
    private RemoteViews.OnClickHandler mOnClickHandler;

    public AppWidgetHost(Context context, int hostId) {
        this(context, hostId, null, context.getMainLooper());
    }

    @UnsupportedAppUsage
    public AppWidgetHost(Context context, int hostId, RemoteViews.OnClickHandler handler, Looper looper) {
        this.mContextOpPackageName = context.getOpPackageName();
        this.mHostId = hostId;
        this.mOnClickHandler = handler;
        this.mHandler = new UpdateHandler(looper);
        this.mCallbacks = new Callbacks(this.mHandler);
        this.mDisplayMetrics = context.getResources().getDisplayMetrics();
        AppWidgetHost.bindService(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void bindService(Context context) {
        Object object = sServiceLock;
        synchronized (object) {
            if (sServiceInitialized) {
                return;
            }
            sServiceInitialized = true;
            PackageManager packageManager = context.getPackageManager();
            if (!packageManager.hasSystemFeature("android.software.app_widgets") && !context.getResources().getBoolean(17891431)) {
                return;
            }
            IBinder b = ServiceManager.getService("appwidget");
            sService = IAppWidgetService.Stub.asInterface(b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startListening() {
        List updates;
        int i;
        int[] idsToUpdate;
        int N;
        if (sService == null) {
            return;
        }
        SparseArray<AppWidgetHostView> sparseArray = this.mViews;
        synchronized (sparseArray) {
            N = this.mViews.size();
            idsToUpdate = new int[N];
            for (i = 0; i < N; ++i) {
                idsToUpdate[i] = this.mViews.keyAt(i);
            }
        }
        try {
            updates = sService.startListening(this.mCallbacks, this.mContextOpPackageName, this.mHostId, idsToUpdate).getList();
        }
        catch (RemoteException e) {
            throw new RuntimeException("system server dead?", e);
        }
        N = updates.size();
        block11: for (i = 0; i < N; ++i) {
            PendingHostUpdate update = (PendingHostUpdate)updates.get(i);
            switch (update.type) {
                case 0: {
                    this.updateAppWidgetView(update.appWidgetId, update.views);
                    continue block11;
                }
                case 1: {
                    this.onProviderChanged(update.appWidgetId, update.widgetInfo);
                    continue block11;
                }
                case 2: {
                    this.viewDataChanged(update.appWidgetId, update.viewId);
                }
            }
        }
    }

    public void stopListening() {
        if (sService == null) {
            return;
        }
        try {
            sService.stopListening(this.mContextOpPackageName, this.mHostId);
        }
        catch (RemoteException e) {
            throw new RuntimeException("system server dead?", e);
        }
    }

    public int allocateAppWidgetId() {
        if (sService == null) {
            return -1;
        }
        try {
            return sService.allocateAppWidgetId(this.mContextOpPackageName, this.mHostId);
        }
        catch (RemoteException e) {
            throw new RuntimeException("system server dead?", e);
        }
    }

    public final void startAppWidgetConfigureActivityForResult(Activity activity, int appWidgetId, int intentFlags, int requestCode, Bundle options) {
        if (sService == null) {
            return;
        }
        try {
            IntentSender intentSender = sService.createAppWidgetConfigIntentSender(this.mContextOpPackageName, appWidgetId, intentFlags);
            if (intentSender == null) {
                throw new ActivityNotFoundException();
            }
            activity.startIntentSenderForResult(intentSender, requestCode, null, 0, 0, 0, options);
        }
        catch (IntentSender.SendIntentException e) {
            throw new ActivityNotFoundException();
        }
        catch (RemoteException e) {
            throw new RuntimeException("system server dead?", e);
        }
    }

    public int[] getAppWidgetIds() {
        if (sService == null) {
            return new int[0];
        }
        try {
            return sService.getAppWidgetIdsForHost(this.mContextOpPackageName, this.mHostId);
        }
        catch (RemoteException e) {
            throw new RuntimeException("system server dead?", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAppWidgetId(int appWidgetId) {
        if (sService == null) {
            return;
        }
        SparseArray<AppWidgetHostView> sparseArray = this.mViews;
        synchronized (sparseArray) {
            this.mViews.remove(appWidgetId);
            try {
                sService.deleteAppWidgetId(this.mContextOpPackageName, appWidgetId);
            }
            catch (RemoteException e) {
                throw new RuntimeException("system server dead?", e);
            }
        }
    }

    public void deleteHost() {
        if (sService == null) {
            return;
        }
        try {
            sService.deleteHost(this.mContextOpPackageName, this.mHostId);
        }
        catch (RemoteException e) {
            throw new RuntimeException("system server dead?", e);
        }
    }

    public static void deleteAllHosts() {
        if (sService == null) {
            return;
        }
        try {
            sService.deleteAllHosts();
        }
        catch (RemoteException e) {
            throw new RuntimeException("system server dead?", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final AppWidgetHostView createView(Context context, int appWidgetId, AppWidgetProviderInfo appWidget) {
        RemoteViews views;
        if (sService == null) {
            return null;
        }
        AppWidgetHostView view = this.onCreateView(context, appWidgetId, appWidget);
        view.setOnClickHandler(this.mOnClickHandler);
        view.setAppWidget(appWidgetId, appWidget);
        SparseArray<AppWidgetHostView> sparseArray = this.mViews;
        synchronized (sparseArray) {
            this.mViews.put(appWidgetId, view);
        }
        try {
            views = sService.getAppWidgetViews(this.mContextOpPackageName, appWidgetId);
        }
        catch (RemoteException e) {
            throw new RuntimeException("system server dead?", e);
        }
        view.updateAppWidget(views);
        return view;
    }

    protected AppWidgetHostView onCreateView(Context context, int appWidgetId, AppWidgetProviderInfo appWidget) {
        return new AppWidgetHostView(context, this.mOnClickHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onProviderChanged(int appWidgetId, AppWidgetProviderInfo appWidget) {
        AppWidgetHostView v;
        appWidget.updateDimensions(this.mDisplayMetrics);
        SparseArray<AppWidgetHostView> sparseArray = this.mViews;
        synchronized (sparseArray) {
            v = this.mViews.get(appWidgetId);
        }
        if (v != null) {
            v.resetAppWidget(appWidget);
        }
    }

    protected void onProvidersChanged() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateAppWidgetView(int appWidgetId, RemoteViews views) {
        AppWidgetHostView v;
        SparseArray<AppWidgetHostView> sparseArray = this.mViews;
        synchronized (sparseArray) {
            v = this.mViews.get(appWidgetId);
        }
        if (v != null) {
            v.updateAppWidget(views);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void viewDataChanged(int appWidgetId, int viewId) {
        AppWidgetHostView v;
        SparseArray<AppWidgetHostView> sparseArray = this.mViews;
        synchronized (sparseArray) {
            v = this.mViews.get(appWidgetId);
        }
        if (v != null) {
            v.viewDataChanged(viewId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearViews() {
        SparseArray<AppWidgetHostView> sparseArray = this.mViews;
        synchronized (sparseArray) {
            this.mViews.clear();
        }
    }

    static {
        sServiceInitialized = false;
    }

    class UpdateHandler
    extends Handler {
        public UpdateHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    AppWidgetHost.this.updateAppWidgetView(msg.arg1, (RemoteViews)msg.obj);
                    break;
                }
                case 2: {
                    AppWidgetHost.this.onProviderChanged(msg.arg1, (AppWidgetProviderInfo)msg.obj);
                    break;
                }
                case 3: {
                    AppWidgetHost.this.onProvidersChanged();
                    break;
                }
                case 4: {
                    AppWidgetHost.this.viewDataChanged(msg.arg1, msg.arg2);
                }
            }
        }
    }

    static class Callbacks
    extends IAppWidgetHost.Stub {
        private final WeakReference<Handler> mWeakHandler;

        public Callbacks(Handler handler) {
            this.mWeakHandler = new WeakReference<Handler>(handler);
        }

        @Override
        public void updateAppWidget(int appWidgetId, RemoteViews views) {
            Handler handler;
            if (Callbacks.isLocalBinder() && views != null) {
                views = views.clone();
            }
            if ((handler = (Handler)this.mWeakHandler.get()) == null) {
                return;
            }
            Message msg = handler.obtainMessage(1, appWidgetId, 0, views);
            msg.sendToTarget();
        }

        @Override
        public void providerChanged(int appWidgetId, AppWidgetProviderInfo info) {
            Handler handler;
            if (Callbacks.isLocalBinder() && info != null) {
                info = info.clone();
            }
            if ((handler = (Handler)this.mWeakHandler.get()) == null) {
                return;
            }
            Message msg = handler.obtainMessage(2, appWidgetId, 0, info);
            msg.sendToTarget();
        }

        @Override
        public void providersChanged() {
            Handler handler = (Handler)this.mWeakHandler.get();
            if (handler == null) {
                return;
            }
            handler.obtainMessage(3).sendToTarget();
        }

        @Override
        public void viewDataChanged(int appWidgetId, int viewId) {
            Handler handler = (Handler)this.mWeakHandler.get();
            if (handler == null) {
                return;
            }
            Message msg = handler.obtainMessage(4, appWidgetId, viewId);
            msg.sendToTarget();
        }

        private static boolean isLocalBinder() {
            return Process.myPid() == Binder.getCallingPid();
        }
    }
}

