/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.UnsupportedAppUsage;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.BluetoothProfileConnector;
import android.bluetooth.IBluetoothHearingAid;
import android.content.Context;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;

public final class BluetoothHearingAid
implements BluetoothProfile {
    private static final String TAG = "BluetoothHearingAid";
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    public static final String ACTION_CONNECTION_STATE_CHANGED = "android.bluetooth.hearingaid.profile.action.CONNECTION_STATE_CHANGED";
    @UnsupportedAppUsage
    public static final String ACTION_ACTIVE_DEVICE_CHANGED = "android.bluetooth.hearingaid.profile.action.ACTIVE_DEVICE_CHANGED";
    public static final int SIDE_LEFT = 0;
    public static final int SIDE_RIGHT = 1;
    public static final int MODE_MONAURAL = 0;
    public static final int MODE_BINAURAL = 1;
    public static final long HI_SYNC_ID_INVALID = 0L;
    private BluetoothAdapter mAdapter;
    private final BluetoothProfileConnector<IBluetoothHearingAid> mProfileConnector = new BluetoothProfileConnector(this, 21, "BluetoothHearingAid", IBluetoothHearingAid.class.getName()){

        public IBluetoothHearingAid getServiceInterface(IBinder service) {
            return IBluetoothHearingAid.Stub.asInterface(Binder.allowBlocking(service));
        }
    };

    BluetoothHearingAid(Context context, BluetoothProfile.ServiceListener listener) {
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
        this.mProfileConnector.connect(context, listener);
    }

    void close() {
        this.mProfileConnector.disconnect();
    }

    private IBluetoothHearingAid getService() {
        return this.mProfileConnector.getService();
    }

    public boolean connect(BluetoothDevice device) {
        BluetoothHearingAid.log("connect(" + device + ")");
        IBluetoothHearingAid service = this.getService();
        try {
            if (service != null && this.isEnabled() && this.isValidDevice(device)) {
                return service.connect(device);
            }
            if (service == null) {
                Log.w(TAG, "Proxy not attached to service");
            }
            return false;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
            return false;
        }
    }

    public boolean disconnect(BluetoothDevice device) {
        BluetoothHearingAid.log("disconnect(" + device + ")");
        IBluetoothHearingAid service = this.getService();
        try {
            if (service != null && this.isEnabled() && this.isValidDevice(device)) {
                return service.disconnect(device);
            }
            if (service == null) {
                Log.w(TAG, "Proxy not attached to service");
            }
            return false;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
            return false;
        }
    }

    @Override
    public List<BluetoothDevice> getConnectedDevices() {
        IBluetoothHearingAid service = this.getService();
        try {
            if (service != null && this.isEnabled()) {
                return service.getConnectedDevices();
            }
            if (service == null) {
                Log.w(TAG, "Proxy not attached to service");
            }
            return new ArrayList<BluetoothDevice>();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
            return new ArrayList<BluetoothDevice>();
        }
    }

    @Override
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] states) {
        IBluetoothHearingAid service = this.getService();
        try {
            if (service != null && this.isEnabled()) {
                return service.getDevicesMatchingConnectionStates(states);
            }
            if (service == null) {
                Log.w(TAG, "Proxy not attached to service");
            }
            return new ArrayList<BluetoothDevice>();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
            return new ArrayList<BluetoothDevice>();
        }
    }

    @Override
    public int getConnectionState(BluetoothDevice device) {
        IBluetoothHearingAid service = this.getService();
        try {
            if (service != null && this.isEnabled() && this.isValidDevice(device)) {
                return service.getConnectionState(device);
            }
            if (service == null) {
                Log.w(TAG, "Proxy not attached to service");
            }
            return 0;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
            return 0;
        }
    }

    @UnsupportedAppUsage
    public boolean setActiveDevice(BluetoothDevice device) {
        BluetoothHearingAid.log("setActiveDevice(" + device + ")");
        IBluetoothHearingAid service = this.getService();
        try {
            if (service != null && this.isEnabled() && (device == null || this.isValidDevice(device))) {
                service.setActiveDevice(device);
                return true;
            }
            if (service == null) {
                Log.w(TAG, "Proxy not attached to service");
            }
            return false;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
            return false;
        }
    }

    @UnsupportedAppUsage
    public List<BluetoothDevice> getActiveDevices() {
        IBluetoothHearingAid service = this.getService();
        try {
            if (service != null && this.isEnabled()) {
                return service.getActiveDevices();
            }
            if (service == null) {
                Log.w(TAG, "Proxy not attached to service");
            }
            return new ArrayList<BluetoothDevice>();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
            return new ArrayList<BluetoothDevice>();
        }
    }

    public boolean setPriority(BluetoothDevice device, int priority) {
        BluetoothHearingAid.log("setPriority(" + device + ", " + priority + ")");
        IBluetoothHearingAid service = this.getService();
        try {
            if (service != null && this.isEnabled() && this.isValidDevice(device)) {
                if (priority != 0 && priority != 100) {
                    return false;
                }
                return service.setPriority(device, priority);
            }
            if (service == null) {
                Log.w(TAG, "Proxy not attached to service");
            }
            return false;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
            return false;
        }
    }

    public int getPriority(BluetoothDevice device) {
        IBluetoothHearingAid service = this.getService();
        try {
            if (service != null && this.isEnabled() && this.isValidDevice(device)) {
                return service.getPriority(device);
            }
            if (service == null) {
                Log.w(TAG, "Proxy not attached to service");
            }
            return 0;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
            return 0;
        }
    }

    public static String stateToString(int state) {
        switch (state) {
            case 0: {
                return "disconnected";
            }
            case 1: {
                return "connecting";
            }
            case 2: {
                return "connected";
            }
            case 3: {
                return "disconnecting";
            }
        }
        return "<unknown state " + state + ">";
    }

    public int getVolume() {
        IBluetoothHearingAid service = this.getService();
        try {
            if (service != null && this.isEnabled()) {
                return service.getVolume();
            }
            if (service == null) {
                Log.w(TAG, "Proxy not attached to service");
            }
            return 0;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
            return 0;
        }
    }

    public void adjustVolume(int direction) {
        BluetoothHearingAid.log("adjustVolume(" + direction + ")");
        IBluetoothHearingAid service = this.getService();
        try {
            if (service == null) {
                Log.w(TAG, "Proxy not attached to service");
                return;
            }
            if (!this.isEnabled()) {
                return;
            }
            service.adjustVolume(direction);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
        }
    }

    public void setVolume(int volume) {
        Log.d(TAG, "setVolume(" + volume + ")");
        IBluetoothHearingAid service = this.getService();
        try {
            if (service == null) {
                Log.w(TAG, "Proxy not attached to service");
                return;
            }
            if (!this.isEnabled()) {
                return;
            }
            service.setVolume(volume);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
        }
    }

    public long getHiSyncId(BluetoothDevice device) {
        IBluetoothHearingAid service = this.getService();
        try {
            if (service == null) {
                Log.w(TAG, "Proxy not attached to service");
                return 0L;
            }
            if (!this.isEnabled() || !this.isValidDevice(device)) {
                return 0L;
            }
            return service.getHiSyncId(device);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
            return 0L;
        }
    }

    public int getDeviceSide(BluetoothDevice device) {
        IBluetoothHearingAid service = this.getService();
        try {
            if (service != null && this.isEnabled() && this.isValidDevice(device)) {
                return service.getDeviceSide(device);
            }
            if (service == null) {
                Log.w(TAG, "Proxy not attached to service");
            }
            return 0;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
            return 0;
        }
    }

    public int getDeviceMode(BluetoothDevice device) {
        IBluetoothHearingAid service = this.getService();
        try {
            if (service != null && this.isEnabled() && this.isValidDevice(device)) {
                return service.getDeviceMode(device);
            }
            if (service == null) {
                Log.w(TAG, "Proxy not attached to service");
            }
            return 0;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
            return 0;
        }
    }

    private boolean isEnabled() {
        return this.mAdapter.getState() == 12;
    }

    private boolean isValidDevice(BluetoothDevice device) {
        if (device == null) {
            return false;
        }
        return BluetoothAdapter.checkBluetoothAddress(device.getAddress());
    }

    private static void log(String msg) {
        Log.d(TAG, msg);
    }
}

