/*
 * Decompiled with CFR 0.152.
 */
package android.companion;

import android.annotation.UnsupportedAppUsage;
import android.companion.DeviceFilter;
import android.os.Parcel;
import android.os.Parcelable;
import android.provider.OneTimeUseBuilder;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.CollectionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class AssociationRequest
implements Parcelable {
    private final boolean mSingleDevice;
    private final List<DeviceFilter<?>> mDeviceFilters;
    public static final Parcelable.Creator<AssociationRequest> CREATOR = new Parcelable.Creator<AssociationRequest>(){

        @Override
        public AssociationRequest createFromParcel(Parcel in) {
            return new AssociationRequest(in);
        }

        public AssociationRequest[] newArray(int size) {
            return new AssociationRequest[size];
        }
    };

    private AssociationRequest(boolean singleDevice, List<DeviceFilter<?>> deviceFilters) {
        this.mSingleDevice = singleDevice;
        this.mDeviceFilters = CollectionUtils.emptyIfNull(deviceFilters);
    }

    private AssociationRequest(Parcel in) {
        this(in.readByte() != 0, in.readParcelableList(new ArrayList(), AssociationRequest.class.getClassLoader()));
    }

    @UnsupportedAppUsage
    public boolean isSingleDevice() {
        return this.mSingleDevice;
    }

    @UnsupportedAppUsage
    public List<DeviceFilter<?>> getDeviceFilters() {
        return this.mDeviceFilters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssociationRequest that = (AssociationRequest)o;
        return this.mSingleDevice == that.mSingleDevice && Objects.equals(this.mDeviceFilters, that.mDeviceFilters);
    }

    public int hashCode() {
        return Objects.hash(this.mSingleDevice, this.mDeviceFilters);
    }

    public String toString() {
        return "AssociationRequest{mSingleDevice=" + this.mSingleDevice + ", mDeviceFilters=" + this.mDeviceFilters + '}';
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeByte((byte)(this.mSingleDevice ? 1 : 0));
        dest.writeParcelableList(this.mDeviceFilters, flags);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final class Builder
    extends OneTimeUseBuilder<AssociationRequest> {
        private boolean mSingleDevice = false;
        private ArrayList<DeviceFilter<?>> mDeviceFilters = null;

        public Builder setSingleDevice(boolean singleDevice) {
            this.checkNotUsed();
            this.mSingleDevice = singleDevice;
            return this;
        }

        public Builder addDeviceFilter(DeviceFilter<?> deviceFilter) {
            this.checkNotUsed();
            if (deviceFilter != null) {
                this.mDeviceFilters = ArrayUtils.add(this.mDeviceFilters, deviceFilter);
            }
            return this;
        }

        @Override
        public AssociationRequest build() {
            this.markUsed();
            return new AssociationRequest(this.mSingleDevice, this.mDeviceFilters);
        }
    }
}

