/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.app.ActivityThread;
import android.content.ComponentName;
import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArraySet;
import android.util.Log;
import android.view.autofill.AutofillManager;
import java.io.PrintWriter;

public final class AutofillOptions
implements Parcelable {
    private static final String TAG = AutofillOptions.class.getSimpleName();
    public final int loggingLevel;
    public final boolean compatModeEnabled;
    public boolean augmentedAutofillEnabled;
    public ArraySet<ComponentName> whitelistedActivitiesForAugmentedAutofill;
    public static final Parcelable.Creator<AutofillOptions> CREATOR = new Parcelable.Creator<AutofillOptions>(){

        @Override
        public AutofillOptions createFromParcel(Parcel parcel) {
            int loggingLevel = parcel.readInt();
            boolean compatMode = parcel.readBoolean();
            AutofillOptions options = new AutofillOptions(loggingLevel, compatMode);
            options.augmentedAutofillEnabled = parcel.readBoolean();
            options.whitelistedActivitiesForAugmentedAutofill = parcel.readArraySet(null);
            return options;
        }

        public AutofillOptions[] newArray(int size) {
            return new AutofillOptions[size];
        }
    };

    public AutofillOptions(int loggingLevel, boolean compatModeEnabled) {
        this.loggingLevel = loggingLevel;
        this.compatModeEnabled = compatModeEnabled;
    }

    public boolean isAugmentedAutofillEnabled(Context context) {
        if (!this.augmentedAutofillEnabled) {
            return false;
        }
        AutofillManager.AutofillClient autofillClient = context.getAutofillClient();
        if (autofillClient == null) {
            return false;
        }
        ComponentName component = autofillClient.autofillClientGetComponentName();
        return this.whitelistedActivitiesForAugmentedAutofill == null || this.whitelistedActivitiesForAugmentedAutofill.contains(component);
    }

    public static AutofillOptions forWhitelistingItself() {
        ActivityThread at = ActivityThread.currentActivityThread();
        if (at == null) {
            throw new IllegalStateException("No ActivityThread");
        }
        String packageName = at.getApplication().getPackageName();
        if (!"android.autofillservice.cts".equals(packageName)) {
            Log.e(TAG, "forWhitelistingItself(): called by " + packageName);
            throw new SecurityException("Thou shall not pass!");
        }
        AutofillOptions options = new AutofillOptions(4, true);
        options.augmentedAutofillEnabled = true;
        Log.i(TAG, "forWhitelistingItself(" + packageName + "): " + options);
        return options;
    }

    public String toString() {
        return "AutofillOptions [loggingLevel=" + this.loggingLevel + ", compatMode=" + this.compatModeEnabled + ", augmentedAutofillEnabled=" + this.augmentedAutofillEnabled + "]";
    }

    public void dumpShort(PrintWriter pw) {
        pw.print("logLvl=");
        pw.print(this.loggingLevel);
        pw.print(", compatMode=");
        pw.print(this.compatModeEnabled);
        pw.print(", augmented=");
        pw.print(this.augmentedAutofillEnabled);
        if (this.whitelistedActivitiesForAugmentedAutofill != null) {
            pw.print(", whitelistedActivitiesForAugmentedAutofill=");
            pw.print(this.whitelistedActivitiesForAugmentedAutofill);
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeInt(this.loggingLevel);
        parcel.writeBoolean(this.compatModeEnabled);
        parcel.writeBoolean(this.augmentedAutofillEnabled);
        parcel.writeArraySet(this.whitelistedActivitiesForAugmentedAutofill);
    }
}

