/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.content.pm.AndroidHidlUpdater;
import android.content.pm.OrgApacheHttpLegacyUpdater;
import android.content.pm.PackageParser;
import android.content.pm.PackageSharedLibraryUpdater;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

@VisibleForTesting
public class PackageBackwardCompatibility
extends PackageSharedLibraryUpdater {
    private static final String TAG = PackageBackwardCompatibility.class.getSimpleName();
    private static final PackageBackwardCompatibility INSTANCE;
    private final boolean mBootClassPathContainsATB;
    private final PackageSharedLibraryUpdater[] mPackageUpdaters;

    private static boolean addOptionalUpdater(List<PackageSharedLibraryUpdater> packageUpdaters, String className, Supplier<PackageSharedLibraryUpdater> defaultUpdater) {
        PackageSharedLibraryUpdater updater;
        Class<PackageSharedLibraryUpdater> clazz;
        try {
            clazz = PackageBackwardCompatibility.class.getClassLoader().loadClass(className).asSubclass(PackageSharedLibraryUpdater.class);
            Log.i(TAG, "Loaded " + className);
        }
        catch (ClassNotFoundException e) {
            Log.i(TAG, "Could not find " + className + ", ignoring");
            clazz = null;
        }
        boolean usedOptional = false;
        if (clazz == null) {
            updater = defaultUpdater.get();
        } else {
            try {
                updater = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                usedOptional = true;
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalStateException("Could not create instance of " + className, e);
            }
        }
        packageUpdaters.add(updater);
        return usedOptional;
    }

    @VisibleForTesting
    public static PackageSharedLibraryUpdater getInstance() {
        return INSTANCE;
    }

    private PackageBackwardCompatibility(boolean bootClassPathContainsATB, PackageSharedLibraryUpdater[] packageUpdaters) {
        this.mBootClassPathContainsATB = bootClassPathContainsATB;
        this.mPackageUpdaters = packageUpdaters;
    }

    @VisibleForTesting
    public static void modifySharedLibraries(PackageParser.Package pkg) {
        INSTANCE.updatePackage(pkg);
    }

    @Override
    public void updatePackage(PackageParser.Package pkg) {
        for (PackageSharedLibraryUpdater packageUpdater : this.mPackageUpdaters) {
            packageUpdater.updatePackage(pkg);
        }
    }

    @VisibleForTesting
    public static boolean bootClassPathContainsATB() {
        return PackageBackwardCompatibility.INSTANCE.mBootClassPathContainsATB;
    }

    static {
        ArrayList<PackageSharedLibraryUpdater> packageUpdaters = new ArrayList<PackageSharedLibraryUpdater>();
        packageUpdaters.add(new OrgApacheHttpLegacyUpdater());
        packageUpdaters.add(new AndroidHidlUpdater());
        packageUpdaters.add(new AndroidTestRunnerSplitUpdater());
        boolean bootClassPathContainsATB = !PackageBackwardCompatibility.addOptionalUpdater(packageUpdaters, "android.content.pm.AndroidTestBaseUpdater", RemoveUnnecessaryAndroidTestBaseLibrary::new);
        PackageSharedLibraryUpdater[] updaterArray = packageUpdaters.toArray(new PackageSharedLibraryUpdater[0]);
        INSTANCE = new PackageBackwardCompatibility(bootClassPathContainsATB, updaterArray);
    }

    @VisibleForTesting
    public static class RemoveUnnecessaryAndroidTestBaseLibrary
    extends PackageSharedLibraryUpdater {
        @Override
        public void updatePackage(PackageParser.Package pkg) {
            RemoveUnnecessaryAndroidTestBaseLibrary.removeLibrary(pkg, "android.test.base");
        }
    }

    @VisibleForTesting
    public static class RemoveUnnecessaryOrgApacheHttpLegacyLibrary
    extends PackageSharedLibraryUpdater {
        @Override
        public void updatePackage(PackageParser.Package pkg) {
            RemoveUnnecessaryOrgApacheHttpLegacyLibrary.removeLibrary(pkg, "org.apache.http.legacy");
        }
    }

    @VisibleForTesting
    public static class AndroidTestRunnerSplitUpdater
    extends PackageSharedLibraryUpdater {
        @Override
        public void updatePackage(PackageParser.Package pkg) {
            this.prefixImplicitDependency(pkg, "android.test.runner", "android.test.mock");
        }
    }
}

