/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.annotation.UnsupportedAppUsage;
import android.apex.ApexInfo;
import android.app.ActivityTaskManager;
import android.app.ActivityThread;
import android.app.ResourcesManager;
import android.content.ComponentName;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.ComponentInfo;
import android.content.pm.ConfigurationInfo;
import android.content.pm.FallbackCategoryProvider;
import android.content.pm.FeatureGroupInfo;
import android.content.pm.FeatureInfo;
import android.content.pm.InstrumentationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageItemInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageParserCacheHelper;
import android.content.pm.PackageUserState;
import android.content.pm.PathPermission;
import android.content.pm.PermissionGroupInfo;
import android.content.pm.PermissionInfo;
import android.content.pm.ProviderInfo;
import android.content.pm.SELinuxUtil;
import android.content.pm.ServiceInfo;
import android.content.pm.SharedLibraryInfo;
import android.content.pm.Signature;
import android.content.pm.SigningInfo;
import android.content.pm.VerifierInfo;
import android.content.pm.split.DefaultSplitAssetLoader;
import android.content.pm.split.SplitAssetDependencyLoader;
import android.content.pm.split.SplitAssetLoader;
import android.content.pm.split.SplitDependencyLoader;
import android.content.res.ApkAssets;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.os.Build;
import android.os.Bundle;
import android.os.FileUtils;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PatternMatcher;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.Trace;
import android.os.UserHandle;
import android.os.storage.StorageManager;
import android.permission.PermissionManager;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.system.StructStat;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.AttributeSet;
import android.util.Base64;
import android.util.ByteStringUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.PackageUtils;
import android.util.Pair;
import android.util.Slog;
import android.util.SparseArray;
import android.util.TypedValue;
import android.util.apk.ApkSignatureVerifier;
import com.android.internal.R;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.os.ClassLoaderFactory;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.XmlUtils;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Constructor;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import libcore.io.IoUtils;
import libcore.util.EmptyArray;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class PackageParser {
    private static final boolean DEBUG_JAR = false;
    private static final boolean DEBUG_PARSER = false;
    private static final boolean DEBUG_BACKUP = false;
    private static final boolean LOG_PARSE_TIMINGS = Build.IS_DEBUGGABLE;
    private static final int LOG_PARSE_TIMINGS_THRESHOLD_MS = 100;
    private static final String PROPERTY_CHILD_PACKAGES_ENABLED = "persist.sys.child_packages_enabled";
    private static final boolean MULTI_PACKAGE_APK_ENABLED = Build.IS_DEBUGGABLE && SystemProperties.getBoolean("persist.sys.child_packages_enabled", false);
    private static final float DEFAULT_PRE_O_MAX_ASPECT_RATIO = 1.86f;
    private static final float DEFAULT_PRE_Q_MIN_ASPECT_RATIO = 1.333f;
    private static final float DEFAULT_PRE_Q_MIN_ASPECT_RATIO_WATCH = 1.0f;
    private static final int DEFAULT_MIN_SDK_VERSION = 1;
    private static final int DEFAULT_TARGET_SDK_VERSION = 0;
    public static final String ANDROID_MANIFEST_FILENAME = "AndroidManifest.xml";
    private static final String MNT_EXPAND = "/mnt/expand/";
    private static final String TAG_MANIFEST = "manifest";
    private static final String TAG_APPLICATION = "application";
    private static final String TAG_PACKAGE_VERIFIER = "package-verifier";
    private static final String TAG_OVERLAY = "overlay";
    private static final String TAG_KEY_SETS = "key-sets";
    private static final String TAG_PERMISSION_GROUP = "permission-group";
    private static final String TAG_PERMISSION = "permission";
    private static final String TAG_PERMISSION_TREE = "permission-tree";
    private static final String TAG_USES_PERMISSION = "uses-permission";
    private static final String TAG_USES_PERMISSION_SDK_M = "uses-permission-sdk-m";
    private static final String TAG_USES_PERMISSION_SDK_23 = "uses-permission-sdk-23";
    private static final String TAG_USES_CONFIGURATION = "uses-configuration";
    private static final String TAG_USES_FEATURE = "uses-feature";
    private static final String TAG_FEATURE_GROUP = "feature-group";
    private static final String TAG_USES_SDK = "uses-sdk";
    private static final String TAG_SUPPORT_SCREENS = "supports-screens";
    private static final String TAG_PROTECTED_BROADCAST = "protected-broadcast";
    private static final String TAG_INSTRUMENTATION = "instrumentation";
    private static final String TAG_ORIGINAL_PACKAGE = "original-package";
    private static final String TAG_ADOPT_PERMISSIONS = "adopt-permissions";
    private static final String TAG_USES_GL_TEXTURE = "uses-gl-texture";
    private static final String TAG_COMPATIBLE_SCREENS = "compatible-screens";
    private static final String TAG_SUPPORTS_INPUT = "supports-input";
    private static final String TAG_EAT_COMMENT = "eat-comment";
    private static final String TAG_PACKAGE = "package";
    private static final String TAG_RESTRICT_UPDATE = "restrict-update";
    private static final String TAG_USES_SPLIT = "uses-split";
    private static final String METADATA_MAX_ASPECT_RATIO = "android.max_aspect";
    private static final int RECREATE_ON_CONFIG_CHANGES_MASK = 3;
    private static final Set<String> CHILD_PACKAGE_TAGS = new ArraySet<String>();
    private static final boolean LOG_UNSAFE_BROADCASTS = false;
    public static final AtomicInteger sCachedPackageReadCount;
    private static final Set<String> SAFE_BROADCASTS;
    public static final String APK_FILE_EXTENSION = ".apk";
    @UnsupportedAppUsage
    public static final NewPermissionInfo[] NEW_PERMISSIONS;
    @Deprecated
    private String mArchiveSourcePath;
    private String[] mSeparateProcesses;
    private boolean mOnlyCoreApps;
    private DisplayMetrics mMetrics = new DisplayMetrics();
    @UnsupportedAppUsage
    private Callback mCallback;
    private File mCacheDir;
    private static final int SDK_VERSION;
    private static final String[] SDK_CODENAMES;
    private int mParseError = 1;
    private static boolean sCompatibilityModeEnabled;
    private static boolean sUseRoundIcon;
    private static final int PARSE_DEFAULT_INSTALL_LOCATION = -1;
    private static final int PARSE_DEFAULT_TARGET_SANDBOX = 1;
    private ParsePackageItemArgs mParseInstrumentationArgs;
    private static final boolean RIGID_PARSER = false;
    private static final String TAG = "PackageParser";
    public static final int PARSE_MUST_BE_APK = 1;
    public static final int PARSE_IGNORE_PROCESSES = 2;
    public static final int PARSE_EXTERNAL_STORAGE = 8;
    public static final int PARSE_IS_SYSTEM_DIR = 16;
    public static final int PARSE_COLLECT_CERTIFICATES = 32;
    public static final int PARSE_ENFORCE_CODE = 64;
    public static final int PARSE_CHATTY = Integer.MIN_VALUE;
    private static final Comparator<String> sSplitNameComparator;
    private static final String ANDROID_RESOURCES = "http://schemas.android.com/apk/res/android";

    @UnsupportedAppUsage
    public PackageParser() {
        this.mMetrics.setToDefaults();
    }

    @UnsupportedAppUsage
    public void setSeparateProcesses(String[] procs) {
        this.mSeparateProcesses = procs;
    }

    public void setOnlyCoreApps(boolean onlyCoreApps) {
        this.mOnlyCoreApps = onlyCoreApps;
    }

    public void setDisplayMetrics(DisplayMetrics metrics) {
        this.mMetrics = metrics;
    }

    public void setCacheDir(File cacheDir) {
        this.mCacheDir = cacheDir;
    }

    public void setCallback(Callback cb) {
        this.mCallback = cb;
    }

    public static final boolean isApkFile(File file) {
        return PackageParser.isApkPath(file.getName());
    }

    public static boolean isApkPath(String path) {
        return path.endsWith(APK_FILE_EXTENSION);
    }

    @UnsupportedAppUsage
    public static PackageInfo generatePackageInfo(Package p, int[] gids, int flags, long firstInstallTime, long lastUpdateTime, Set<String> grantedPermissions, PackageUserState state) {
        return PackageParser.generatePackageInfo(p, gids, flags, firstInstallTime, lastUpdateTime, grantedPermissions, state, UserHandle.getCallingUserId());
    }

    private static boolean checkUseInstalledOrHidden(int flags, PackageUserState state, ApplicationInfo appInfo) {
        if ((flags & 0x20000000) == 0 && !state.installed && appInfo != null && appInfo.hiddenUntilInstalled) {
            return false;
        }
        return state.isAvailable(flags) || appInfo != null && appInfo.isSystemApp() && ((flags & 0x402000) != 0 || (flags & 0x20000000) != 0);
    }

    public static boolean isAvailable(PackageUserState state) {
        return PackageParser.checkUseInstalledOrHidden(0, state, null);
    }

    @UnsupportedAppUsage
    public static PackageInfo generatePackageInfo(Package p, int[] gids, int flags, long firstInstallTime, long lastUpdateTime, Set<String> grantedPermissions, PackageUserState state, int userId) {
        int i;
        Activity a;
        int i2;
        ComponentInfo[] res;
        int num;
        int N;
        if (!PackageParser.checkUseInstalledOrHidden(flags, state, p.applicationInfo) || !p.isMatch(flags)) {
            return null;
        }
        PackageInfo pi = new PackageInfo();
        pi.packageName = p.packageName;
        pi.splitNames = p.splitNames;
        pi.versionCode = p.mVersionCode;
        pi.versionCodeMajor = p.mVersionCodeMajor;
        pi.baseRevisionCode = p.baseRevisionCode;
        pi.splitRevisionCodes = p.splitRevisionCodes;
        pi.versionName = p.mVersionName;
        pi.sharedUserId = p.mSharedUserId;
        pi.sharedUserLabel = p.mSharedUserLabel;
        pi.applicationInfo = PackageParser.generateApplicationInfo(p, flags, state, userId);
        pi.installLocation = p.installLocation;
        pi.isStub = p.isStub;
        pi.coreApp = p.coreApp;
        if ((pi.applicationInfo.flags & 1) != 0 || (pi.applicationInfo.flags & 0x80) != 0) {
            pi.requiredForAllUsers = p.mRequiredForAllUsers;
        }
        pi.restrictedAccountType = p.mRestrictedAccountType;
        pi.requiredAccountType = p.mRequiredAccountType;
        pi.overlayTarget = p.mOverlayTarget;
        pi.targetOverlayableName = p.mOverlayTargetName;
        pi.overlayCategory = p.mOverlayCategory;
        pi.overlayPriority = p.mOverlayPriority;
        pi.mOverlayIsStatic = p.mOverlayIsStatic;
        pi.compileSdkVersion = p.mCompileSdkVersion;
        pi.compileSdkVersionCodename = p.mCompileSdkVersionCodename;
        pi.firstInstallTime = firstInstallTime;
        pi.lastUpdateTime = lastUpdateTime;
        if ((flags & 0x100) != 0) {
            pi.gids = gids;
        }
        if ((flags & 0x4000) != 0) {
            int n = N = p.configPreferences != null ? p.configPreferences.size() : 0;
            if (N > 0) {
                pi.configPreferences = new ConfigurationInfo[N];
                p.configPreferences.toArray(pi.configPreferences);
            }
            int n2 = N = p.reqFeatures != null ? p.reqFeatures.size() : 0;
            if (N > 0) {
                pi.reqFeatures = new FeatureInfo[N];
                p.reqFeatures.toArray(pi.reqFeatures);
            }
            int n3 = N = p.featureGroups != null ? p.featureGroups.size() : 0;
            if (N > 0) {
                pi.featureGroups = new FeatureGroupInfo[N];
                p.featureGroups.toArray(pi.featureGroups);
            }
        }
        if ((flags & 1) != 0 && (N = p.activities.size()) > 0) {
            num = 0;
            res = new ActivityInfo[N];
            for (i2 = 0; i2 < N; ++i2) {
                a = p.activities.get(i2);
                if (!state.isMatch(a.info, flags) || PackageManager.APP_DETAILS_ACTIVITY_CLASS_NAME.equals(a.className)) continue;
                res[num++] = PackageParser.generateActivityInfo(a, flags, state, userId);
            }
            pi.activities = ArrayUtils.trimToSize(res, num);
        }
        if ((flags & 2) != 0 && (N = p.receivers.size()) > 0) {
            num = 0;
            res = new ActivityInfo[N];
            for (i2 = 0; i2 < N; ++i2) {
                a = p.receivers.get(i2);
                if (!state.isMatch(a.info, flags)) continue;
                res[num++] = PackageParser.generateActivityInfo(a, flags, state, userId);
            }
            pi.receivers = (ActivityInfo[])ArrayUtils.trimToSize(res, num);
        }
        if ((flags & 4) != 0 && (N = p.services.size()) > 0) {
            num = 0;
            res = new ServiceInfo[N];
            for (i2 = 0; i2 < N; ++i2) {
                Service s = p.services.get(i2);
                if (!state.isMatch(s.info, flags)) continue;
                res[num++] = PackageParser.generateServiceInfo(s, flags, state, userId);
            }
            pi.services = (ServiceInfo[])ArrayUtils.trimToSize(res, num);
        }
        if ((flags & 8) != 0 && (N = p.providers.size()) > 0) {
            num = 0;
            res = new ProviderInfo[N];
            for (i2 = 0; i2 < N; ++i2) {
                Provider pr = p.providers.get(i2);
                if (!state.isMatch(pr.info, flags)) continue;
                res[num++] = PackageParser.generateProviderInfo(pr, flags, state, userId);
            }
            pi.providers = (ProviderInfo[])ArrayUtils.trimToSize(res, num);
        }
        if ((flags & 0x10) != 0 && (N = p.instrumentation.size()) > 0) {
            pi.instrumentation = new InstrumentationInfo[N];
            for (i = 0; i < N; ++i) {
                pi.instrumentation[i] = PackageParser.generateInstrumentationInfo(p.instrumentation.get(i), flags);
            }
        }
        if ((flags & 0x1000) != 0) {
            N = p.permissions.size();
            if (N > 0) {
                pi.permissions = new PermissionInfo[N];
                for (i = 0; i < N; ++i) {
                    pi.permissions[i] = PackageParser.generatePermissionInfo(p.permissions.get(i), flags);
                }
            }
            if ((N = p.requestedPermissions.size()) > 0) {
                pi.requestedPermissions = new String[N];
                pi.requestedPermissionsFlags = new int[N];
                for (i = 0; i < N; ++i) {
                    String perm;
                    pi.requestedPermissions[i] = perm = p.requestedPermissions.get(i);
                    int n = i;
                    pi.requestedPermissionsFlags[n] = pi.requestedPermissionsFlags[n] | 1;
                    if (grantedPermissions == null || !grantedPermissions.contains(perm)) continue;
                    int n4 = i;
                    pi.requestedPermissionsFlags[n4] = pi.requestedPermissionsFlags[n4] | 2;
                }
            }
        }
        if ((flags & 0x40) != 0) {
            if (p.mSigningDetails.hasPastSigningCertificates()) {
                pi.signatures = new Signature[1];
                pi.signatures[0] = p.mSigningDetails.pastSigningCertificates[0];
            } else if (p.mSigningDetails.hasSignatures()) {
                int numberOfSigs = p.mSigningDetails.signatures.length;
                pi.signatures = new Signature[numberOfSigs];
                System.arraycopy(p.mSigningDetails.signatures, 0, pi.signatures, 0, numberOfSigs);
            }
        }
        if ((flags & 0x8000000) != 0) {
            pi.signingInfo = p.mSigningDetails != SigningDetails.UNKNOWN ? new SigningInfo(p.mSigningDetails) : null;
        }
        return pi;
    }

    @UnsupportedAppUsage
    public static PackageLite parsePackageLite(File packageFile, int flags) throws PackageParserException {
        if (packageFile.isDirectory()) {
            return PackageParser.parseClusterPackageLite(packageFile, flags);
        }
        return PackageParser.parseMonolithicPackageLite(packageFile, flags);
    }

    private static PackageLite parseMonolithicPackageLite(File packageFile, int flags) throws PackageParserException {
        Trace.traceBegin(262144L, "parseApkLite");
        ApkLite baseApk = PackageParser.parseApkLite(packageFile, flags);
        String packagePath = packageFile.getAbsolutePath();
        Trace.traceEnd(262144L);
        return new PackageLite(packagePath, baseApk, null, null, null, null, null, null);
    }

    static PackageLite parseClusterPackageLite(File packageDir, int flags) throws PackageParserException {
        File[] files = packageDir.listFiles();
        if (ArrayUtils.isEmpty(files)) {
            throw new PackageParserException(-100, "No packages found in split");
        }
        String packageName = null;
        int versionCode = 0;
        Trace.traceBegin(262144L, "parseApkLite");
        ArrayMap<String, ApkLite> apks = new ArrayMap<String, ApkLite>();
        for (File file : files) {
            if (!PackageParser.isApkFile(file)) continue;
            ApkLite lite = PackageParser.parseApkLite(file, flags);
            if (packageName == null) {
                packageName = lite.packageName;
                versionCode = lite.versionCode;
            } else {
                if (!packageName.equals(lite.packageName)) {
                    throw new PackageParserException(-101, "Inconsistent package " + lite.packageName + " in " + file + "; expected " + packageName);
                }
                if (versionCode != lite.versionCode) {
                    throw new PackageParserException(-101, "Inconsistent version " + lite.versionCode + " in " + file + "; expected " + versionCode);
                }
            }
            if (apks.put(lite.splitName, lite) == null) continue;
            throw new PackageParserException(-101, "Split name " + lite.splitName + " defined more than once; most recent was " + file);
        }
        Trace.traceEnd(262144L);
        ApkLite baseApk = (ApkLite)apks.remove(null);
        if (baseApk == null) {
            throw new PackageParserException(-101, "Missing base APK in " + packageDir);
        }
        int size = apks.size();
        String[] splitNames = null;
        boolean[] isFeatureSplits = null;
        String[] usesSplitNames = null;
        String[] configForSplits = null;
        String[] splitCodePaths = null;
        int[] splitRevisionCodes = null;
        Object splitClassLoaderNames = null;
        if (size > 0) {
            splitNames = new String[size];
            isFeatureSplits = new boolean[size];
            usesSplitNames = new String[size];
            configForSplits = new String[size];
            splitCodePaths = new String[size];
            splitRevisionCodes = new int[size];
            splitNames = apks.keySet().toArray(splitNames);
            Arrays.sort(splitNames, sSplitNameComparator);
            for (int i = 0; i < size; ++i) {
                ApkLite apk = (ApkLite)apks.get(splitNames[i]);
                usesSplitNames[i] = apk.usesSplitName;
                isFeatureSplits[i] = apk.isFeatureSplit;
                configForSplits[i] = apk.configForSplit;
                splitCodePaths[i] = apk.codePath;
                splitRevisionCodes[i] = apk.revisionCode;
            }
        }
        String codePath = packageDir.getAbsolutePath();
        return new PackageLite(codePath, baseApk, splitNames, isFeatureSplits, usesSplitNames, configForSplits, splitCodePaths, splitRevisionCodes);
    }

    @UnsupportedAppUsage
    public Package parsePackage(File packageFile, int flags, boolean useCaches) throws PackageParserException {
        Package parsed;
        Package package_ = parsed = useCaches ? this.getCachedResult(packageFile, flags) : null;
        if (parsed != null) {
            return parsed;
        }
        long parseTime = LOG_PARSE_TIMINGS ? SystemClock.uptimeMillis() : 0L;
        parsed = packageFile.isDirectory() ? this.parseClusterPackage(packageFile, flags) : this.parseMonolithicPackage(packageFile, flags);
        long cacheTime = LOG_PARSE_TIMINGS ? SystemClock.uptimeMillis() : 0L;
        this.cacheResult(packageFile, flags, parsed);
        if (LOG_PARSE_TIMINGS && (parseTime = cacheTime - parseTime) + (cacheTime = SystemClock.uptimeMillis() - cacheTime) > 100L) {
            Slog.i(TAG, "Parse times for '" + packageFile + "': parse=" + parseTime + "ms, update_cache=" + cacheTime + " ms");
        }
        return parsed;
    }

    @UnsupportedAppUsage
    public Package parsePackage(File packageFile, int flags) throws PackageParserException {
        return this.parsePackage(packageFile, flags, false);
    }

    private String getCacheKey(File packageFile, int flags) {
        StringBuilder sb = new StringBuilder(packageFile.getName());
        sb.append('-');
        sb.append(flags);
        return sb.toString();
    }

    @VisibleForTesting
    protected Package fromCacheEntry(byte[] bytes) {
        return PackageParser.fromCacheEntryStatic(bytes);
    }

    @VisibleForTesting
    public static Package fromCacheEntryStatic(byte[] bytes) {
        Parcel p = Parcel.obtain();
        p.unmarshall(bytes, 0, bytes.length);
        p.setDataPosition(0);
        PackageParserCacheHelper.ReadHelper helper = new PackageParserCacheHelper.ReadHelper(p);
        helper.startAndInstall();
        Package pkg = new Package(p);
        p.recycle();
        sCachedPackageReadCount.incrementAndGet();
        return pkg;
    }

    @VisibleForTesting
    protected byte[] toCacheEntry(Package pkg) {
        return PackageParser.toCacheEntryStatic(pkg);
    }

    @VisibleForTesting
    public static byte[] toCacheEntryStatic(Package pkg) {
        Parcel p = Parcel.obtain();
        PackageParserCacheHelper.WriteHelper helper = new PackageParserCacheHelper.WriteHelper(p);
        pkg.writeToParcel(p, 0);
        helper.finishAndUninstall();
        byte[] serialized = p.marshall();
        p.recycle();
        return serialized;
    }

    private static boolean isCacheUpToDate(File packageFile, File cacheFile) {
        try {
            StructStat pkg = Os.stat(packageFile.getAbsolutePath());
            StructStat cache = Os.stat(cacheFile.getAbsolutePath());
            return pkg.st_mtime < cache.st_mtime;
        }
        catch (ErrnoException ee) {
            if (ee.errno != OsConstants.ENOENT) {
                Slog.w("Error while stating package cache : ", ee);
            }
            return false;
        }
    }

    private Package getCachedResult(File packageFile, int flags) {
        if (this.mCacheDir == null) {
            return null;
        }
        String cacheKey = this.getCacheKey(packageFile, flags);
        File cacheFile = new File(this.mCacheDir, cacheKey);
        try {
            String[] overlayApks;
            if (!PackageParser.isCacheUpToDate(packageFile, cacheFile)) {
                return null;
            }
            byte[] bytes = IoUtils.readFileAsByteArray(cacheFile.getAbsolutePath());
            Package p = this.fromCacheEntry(bytes);
            if (this.mCallback != null && (overlayApks = this.mCallback.getOverlayApks(p.packageName)) != null && overlayApks.length > 0) {
                for (String overlayApk : overlayApks) {
                    if (PackageParser.isCacheUpToDate(new File(overlayApk), cacheFile)) continue;
                    return null;
                }
            }
            return p;
        }
        catch (Throwable e) {
            Slog.w(TAG, "Error reading package cache: ", e);
            cacheFile.delete();
            return null;
        }
    }

    private void cacheResult(File packageFile, int flags, Package parsed) {
        if (this.mCacheDir == null) {
            return;
        }
        try {
            byte[] cacheEntry;
            String cacheKey = this.getCacheKey(packageFile, flags);
            File cacheFile = new File(this.mCacheDir, cacheKey);
            if (cacheFile.exists() && !cacheFile.delete()) {
                Slog.e(TAG, "Unable to delete cache file: " + cacheFile);
            }
            if ((cacheEntry = this.toCacheEntry(parsed)) == null) {
                return;
            }
            try (FileOutputStream fos = new FileOutputStream(cacheFile);){
                fos.write(cacheEntry);
            }
            catch (IOException ioe) {
                Slog.w(TAG, "Error writing cache entry.", ioe);
                cacheFile.delete();
            }
        }
        catch (Throwable e) {
            Slog.w(TAG, "Error saving package cache.", e);
        }
    }

    private Package parseClusterPackage(File packageDir, int flags) throws PackageParserException {
        SplitAssetLoader assetLoader;
        PackageLite lite = PackageParser.parseClusterPackageLite(packageDir, 0);
        if (this.mOnlyCoreApps && !lite.coreApp) {
            throw new PackageParserException(-108, "Not a coreApp: " + packageDir);
        }
        SparseArray<int[]> splitDependencies = null;
        if (lite.isolatedSplits && !ArrayUtils.isEmpty(lite.splitNames)) {
            try {
                splitDependencies = SplitAssetDependencyLoader.createDependenciesFromPackage(lite);
                assetLoader = new SplitAssetDependencyLoader(lite, splitDependencies, flags);
            }
            catch (SplitDependencyLoader.IllegalDependencyException e) {
                throw new PackageParserException(-101, e.getMessage());
            }
        } else {
            assetLoader = new DefaultSplitAssetLoader(lite, flags);
        }
        try {
            AssetManager assets = assetLoader.getBaseAssetManager();
            File baseApk = new File(lite.baseCodePath);
            Package pkg = this.parseBaseApk(baseApk, assets, flags);
            if (pkg == null) {
                throw new PackageParserException(-100, "Failed to parse base APK: " + baseApk);
            }
            if (!ArrayUtils.isEmpty(lite.splitNames)) {
                int num = lite.splitNames.length;
                pkg.splitNames = lite.splitNames;
                pkg.splitCodePaths = lite.splitCodePaths;
                pkg.splitRevisionCodes = lite.splitRevisionCodes;
                pkg.splitFlags = new int[num];
                pkg.splitPrivateFlags = new int[num];
                pkg.applicationInfo.splitNames = pkg.splitNames;
                pkg.applicationInfo.splitDependencies = splitDependencies;
                pkg.applicationInfo.splitClassLoaderNames = new String[num];
                for (int i = 0; i < num; ++i) {
                    AssetManager splitAssets = assetLoader.getSplitAssetManager(i);
                    this.parseSplitApk(pkg, i, splitAssets, flags);
                }
            }
            pkg.setCodePath(packageDir.getCanonicalPath());
            pkg.setUse32bitAbi(lite.use32bitAbi);
            Package package_ = pkg;
            return package_;
        }
        catch (IOException e) {
            throw new PackageParserException(-102, "Failed to get path: " + lite.baseCodePath, e);
        }
        finally {
            IoUtils.closeQuietly(assetLoader);
        }
    }

    @Deprecated
    @UnsupportedAppUsage
    public Package parseMonolithicPackage(File apkFile, int flags) throws PackageParserException {
        PackageLite lite = PackageParser.parseMonolithicPackageLite(apkFile, flags);
        if (this.mOnlyCoreApps && !lite.coreApp) {
            throw new PackageParserException(-108, "Not a coreApp: " + apkFile);
        }
        DefaultSplitAssetLoader assetLoader = new DefaultSplitAssetLoader(lite, flags);
        try {
            Package pkg = this.parseBaseApk(apkFile, assetLoader.getBaseAssetManager(), flags);
            pkg.setCodePath(apkFile.getCanonicalPath());
            pkg.setUse32bitAbi(lite.use32bitAbi);
            Package package_ = pkg;
            return package_;
        }
        catch (IOException e) {
            throw new PackageParserException(-102, "Failed to get path: " + apkFile, e);
        }
        finally {
            IoUtils.closeQuietly(assetLoader);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Package parseBaseApk(File apkFile, AssetManager assets, int flags) throws PackageParserException {
        Package package_;
        String apkPath = apkFile.getAbsolutePath();
        String volumeUuid = null;
        if (apkPath.startsWith(MNT_EXPAND)) {
            int end = apkPath.indexOf(47, MNT_EXPAND.length());
            volumeUuid = apkPath.substring(MNT_EXPAND.length(), end);
        }
        this.mParseError = 1;
        this.mArchiveSourcePath = apkFile.getAbsolutePath();
        XmlResourceParser parser = null;
        try {
            String[] outError;
            int cookie = assets.findCookieForPath(apkPath);
            if (cookie == 0) {
                throw new PackageParserException(-101, "Failed adding asset path: " + apkPath);
            }
            Resources res = new Resources(assets, this.mMetrics, null);
            parser = assets.openXmlResourceParser(cookie, ANDROID_MANIFEST_FILENAME);
            Package pkg = this.parseBaseApk(apkPath, res, parser, flags, outError = new String[1]);
            if (pkg == null) {
                throw new PackageParserException(this.mParseError, apkPath + " (at " + parser.getPositionDescription() + "): " + outError[0]);
            }
            pkg.setVolumeUuid(volumeUuid);
            pkg.setApplicationVolumeUuid(volumeUuid);
            pkg.setBaseCodePath(apkPath);
            pkg.setSigningDetails(SigningDetails.UNKNOWN);
            package_ = pkg;
        }
        catch (PackageParserException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new PackageParserException(-102, "Failed to read manifest from " + apkPath, e2);
                }
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(parser);
                throw throwable;
            }
        }
        IoUtils.closeQuietly(parser);
        return package_;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseSplitApk(Package pkg, int splitIndex, AssetManager assets, int flags) throws PackageParserException {
        String apkPath = pkg.splitCodePaths[splitIndex];
        this.mParseError = 1;
        this.mArchiveSourcePath = apkPath;
        XmlResourceParser parser = null;
        try {
            String[] outError;
            int cookie = assets.findCookieForPath(apkPath);
            if (cookie == 0) {
                throw new PackageParserException(-101, "Failed adding asset path: " + apkPath);
            }
            Resources res = new Resources(assets, this.mMetrics, null);
            parser = assets.openXmlResourceParser(cookie, ANDROID_MANIFEST_FILENAME);
            if ((pkg = this.parseSplitApk(pkg, res, parser, flags, splitIndex, outError = new String[1])) == null) {
                throw new PackageParserException(this.mParseError, apkPath + " (at " + parser.getPositionDescription() + "): " + outError[0]);
            }
        }
        catch (PackageParserException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new PackageParserException(-102, "Failed to read manifest from " + apkPath, e2);
                }
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(parser);
                throw throwable;
            }
        }
        IoUtils.closeQuietly(parser);
    }

    private Package parseSplitApk(Package pkg, Resources res, XmlResourceParser parser, int flags, int splitIndex, String[] outError) throws XmlPullParserException, IOException, PackageParserException {
        int type;
        XmlResourceParser attrs = parser;
        PackageParser.parsePackageSplitNames(parser, attrs);
        this.mParseInstrumentationArgs = null;
        boolean foundApp = false;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if (tagName.equals(TAG_APPLICATION)) {
                if (foundApp) {
                    Slog.w(TAG, "<manifest> has more than one <application>");
                    XmlUtils.skipCurrentTag(parser);
                    continue;
                }
                foundApp = true;
                if (this.parseSplitApplication(pkg, res, parser, flags, splitIndex, outError)) continue;
                return null;
            }
            Slog.w(TAG, "Unknown element under <manifest>: " + parser.getName() + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
            XmlUtils.skipCurrentTag(parser);
        }
        if (!foundApp) {
            outError[0] = "<manifest> does not contain an <application>";
            this.mParseError = -109;
        }
        return pkg;
    }

    public static ArraySet<PublicKey> toSigningKeys(Signature[] signatures) throws CertificateException {
        ArraySet<PublicKey> keys = new ArraySet<PublicKey>(signatures.length);
        for (int i = 0; i < signatures.length; ++i) {
            keys.add(signatures[i].getPublicKey());
        }
        return keys;
    }

    @UnsupportedAppUsage
    public static void collectCertificates(Package pkg, boolean skipVerify) throws PackageParserException {
        PackageParser.collectCertificatesInternal(pkg, skipVerify);
        int childCount = pkg.childPackages != null ? pkg.childPackages.size() : 0;
        for (int i = 0; i < childCount; ++i) {
            Package childPkg = pkg.childPackages.get(i);
            childPkg.mSigningDetails = pkg.mSigningDetails;
        }
    }

    private static void collectCertificatesInternal(Package pkg, boolean skipVerify) throws PackageParserException {
        pkg.mSigningDetails = SigningDetails.UNKNOWN;
        Trace.traceBegin(262144L, "collectCertificates");
        try {
            PackageParser.collectCertificates(pkg, new File(pkg.baseCodePath), skipVerify);
            if (!ArrayUtils.isEmpty(pkg.splitCodePaths)) {
                for (int i = 0; i < pkg.splitCodePaths.length; ++i) {
                    PackageParser.collectCertificates(pkg, new File(pkg.splitCodePaths[i]), skipVerify);
                }
            }
        }
        finally {
            Trace.traceEnd(262144L);
        }
    }

    @UnsupportedAppUsage
    private static void collectCertificates(Package pkg, File apkFile, boolean skipVerify) throws PackageParserException {
        String apkPath = apkFile.getAbsolutePath();
        int minSignatureScheme = 1;
        if (pkg.applicationInfo.isStaticSharedLibrary()) {
            minSignatureScheme = 2;
        }
        SigningDetails verified = skipVerify ? ApkSignatureVerifier.unsafeGetCertsWithoutVerification(apkPath, minSignatureScheme) : ApkSignatureVerifier.verify(apkPath, minSignatureScheme);
        if (pkg.mSigningDetails == SigningDetails.UNKNOWN) {
            pkg.mSigningDetails = verified;
        } else if (!Signature.areExactMatch(pkg.mSigningDetails.signatures, verified.signatures)) {
            throw new PackageParserException(-104, apkPath + " has mismatched certificates");
        }
    }

    private static AssetManager newConfiguredAssetManager() {
        AssetManager assetManager = new AssetManager();
        assetManager.setConfiguration(0, 0, null, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, Build.VERSION.RESOURCES_SDK_INT);
        return assetManager;
    }

    public static ApkLite parseApkLite(File apkFile, int flags) throws PackageParserException {
        return PackageParser.parseApkLiteInner(apkFile, null, null, flags);
    }

    public static ApkLite parseApkLite(FileDescriptor fd, String debugPathName, int flags) throws PackageParserException {
        return PackageParser.parseApkLiteInner(null, fd, debugPathName, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ApkLite parseApkLiteInner(File apkFile, FileDescriptor fd, String debugPathName, int flags) throws PackageParserException {
        ApkLite apkLite;
        String apkPath = fd != null ? debugPathName : apkFile.getAbsolutePath();
        XmlResourceParser parser = null;
        ApkAssets apkAssets = null;
        try {
            SigningDetails signingDetails;
            try {
                apkAssets = fd != null ? ApkAssets.loadFromFd(fd, debugPathName, false, false) : ApkAssets.loadFromPath(apkPath);
            }
            catch (IOException e) {
                throw new PackageParserException(-100, "Failed to parse " + apkPath);
            }
            parser = apkAssets.openXml(ANDROID_MANIFEST_FILENAME);
            if ((flags & 0x20) != 0) {
                Package tempPkg = new Package((String)null);
                boolean skipVerify = (flags & 0x10) != 0;
                Trace.traceBegin(262144L, "collectCertificates");
                try {
                    PackageParser.collectCertificates(tempPkg, apkFile, skipVerify);
                }
                finally {
                    Trace.traceEnd(262144L);
                }
                signingDetails = tempPkg.mSigningDetails;
            } else {
                signingDetails = SigningDetails.UNKNOWN;
            }
            XmlResourceParser attrs = parser;
            apkLite = PackageParser.parseApkLite(apkPath, parser, attrs, signingDetails);
        }
        catch (IOException | RuntimeException | XmlPullParserException e) {
            try {
                Slog.w(TAG, "Failed to parse " + apkPath, e);
                throw new PackageParserException(-102, "Failed to parse " + apkPath, e);
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(parser);
                if (apkAssets != null) {
                    try {
                        apkAssets.close();
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        IoUtils.closeQuietly(parser);
        if (apkAssets != null) {
            try {
                apkAssets.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return apkLite;
    }

    private static String validateName(String name, boolean requireSeparator, boolean requireFilename) {
        int N = name.length();
        boolean hasSep = false;
        boolean front = true;
        for (int i = 0; i < N; ++i) {
            char c = name.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                front = false;
                continue;
            }
            if (!front && (c >= '0' && c <= '9' || c == '_')) continue;
            if (c == '.') {
                hasSep = true;
                front = true;
                continue;
            }
            return "bad character '" + c + "'";
        }
        if (requireFilename && !FileUtils.isValidExtFilename(name)) {
            return "Invalid filename";
        }
        return hasSep || !requireSeparator ? null : "must have at least one '.' separator";
    }

    private static Pair<String, String> parsePackageSplitNames(XmlPullParser parser, AttributeSet attrs) throws IOException, XmlPullParserException, PackageParserException {
        String error;
        int type;
        while ((type = parser.next()) != 2 && type != 1) {
        }
        if (type != 2) {
            throw new PackageParserException(-108, "No start tag found");
        }
        if (!parser.getName().equals(TAG_MANIFEST)) {
            throw new PackageParserException(-108, "No <manifest> tag");
        }
        String packageName = attrs.getAttributeValue(null, TAG_PACKAGE);
        if (!"android".equals(packageName) && (error = PackageParser.validateName(packageName, true, true)) != null) {
            throw new PackageParserException(-106, "Invalid manifest package: " + error);
        }
        String splitName = attrs.getAttributeValue(null, "split");
        if (splitName != null) {
            if (splitName.length() == 0) {
                splitName = null;
            } else {
                String error2 = PackageParser.validateName(splitName, false, false);
                if (error2 != null) {
                    throw new PackageParserException(-106, "Invalid manifest split: " + error2);
                }
            }
        }
        return Pair.create(packageName.intern(), splitName != null ? splitName.intern() : splitName);
    }

    private static ApkLite parseApkLite(String codePath, XmlPullParser parser, AttributeSet attrs, SigningDetails signingDetails) throws IOException, XmlPullParserException, PackageParserException {
        int type;
        Pair<String, String> packageSplit = PackageParser.parsePackageSplitNames(parser, attrs);
        int installLocation = -1;
        int versionCode = 0;
        int versionCodeMajor = 0;
        int targetSdkVersion = 0;
        int minSdkVersion = 1;
        int revisionCode = 0;
        boolean coreApp = false;
        boolean debuggable = false;
        boolean multiArch = false;
        boolean use32bitAbi = false;
        boolean extractNativeLibs = true;
        boolean isolatedSplits = false;
        boolean isFeatureSplit = false;
        boolean isSplitRequired = false;
        boolean useEmbeddedDex = false;
        String configForSplit = null;
        String usesSplitName = null;
        for (int i = 0; i < attrs.getAttributeCount(); ++i) {
            String attr2 = attrs.getAttributeName(i);
            if (attr2.equals("installLocation")) {
                installLocation = attrs.getAttributeIntValue(i, -1);
                continue;
            }
            if (attr2.equals("versionCode")) {
                versionCode = attrs.getAttributeIntValue(i, 0);
                continue;
            }
            if (attr2.equals("versionCodeMajor")) {
                versionCodeMajor = attrs.getAttributeIntValue(i, 0);
                continue;
            }
            if (attr2.equals("revisionCode")) {
                revisionCode = attrs.getAttributeIntValue(i, 0);
                continue;
            }
            if (attr2.equals("coreApp")) {
                coreApp = attrs.getAttributeBooleanValue(i, false);
                continue;
            }
            if (attr2.equals("isolatedSplits")) {
                isolatedSplits = attrs.getAttributeBooleanValue(i, false);
                continue;
            }
            if (attr2.equals("configForSplit")) {
                configForSplit = attrs.getAttributeValue(i);
                continue;
            }
            if (attr2.equals("isFeatureSplit")) {
                isFeatureSplit = attrs.getAttributeBooleanValue(i, false);
                continue;
            }
            if (!attr2.equals("isSplitRequired")) continue;
            isSplitRequired = attrs.getAttributeBooleanValue(i, false);
        }
        int searchDepth = parser.getDepth() + 1;
        ArrayList<VerifierInfo> verifiers = new ArrayList<VerifierInfo>();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() >= searchDepth)) {
            String attr3;
            if (type == 3 || type == 4 || parser.getDepth() != searchDepth) continue;
            if (TAG_PACKAGE_VERIFIER.equals(parser.getName())) {
                VerifierInfo verifier = PackageParser.parseVerifier(attrs);
                if (verifier == null) continue;
                verifiers.add(verifier);
                continue;
            }
            if (TAG_APPLICATION.equals(parser.getName())) {
                for (int i = 0; i < attrs.getAttributeCount(); ++i) {
                    attr3 = attrs.getAttributeName(i);
                    if ("debuggable".equals(attr3)) {
                        debuggable = attrs.getAttributeBooleanValue(i, false);
                    }
                    if ("multiArch".equals(attr3)) {
                        multiArch = attrs.getAttributeBooleanValue(i, false);
                    }
                    if ("use32bitAbi".equals(attr3)) {
                        use32bitAbi = attrs.getAttributeBooleanValue(i, false);
                    }
                    if ("extractNativeLibs".equals(attr3)) {
                        extractNativeLibs = attrs.getAttributeBooleanValue(i, true);
                    }
                    if (!"useEmbeddedDex".equals(attr3)) continue;
                    useEmbeddedDex = attrs.getAttributeBooleanValue(i, false);
                }
                continue;
            }
            if (TAG_USES_SPLIT.equals(parser.getName())) {
                if (usesSplitName != null) {
                    Slog.w(TAG, "Only one <uses-split> permitted. Ignoring others.");
                    continue;
                }
                usesSplitName = attrs.getAttributeValue(ANDROID_RESOURCES, "name");
                if (usesSplitName != null) continue;
                throw new PackageParserException(-108, "<uses-split> tag requires 'android:name' attribute");
            }
            if (!TAG_USES_SDK.equals(parser.getName())) continue;
            for (int i = 0; i < attrs.getAttributeCount(); ++i) {
                attr3 = attrs.getAttributeName(i);
                if ("targetSdkVersion".equals(attr3)) {
                    targetSdkVersion = attrs.getAttributeIntValue(i, 0);
                }
                if (!"minSdkVersion".equals(attr3)) continue;
                minSdkVersion = attrs.getAttributeIntValue(i, 1);
            }
        }
        return new ApkLite(codePath, (String)packageSplit.first, (String)packageSplit.second, isFeatureSplit, configForSplit, usesSplitName, isSplitRequired, versionCode, versionCodeMajor, revisionCode, installLocation, verifiers, signingDetails, coreApp, debuggable, multiArch, use32bitAbi, useEmbeddedDex, extractNativeLibs, isolatedSplits, minSdkVersion, targetSdkVersion);
    }

    private boolean parseBaseApkChild(Package parentPkg, Resources res, XmlResourceParser parser, int flags, String[] outError) throws XmlPullParserException, IOException {
        String childPackageName = parser.getAttributeValue(null, TAG_PACKAGE);
        if (PackageParser.validateName(childPackageName, true, false) != null) {
            this.mParseError = -106;
            return false;
        }
        if (childPackageName.equals(parentPkg.packageName)) {
            String message = "Child package name cannot be equal to parent package name: " + parentPkg.packageName;
            Slog.w(TAG, message);
            outError[0] = message;
            this.mParseError = -108;
            return false;
        }
        if (parentPkg.hasChildPackage(childPackageName)) {
            String message = "Duplicate child package:" + childPackageName;
            Slog.w(TAG, message);
            outError[0] = message;
            this.mParseError = -108;
            return false;
        }
        Package childPkg = new Package(childPackageName);
        childPkg.mVersionCode = parentPkg.mVersionCode;
        childPkg.baseRevisionCode = parentPkg.baseRevisionCode;
        childPkg.mVersionName = parentPkg.mVersionName;
        childPkg.applicationInfo.targetSdkVersion = parentPkg.applicationInfo.targetSdkVersion;
        childPkg.applicationInfo.minSdkVersion = parentPkg.applicationInfo.minSdkVersion;
        if ((childPkg = this.parseBaseApkCommon(childPkg, CHILD_PACKAGE_TAGS, res, parser, flags, outError)) == null) {
            return false;
        }
        if (parentPkg.childPackages == null) {
            parentPkg.childPackages = new ArrayList();
        }
        parentPkg.childPackages.add(childPkg);
        childPkg.parentPackage = parentPkg;
        return true;
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private Package parseBaseApk(String apkPath, Resources res, XmlResourceParser parser, int flags, String[] outError) throws XmlPullParserException, IOException {
        String[] overlayPaths;
        String pkgName;
        try {
            Pair<String, String> packageSplit = PackageParser.parsePackageSplitNames(parser, parser);
            pkgName = (String)packageSplit.first;
            String splitName = (String)packageSplit.second;
            if (!TextUtils.isEmpty(splitName)) {
                outError[0] = "Expected base APK, but found split " + splitName;
                this.mParseError = -106;
                return null;
            }
        }
        catch (PackageParserException e) {
            this.mParseError = -106;
            return null;
        }
        if (this.mCallback != null && (overlayPaths = this.mCallback.getOverlayPaths(pkgName, apkPath)) != null && overlayPaths.length > 0) {
            for (String overlayPath : overlayPaths) {
                res.getAssets().addOverlayPath(overlayPath);
            }
        }
        Package pkg = new Package(pkgName);
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifest);
        pkg.mVersionCode = sa.getInteger(1, 0);
        pkg.mVersionCodeMajor = sa.getInteger(11, 0);
        pkg.applicationInfo.setVersionCode(pkg.getLongVersionCode());
        pkg.baseRevisionCode = sa.getInteger(5, 0);
        pkg.mVersionName = sa.getNonConfigurationString(2, 0);
        if (pkg.mVersionName != null) {
            pkg.mVersionName = pkg.mVersionName.intern();
        }
        pkg.coreApp = parser.getAttributeBooleanValue(null, "coreApp", false);
        pkg.applicationInfo.compileSdkVersion = pkg.mCompileSdkVersion = sa.getInteger(9, 0);
        pkg.mCompileSdkVersionCodename = sa.getNonConfigurationString(10, 0);
        if (pkg.mCompileSdkVersionCodename != null) {
            pkg.mCompileSdkVersionCodename = pkg.mCompileSdkVersionCodename.intern();
        }
        pkg.applicationInfo.compileSdkVersionCodename = pkg.mCompileSdkVersionCodename;
        sa.recycle();
        return this.parseBaseApkCommon(pkg, null, res, parser, flags, outError);
    }

    private Package parseBaseApkCommon(Package pkg, Set<String> acceptedTags, Resources res, XmlResourceParser parser, int flags, String[] outError) throws XmlPullParserException, IOException {
        int type;
        int targetSandboxVersion;
        this.mParseInstrumentationArgs = null;
        boolean foundApp = false;
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifest);
        String str = sa.getNonConfigurationString(0, 0);
        if (str != null && str.length() > 0) {
            String nameError = PackageParser.validateName(str, true, true);
            if (nameError != null && !"android".equals(pkg.packageName)) {
                outError[0] = "<manifest> specifies bad sharedUserId name \"" + str + "\": " + nameError;
                this.mParseError = -107;
                return null;
            }
            pkg.mSharedUserId = str.intern();
            pkg.mSharedUserLabel = sa.getResourceId(3, 0);
        }
        pkg.applicationInfo.installLocation = pkg.installLocation = sa.getInteger(4, -1);
        pkg.applicationInfo.targetSandboxVersion = targetSandboxVersion = sa.getInteger(7, 1);
        if ((flags & 8) != 0) {
            pkg.applicationInfo.flags |= 0x40000;
        }
        if (sa.getBoolean(6, false)) {
            pkg.applicationInfo.privateFlags |= 0x8000;
        }
        int supportsSmallScreens = 1;
        int supportsNormalScreens = 1;
        int supportsLargeScreens = 1;
        int supportsXLargeScreens = 1;
        int resizeable = 1;
        int anyDensity = 1;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if (acceptedTags != null && !acceptedTags.contains(tagName)) {
                Slog.w(TAG, "Skipping unsupported element under <manifest>: " + tagName + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals(TAG_APPLICATION)) {
                if (foundApp) {
                    Slog.w(TAG, "<manifest> has more than one <application>");
                    XmlUtils.skipCurrentTag(parser);
                    continue;
                }
                foundApp = true;
                if (this.parseBaseApplication(pkg, res, parser, flags, outError)) continue;
                return null;
            }
            if (tagName.equals(TAG_OVERLAY)) {
                sa = res.obtainAttributes(parser, R.styleable.AndroidManifestResourceOverlay);
                pkg.mOverlayTarget = sa.getString(1);
                pkg.mOverlayTargetName = sa.getString(3);
                pkg.mOverlayCategory = sa.getString(2);
                pkg.mOverlayPriority = sa.getInt(0, 0);
                pkg.mOverlayIsStatic = sa.getBoolean(4, false);
                String propName = sa.getString(5);
                String propValue = sa.getString(6);
                sa.recycle();
                if (pkg.mOverlayTarget == null) {
                    outError[0] = "<overlay> does not specify a target package";
                    this.mParseError = -108;
                    return null;
                }
                if (pkg.mOverlayPriority < 0 || pkg.mOverlayPriority > 9999) {
                    outError[0] = "<overlay> priority must be between 0 and 9999";
                    this.mParseError = -108;
                    return null;
                }
                if (!this.checkOverlayRequiredSystemProperty(propName, propValue)) {
                    Slog.i(TAG, "Skipping target and overlay pair " + pkg.mOverlayTarget + " and " + pkg.baseCodePath + ": overlay ignored due to required system property: " + propName + " with value: " + propValue);
                    return null;
                }
                pkg.applicationInfo.privateFlags |= 0x10000000;
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals(TAG_KEY_SETS)) {
                if (this.parseKeySets(pkg, res, parser, outError)) continue;
                return null;
            }
            if (tagName.equals(TAG_PERMISSION_GROUP)) {
                if (this.parsePermissionGroup(pkg, flags, res, parser, outError)) continue;
                return null;
            }
            if (tagName.equals(TAG_PERMISSION)) {
                if (this.parsePermission(pkg, res, parser, outError)) continue;
                return null;
            }
            if (tagName.equals(TAG_PERMISSION_TREE)) {
                if (this.parsePermissionTree(pkg, res, parser, outError)) continue;
                return null;
            }
            if (tagName.equals(TAG_USES_PERMISSION)) {
                if (this.parseUsesPermission(pkg, res, parser)) continue;
                return null;
            }
            if (tagName.equals(TAG_USES_PERMISSION_SDK_M) || tagName.equals(TAG_USES_PERMISSION_SDK_23)) {
                if (this.parseUsesPermission(pkg, res, parser)) continue;
                return null;
            }
            if (tagName.equals(TAG_USES_CONFIGURATION)) {
                ConfigurationInfo cPref = new ConfigurationInfo();
                sa = res.obtainAttributes(parser, R.styleable.AndroidManifestUsesConfiguration);
                cPref.reqTouchScreen = sa.getInt(0, 0);
                cPref.reqKeyboardType = sa.getInt(1, 0);
                if (sa.getBoolean(2, false)) {
                    cPref.reqInputFeatures |= 1;
                }
                cPref.reqNavigation = sa.getInt(3, 0);
                if (sa.getBoolean(4, false)) {
                    cPref.reqInputFeatures |= 2;
                }
                sa.recycle();
                pkg.configPreferences = ArrayUtils.add(pkg.configPreferences, cPref);
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals(TAG_USES_FEATURE)) {
                FeatureInfo fi = this.parseUsesFeature(res, parser);
                pkg.reqFeatures = ArrayUtils.add(pkg.reqFeatures, fi);
                if (fi.name == null) {
                    ConfigurationInfo cPref = new ConfigurationInfo();
                    cPref.reqGlEsVersion = fi.reqGlEsVersion;
                    pkg.configPreferences = ArrayUtils.add(pkg.configPreferences, cPref);
                }
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals(TAG_FEATURE_GROUP)) {
                FeatureGroupInfo group = new FeatureGroupInfo();
                ArrayList<FeatureInfo> features = null;
                int innerDepth = parser.getDepth();
                while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > innerDepth)) {
                    if (type == 3 || type == 4) continue;
                    String innerTagName = parser.getName();
                    if (innerTagName.equals(TAG_USES_FEATURE)) {
                        FeatureInfo featureInfo = this.parseUsesFeature(res, parser);
                        featureInfo.flags |= 1;
                        features = ArrayUtils.add(features, featureInfo);
                    } else {
                        Slog.w(TAG, "Unknown element under <feature-group>: " + innerTagName + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
                    }
                    XmlUtils.skipCurrentTag(parser);
                }
                if (features != null) {
                    group.features = new FeatureInfo[features.size()];
                    group.features = features.toArray(group.features);
                }
                pkg.featureGroups = ArrayUtils.add(pkg.featureGroups, group);
                continue;
            }
            if (tagName.equals(TAG_USES_SDK)) {
                if (SDK_VERSION > 0) {
                    sa = res.obtainAttributes(parser, R.styleable.AndroidManifestUsesSdk);
                    int minVers = 1;
                    String minCode = null;
                    int targetVers = 0;
                    String targetCode = null;
                    TypedValue val = sa.peekValue(0);
                    if (val != null) {
                        if (val.type == 3 && val.string != null) {
                            minCode = val.string.toString();
                        } else {
                            minVers = val.data;
                        }
                    }
                    if ((val = sa.peekValue(1)) != null) {
                        if (val.type == 3 && val.string != null) {
                            targetCode = val.string.toString();
                            if (minCode == null) {
                                minCode = targetCode;
                            }
                        } else {
                            targetVers = val.data;
                        }
                    } else {
                        targetVers = minVers;
                        targetCode = minCode;
                    }
                    sa.recycle();
                    int minSdkVersion = PackageParser.computeMinSdkVersion(minVers, minCode, SDK_VERSION, SDK_CODENAMES, outError);
                    if (minSdkVersion < 0) {
                        this.mParseError = -12;
                        return null;
                    }
                    int targetSdkVersion = PackageParser.computeTargetSdkVersion(targetVers, targetCode, SDK_CODENAMES, outError);
                    if (targetSdkVersion < 0) {
                        this.mParseError = -12;
                        return null;
                    }
                    pkg.applicationInfo.minSdkVersion = minSdkVersion;
                    pkg.applicationInfo.targetSdkVersion = targetSdkVersion;
                }
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals(TAG_SUPPORT_SCREENS)) {
                sa = res.obtainAttributes(parser, R.styleable.AndroidManifestSupportsScreens);
                pkg.applicationInfo.requiresSmallestWidthDp = sa.getInteger(6, 0);
                pkg.applicationInfo.compatibleWidthLimitDp = sa.getInteger(7, 0);
                pkg.applicationInfo.largestWidthLimitDp = sa.getInteger(8, 0);
                supportsSmallScreens = sa.getInteger(1, supportsSmallScreens);
                supportsNormalScreens = sa.getInteger(2, supportsNormalScreens);
                supportsLargeScreens = sa.getInteger(3, supportsLargeScreens);
                supportsXLargeScreens = sa.getInteger(5, supportsXLargeScreens);
                resizeable = sa.getInteger(4, resizeable);
                anyDensity = sa.getInteger(0, anyDensity);
                sa.recycle();
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals(TAG_PROTECTED_BROADCAST)) {
                sa = res.obtainAttributes(parser, R.styleable.AndroidManifestProtectedBroadcast);
                String name = sa.getNonResourceString(0);
                sa.recycle();
                if (name != null) {
                    if (pkg.protectedBroadcasts == null) {
                        pkg.protectedBroadcasts = new ArrayList();
                    }
                    if (!pkg.protectedBroadcasts.contains(name)) {
                        pkg.protectedBroadcasts.add(name.intern());
                    }
                }
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals(TAG_INSTRUMENTATION)) {
                if (this.parseInstrumentation(pkg, res, parser, outError) != null) continue;
                return null;
            }
            if (tagName.equals(TAG_ORIGINAL_PACKAGE)) {
                sa = res.obtainAttributes(parser, R.styleable.AndroidManifestOriginalPackage);
                String orig = sa.getNonConfigurationString(0, 0);
                if (!pkg.packageName.equals(orig)) {
                    if (pkg.mOriginalPackages == null) {
                        pkg.mOriginalPackages = new ArrayList();
                        pkg.mRealPackage = pkg.packageName;
                    }
                    pkg.mOriginalPackages.add(orig);
                }
                sa.recycle();
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals(TAG_ADOPT_PERMISSIONS)) {
                sa = res.obtainAttributes(parser, R.styleable.AndroidManifestOriginalPackage);
                String name = sa.getNonConfigurationString(0, 0);
                sa.recycle();
                if (name != null) {
                    if (pkg.mAdoptPermissions == null) {
                        pkg.mAdoptPermissions = new ArrayList();
                    }
                    pkg.mAdoptPermissions.add(name);
                }
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals(TAG_USES_GL_TEXTURE)) {
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals(TAG_COMPATIBLE_SCREENS)) {
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals(TAG_SUPPORTS_INPUT)) {
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals(TAG_EAT_COMMENT)) {
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals(TAG_PACKAGE)) {
                if (!MULTI_PACKAGE_APK_ENABLED) {
                    XmlUtils.skipCurrentTag(parser);
                    continue;
                }
                if (this.parseBaseApkChild(pkg, res, parser, flags, outError)) continue;
                return null;
            }
            if (tagName.equals(TAG_RESTRICT_UPDATE)) {
                if ((flags & 0x10) != 0) {
                    sa = res.obtainAttributes(parser, R.styleable.AndroidManifestRestrictUpdate);
                    String hash = sa.getNonConfigurationString(0, 0);
                    sa.recycle();
                    pkg.restrictUpdateHash = null;
                    if (hash != null) {
                        int hashLength = hash.length();
                        byte[] hashBytes = new byte[hashLength / 2];
                        for (int i = 0; i < hashLength; i += 2) {
                            hashBytes[i / 2] = (byte)((Character.digit(hash.charAt(i), 16) << 4) + Character.digit(hash.charAt(i + 1), 16));
                        }
                        pkg.restrictUpdateHash = hashBytes;
                    }
                }
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            Slog.w(TAG, "Unknown element under <manifest>: " + parser.getName() + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
            XmlUtils.skipCurrentTag(parser);
        }
        if (!foundApp && pkg.instrumentation.size() == 0) {
            outError[0] = "<manifest> does not contain an <application> or <instrumentation>";
            this.mParseError = -109;
        }
        int NP = NEW_PERMISSIONS.length;
        StringBuilder newPermsMsg = null;
        for (int ip = 0; ip < NP; ++ip) {
            NewPermissionInfo npi = NEW_PERMISSIONS[ip];
            if (pkg.applicationInfo.targetSdkVersion >= npi.sdkVersion) break;
            if (pkg.requestedPermissions.contains(npi.name)) continue;
            if (newPermsMsg == null) {
                newPermsMsg = new StringBuilder(128);
                newPermsMsg.append(pkg.packageName);
                newPermsMsg.append(": compat added ");
            } else {
                newPermsMsg.append(' ');
            }
            newPermsMsg.append(npi.name);
            pkg.requestedPermissions.add(npi.name);
            pkg.implicitPermissions.add(npi.name);
        }
        if (newPermsMsg != null) {
            Slog.i(TAG, newPermsMsg.toString());
        }
        int NS = PermissionManager.SPLIT_PERMISSIONS.size();
        for (int is = 0; is < NS; ++is) {
            PermissionManager.SplitPermissionInfo spi = PermissionManager.SPLIT_PERMISSIONS.get(is);
            if (pkg.applicationInfo.targetSdkVersion >= spi.getTargetSdk() || !pkg.requestedPermissions.contains(spi.getSplitPermission())) continue;
            List<String> newPerms = spi.getNewPermissions();
            for (int in = 0; in < newPerms.size(); ++in) {
                String perm = newPerms.get(in);
                if (pkg.requestedPermissions.contains(perm)) continue;
                pkg.requestedPermissions.add(perm);
                pkg.implicitPermissions.add(perm);
            }
        }
        if (supportsSmallScreens < 0 || supportsSmallScreens > 0 && pkg.applicationInfo.targetSdkVersion >= 4) {
            pkg.applicationInfo.flags |= 0x200;
        }
        if (supportsNormalScreens != 0) {
            pkg.applicationInfo.flags |= 0x400;
        }
        if (supportsLargeScreens < 0 || supportsLargeScreens > 0 && pkg.applicationInfo.targetSdkVersion >= 4) {
            pkg.applicationInfo.flags |= 0x800;
        }
        if (supportsXLargeScreens < 0 || supportsXLargeScreens > 0 && pkg.applicationInfo.targetSdkVersion >= 9) {
            pkg.applicationInfo.flags |= 0x80000;
        }
        if (resizeable < 0 || resizeable > 0 && pkg.applicationInfo.targetSdkVersion >= 4) {
            pkg.applicationInfo.flags |= 0x1000;
        }
        if (anyDensity < 0 || anyDensity > 0 && pkg.applicationInfo.targetSdkVersion >= 4) {
            pkg.applicationInfo.flags |= 0x2000;
        }
        if (pkg.applicationInfo.usesCompatibilityMode()) {
            this.adjustPackageToBeUnresizeableAndUnpipable(pkg);
        }
        return pkg;
    }

    private boolean checkOverlayRequiredSystemProperty(String propName, String propValue) {
        if (TextUtils.isEmpty(propName) || TextUtils.isEmpty(propValue)) {
            if (!TextUtils.isEmpty(propName) || !TextUtils.isEmpty(propValue)) {
                Slog.w(TAG, "Disabling overlay - incomplete property :'" + propName + "=" + propValue + "' - require both requiredSystemPropertyName AND requiredSystemPropertyValue to be specified.");
                return false;
            }
            return true;
        }
        String currValue = SystemProperties.get(propName);
        return currValue != null && currValue.equals(propValue);
    }

    private void adjustPackageToBeUnresizeableAndUnpipable(Package pkg) {
        for (Activity a : pkg.activities) {
            a.info.resizeMode = 0;
            a.info.flags &= 0xFFBFFFFF;
        }
    }

    private static boolean matchTargetCode(String[] codeNames, String targetCode) {
        int targetCodeIdx = targetCode.indexOf(46);
        String targetCodeName = targetCodeIdx == -1 ? targetCode : targetCode.substring(0, targetCodeIdx);
        return ArrayUtils.contains(codeNames, targetCodeName);
    }

    public static int computeTargetSdkVersion(int targetVers, String targetCode, String[] platformSdkCodenames, String[] outError) {
        if (targetCode == null) {
            return targetVers;
        }
        if (PackageParser.matchTargetCode(platformSdkCodenames, targetCode)) {
            return 10000;
        }
        outError[0] = platformSdkCodenames.length > 0 ? "Requires development platform " + targetCode + " (current platform is any of " + Arrays.toString(platformSdkCodenames) + ")" : "Requires development platform " + targetCode + " but this is a release platform.";
        return -1;
    }

    public static int computeMinSdkVersion(int minVers, String minCode, int platformSdkVersion, String[] platformSdkCodenames, String[] outError) {
        if (minCode == null) {
            if (minVers <= platformSdkVersion) {
                return minVers;
            }
            outError[0] = "Requires newer sdk version #" + minVers + " (current version is #" + platformSdkVersion + ")";
            return -1;
        }
        if (PackageParser.matchTargetCode(platformSdkCodenames, minCode)) {
            return 10000;
        }
        outError[0] = platformSdkCodenames.length > 0 ? "Requires development platform " + minCode + " (current platform is any of " + Arrays.toString(platformSdkCodenames) + ")" : "Requires development platform " + minCode + " but this is a release platform.";
        return -1;
    }

    private FeatureInfo parseUsesFeature(Resources res, AttributeSet attrs) {
        FeatureInfo fi = new FeatureInfo();
        TypedArray sa = res.obtainAttributes(attrs, R.styleable.AndroidManifestUsesFeature);
        fi.name = sa.getNonResourceString(0);
        fi.version = sa.getInt(3, 0);
        if (fi.name == null) {
            fi.reqGlEsVersion = sa.getInt(1, 0);
        }
        if (sa.getBoolean(2, true)) {
            fi.flags |= 1;
        }
        sa.recycle();
        return fi;
    }

    private boolean parseUsesStaticLibrary(Package pkg, Resources res, XmlResourceParser parser, String[] outError) throws XmlPullParserException, IOException {
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestUsesStaticLibrary);
        String lname = sa.getNonResourceString(0);
        int version = sa.getInt(1, -1);
        String certSha256Digest = sa.getNonResourceString(2);
        sa.recycle();
        if (lname == null || version < 0 || certSha256Digest == null) {
            outError[0] = "Bad uses-static-library declaration name: " + lname + " version: " + version + " certDigest" + certSha256Digest;
            this.mParseError = -108;
            XmlUtils.skipCurrentTag(parser);
            return false;
        }
        if (pkg.usesStaticLibraries != null && pkg.usesStaticLibraries.contains(lname)) {
            outError[0] = "Depending on multiple versions of static library " + lname;
            this.mParseError = -108;
            XmlUtils.skipCurrentTag(parser);
            return false;
        }
        lname = lname.intern();
        certSha256Digest = certSha256Digest.replace(":", "").toLowerCase();
        String[] additionalCertSha256Digests = EmptyArray.STRING;
        if (pkg.applicationInfo.targetSdkVersion >= 27) {
            additionalCertSha256Digests = this.parseAdditionalCertificates(res, parser, outError);
            if (additionalCertSha256Digests == null) {
                return false;
            }
        } else {
            XmlUtils.skipCurrentTag(parser);
        }
        String[] certSha256Digests = new String[additionalCertSha256Digests.length + 1];
        certSha256Digests[0] = certSha256Digest;
        System.arraycopy(additionalCertSha256Digests, 0, certSha256Digests, 1, additionalCertSha256Digests.length);
        pkg.usesStaticLibraries = ArrayUtils.add(pkg.usesStaticLibraries, lname);
        pkg.usesStaticLibrariesVersions = ArrayUtils.appendLong(pkg.usesStaticLibrariesVersions, version, true);
        pkg.usesStaticLibrariesCertDigests = ArrayUtils.appendElement(String[].class, pkg.usesStaticLibrariesCertDigests, certSha256Digests, true);
        return true;
    }

    private String[] parseAdditionalCertificates(Resources resources, XmlResourceParser parser, String[] outError) throws XmlPullParserException, IOException {
        int type;
        String[] certSha256Digests = EmptyArray.STRING;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String nodeName = parser.getName();
            if (nodeName.equals("additional-certificate")) {
                TypedArray sa = resources.obtainAttributes(parser, R.styleable.AndroidManifestAdditionalCertificate);
                String certSha256Digest = sa.getNonResourceString(0);
                sa.recycle();
                if (TextUtils.isEmpty(certSha256Digest)) {
                    outError[0] = "Bad additional-certificate declaration with empty certDigest:" + certSha256Digest;
                    this.mParseError = -108;
                    XmlUtils.skipCurrentTag(parser);
                    sa.recycle();
                    return null;
                }
                certSha256Digest = certSha256Digest.replace(":", "").toLowerCase();
                certSha256Digests = ArrayUtils.appendElement(String.class, certSha256Digests, certSha256Digest);
                continue;
            }
            XmlUtils.skipCurrentTag(parser);
        }
        return certSha256Digests;
    }

    private boolean parseUsesPermission(Package pkg, Resources res, XmlResourceParser parser) throws XmlPullParserException, IOException {
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestUsesPermission);
        String name = sa.getNonResourceString(0);
        int maxSdkVersion = 0;
        TypedValue val = sa.peekValue(1);
        if (val != null && val.type >= 16 && val.type <= 31) {
            maxSdkVersion = val.data;
        }
        String requiredFeature = sa.getNonConfigurationString(2, 0);
        String requiredNotfeature = sa.getNonConfigurationString(3, 0);
        sa.recycle();
        XmlUtils.skipCurrentTag(parser);
        if (name == null) {
            return true;
        }
        if (maxSdkVersion != 0 && maxSdkVersion < Build.VERSION.RESOURCES_SDK_INT) {
            return true;
        }
        if (requiredFeature != null && this.mCallback != null && !this.mCallback.hasFeature(requiredFeature)) {
            return true;
        }
        if (requiredNotfeature != null && this.mCallback != null && this.mCallback.hasFeature(requiredNotfeature)) {
            return true;
        }
        int index = pkg.requestedPermissions.indexOf(name);
        if (index == -1) {
            pkg.requestedPermissions.add(name.intern());
        } else {
            Slog.w(TAG, "Ignoring duplicate uses-permissions/uses-permissions-sdk-m: " + name + " in package: " + pkg.packageName + " at: " + parser.getPositionDescription());
        }
        return true;
    }

    private static String buildClassName(String pkg, CharSequence clsSeq, String[] outError) {
        if (clsSeq == null || clsSeq.length() <= 0) {
            outError[0] = "Empty class name in package " + pkg;
            return null;
        }
        String cls = clsSeq.toString();
        char c = cls.charAt(0);
        if (c == '.') {
            return pkg + cls;
        }
        if (cls.indexOf(46) < 0) {
            StringBuilder b = new StringBuilder(pkg);
            b.append('.');
            b.append(cls);
            return b.toString();
        }
        return cls;
    }

    private static String buildCompoundName(String pkg, CharSequence procSeq, String type, String[] outError) {
        String proc = procSeq.toString();
        char c = proc.charAt(0);
        if (pkg != null && c == ':') {
            if (proc.length() < 2) {
                outError[0] = "Bad " + type + " name " + proc + " in package " + pkg + ": must be at least two characters";
                return null;
            }
            String subName = proc.substring(1);
            String nameError = PackageParser.validateName(subName, false, false);
            if (nameError != null) {
                outError[0] = "Invalid " + type + " name " + proc + " in package " + pkg + ": " + nameError;
                return null;
            }
            return pkg + proc;
        }
        String nameError = PackageParser.validateName(proc, true, false);
        if (nameError != null && !"system".equals(proc)) {
            outError[0] = "Invalid " + type + " name " + proc + " in package " + pkg + ": " + nameError;
            return null;
        }
        return proc;
    }

    private static String buildProcessName(String pkg, String defProc, CharSequence procSeq, int flags, String[] separateProcesses, String[] outError) {
        if ((flags & 2) != 0 && !"system".equals(procSeq)) {
            return defProc != null ? defProc : pkg;
        }
        if (separateProcesses != null) {
            for (int i = separateProcesses.length - 1; i >= 0; --i) {
                String sp = separateProcesses[i];
                if (!sp.equals(pkg) && !sp.equals(defProc) && !sp.equals(procSeq)) continue;
                return pkg;
            }
        }
        if (procSeq == null || procSeq.length() <= 0) {
            return defProc;
        }
        return TextUtils.safeIntern(PackageParser.buildCompoundName(pkg, procSeq, "process", outError));
    }

    private static String buildTaskAffinityName(String pkg, String defProc, CharSequence procSeq, String[] outError) {
        if (procSeq == null) {
            return defProc;
        }
        if (procSeq.length() <= 0) {
            return null;
        }
        return PackageParser.buildCompoundName(pkg, procSeq, "taskAffinity", outError);
    }

    private boolean parseKeySets(Package owner, Resources res, XmlResourceParser parser, String[] outError) throws XmlPullParserException, IOException {
        int type;
        int outerDepth = parser.getDepth();
        int currentKeySetDepth = -1;
        String currentKeySet = null;
        ArrayMap<String, PublicKey> publicKeys = new ArrayMap<String, PublicKey>();
        ArraySet<String> upgradeKeySets = new ArraySet<String>();
        ArrayMap definedKeySets = new ArrayMap();
        ArraySet<String> improperKeySets = new ArraySet<String>();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            TypedArray sa;
            if (type == 3) {
                if (parser.getDepth() != currentKeySetDepth) continue;
                currentKeySet = null;
                currentKeySetDepth = -1;
                continue;
            }
            String tagName = parser.getName();
            if (tagName.equals("key-set")) {
                if (currentKeySet != null) {
                    outError[0] = "Improperly nested 'key-set' tag at " + parser.getPositionDescription();
                    this.mParseError = -108;
                    return false;
                }
                sa = res.obtainAttributes(parser, R.styleable.AndroidManifestKeySet);
                String keysetName = sa.getNonResourceString(0);
                definedKeySets.put(keysetName, new ArraySet());
                currentKeySet = keysetName;
                currentKeySetDepth = parser.getDepth();
                sa.recycle();
                continue;
            }
            if (tagName.equals("public-key")) {
                if (currentKeySet == null) {
                    outError[0] = "Improperly nested 'key-set' tag at " + parser.getPositionDescription();
                    this.mParseError = -108;
                    return false;
                }
                sa = res.obtainAttributes(parser, R.styleable.AndroidManifestPublicKey);
                String publicKeyName = sa.getNonResourceString(0);
                String encodedKey = sa.getNonResourceString(1);
                if (encodedKey == null && publicKeys.get(publicKeyName) == null) {
                    outError[0] = "'public-key' " + publicKeyName + " must define a public-key value on first use at " + parser.getPositionDescription();
                    this.mParseError = -108;
                    sa.recycle();
                    return false;
                }
                if (encodedKey != null) {
                    PublicKey currentKey = PackageParser.parsePublicKey(encodedKey);
                    if (currentKey == null) {
                        Slog.w(TAG, "No recognized valid key in 'public-key' tag at " + parser.getPositionDescription() + " key-set " + currentKeySet + " will not be added to the package's defined key-sets.");
                        sa.recycle();
                        improperKeySets.add(currentKeySet);
                        XmlUtils.skipCurrentTag(parser);
                        continue;
                    }
                    if (publicKeys.get(publicKeyName) == null || ((PublicKey)publicKeys.get(publicKeyName)).equals(currentKey)) {
                        publicKeys.put(publicKeyName, currentKey);
                    } else {
                        outError[0] = "Value of 'public-key' " + publicKeyName + " conflicts with previously defined value at " + parser.getPositionDescription();
                        this.mParseError = -108;
                        sa.recycle();
                        return false;
                    }
                }
                ((ArraySet)definedKeySets.get(currentKeySet)).add(publicKeyName);
                sa.recycle();
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals("upgrade-key-set")) {
                sa = res.obtainAttributes(parser, R.styleable.AndroidManifestUpgradeKeySet);
                String name = sa.getNonResourceString(0);
                upgradeKeySets.add(name);
                sa.recycle();
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            Slog.w(TAG, "Unknown element under <key-sets>: " + parser.getName() + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
            XmlUtils.skipCurrentTag(parser);
        }
        Set publicKeyNames = publicKeys.keySet();
        if (publicKeyNames.removeAll(definedKeySets.keySet())) {
            outError[0] = "Package" + owner.packageName + " AndroidManifext.xml 'key-set' and 'public-key' names must be distinct.";
            this.mParseError = -108;
            return false;
        }
        owner.mKeySetMapping = new ArrayMap();
        for (Map.Entry e : definedKeySets.entrySet()) {
            String keySetName = (String)e.getKey();
            if (((ArraySet)e.getValue()).size() == 0) {
                Slog.w(TAG, "Package" + owner.packageName + " AndroidManifext.xml 'key-set' " + keySetName + " has no valid associated 'public-key'. Not including in package's defined key-sets.");
                continue;
            }
            if (improperKeySets.contains(keySetName)) {
                Slog.w(TAG, "Package" + owner.packageName + " AndroidManifext.xml 'key-set' " + keySetName + " contained improper 'public-key' tags. Not including in package's defined key-sets.");
                continue;
            }
            owner.mKeySetMapping.put(keySetName, new ArraySet());
            for (String s : (ArraySet)e.getValue()) {
                owner.mKeySetMapping.get(keySetName).add((PublicKey)publicKeys.get(s));
            }
        }
        if (!owner.mKeySetMapping.keySet().containsAll(upgradeKeySets)) {
            outError[0] = "Package" + owner.packageName + " AndroidManifext.xml does not define all 'upgrade-key-set's .";
            this.mParseError = -108;
            return false;
        }
        owner.mUpgradeKeySets = upgradeKeySets;
        return true;
    }

    private boolean parsePermissionGroup(Package owner, int flags, Resources res, XmlResourceParser parser, String[] outError) throws XmlPullParserException, IOException {
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestPermissionGroup);
        int requestDetailResourceId = sa.getResourceId(12, 0);
        int backgroundRequestResourceId = sa.getResourceId(9, 0);
        int backgroundRequestDetailResourceId = sa.getResourceId(10, 0);
        PermissionGroup perm = new PermissionGroup(owner, requestDetailResourceId, backgroundRequestResourceId, backgroundRequestDetailResourceId);
        if (!PackageParser.parsePackageItemInfo(owner, perm.info, outError, "<permission-group>", sa, true, 2, 0, 1, 8, 5, 7)) {
            sa.recycle();
            this.mParseError = -108;
            return false;
        }
        perm.info.descriptionRes = sa.getResourceId(4, 0);
        perm.info.requestRes = sa.getResourceId(11, 0);
        perm.info.flags = sa.getInt(6, 0);
        perm.info.priority = sa.getInt(3, 0);
        sa.recycle();
        if (!this.parseAllMetaData(res, parser, "<permission-group>", perm, outError)) {
            this.mParseError = -108;
            return false;
        }
        owner.permissionGroups.add(perm);
        return true;
    }

    private boolean parsePermission(Package owner, Resources res, XmlResourceParser parser, String[] outError) throws XmlPullParserException, IOException {
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestPermission);
        String backgroundPermission = null;
        if (sa.hasValue(10)) {
            if ("android".equals(owner.packageName)) {
                backgroundPermission = sa.getNonResourceString(10);
            } else {
                Slog.w(TAG, owner.packageName + " defines a background permission. Only the 'android' package can do that.");
            }
        }
        Permission perm = new Permission(owner, backgroundPermission);
        if (!PackageParser.parsePackageItemInfo(owner, perm.info, outError, "<permission>", sa, true, 2, 0, 1, 9, 6, 8)) {
            sa.recycle();
            this.mParseError = -108;
            return false;
        }
        perm.info.group = sa.getNonResourceString(4);
        if (perm.info.group != null) {
            perm.info.group = perm.info.group.intern();
        }
        perm.info.descriptionRes = sa.getResourceId(5, 0);
        perm.info.requestRes = sa.getResourceId(11, 0);
        perm.info.protectionLevel = sa.getInt(3, 0);
        perm.info.flags = sa.getInt(7, 0);
        if (!perm.info.isRuntime() || !"android".equals(perm.info.packageName)) {
            perm.info.flags &= 0xFFFFFFFB;
            perm.info.flags &= 0xFFFFFFF7;
        } else if ((perm.info.flags & 4) != 0 && (perm.info.flags & 8) != 0) {
            throw new IllegalStateException("Permission cannot be both soft and hard restricted: " + perm.info.name);
        }
        sa.recycle();
        if (perm.info.protectionLevel == -1) {
            outError[0] = "<permission> does not specify protectionLevel";
            this.mParseError = -108;
            return false;
        }
        perm.info.protectionLevel = PermissionInfo.fixProtectionLevel(perm.info.protectionLevel);
        if (perm.info.getProtectionFlags() != 0 && (perm.info.protectionLevel & 0x1000) == 0 && (perm.info.protectionLevel & 0x2000) == 0 && (perm.info.protectionLevel & 0xF) != 2) {
            outError[0] = "<permission>  protectionLevel specifies a non-instant flag but is not based on signature type";
            this.mParseError = -108;
            return false;
        }
        if (!this.parseAllMetaData(res, parser, "<permission>", perm, outError)) {
            this.mParseError = -108;
            return false;
        }
        owner.permissions.add(perm);
        return true;
    }

    private boolean parsePermissionTree(Package owner, Resources res, XmlResourceParser parser, String[] outError) throws XmlPullParserException, IOException {
        Permission perm = new Permission(owner, (String)null);
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestPermissionTree);
        if (!PackageParser.parsePackageItemInfo(owner, perm.info, outError, "<permission-tree>", sa, true, 2, 0, 1, 5, 3, 4)) {
            sa.recycle();
            this.mParseError = -108;
            return false;
        }
        sa.recycle();
        int index = perm.info.name.indexOf(46);
        if (index > 0) {
            index = perm.info.name.indexOf(46, index + 1);
        }
        if (index < 0) {
            outError[0] = "<permission-tree> name has less than three segments: " + perm.info.name;
            this.mParseError = -108;
            return false;
        }
        perm.info.descriptionRes = 0;
        perm.info.requestRes = 0;
        perm.info.protectionLevel = 0;
        perm.tree = true;
        if (!this.parseAllMetaData(res, parser, "<permission-tree>", perm, outError)) {
            this.mParseError = -108;
            return false;
        }
        owner.permissions.add(perm);
        return true;
    }

    private Instrumentation parseInstrumentation(Package owner, Resources res, XmlResourceParser parser, String[] outError) throws XmlPullParserException, IOException {
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestInstrumentation);
        if (this.mParseInstrumentationArgs == null) {
            this.mParseInstrumentationArgs = new ParsePackageItemArgs(owner, outError, 2, 0, 1, 8, 6, 7);
            this.mParseInstrumentationArgs.tag = "<instrumentation>";
        }
        this.mParseInstrumentationArgs.sa = sa;
        Instrumentation a = new Instrumentation(this.mParseInstrumentationArgs, new InstrumentationInfo());
        if (outError[0] != null) {
            sa.recycle();
            this.mParseError = -108;
            return null;
        }
        String str = sa.getNonResourceString(3);
        a.info.targetPackage = str != null ? str.intern() : null;
        str = sa.getNonResourceString(9);
        a.info.targetProcesses = str != null ? str.intern() : null;
        a.info.handleProfiling = sa.getBoolean(4, false);
        a.info.functionalTest = sa.getBoolean(5, false);
        sa.recycle();
        if (a.info.targetPackage == null) {
            outError[0] = "<instrumentation> does not specify targetPackage";
            this.mParseError = -108;
            return null;
        }
        if (!this.parseAllMetaData(res, parser, "<instrumentation>", a, outError)) {
            this.mParseError = -108;
            return null;
        }
        owner.instrumentation.add(a);
        return a;
    }

    @UnsupportedAppUsage
    private boolean parseBaseApplication(Package owner, Resources res, XmlResourceParser parser, int flags, String[] outError) throws XmlPullParserException, IOException {
        int type;
        String requiredAccountType;
        String restrictedAccountType;
        String requiredFeature;
        boolean allowBackup;
        String manageSpaceActivity;
        ApplicationInfo ai = owner.applicationInfo;
        String pkgName = owner.applicationInfo.packageName;
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestApplication);
        ai.iconRes = sa.getResourceId(2, 0);
        ai.roundIconRes = sa.getResourceId(42, 0);
        if (!PackageParser.parsePackageItemInfo(owner, ai, outError, "<application>", sa, false, 3, 1, 2, 42, 22, 30)) {
            sa.recycle();
            this.mParseError = -108;
            return false;
        }
        if (ai.name != null) {
            ai.className = ai.name;
        }
        if ((manageSpaceActivity = sa.getNonConfigurationString(4, 1024)) != null) {
            ai.manageSpaceActivityName = PackageParser.buildClassName(pkgName, manageSpaceActivity, outError);
        }
        if (allowBackup = sa.getBoolean(17, true)) {
            TypedValue v;
            ai.flags |= 0x8000;
            String backupAgent = sa.getNonConfigurationString(16, 1024);
            if (backupAgent != null) {
                ai.backupAgentName = PackageParser.buildClassName(pkgName, backupAgent, outError);
                if (sa.getBoolean(18, true)) {
                    ai.flags |= 0x10000;
                }
                if (sa.getBoolean(21, false)) {
                    ai.flags |= 0x20000;
                }
                if (sa.getBoolean(32, false)) {
                    ai.flags |= 0x4000000;
                }
                if (sa.getBoolean(40, false)) {
                    ai.privateFlags |= 0x2000;
                }
            }
            if ((v = sa.peekValue(35)) != null && (ai.fullBackupContent = v.resourceId) == 0) {
                ai.fullBackupContent = v.data == 0 ? -1 : 0;
            }
        }
        ai.theme = sa.getResourceId(0, 0);
        ai.descriptionRes = sa.getResourceId(13, 0);
        if (sa.getBoolean(8, false) && ((requiredFeature = sa.getNonResourceString(45)) == null || this.mCallback.hasFeature(requiredFeature))) {
            ai.flags |= 8;
        }
        if (sa.getBoolean(27, false)) {
            owner.mRequiredForAllUsers = true;
        }
        if ((restrictedAccountType = sa.getString(28)) != null && restrictedAccountType.length() > 0) {
            owner.mRestrictedAccountType = restrictedAccountType;
        }
        if ((requiredAccountType = sa.getString(29)) != null && requiredAccountType.length() > 0) {
            owner.mRequiredAccountType = requiredAccountType;
        }
        if (sa.getBoolean(10, false)) {
            ai.flags |= 2;
            ai.privateFlags |= 0x800000;
        }
        if (sa.getBoolean(20, false)) {
            ai.flags |= 0x4000;
        }
        owner.baseHardwareAccelerated = sa.getBoolean(23, owner.applicationInfo.targetSdkVersion >= 14);
        if (owner.baseHardwareAccelerated) {
            ai.flags |= 0x20000000;
        }
        if (sa.getBoolean(7, true)) {
            ai.flags |= 4;
        }
        if (sa.getBoolean(14, false)) {
            ai.flags |= 0x20;
        }
        if (sa.getBoolean(5, true)) {
            ai.flags |= 0x40;
        }
        if (owner.parentPackage == null && sa.getBoolean(15, false)) {
            ai.flags |= 0x100;
        }
        if (sa.getBoolean(24, false)) {
            ai.flags |= 0x100000;
        }
        if (sa.getBoolean(36, owner.applicationInfo.targetSdkVersion < 28)) {
            ai.flags |= 0x8000000;
        }
        if (sa.getBoolean(26, false)) {
            ai.flags |= 0x400000;
        }
        if (sa.getBoolean(33, false)) {
            ai.flags |= Integer.MIN_VALUE;
        }
        if (sa.getBoolean(34, true)) {
            ai.flags |= 0x10000000;
        }
        if (sa.getBoolean(53, false)) {
            ai.privateFlags |= 0x2000000;
        }
        if (sa.getBoolean(38, false)) {
            ai.privateFlags |= 0x20;
        }
        if (sa.getBoolean(39, false)) {
            ai.privateFlags |= 0x40;
        }
        if (sa.hasValueOrEmpty(37)) {
            ai.privateFlags = sa.getBoolean(37, true) ? (ai.privateFlags |= 0x400) : (ai.privateFlags |= 0x800);
        } else if (owner.applicationInfo.targetSdkVersion >= 24) {
            ai.privateFlags |= 0x1000;
        }
        if (sa.getBoolean(54, true)) {
            ai.privateFlags |= 0x4000000;
        }
        if (sa.getBoolean(55, owner.applicationInfo.targetSdkVersion >= 29)) {
            ai.privateFlags |= 0x8000000;
        }
        if (sa.getBoolean(56, owner.applicationInfo.targetSdkVersion < 29)) {
            ai.privateFlags |= 0x20000000;
        }
        ai.maxAspectRatio = sa.getFloat(44, 0.0f);
        ai.minAspectRatio = sa.getFloat(51, 0.0f);
        ai.networkSecurityConfigRes = sa.getResourceId(41, 0);
        ai.category = sa.getInt(43, -1);
        String str = sa.getNonConfigurationString(6, 0);
        ai.permission = str != null && str.length() > 0 ? str.intern() : null;
        str = owner.applicationInfo.targetSdkVersion >= 8 ? sa.getNonConfigurationString(12, 1024) : sa.getNonResourceString(12);
        ai.taskAffinity = PackageParser.buildTaskAffinityName(ai.packageName, ai.packageName, str, outError);
        String factory = sa.getNonResourceString(48);
        if (factory != null) {
            ai.appComponentFactory = PackageParser.buildClassName(ai.packageName, factory, outError);
        }
        if (sa.getBoolean(49, false)) {
            ai.privateFlags |= 0x400000;
        }
        if (sa.getBoolean(50, false)) {
            ai.privateFlags |= 0x1000000;
        }
        if (outError[0] == null) {
            String pname = owner.applicationInfo.targetSdkVersion >= 8 ? sa.getNonConfigurationString(11, 1024) : sa.getNonResourceString(11);
            ai.processName = PackageParser.buildProcessName(ai.packageName, null, pname, flags, this.mSeparateProcesses, outError);
            ai.enabled = sa.getBoolean(9, true);
            if (sa.getBoolean(31, false)) {
                ai.flags |= 0x2000000;
            }
            if (sa.getBoolean(47, false)) {
                ai.privateFlags |= 2;
                if (ai.processName != null && !ai.processName.equals(ai.packageName)) {
                    outError[0] = "cantSaveState applications can not use custom processes";
                }
            }
        }
        ai.uiOptions = sa.getInt(25, 0);
        ai.classLoaderName = sa.getString(46);
        if (ai.classLoaderName != null && !ClassLoaderFactory.isValidClassLoaderName(ai.classLoaderName)) {
            outError[0] = "Invalid class loader name: " + ai.classLoaderName;
        }
        ai.zygotePreloadName = sa.getString(52);
        sa.recycle();
        if (outError[0] != null) {
            this.mParseError = -108;
            return false;
        }
        int innerDepth = parser.getDepth();
        CachedComponentArgs cachedArgs = new CachedComponentArgs();
        boolean hasActivityOrder = false;
        boolean hasReceiverOrder = false;
        boolean hasServiceOrder = false;
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > innerDepth)) {
            String lname;
            Activity a;
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if (tagName.equals("activity")) {
                a = this.parseActivity(owner, res, parser, flags, outError, cachedArgs, false, owner.baseHardwareAccelerated);
                if (a == null) {
                    this.mParseError = -108;
                    return false;
                }
                hasActivityOrder |= a.order != 0;
                owner.activities.add(a);
                continue;
            }
            if (tagName.equals("receiver")) {
                a = this.parseActivity(owner, res, parser, flags, outError, cachedArgs, true, false);
                if (a == null) {
                    this.mParseError = -108;
                    return false;
                }
                hasReceiverOrder |= a.order != 0;
                owner.receivers.add(a);
                continue;
            }
            if (tagName.equals("service")) {
                Service s = this.parseService(owner, res, parser, flags, outError, cachedArgs);
                if (s == null) {
                    this.mParseError = -108;
                    return false;
                }
                hasServiceOrder |= s.order != 0;
                owner.services.add(s);
                continue;
            }
            if (tagName.equals("provider")) {
                Provider p = this.parseProvider(owner, res, parser, flags, outError, cachedArgs);
                if (p == null) {
                    this.mParseError = -108;
                    return false;
                }
                owner.providers.add(p);
                continue;
            }
            if (tagName.equals("activity-alias")) {
                a = this.parseActivityAlias(owner, res, parser, flags, outError, cachedArgs);
                if (a == null) {
                    this.mParseError = -108;
                    return false;
                }
                hasActivityOrder |= a.order != 0;
                owner.activities.add(a);
                continue;
            }
            if (parser.getName().equals("meta-data")) {
                owner.mAppMetaData = this.parseMetaData(res, parser, owner.mAppMetaData, outError);
                if (owner.mAppMetaData != null) continue;
                this.mParseError = -108;
                return false;
            }
            if (tagName.equals("static-library")) {
                sa = res.obtainAttributes(parser, R.styleable.AndroidManifestStaticLibrary);
                lname = sa.getNonResourceString(0);
                int version = sa.getInt(1, -1);
                int versionMajor = sa.getInt(2, 0);
                sa.recycle();
                if (lname == null || version < 0) {
                    outError[0] = "Bad static-library declaration name: " + lname + " version: " + version;
                    this.mParseError = -108;
                    XmlUtils.skipCurrentTag(parser);
                    return false;
                }
                if (owner.mSharedUserId != null) {
                    outError[0] = "sharedUserId not allowed in static shared library";
                    this.mParseError = -107;
                    XmlUtils.skipCurrentTag(parser);
                    return false;
                }
                if (owner.staticSharedLibName != null) {
                    outError[0] = "Multiple static-shared libs for package " + pkgName;
                    this.mParseError = -108;
                    XmlUtils.skipCurrentTag(parser);
                    return false;
                }
                owner.staticSharedLibName = lname.intern();
                owner.staticSharedLibVersion = version >= 0 ? PackageInfo.composeLongVersionCode(versionMajor, version) : (long)version;
                ai.privateFlags |= 0x4000;
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals("library")) {
                sa = res.obtainAttributes(parser, R.styleable.AndroidManifestLibrary);
                lname = sa.getNonResourceString(0);
                sa.recycle();
                if (lname != null && !ArrayUtils.contains(owner.libraryNames, lname = lname.intern())) {
                    owner.libraryNames = ArrayUtils.add(owner.libraryNames, lname);
                }
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals("uses-static-library")) {
                if (this.parseUsesStaticLibrary(owner, res, parser, outError)) continue;
                return false;
            }
            if (tagName.equals("uses-library")) {
                sa = res.obtainAttributes(parser, R.styleable.AndroidManifestUsesLibrary);
                lname = sa.getNonResourceString(0);
                boolean req = sa.getBoolean(1, true);
                sa.recycle();
                if (lname != null) {
                    lname = lname.intern();
                    if (req) {
                        owner.usesLibraries = ArrayUtils.add(owner.usesLibraries, lname);
                    } else {
                        owner.usesOptionalLibraries = ArrayUtils.add(owner.usesOptionalLibraries, lname);
                    }
                }
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals("uses-package")) {
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals("profileable")) {
                sa = res.obtainAttributes(parser, R.styleable.AndroidManifestProfileable);
                if (sa.getBoolean(0, false)) {
                    ai.privateFlags |= 0x800000;
                }
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            Slog.w(TAG, "Unknown element under <application>: " + tagName + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
            XmlUtils.skipCurrentTag(parser);
        }
        if (TextUtils.isEmpty(owner.staticSharedLibName)) {
            Activity a = this.generateAppDetailsHiddenActivity(owner, flags, outError, owner.baseHardwareAccelerated);
            owner.activities.add(a);
        }
        if (hasActivityOrder) {
            Collections.sort(owner.activities, (a1, a2) -> Integer.compare(a2.order, a1.order));
        }
        if (hasReceiverOrder) {
            Collections.sort(owner.receivers, (r1, r2) -> Integer.compare(r2.order, r1.order));
        }
        if (hasServiceOrder) {
            Collections.sort(owner.services, (s1, s2) -> Integer.compare(s2.order, s1.order));
        }
        this.setMaxAspectRatio(owner);
        this.setMinAspectRatio(owner);
        owner.applicationInfo.privateFlags = PackageParser.hasDomainURLs(owner) ? (owner.applicationInfo.privateFlags |= 0x10) : (owner.applicationInfo.privateFlags &= 0xFFFFFFEF);
        return true;
    }

    private static boolean hasDomainURLs(Package pkg) {
        if (pkg == null || pkg.activities == null) {
            return false;
        }
        ArrayList<Activity> activities = pkg.activities;
        int countActivities = activities.size();
        for (int n = 0; n < countActivities; ++n) {
            Activity activity = activities.get(n);
            ArrayList filters = activity.intents;
            if (filters == null) continue;
            int countFilters = filters.size();
            for (int m = 0; m < countFilters; ++m) {
                ActivityIntentInfo aii = (ActivityIntentInfo)filters.get(m);
                if (!aii.hasAction("android.intent.action.VIEW") || !aii.hasAction("android.intent.action.VIEW") || !aii.hasDataScheme("http") && !aii.hasDataScheme("https")) continue;
                return true;
            }
        }
        return false;
    }

    private boolean parseSplitApplication(Package owner, Resources res, XmlResourceParser parser, int flags, int splitIndex, String[] outError) throws XmlPullParserException, IOException {
        int type;
        String classLoaderName;
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestApplication);
        if (sa.getBoolean(7, true)) {
            int n = splitIndex;
            owner.splitFlags[n] = owner.splitFlags[n] | 4;
        }
        if ((classLoaderName = sa.getString(46)) != null && !ClassLoaderFactory.isValidClassLoaderName(classLoaderName)) {
            outError[0] = "Invalid class loader name: " + classLoaderName;
            this.mParseError = -108;
            return false;
        }
        owner.applicationInfo.splitClassLoaderNames[splitIndex] = classLoaderName;
        int innerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > innerDepth)) {
            Activity a;
            if (type == 3 || type == 4) continue;
            ComponentInfo parsedComponent = null;
            CachedComponentArgs cachedArgs = new CachedComponentArgs();
            String tagName = parser.getName();
            if (tagName.equals("activity")) {
                a = this.parseActivity(owner, res, parser, flags, outError, cachedArgs, false, owner.baseHardwareAccelerated);
                if (a == null) {
                    this.mParseError = -108;
                    return false;
                }
                owner.activities.add(a);
                parsedComponent = a.info;
            } else if (tagName.equals("receiver")) {
                a = this.parseActivity(owner, res, parser, flags, outError, cachedArgs, true, false);
                if (a == null) {
                    this.mParseError = -108;
                    return false;
                }
                owner.receivers.add(a);
                parsedComponent = a.info;
            } else if (tagName.equals("service")) {
                Service s = this.parseService(owner, res, parser, flags, outError, cachedArgs);
                if (s == null) {
                    this.mParseError = -108;
                    return false;
                }
                owner.services.add(s);
                parsedComponent = s.info;
            } else if (tagName.equals("provider")) {
                Provider p = this.parseProvider(owner, res, parser, flags, outError, cachedArgs);
                if (p == null) {
                    this.mParseError = -108;
                    return false;
                }
                owner.providers.add(p);
                parsedComponent = p.info;
            } else if (tagName.equals("activity-alias")) {
                a = this.parseActivityAlias(owner, res, parser, flags, outError, cachedArgs);
                if (a == null) {
                    this.mParseError = -108;
                    return false;
                }
                owner.activities.add(a);
                parsedComponent = a.info;
            } else if (parser.getName().equals("meta-data")) {
                owner.mAppMetaData = this.parseMetaData(res, parser, owner.mAppMetaData, outError);
                if (owner.mAppMetaData == null) {
                    this.mParseError = -108;
                    return false;
                }
            } else if (tagName.equals("uses-static-library")) {
                if (!this.parseUsesStaticLibrary(owner, res, parser, outError)) {
                    return false;
                }
            } else if (tagName.equals("uses-library")) {
                sa = res.obtainAttributes(parser, R.styleable.AndroidManifestUsesLibrary);
                String lname = sa.getNonResourceString(0);
                boolean req = sa.getBoolean(1, true);
                sa.recycle();
                if (lname != null) {
                    lname = lname.intern();
                    if (req) {
                        owner.usesLibraries = ArrayUtils.add(owner.usesLibraries, lname);
                        owner.usesOptionalLibraries = ArrayUtils.remove(owner.usesOptionalLibraries, lname);
                    } else if (!ArrayUtils.contains(owner.usesLibraries, lname)) {
                        owner.usesOptionalLibraries = ArrayUtils.add(owner.usesOptionalLibraries, lname);
                    }
                }
                XmlUtils.skipCurrentTag(parser);
            } else if (tagName.equals("uses-package")) {
                XmlUtils.skipCurrentTag(parser);
            } else {
                Slog.w(TAG, "Unknown element under <application>: " + tagName + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (parsedComponent == null || parsedComponent.splitName != null) continue;
            parsedComponent.splitName = owner.splitNames[splitIndex];
        }
        return true;
    }

    private static boolean parsePackageItemInfo(Package owner, PackageItemInfo outInfo, String[] outError, String tag, TypedArray sa, boolean nameRequired, int nameRes, int labelRes, int iconRes, int roundIconRes, int logoRes, int bannerRes) {
        TypedValue v;
        int bannerVal;
        int roundIconVal;
        if (sa == null) {
            outError[0] = tag + " does not contain any attributes";
            return false;
        }
        String name = sa.getNonConfigurationString(nameRes, 0);
        if (name == null) {
            if (nameRequired) {
                outError[0] = tag + " does not specify android:name";
                return false;
            }
        } else {
            String outInfoName = PackageParser.buildClassName(owner.applicationInfo.packageName, name, outError);
            if (PackageManager.APP_DETAILS_ACTIVITY_CLASS_NAME.equals(outInfoName)) {
                outError[0] = tag + " invalid android:name";
                return false;
            }
            outInfo.name = outInfoName;
            if (outInfoName == null) {
                return false;
            }
        }
        int n = roundIconVal = sUseRoundIcon ? sa.getResourceId(roundIconRes, 0) : 0;
        if (roundIconVal != 0) {
            outInfo.icon = roundIconVal;
            outInfo.nonLocalizedLabel = null;
        } else {
            int iconVal = sa.getResourceId(iconRes, 0);
            if (iconVal != 0) {
                outInfo.icon = iconVal;
                outInfo.nonLocalizedLabel = null;
            }
        }
        int logoVal = sa.getResourceId(logoRes, 0);
        if (logoVal != 0) {
            outInfo.logo = logoVal;
        }
        if ((bannerVal = sa.getResourceId(bannerRes, 0)) != 0) {
            outInfo.banner = bannerVal;
        }
        if ((v = sa.peekValue(labelRes)) != null && (outInfo.labelRes = v.resourceId) == 0) {
            outInfo.nonLocalizedLabel = v.coerceToString();
        }
        outInfo.packageName = owner.packageName;
        return true;
    }

    private Activity generateAppDetailsHiddenActivity(Package owner, int flags, String[] outError, boolean hardwareAccelerated) {
        Activity a = new Activity(owner, PackageManager.APP_DETAILS_ACTIVITY_CLASS_NAME, new ActivityInfo());
        a.owner = owner;
        a.setPackageName(owner.packageName);
        a.info.theme = 16973909;
        a.info.exported = true;
        a.info.name = PackageManager.APP_DETAILS_ACTIVITY_CLASS_NAME;
        a.info.processName = owner.applicationInfo.processName;
        a.info.uiOptions = a.info.applicationInfo.uiOptions;
        a.info.taskAffinity = PackageParser.buildTaskAffinityName(owner.packageName, owner.packageName, ":app_details", outError);
        a.info.enabled = true;
        a.info.launchMode = 0;
        a.info.documentLaunchMode = 0;
        a.info.maxRecents = ActivityTaskManager.getDefaultAppRecentsLimitStatic();
        a.info.configChanges = PackageParser.getActivityConfigChanges(0, 0);
        a.info.softInputMode = 0;
        a.info.persistableMode = 1;
        a.info.screenOrientation = -1;
        a.info.resizeMode = 4;
        a.info.lockTaskLaunchMode = 0;
        a.info.directBootAware = false;
        a.info.encryptionAware = false;
        a.info.rotationAnimation = -1;
        a.info.colorMode = 0;
        if (hardwareAccelerated) {
            a.info.flags |= 0x200;
        }
        return a;
    }

    private Activity parseActivity(Package owner, Resources res, XmlResourceParser parser, int flags, String[] outError, CachedComponentArgs cachedArgs, boolean receiver, boolean hardwareAccelerated) throws XmlPullParserException, IOException {
        int type;
        boolean visibleToEphemeral;
        String str;
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestActivity);
        if (cachedArgs.mActivityArgs == null) {
            cachedArgs.mActivityArgs = new ParseComponentArgs(owner, outError, 3, 1, 2, 44, 23, 30, this.mSeparateProcesses, 7, 17, 5);
        }
        cachedArgs.mActivityArgs.tag = receiver ? "<receiver>" : "<activity>";
        cachedArgs.mActivityArgs.sa = sa;
        cachedArgs.mActivityArgs.flags = flags;
        Activity a = new Activity(cachedArgs.mActivityArgs, new ActivityInfo());
        if (outError[0] != null) {
            sa.recycle();
            return null;
        }
        boolean setExported = sa.hasValue(6);
        if (setExported) {
            a.info.exported = sa.getBoolean(6, false);
        }
        a.info.theme = sa.getResourceId(0, 0);
        a.info.uiOptions = sa.getInt(26, a.info.applicationInfo.uiOptions);
        String parentName = sa.getNonConfigurationString(27, 1024);
        if (parentName != null) {
            String parentClassName = PackageParser.buildClassName(a.info.packageName, parentName, outError);
            if (outError[0] == null) {
                a.info.parentActivityName = parentClassName;
            } else {
                Log.e(TAG, "Activity " + a.info.name + " specified invalid parentActivityName " + parentName);
                outError[0] = null;
            }
        }
        a.info.permission = (str = sa.getNonConfigurationString(4, 0)) == null ? owner.applicationInfo.permission : (str.length() > 0 ? str.toString().intern() : null);
        str = sa.getNonConfigurationString(8, 1024);
        a.info.taskAffinity = PackageParser.buildTaskAffinityName(owner.applicationInfo.packageName, owner.applicationInfo.taskAffinity, str, outError);
        a.info.splitName = sa.getNonConfigurationString(48, 0);
        a.info.flags = 0;
        if (sa.getBoolean(9, false)) {
            a.info.flags |= 1;
        }
        if (sa.getBoolean(10, false)) {
            a.info.flags |= 2;
        }
        if (sa.getBoolean(11, false)) {
            a.info.flags |= 4;
        }
        if (sa.getBoolean(21, false)) {
            a.info.flags |= 0x80;
        }
        if (sa.getBoolean(18, false)) {
            a.info.flags |= 8;
        }
        if (sa.getBoolean(12, false)) {
            a.info.flags |= 0x10;
        }
        if (sa.getBoolean(13, false)) {
            a.info.flags |= 0x20;
        }
        if (sa.getBoolean(19, (owner.applicationInfo.flags & 0x20) != 0)) {
            a.info.flags |= 0x40;
        }
        if (sa.getBoolean(22, false)) {
            a.info.flags |= 0x100;
        }
        if (sa.getBoolean(29, false) || sa.getBoolean(39, false)) {
            a.info.flags |= 0x400;
        }
        if (sa.getBoolean(24, false)) {
            a.info.flags |= 0x800;
        }
        if (sa.getBoolean(56, false)) {
            a.info.flags |= 0x20000000;
        }
        if (!receiver) {
            if (sa.getBoolean(25, hardwareAccelerated)) {
                a.info.flags |= 0x200;
            }
            a.info.launchMode = sa.getInt(14, 0);
            a.info.documentLaunchMode = sa.getInt(33, 0);
            a.info.maxRecents = sa.getInt(34, ActivityTaskManager.getDefaultAppRecentsLimitStatic());
            a.info.configChanges = PackageParser.getActivityConfigChanges(sa.getInt(16, 0), sa.getInt(47, 0));
            a.info.softInputMode = sa.getInt(20, 0);
            a.info.persistableMode = sa.getInteger(32, 0);
            if (sa.getBoolean(31, false)) {
                a.info.flags |= Integer.MIN_VALUE;
            }
            if (sa.getBoolean(35, false)) {
                a.info.flags |= 0x2000;
            }
            if (sa.getBoolean(36, false)) {
                a.info.flags |= 0x1000;
            }
            if (sa.getBoolean(37, false)) {
                a.info.flags |= 0x4000;
            }
            a.info.screenOrientation = sa.getInt(15, -1);
            this.setActivityResizeMode(a.info, sa, owner);
            if (sa.getBoolean(41, false)) {
                a.info.flags |= 0x400000;
            }
            if (sa.getBoolean(55, false)) {
                a.info.flags |= 0x40000;
            }
            if (sa.hasValue(50) && sa.getType(50) == 4) {
                a.setMaxAspectRatio(sa.getFloat(50, 0.0f));
            }
            if (sa.hasValue(53) && sa.getType(53) == 4) {
                a.setMinAspectRatio(sa.getFloat(53, 0.0f));
            }
            a.info.lockTaskLaunchMode = sa.getInt(38, 0);
            a.info.encryptionAware = a.info.directBootAware = sa.getBoolean(42, false);
            a.info.requestedVrComponent = sa.getString(43);
            a.info.rotationAnimation = sa.getInt(46, -1);
            a.info.colorMode = sa.getInt(49, 0);
            if (sa.getBoolean(51, false)) {
                a.info.flags |= 0x800000;
            }
            if (sa.getBoolean(52, false)) {
                a.info.flags |= 0x1000000;
            }
            if (sa.getBoolean(54, false)) {
                a.info.privateFlags |= 1;
            }
        } else {
            a.info.launchMode = 0;
            a.info.configChanges = 0;
            if (sa.getBoolean(28, false)) {
                a.info.flags |= 0x40000000;
            }
            a.info.encryptionAware = a.info.directBootAware = sa.getBoolean(42, false);
        }
        if (a.info.directBootAware) {
            owner.applicationInfo.privateFlags |= 0x100;
        }
        if (visibleToEphemeral = sa.getBoolean(45, false)) {
            a.info.flags |= 0x100000;
            owner.visibleToInstantApps = true;
        }
        sa.recycle();
        if (receiver && (owner.applicationInfo.privateFlags & 2) != 0 && a.info.processName == owner.packageName) {
            outError[0] = "Heavy-weight applications can not have receivers in main process";
        }
        if (outError[0] != null) {
            return null;
        }
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            int visibility;
            ActivityIntentInfo intent;
            if (type == 3 || type == 4) continue;
            if (parser.getName().equals("intent-filter")) {
                intent = new ActivityIntentInfo(a);
                if (!this.parseIntent(res, parser, true, true, intent, outError)) {
                    return null;
                }
                if (intent.countActions() == 0) {
                    Slog.w(TAG, "No actions in intent filter at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
                } else {
                    a.order = Math.max(intent.getOrder(), a.order);
                    a.intents.add(intent);
                }
                visibility = visibleToEphemeral ? 1 : (!receiver && this.isImplicitlyExposedIntent(intent) ? 2 : 0);
                intent.setVisibilityToInstantApp(visibility);
                if (intent.isVisibleToInstantApp()) {
                    a.info.flags |= 0x100000;
                }
                if (!intent.isImplicitlyVisibleToInstantApp()) continue;
                a.info.flags |= 0x200000;
                continue;
            }
            if (!receiver && parser.getName().equals("preferred")) {
                intent = new ActivityIntentInfo(a);
                if (!this.parseIntent(res, parser, false, false, intent, outError)) {
                    return null;
                }
                if (intent.countActions() == 0) {
                    Slog.w(TAG, "No actions in preferred at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
                } else {
                    if (owner.preferredActivityFilters == null) {
                        owner.preferredActivityFilters = new ArrayList();
                    }
                    owner.preferredActivityFilters.add(intent);
                }
                visibility = visibleToEphemeral ? 1 : (!receiver && this.isImplicitlyExposedIntent(intent) ? 2 : 0);
                intent.setVisibilityToInstantApp(visibility);
                if (intent.isVisibleToInstantApp()) {
                    a.info.flags |= 0x100000;
                }
                if (!intent.isImplicitlyVisibleToInstantApp()) continue;
                a.info.flags |= 0x200000;
                continue;
            }
            if (parser.getName().equals("meta-data")) {
                a.metaData = this.parseMetaData(res, parser, a.metaData, outError);
                if (a.metaData != null) continue;
                return null;
            }
            if (!receiver && parser.getName().equals("layout")) {
                this.parseLayout(res, parser, a);
                continue;
            }
            Slog.w(TAG, "Problem in package " + this.mArchiveSourcePath + ":");
            if (receiver) {
                Slog.w(TAG, "Unknown element under <receiver>: " + parser.getName() + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
            } else {
                Slog.w(TAG, "Unknown element under <activity>: " + parser.getName() + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
            }
            XmlUtils.skipCurrentTag(parser);
        }
        if (!setExported) {
            a.info.exported = a.intents.size() > 0;
        }
        return a;
    }

    private void setActivityResizeMode(ActivityInfo aInfo, TypedArray sa, Package owner) {
        boolean appExplicitDefault;
        boolean bl = appExplicitDefault = (owner.applicationInfo.privateFlags & 0xC00) != 0;
        if (sa.hasValue(40) || appExplicitDefault) {
            boolean appResizeable = (owner.applicationInfo.privateFlags & 0x400) != 0;
            aInfo.resizeMode = sa.getBoolean(40, appResizeable) ? 2 : 0;
            return;
        }
        if ((owner.applicationInfo.privateFlags & 0x1000) != 0) {
            aInfo.resizeMode = 1;
            return;
        }
        aInfo.resizeMode = aInfo.isFixedOrientationPortrait() ? 6 : (aInfo.isFixedOrientationLandscape() ? 5 : (aInfo.isFixedOrientation() ? 7 : 4));
    }

    private void setMaxAspectRatio(Package owner) {
        float maxAspectRatio;
        float f = maxAspectRatio = owner.applicationInfo.targetSdkVersion < 26 ? 1.86f : 0.0f;
        if (owner.applicationInfo.maxAspectRatio != 0.0f) {
            maxAspectRatio = owner.applicationInfo.maxAspectRatio;
        } else if (owner.mAppMetaData != null && owner.mAppMetaData.containsKey(METADATA_MAX_ASPECT_RATIO)) {
            maxAspectRatio = owner.mAppMetaData.getFloat(METADATA_MAX_ASPECT_RATIO, maxAspectRatio);
        }
        for (Activity activity : owner.activities) {
            if (activity.hasMaxAspectRatio()) continue;
            float activityAspectRatio = activity.metaData != null ? activity.metaData.getFloat(METADATA_MAX_ASPECT_RATIO, maxAspectRatio) : maxAspectRatio;
            activity.setMaxAspectRatio(activityAspectRatio);
        }
    }

    private void setMinAspectRatio(Package owner) {
        float minAspectRatio = owner.applicationInfo.minAspectRatio != 0.0f ? owner.applicationInfo.minAspectRatio : (owner.applicationInfo.targetSdkVersion >= 29 ? 0.0f : (this.mCallback != null && this.mCallback.hasFeature("android.hardware.type.watch") ? 1.0f : 1.333f));
        for (Activity activity : owner.activities) {
            if (activity.hasMinAspectRatio()) continue;
            activity.setMinAspectRatio(minAspectRatio);
        }
    }

    public static int getActivityConfigChanges(int configChanges, int recreateOnConfigChanges) {
        return configChanges | ~recreateOnConfigChanges & 3;
    }

    private void parseLayout(Resources res, AttributeSet attrs, Activity a) {
        TypedArray sw = res.obtainAttributes(attrs, R.styleable.AndroidManifestLayout);
        int width = -1;
        float widthFraction = -1.0f;
        int height = -1;
        float heightFraction = -1.0f;
        int widthType = sw.getType(3);
        if (widthType == 6) {
            widthFraction = sw.getFraction(3, 1, 1, -1.0f);
        } else if (widthType == 5) {
            width = sw.getDimensionPixelSize(3, -1);
        }
        int heightType = sw.getType(4);
        if (heightType == 6) {
            heightFraction = sw.getFraction(4, 1, 1, -1.0f);
        } else if (heightType == 5) {
            height = sw.getDimensionPixelSize(4, -1);
        }
        int gravity = sw.getInt(0, 17);
        int minWidth = sw.getDimensionPixelSize(1, -1);
        int minHeight = sw.getDimensionPixelSize(2, -1);
        sw.recycle();
        a.info.windowLayout = new ActivityInfo.WindowLayout(width, widthFraction, height, heightFraction, gravity, minWidth, minHeight);
    }

    private Activity parseActivityAlias(Package owner, Resources res, XmlResourceParser parser, int flags, String[] outError, CachedComponentArgs cachedArgs) throws XmlPullParserException, IOException {
        int type;
        String parentName;
        String str;
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestActivityAlias);
        String targetActivity = sa.getNonConfigurationString(7, 1024);
        if (targetActivity == null) {
            outError[0] = "<activity-alias> does not specify android:targetActivity";
            sa.recycle();
            return null;
        }
        if ((targetActivity = PackageParser.buildClassName(owner.applicationInfo.packageName, targetActivity, outError)) == null) {
            sa.recycle();
            return null;
        }
        if (cachedArgs.mActivityAliasArgs == null) {
            cachedArgs.mActivityAliasArgs = new ParseComponentArgs(owner, outError, 2, 0, 1, 11, 8, 10, this.mSeparateProcesses, 0, 6, 4);
            cachedArgs.mActivityAliasArgs.tag = "<activity-alias>";
        }
        cachedArgs.mActivityAliasArgs.sa = sa;
        cachedArgs.mActivityAliasArgs.flags = flags;
        Activity target = null;
        int NA = owner.activities.size();
        for (int i = 0; i < NA; ++i) {
            Activity t = owner.activities.get(i);
            if (!targetActivity.equals(t.info.name)) continue;
            target = t;
            break;
        }
        if (target == null) {
            outError[0] = "<activity-alias> target activity " + targetActivity + " not found in manifest";
            sa.recycle();
            return null;
        }
        ActivityInfo info = new ActivityInfo();
        info.targetActivity = targetActivity;
        info.configChanges = target.info.configChanges;
        info.flags = target.info.flags;
        info.privateFlags = target.info.privateFlags;
        info.icon = target.info.icon;
        info.logo = target.info.logo;
        info.banner = target.info.banner;
        info.labelRes = target.info.labelRes;
        info.nonLocalizedLabel = target.info.nonLocalizedLabel;
        info.launchMode = target.info.launchMode;
        info.lockTaskLaunchMode = target.info.lockTaskLaunchMode;
        info.processName = target.info.processName;
        if (info.descriptionRes == 0) {
            info.descriptionRes = target.info.descriptionRes;
        }
        info.screenOrientation = target.info.screenOrientation;
        info.taskAffinity = target.info.taskAffinity;
        info.theme = target.info.theme;
        info.softInputMode = target.info.softInputMode;
        info.uiOptions = target.info.uiOptions;
        info.parentActivityName = target.info.parentActivityName;
        info.maxRecents = target.info.maxRecents;
        info.windowLayout = target.info.windowLayout;
        info.resizeMode = target.info.resizeMode;
        info.maxAspectRatio = target.info.maxAspectRatio;
        info.minAspectRatio = target.info.minAspectRatio;
        info.requestedVrComponent = target.info.requestedVrComponent;
        info.encryptionAware = info.directBootAware = target.info.directBootAware;
        Activity a = new Activity(cachedArgs.mActivityAliasArgs, info);
        if (outError[0] != null) {
            sa.recycle();
            return null;
        }
        boolean setExported = sa.hasValue(5);
        if (setExported) {
            a.info.exported = sa.getBoolean(5, false);
        }
        if ((str = sa.getNonConfigurationString(3, 0)) != null) {
            String string2 = a.info.permission = str.length() > 0 ? str.toString().intern() : null;
        }
        if ((parentName = sa.getNonConfigurationString(9, 1024)) != null) {
            String parentClassName = PackageParser.buildClassName(a.info.packageName, parentName, outError);
            if (outError[0] == null) {
                a.info.parentActivityName = parentClassName;
            } else {
                Log.e(TAG, "Activity alias " + a.info.name + " specified invalid parentActivityName " + parentName);
                outError[0] = null;
            }
        }
        boolean visibleToEphemeral = (a.info.flags & 0x100000) != 0;
        sa.recycle();
        if (outError[0] != null) {
            return null;
        }
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            if (parser.getName().equals("intent-filter")) {
                ActivityIntentInfo intent = new ActivityIntentInfo(a);
                if (!this.parseIntent(res, parser, true, true, intent, outError)) {
                    return null;
                }
                if (intent.countActions() == 0) {
                    Slog.w(TAG, "No actions in intent filter at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
                } else {
                    a.order = Math.max(intent.getOrder(), a.order);
                    a.intents.add(intent);
                }
                int visibility = visibleToEphemeral ? 1 : (this.isImplicitlyExposedIntent(intent) ? 2 : 0);
                intent.setVisibilityToInstantApp(visibility);
                if (intent.isVisibleToInstantApp()) {
                    a.info.flags |= 0x100000;
                }
                if (!intent.isImplicitlyVisibleToInstantApp()) continue;
                a.info.flags |= 0x200000;
                continue;
            }
            if (parser.getName().equals("meta-data")) {
                a.metaData = this.parseMetaData(res, parser, a.metaData, outError);
                if (a.metaData != null) continue;
                return null;
            }
            Slog.w(TAG, "Unknown element under <activity-alias>: " + parser.getName() + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
            XmlUtils.skipCurrentTag(parser);
        }
        if (!setExported) {
            a.info.exported = a.intents.size() > 0;
        }
        return a;
    }

    private Provider parseProvider(Package owner, Resources res, XmlResourceParser parser, int flags, String[] outError, CachedComponentArgs cachedArgs) throws XmlPullParserException, IOException {
        boolean visibleToEphemeral;
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestProvider);
        if (cachedArgs.mProviderArgs == null) {
            cachedArgs.mProviderArgs = new ParseComponentArgs(owner, outError, 2, 0, 1, 19, 15, 17, this.mSeparateProcesses, 8, 14, 6);
            cachedArgs.mProviderArgs.tag = "<provider>";
        }
        cachedArgs.mProviderArgs.sa = sa;
        cachedArgs.mProviderArgs.flags = flags;
        Provider p = new Provider(cachedArgs.mProviderArgs, new ProviderInfo());
        if (outError[0] != null) {
            sa.recycle();
            return null;
        }
        boolean providerExportedDefault = false;
        if (owner.applicationInfo.targetSdkVersion < 17) {
            providerExportedDefault = true;
        }
        p.info.exported = sa.getBoolean(7, providerExportedDefault);
        String cpname = sa.getNonConfigurationString(10, 0);
        p.info.isSyncable = sa.getBoolean(11, false);
        String permission2 = sa.getNonConfigurationString(3, 0);
        String str = sa.getNonConfigurationString(4, 0);
        if (str == null) {
            str = permission2;
        }
        p.info.readPermission = str == null ? owner.applicationInfo.permission : (str.length() > 0 ? str.toString().intern() : null);
        str = sa.getNonConfigurationString(5, 0);
        if (str == null) {
            str = permission2;
        }
        p.info.writePermission = str == null ? owner.applicationInfo.permission : (str.length() > 0 ? str.toString().intern() : null);
        p.info.grantUriPermissions = sa.getBoolean(13, false);
        p.info.forceUriPermissions = sa.getBoolean(22, false);
        p.info.multiprocess = sa.getBoolean(9, false);
        p.info.initOrder = sa.getInt(12, 0);
        p.info.splitName = sa.getNonConfigurationString(21, 0);
        p.info.flags = 0;
        if (sa.getBoolean(16, false)) {
            p.info.flags |= 0x40000000;
        }
        p.info.encryptionAware = p.info.directBootAware = sa.getBoolean(18, false);
        if (p.info.directBootAware) {
            owner.applicationInfo.privateFlags |= 0x100;
        }
        if (visibleToEphemeral = sa.getBoolean(20, false)) {
            p.info.flags |= 0x100000;
            owner.visibleToInstantApps = true;
        }
        sa.recycle();
        if ((owner.applicationInfo.privateFlags & 2) != 0 && p.info.processName == owner.packageName) {
            outError[0] = "Heavy-weight applications can not have providers in main process";
            return null;
        }
        if (cpname == null) {
            outError[0] = "<provider> does not include authorities attribute";
            return null;
        }
        if (cpname.length() <= 0) {
            outError[0] = "<provider> has empty authorities attribute";
            return null;
        }
        p.info.authority = cpname.intern();
        if (!this.parseProviderTags(res, parser, visibleToEphemeral, p, outError)) {
            return null;
        }
        return p;
    }

    private boolean parseProviderTags(Resources res, XmlResourceParser parser, boolean visibleToEphemeral, Provider outInfo, String[] outError) throws XmlPullParserException, IOException {
        int type;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            PatternMatcher pa;
            TypedArray sa;
            if (type == 3 || type == 4) continue;
            if (parser.getName().equals("intent-filter")) {
                ProviderIntentInfo intent = new ProviderIntentInfo(outInfo);
                if (!this.parseIntent(res, parser, true, false, intent, outError)) {
                    return false;
                }
                if (visibleToEphemeral) {
                    intent.setVisibilityToInstantApp(1);
                    outInfo.info.flags |= 0x100000;
                }
                outInfo.order = Math.max(intent.getOrder(), outInfo.order);
                outInfo.intents.add(intent);
                continue;
            }
            if (parser.getName().equals("meta-data")) {
                outInfo.metaData = this.parseMetaData(res, parser, outInfo.metaData, outError);
                if (outInfo.metaData != null) continue;
                return false;
            }
            if (parser.getName().equals("grant-uri-permission")) {
                sa = res.obtainAttributes(parser, R.styleable.AndroidManifestGrantUriPermission);
                pa = null;
                String str = sa.getNonConfigurationString(0, 0);
                if (str != null) {
                    pa = new PatternMatcher(str, 0);
                }
                if ((str = sa.getNonConfigurationString(1, 0)) != null) {
                    pa = new PatternMatcher(str, 1);
                }
                if ((str = sa.getNonConfigurationString(2, 0)) != null) {
                    pa = new PatternMatcher(str, 2);
                }
                sa.recycle();
                if (pa != null) {
                    if (outInfo.info.uriPermissionPatterns == null) {
                        outInfo.info.uriPermissionPatterns = new PatternMatcher[1];
                        outInfo.info.uriPermissionPatterns[0] = pa;
                    } else {
                        int N = outInfo.info.uriPermissionPatterns.length;
                        PatternMatcher[] newp = new PatternMatcher[N + 1];
                        System.arraycopy(outInfo.info.uriPermissionPatterns, 0, newp, 0, N);
                        newp[N] = pa;
                        outInfo.info.uriPermissionPatterns = newp;
                    }
                } else {
                    Slog.w(TAG, "Unknown element under <path-permission>: " + parser.getName() + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
                    XmlUtils.skipCurrentTag(parser);
                    continue;
                }
                outInfo.info.grantUriPermissions = true;
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (parser.getName().equals("path-permission")) {
                String writePermission;
                sa = res.obtainAttributes(parser, R.styleable.AndroidManifestPathPermission);
                pa = null;
                String permission2 = sa.getNonConfigurationString(0, 0);
                String readPermission = sa.getNonConfigurationString(1, 0);
                if (readPermission == null) {
                    readPermission = permission2;
                }
                if ((writePermission = sa.getNonConfigurationString(2, 0)) == null) {
                    writePermission = permission2;
                }
                boolean havePerm = false;
                if (readPermission != null) {
                    readPermission = readPermission.intern();
                    havePerm = true;
                }
                if (writePermission != null) {
                    writePermission = writePermission.intern();
                    havePerm = true;
                }
                if (!havePerm) {
                    Slog.w(TAG, "No readPermission or writePermssion for <path-permission>: " + parser.getName() + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
                    XmlUtils.skipCurrentTag(parser);
                    continue;
                }
                String path = sa.getNonConfigurationString(3, 0);
                if (path != null) {
                    pa = new PathPermission(path, 0, readPermission, writePermission);
                }
                if ((path = sa.getNonConfigurationString(4, 0)) != null) {
                    pa = new PathPermission(path, 1, readPermission, writePermission);
                }
                if ((path = sa.getNonConfigurationString(5, 0)) != null) {
                    pa = new PathPermission(path, 2, readPermission, writePermission);
                }
                if ((path = sa.getNonConfigurationString(6, 0)) != null) {
                    pa = new PathPermission(path, 3, readPermission, writePermission);
                }
                sa.recycle();
                if (pa != null) {
                    if (outInfo.info.pathPermissions == null) {
                        outInfo.info.pathPermissions = new PathPermission[1];
                        outInfo.info.pathPermissions[0] = pa;
                    } else {
                        int N = outInfo.info.pathPermissions.length;
                        PathPermission[] newp = new PathPermission[N + 1];
                        System.arraycopy(outInfo.info.pathPermissions, 0, newp, 0, N);
                        newp[N] = pa;
                        outInfo.info.pathPermissions = newp;
                    }
                } else {
                    Slog.w(TAG, "No path, pathPrefix, or pathPattern for <path-permission>: " + parser.getName() + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
                    XmlUtils.skipCurrentTag(parser);
                    continue;
                }
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            Slog.w(TAG, "Unknown element under <provider>: " + parser.getName() + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
            XmlUtils.skipCurrentTag(parser);
        }
        return true;
    }

    private Service parseService(Package owner, Resources res, XmlResourceParser parser, int flags, String[] outError, CachedComponentArgs cachedArgs) throws XmlPullParserException, IOException {
        int type;
        boolean visibleToEphemeral;
        String str;
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestService);
        if (cachedArgs.mServiceArgs == null) {
            cachedArgs.mServiceArgs = new ParseComponentArgs(owner, outError, 2, 0, 1, 15, 8, 12, this.mSeparateProcesses, 6, 7, 4);
            cachedArgs.mServiceArgs.tag = "<service>";
        }
        cachedArgs.mServiceArgs.sa = sa;
        cachedArgs.mServiceArgs.flags = flags;
        Service s = new Service(cachedArgs.mServiceArgs, new ServiceInfo());
        if (outError[0] != null) {
            sa.recycle();
            return null;
        }
        boolean setExported = sa.hasValue(5);
        if (setExported) {
            s.info.exported = sa.getBoolean(5, false);
        }
        s.info.permission = (str = sa.getNonConfigurationString(3, 0)) == null ? owner.applicationInfo.permission : (str.length() > 0 ? str.toString().intern() : null);
        s.info.splitName = sa.getNonConfigurationString(17, 0);
        s.info.mForegroundServiceType = sa.getInt(19, 0);
        s.info.flags = 0;
        if (sa.getBoolean(9, false)) {
            s.info.flags |= 1;
        }
        if (sa.getBoolean(10, false)) {
            s.info.flags |= 2;
        }
        if (sa.getBoolean(14, false)) {
            s.info.flags |= 4;
        }
        if (sa.getBoolean(18, false)) {
            s.info.flags |= 8;
        }
        if (sa.getBoolean(11, false)) {
            s.info.flags |= 0x40000000;
        }
        s.info.encryptionAware = s.info.directBootAware = sa.getBoolean(13, false);
        if (s.info.directBootAware) {
            owner.applicationInfo.privateFlags |= 0x100;
        }
        if (visibleToEphemeral = sa.getBoolean(16, false)) {
            s.info.flags |= 0x100000;
            owner.visibleToInstantApps = true;
        }
        sa.recycle();
        if ((owner.applicationInfo.privateFlags & 2) != 0 && s.info.processName == owner.packageName) {
            outError[0] = "Heavy-weight applications can not have services in main process";
            return null;
        }
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            if (parser.getName().equals("intent-filter")) {
                ServiceIntentInfo intent = new ServiceIntentInfo(s);
                if (!this.parseIntent(res, parser, true, false, intent, outError)) {
                    return null;
                }
                if (visibleToEphemeral) {
                    intent.setVisibilityToInstantApp(1);
                    s.info.flags |= 0x100000;
                }
                s.order = Math.max(intent.getOrder(), s.order);
                s.intents.add(intent);
                continue;
            }
            if (parser.getName().equals("meta-data")) {
                s.metaData = this.parseMetaData(res, parser, s.metaData, outError);
                if (s.metaData != null) continue;
                return null;
            }
            Slog.w(TAG, "Unknown element under <service>: " + parser.getName() + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
            XmlUtils.skipCurrentTag(parser);
        }
        if (!setExported) {
            s.info.exported = s.intents.size() > 0;
        }
        return s;
    }

    private boolean isImplicitlyExposedIntent(IntentInfo intent) {
        return intent.hasCategory("android.intent.category.BROWSABLE") || intent.hasAction("android.intent.action.SEND") || intent.hasAction("android.intent.action.SENDTO") || intent.hasAction("android.intent.action.SEND_MULTIPLE");
    }

    private boolean parseAllMetaData(Resources res, XmlResourceParser parser, String tag, Component<?> outInfo, String[] outError) throws XmlPullParserException, IOException {
        int type;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            if (parser.getName().equals("meta-data")) {
                outInfo.metaData = this.parseMetaData(res, parser, outInfo.metaData, outError);
                if (outInfo.metaData != null) continue;
                return false;
            }
            Slog.w(TAG, "Unknown element under " + tag + ": " + parser.getName() + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
            XmlUtils.skipCurrentTag(parser);
        }
        return true;
    }

    private Bundle parseMetaData(Resources res, XmlResourceParser parser, Bundle data, String[] outError) throws XmlPullParserException, IOException {
        String name;
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestMetaData);
        if (data == null) {
            data = new Bundle();
        }
        if ((name = sa.getNonConfigurationString(0, 0)) == null) {
            outError[0] = "<meta-data> requires an android:name attribute";
            sa.recycle();
            return null;
        }
        name = name.intern();
        TypedValue v = sa.peekValue(2);
        if (v != null && v.resourceId != 0) {
            data.putInt(name, v.resourceId);
        } else {
            v = sa.peekValue(1);
            if (v != null) {
                if (v.type == 3) {
                    CharSequence cs = v.coerceToString();
                    data.putString(name, cs != null ? cs.toString() : null);
                } else if (v.type == 18) {
                    data.putBoolean(name, v.data != 0);
                } else if (v.type >= 16 && v.type <= 31) {
                    data.putInt(name, v.data);
                } else if (v.type == 4) {
                    data.putFloat(name, v.getFloat());
                } else {
                    Slog.w(TAG, "<meta-data> only supports string, integer, float, color, boolean, and resource reference types: " + parser.getName() + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
                }
            } else {
                outError[0] = "<meta-data> requires an android:value or android:resource attribute";
                data = null;
            }
        }
        sa.recycle();
        XmlUtils.skipCurrentTag(parser);
        return data;
    }

    private static VerifierInfo parseVerifier(AttributeSet attrs) {
        String packageName = null;
        String encodedPublicKey = null;
        int attrCount = attrs.getAttributeCount();
        block4: for (int i = 0; i < attrCount; ++i) {
            int attrResId = attrs.getAttributeNameResource(i);
            switch (attrResId) {
                case 0x1010003: {
                    packageName = attrs.getAttributeValue(i);
                    continue block4;
                }
                case 16843686: {
                    encodedPublicKey = attrs.getAttributeValue(i);
                }
            }
        }
        if (packageName == null || packageName.length() == 0) {
            Slog.i(TAG, "verifier package name was null; skipping");
            return null;
        }
        PublicKey publicKey = PackageParser.parsePublicKey(encodedPublicKey);
        if (publicKey == null) {
            Slog.i(TAG, "Unable to parse verifier public key for " + packageName);
            return null;
        }
        return new VerifierInfo(packageName, publicKey);
    }

    public static final PublicKey parsePublicKey(String encodedPublicKey) {
        X509EncodedKeySpec keySpec;
        if (encodedPublicKey == null) {
            Slog.w(TAG, "Could not parse null public key");
            return null;
        }
        try {
            byte[] encoded = Base64.decode(encodedPublicKey, 0);
            keySpec = new X509EncodedKeySpec(encoded);
        }
        catch (IllegalArgumentException e) {
            Slog.w(TAG, "Could not parse verifier public key; invalid Base64");
            return null;
        }
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            Slog.wtf(TAG, "Could not parse public key: RSA KeyFactory not included in build");
        }
        catch (InvalidKeySpecException e) {
            // empty catch block
        }
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("EC");
            return keyFactory.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            Slog.wtf(TAG, "Could not parse public key: EC KeyFactory not included in build");
        }
        catch (InvalidKeySpecException e) {
            // empty catch block
        }
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("DSA");
            return keyFactory.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            Slog.wtf(TAG, "Could not parse public key: DSA KeyFactory not included in build");
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            // empty catch block
        }
        return null;
    }

    private boolean parseIntent(Resources res, XmlResourceParser parser, boolean allowGlobs, boolean allowAutoVerify, IntentInfo outInfo, String[] outError) throws XmlPullParserException, IOException {
        int type;
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestIntentFilter);
        int priority = sa.getInt(2, 0);
        outInfo.setPriority(priority);
        int order = sa.getInt(3, 0);
        outInfo.setOrder(order);
        TypedValue v = sa.peekValue(0);
        if (v != null && (outInfo.labelRes = v.resourceId) == 0) {
            outInfo.nonLocalizedLabel = v.coerceToString();
        }
        int roundIconVal = sUseRoundIcon ? sa.getResourceId(7, 0) : 0;
        outInfo.icon = roundIconVal != 0 ? roundIconVal : sa.getResourceId(1, 0);
        outInfo.logo = sa.getResourceId(4, 0);
        outInfo.banner = sa.getResourceId(5, 0);
        if (allowAutoVerify) {
            outInfo.setAutoVerify(sa.getBoolean(6, false));
        }
        sa.recycle();
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            String value;
            if (type == 3 || type == 4) continue;
            String nodeName = parser.getName();
            if (nodeName.equals("action")) {
                value = parser.getAttributeValue(ANDROID_RESOURCES, "name");
                if (value == null || value == "") {
                    outError[0] = "No value supplied for <android:name>";
                    return false;
                }
                XmlUtils.skipCurrentTag(parser);
                outInfo.addAction(value);
                continue;
            }
            if (nodeName.equals("category")) {
                value = parser.getAttributeValue(ANDROID_RESOURCES, "name");
                if (value == null || value == "") {
                    outError[0] = "No value supplied for <android:name>";
                    return false;
                }
                XmlUtils.skipCurrentTag(parser);
                outInfo.addCategory(value);
                continue;
            }
            if (nodeName.equals("data")) {
                sa = res.obtainAttributes(parser, R.styleable.AndroidManifestData);
                String str = sa.getNonConfigurationString(0, 0);
                if (str != null) {
                    try {
                        outInfo.addDataType(str);
                    }
                    catch (IntentFilter.MalformedMimeTypeException e) {
                        outError[0] = e.toString();
                        sa.recycle();
                        return false;
                    }
                }
                if ((str = sa.getNonConfigurationString(1, 0)) != null) {
                    outInfo.addDataScheme(str);
                }
                if ((str = sa.getNonConfigurationString(7, 0)) != null) {
                    outInfo.addDataSchemeSpecificPart(str, 0);
                }
                if ((str = sa.getNonConfigurationString(8, 0)) != null) {
                    outInfo.addDataSchemeSpecificPart(str, 1);
                }
                if ((str = sa.getNonConfigurationString(9, 0)) != null) {
                    if (!allowGlobs) {
                        outError[0] = "sspPattern not allowed here; ssp must be literal";
                        return false;
                    }
                    outInfo.addDataSchemeSpecificPart(str, 2);
                }
                String host = sa.getNonConfigurationString(2, 0);
                String port = sa.getNonConfigurationString(3, 0);
                if (host != null) {
                    outInfo.addDataAuthority(host, port);
                }
                if ((str = sa.getNonConfigurationString(4, 0)) != null) {
                    outInfo.addDataPath(str, 0);
                }
                if ((str = sa.getNonConfigurationString(5, 0)) != null) {
                    outInfo.addDataPath(str, 1);
                }
                if ((str = sa.getNonConfigurationString(6, 0)) != null) {
                    if (!allowGlobs) {
                        outError[0] = "pathPattern not allowed here; path must be literal";
                        return false;
                    }
                    outInfo.addDataPath(str, 2);
                }
                if ((str = sa.getNonConfigurationString(10, 0)) != null) {
                    if (!allowGlobs) {
                        outError[0] = "pathAdvancedPattern not allowed here; path must be literal";
                        return false;
                    }
                    outInfo.addDataPath(str, 3);
                }
                sa.recycle();
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            Slog.w(TAG, "Unknown element under <intent-filter>: " + parser.getName() + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
            XmlUtils.skipCurrentTag(parser);
        }
        outInfo.hasDefault = outInfo.hasCategory("android.intent.category.DEFAULT");
        return true;
    }

    private static boolean copyNeeded(int flags, Package p, PackageUserState state, Bundle metaData, int userId) {
        boolean suspended;
        if (userId != 0) {
            return true;
        }
        if (state.enabled != 0) {
            boolean enabled;
            boolean bl = enabled = state.enabled == 1;
            if (p.applicationInfo.enabled != enabled) {
                return true;
            }
        }
        boolean bl = suspended = (p.applicationInfo.flags & 0x40000000) != 0;
        if (state.suspended != suspended) {
            return true;
        }
        if (!state.installed || state.hidden) {
            return true;
        }
        if (state.stopped) {
            return true;
        }
        if (state.instantApp != p.applicationInfo.isInstantApp()) {
            return true;
        }
        if ((flags & 0x80) != 0 && (metaData != null || p.mAppMetaData != null)) {
            return true;
        }
        if ((flags & 0x400) != 0 && p.usesLibraryFiles != null) {
            return true;
        }
        if ((flags & 0x400) != 0 && p.usesLibraryInfos != null) {
            return true;
        }
        return p.staticSharedLibName != null;
    }

    @UnsupportedAppUsage
    public static ApplicationInfo generateApplicationInfo(Package p, int flags, PackageUserState state) {
        return PackageParser.generateApplicationInfo(p, flags, state, UserHandle.getCallingUserId());
    }

    private static void updateApplicationInfo(ApplicationInfo ai, int flags, PackageUserState state) {
        if (!sCompatibilityModeEnabled) {
            ai.disableCompatibilityMode();
        }
        ai.flags = state.installed ? (ai.flags |= 0x800000) : (ai.flags &= 0xFF7FFFFF);
        ai.flags = state.suspended ? (ai.flags |= 0x40000000) : (ai.flags &= 0xBFFFFFFF);
        ai.privateFlags = state.instantApp ? (ai.privateFlags |= 0x80) : (ai.privateFlags &= 0xFFFFFF7F);
        ai.privateFlags = state.virtualPreload ? (ai.privateFlags |= 0x10000) : (ai.privateFlags &= 0xFFFEFFFF);
        ai.privateFlags = state.hidden ? (ai.privateFlags |= 1) : (ai.privateFlags &= 0xFFFFFFFE);
        if (state.enabled == 1) {
            ai.enabled = true;
        } else if (state.enabled == 4) {
            ai.enabled = (flags & 0x8000) != 0;
        } else if (state.enabled == 2 || state.enabled == 3) {
            ai.enabled = false;
        }
        ai.enabledSetting = state.enabled;
        if (ai.category == -1) {
            ai.category = state.categoryHint;
        }
        if (ai.category == -1) {
            ai.category = FallbackCategoryProvider.getFallbackCategory(ai.packageName);
        }
        ai.seInfoUser = SELinuxUtil.assignSeinfoUser(state);
        ai.resourceDirs = state.overlayPaths;
        ai.icon = sUseRoundIcon && ai.roundIconRes != 0 ? ai.roundIconRes : ai.iconRes;
    }

    @UnsupportedAppUsage
    public static ApplicationInfo generateApplicationInfo(Package p, int flags, PackageUserState state, int userId) {
        if (p == null) {
            return null;
        }
        if (!PackageParser.checkUseInstalledOrHidden(flags, state, p.applicationInfo) || !p.isMatch(flags)) {
            return null;
        }
        if (!(PackageParser.copyNeeded(flags, p, state, null, userId) || (flags & 0x8000) != 0 && state.enabled == 4)) {
            PackageParser.updateApplicationInfo(p.applicationInfo, flags, state);
            return p.applicationInfo;
        }
        ApplicationInfo ai = new ApplicationInfo(p.applicationInfo);
        ai.initForUser(userId);
        if ((flags & 0x80) != 0) {
            ai.metaData = p.mAppMetaData;
        }
        if ((flags & 0x400) != 0) {
            ai.sharedLibraryFiles = p.usesLibraryFiles;
            ai.sharedLibraryInfos = p.usesLibraryInfos;
        }
        ai.flags = state.stopped ? (ai.flags |= 0x200000) : (ai.flags &= 0xFFDFFFFF);
        PackageParser.updateApplicationInfo(ai, flags, state);
        return ai;
    }

    public static ApplicationInfo generateApplicationInfo(ApplicationInfo ai, int flags, PackageUserState state, int userId) {
        if (ai == null) {
            return null;
        }
        if (!PackageParser.checkUseInstalledOrHidden(flags, state, ai)) {
            return null;
        }
        ai = new ApplicationInfo(ai);
        ai.initForUser(userId);
        ai.flags = state.stopped ? (ai.flags |= 0x200000) : (ai.flags &= 0xFFDFFFFF);
        PackageParser.updateApplicationInfo(ai, flags, state);
        return ai;
    }

    @UnsupportedAppUsage
    public static final PermissionInfo generatePermissionInfo(Permission p, int flags) {
        if (p == null) {
            return null;
        }
        if ((flags & 0x80) == 0) {
            return p.info;
        }
        PermissionInfo pi = new PermissionInfo(p.info);
        pi.metaData = p.metaData;
        return pi;
    }

    @UnsupportedAppUsage
    public static final PermissionGroupInfo generatePermissionGroupInfo(PermissionGroup pg, int flags) {
        if (pg == null) {
            return null;
        }
        if ((flags & 0x80) == 0) {
            return pg.info;
        }
        PermissionGroupInfo pgi = new PermissionGroupInfo(pg.info);
        pgi.metaData = pg.metaData;
        return pgi;
    }

    @UnsupportedAppUsage
    public static final ActivityInfo generateActivityInfo(Activity a, int flags, PackageUserState state, int userId) {
        if (a == null) {
            return null;
        }
        if (!PackageParser.checkUseInstalledOrHidden(flags, state, a.owner.applicationInfo)) {
            return null;
        }
        if (!PackageParser.copyNeeded(flags, a.owner, state, a.metaData, userId)) {
            PackageParser.updateApplicationInfo(a.info.applicationInfo, flags, state);
            return a.info;
        }
        ActivityInfo ai = new ActivityInfo(a.info);
        ai.metaData = a.metaData;
        ai.applicationInfo = PackageParser.generateApplicationInfo(a.owner, flags, state, userId);
        return ai;
    }

    public static final ActivityInfo generateActivityInfo(ActivityInfo ai, int flags, PackageUserState state, int userId) {
        if (ai == null) {
            return null;
        }
        if (!PackageParser.checkUseInstalledOrHidden(flags, state, ai.applicationInfo)) {
            return null;
        }
        ai = new ActivityInfo(ai);
        ai.applicationInfo = PackageParser.generateApplicationInfo(ai.applicationInfo, flags, state, userId);
        return ai;
    }

    @UnsupportedAppUsage
    public static final ServiceInfo generateServiceInfo(Service s, int flags, PackageUserState state, int userId) {
        if (s == null) {
            return null;
        }
        if (!PackageParser.checkUseInstalledOrHidden(flags, state, s.owner.applicationInfo)) {
            return null;
        }
        if (!PackageParser.copyNeeded(flags, s.owner, state, s.metaData, userId)) {
            PackageParser.updateApplicationInfo(s.info.applicationInfo, flags, state);
            return s.info;
        }
        ServiceInfo si = new ServiceInfo(s.info);
        si.metaData = s.metaData;
        si.applicationInfo = PackageParser.generateApplicationInfo(s.owner, flags, state, userId);
        return si;
    }

    @UnsupportedAppUsage
    public static final ProviderInfo generateProviderInfo(Provider p, int flags, PackageUserState state, int userId) {
        if (p == null) {
            return null;
        }
        if (!PackageParser.checkUseInstalledOrHidden(flags, state, p.owner.applicationInfo)) {
            return null;
        }
        if (!(PackageParser.copyNeeded(flags, p.owner, state, p.metaData, userId) || (flags & 0x800) == 0 && p.info.uriPermissionPatterns != null)) {
            PackageParser.updateApplicationInfo(p.info.applicationInfo, flags, state);
            return p.info;
        }
        ProviderInfo pi = new ProviderInfo(p.info);
        pi.metaData = p.metaData;
        if ((flags & 0x800) == 0) {
            pi.uriPermissionPatterns = null;
        }
        pi.applicationInfo = PackageParser.generateApplicationInfo(p.owner, flags, state, userId);
        return pi;
    }

    @UnsupportedAppUsage
    public static final InstrumentationInfo generateInstrumentationInfo(Instrumentation i, int flags) {
        if (i == null) {
            return null;
        }
        if ((flags & 0x80) == 0) {
            return i.info;
        }
        InstrumentationInfo ii = new InstrumentationInfo(i.info);
        ii.metaData = i.metaData;
        return ii;
    }

    @UnsupportedAppUsage
    public static void setCompatibilityModeEnabled(boolean compatibilityModeEnabled) {
        sCompatibilityModeEnabled = compatibilityModeEnabled;
    }

    public static void readConfigUseRoundIcon(Resources r) {
        ApplicationInfo androidAppInfo;
        if (r != null) {
            sUseRoundIcon = r.getBoolean(17891559);
            return;
        }
        try {
            androidAppInfo = ActivityThread.getPackageManager().getApplicationInfo("android", 0, UserHandle.myUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        Resources systemResources = Resources.getSystem();
        Resources overlayableRes = ResourcesManager.getInstance().getResources(null, null, null, androidAppInfo.resourceDirs, androidAppInfo.sharedLibraryFiles, 0, null, systemResources.getCompatibilityInfo(), systemResources.getClassLoader());
        sUseRoundIcon = overlayableRes.getBoolean(17891559);
    }

    public static PackageInfo generatePackageInfoFromApex(ApexInfo apexInfo, int flags) throws PackageParserException {
        PackageParser pp = new PackageParser();
        File apexFile = new File(apexInfo.packagePath);
        Package p = pp.parsePackage(apexFile, flags, false);
        PackageUserState state = new PackageUserState();
        PackageInfo pi = PackageParser.generatePackageInfo(p, EmptyArray.INT, flags, 0L, 0L, Collections.emptySet(), state);
        pi.applicationInfo.sourceDir = apexFile.getPath();
        pi.applicationInfo.publicSourceDir = apexFile.getPath();
        pi.applicationInfo.flags = apexInfo.isFactory ? (pi.applicationInfo.flags |= 1) : (pi.applicationInfo.flags &= 0xFFFFFFFE);
        pi.applicationInfo.flags = apexInfo.isActive ? (pi.applicationInfo.flags |= 0x800000) : (pi.applicationInfo.flags &= 0xFF7FFFFF);
        pi.isApex = true;
        if ((flags & 0x8000000) != 0) {
            PackageParser.collectCertificates(p, apexFile, false);
            if (p.mSigningDetails.hasPastSigningCertificates()) {
                pi.signatures = new Signature[1];
                pi.signatures[0] = p.mSigningDetails.pastSigningCertificates[0];
            } else if (p.mSigningDetails.hasSignatures()) {
                int numberOfSigs = p.mSigningDetails.signatures.length;
                pi.signatures = new Signature[numberOfSigs];
                System.arraycopy(p.mSigningDetails.signatures, 0, pi.signatures, 0, numberOfSigs);
            }
            pi.signingInfo = p.mSigningDetails != SigningDetails.UNKNOWN ? new SigningInfo(p.mSigningDetails) : null;
        }
        return pi;
    }

    static {
        CHILD_PACKAGE_TAGS.add(TAG_APPLICATION);
        CHILD_PACKAGE_TAGS.add(TAG_USES_PERMISSION);
        CHILD_PACKAGE_TAGS.add(TAG_USES_PERMISSION_SDK_M);
        CHILD_PACKAGE_TAGS.add(TAG_USES_PERMISSION_SDK_23);
        CHILD_PACKAGE_TAGS.add(TAG_USES_CONFIGURATION);
        CHILD_PACKAGE_TAGS.add(TAG_USES_FEATURE);
        CHILD_PACKAGE_TAGS.add(TAG_FEATURE_GROUP);
        CHILD_PACKAGE_TAGS.add(TAG_USES_SDK);
        CHILD_PACKAGE_TAGS.add(TAG_SUPPORT_SCREENS);
        CHILD_PACKAGE_TAGS.add(TAG_INSTRUMENTATION);
        CHILD_PACKAGE_TAGS.add(TAG_USES_GL_TEXTURE);
        CHILD_PACKAGE_TAGS.add(TAG_COMPATIBLE_SCREENS);
        CHILD_PACKAGE_TAGS.add(TAG_SUPPORTS_INPUT);
        CHILD_PACKAGE_TAGS.add(TAG_EAT_COMMENT);
        sCachedPackageReadCount = new AtomicInteger();
        SAFE_BROADCASTS = new ArraySet<String>();
        SAFE_BROADCASTS.add("android.intent.action.BOOT_COMPLETED");
        NEW_PERMISSIONS = new NewPermissionInfo[]{new NewPermissionInfo("android.permission.WRITE_EXTERNAL_STORAGE", 4, 0), new NewPermissionInfo("android.permission.READ_PHONE_STATE", 4, 0)};
        SDK_VERSION = Build.VERSION.SDK_INT;
        SDK_CODENAMES = Build.VERSION.ACTIVE_CODENAMES;
        sCompatibilityModeEnabled = true;
        sUseRoundIcon = false;
        sSplitNameComparator = new SplitNameComparator();
    }

    public static class PackageParserException
    extends Exception {
        public final int error;

        public PackageParserException(int error, String detailMessage) {
            super(detailMessage);
            this.error = error;
        }

        public PackageParserException(int error, String detailMessage, Throwable throwable) {
            super(detailMessage, throwable);
            this.error = error;
        }
    }

    public static final class ProviderIntentInfo
    extends IntentInfo {
        @UnsupportedAppUsage
        public Provider provider;

        public ProviderIntentInfo(Provider provider) {
            this.provider = provider;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(128);
            sb.append("ProviderIntentInfo{");
            sb.append(Integer.toHexString(System.identityHashCode(this)));
            sb.append(' ');
            this.provider.appendComponentShortName(sb);
            sb.append('}');
            return sb.toString();
        }

        public ProviderIntentInfo(Parcel in) {
            super(in);
        }
    }

    public static final class ServiceIntentInfo
    extends IntentInfo {
        @UnsupportedAppUsage
        public Service service;

        public ServiceIntentInfo(Service _service) {
            this.service = _service;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(128);
            sb.append("ServiceIntentInfo{");
            sb.append(Integer.toHexString(System.identityHashCode(this)));
            sb.append(' ');
            this.service.appendComponentShortName(sb);
            sb.append('}');
            return sb.toString();
        }

        public ServiceIntentInfo(Parcel in) {
            super(in);
        }
    }

    public static final class ActivityIntentInfo
    extends IntentInfo {
        @UnsupportedAppUsage
        public Activity activity;

        public ActivityIntentInfo(Activity _activity) {
            this.activity = _activity;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(128);
            sb.append("ActivityIntentInfo{");
            sb.append(Integer.toHexString(System.identityHashCode(this)));
            sb.append(' ');
            this.activity.appendComponentShortName(sb);
            sb.append('}');
            return sb.toString();
        }

        public ActivityIntentInfo(Parcel in) {
            super(in);
        }
    }

    public static abstract class IntentInfo
    extends IntentFilter {
        @UnsupportedAppUsage
        public boolean hasDefault;
        @UnsupportedAppUsage
        public int labelRes;
        @UnsupportedAppUsage
        public CharSequence nonLocalizedLabel;
        @UnsupportedAppUsage
        public int icon;
        @UnsupportedAppUsage
        public int logo;
        @UnsupportedAppUsage
        public int banner;
        public int preferred;

        @UnsupportedAppUsage
        protected IntentInfo() {
        }

        protected IntentInfo(Parcel dest) {
            super(dest);
            this.hasDefault = dest.readInt() == 1;
            this.labelRes = dest.readInt();
            this.nonLocalizedLabel = dest.readCharSequence();
            this.icon = dest.readInt();
            this.logo = dest.readInt();
            this.banner = dest.readInt();
            this.preferred = dest.readInt();
        }

        public void writeIntentInfoToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.hasDefault ? 1 : 0);
            dest.writeInt(this.labelRes);
            dest.writeCharSequence(this.nonLocalizedLabel);
            dest.writeInt(this.icon);
            dest.writeInt(this.logo);
            dest.writeInt(this.banner);
            dest.writeInt(this.preferred);
        }
    }

    public static final class Instrumentation
    extends Component<IntentInfo>
    implements Parcelable {
        @UnsupportedAppUsage
        public final InstrumentationInfo info;
        public static final Parcelable.Creator CREATOR = new Parcelable.Creator<Instrumentation>(){

            @Override
            public Instrumentation createFromParcel(Parcel in) {
                return new Instrumentation(in);
            }

            public Instrumentation[] newArray(int size) {
                return new Instrumentation[size];
            }
        };

        public Instrumentation(ParsePackageItemArgs args, InstrumentationInfo _info) {
            super(args, _info);
            this.info = _info;
        }

        @Override
        public void setPackageName(String packageName) {
            super.setPackageName(packageName);
            this.info.packageName = packageName;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(128);
            sb.append("Instrumentation{");
            sb.append(Integer.toHexString(System.identityHashCode(this)));
            sb.append(' ');
            this.appendComponentShortName(sb);
            sb.append('}');
            return sb.toString();
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeParcelable(this.info, flags);
        }

        private Instrumentation(Parcel in) {
            super(in);
            this.info = (InstrumentationInfo)in.readParcelable(Object.class.getClassLoader());
            if (this.info.targetPackage != null) {
                this.info.targetPackage = this.info.targetPackage.intern();
            }
            if (this.info.targetProcesses != null) {
                this.info.targetProcesses = this.info.targetProcesses.intern();
            }
        }
    }

    public static final class Provider
    extends Component<ProviderIntentInfo>
    implements Parcelable {
        @UnsupportedAppUsage
        public final ProviderInfo info;
        @UnsupportedAppUsage
        public boolean syncable;
        public static final Parcelable.Creator CREATOR = new Parcelable.Creator<Provider>(){

            @Override
            public Provider createFromParcel(Parcel in) {
                return new Provider(in);
            }

            public Provider[] newArray(int size) {
                return new Provider[size];
            }
        };

        public Provider(ParseComponentArgs args, ProviderInfo _info) {
            super(args, _info);
            this.info = _info;
            this.info.applicationInfo = args.owner.applicationInfo;
            this.syncable = false;
        }

        @UnsupportedAppUsage
        public Provider(Provider existingProvider) {
            super(existingProvider);
            this.info = existingProvider.info;
            this.syncable = existingProvider.syncable;
        }

        @Override
        public void setPackageName(String packageName) {
            super.setPackageName(packageName);
            this.info.packageName = packageName;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(128);
            sb.append("Provider{");
            sb.append(Integer.toHexString(System.identityHashCode(this)));
            sb.append(' ');
            this.appendComponentShortName(sb);
            sb.append('}');
            return sb.toString();
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeParcelable(this.info, flags | 2);
            dest.writeInt(this.syncable ? 1 : 0);
        }

        private Provider(Parcel in) {
            super(in);
            this.info = (ProviderInfo)in.readParcelable(Object.class.getClassLoader());
            this.syncable = in.readInt() == 1;
            for (ProviderIntentInfo aii : this.intents) {
                aii.provider = this;
            }
            if (this.info.readPermission != null) {
                this.info.readPermission = this.info.readPermission.intern();
            }
            if (this.info.writePermission != null) {
                this.info.writePermission = this.info.writePermission.intern();
            }
            if (this.info.authority != null) {
                this.info.authority = this.info.authority.intern();
            }
        }
    }

    public static final class Service
    extends Component<ServiceIntentInfo>
    implements Parcelable {
        @UnsupportedAppUsage
        public final ServiceInfo info;
        public static final Parcelable.Creator CREATOR = new Parcelable.Creator<Service>(){

            @Override
            public Service createFromParcel(Parcel in) {
                return new Service(in);
            }

            public Service[] newArray(int size) {
                return new Service[size];
            }
        };

        public Service(ParseComponentArgs args, ServiceInfo _info) {
            super(args, _info);
            this.info = _info;
            this.info.applicationInfo = args.owner.applicationInfo;
        }

        @Override
        public void setPackageName(String packageName) {
            super.setPackageName(packageName);
            this.info.packageName = packageName;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(128);
            sb.append("Service{");
            sb.append(Integer.toHexString(System.identityHashCode(this)));
            sb.append(' ');
            this.appendComponentShortName(sb);
            sb.append('}');
            return sb.toString();
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeParcelable(this.info, flags | 2);
        }

        private Service(Parcel in) {
            super(in);
            this.info = (ServiceInfo)in.readParcelable(Object.class.getClassLoader());
            for (ServiceIntentInfo aii : this.intents) {
                aii.service = this;
                this.order = Math.max(aii.getOrder(), this.order);
            }
            if (this.info.permission != null) {
                this.info.permission = this.info.permission.intern();
            }
        }
    }

    public static final class Activity
    extends Component<ActivityIntentInfo>
    implements Parcelable {
        @UnsupportedAppUsage
        public final ActivityInfo info;
        private boolean mHasMaxAspectRatio;
        private boolean mHasMinAspectRatio;
        public static final Parcelable.Creator CREATOR = new Parcelable.Creator<Activity>(){

            @Override
            public Activity createFromParcel(Parcel in) {
                return new Activity(in);
            }

            public Activity[] newArray(int size) {
                return new Activity[size];
            }
        };

        private boolean hasMaxAspectRatio() {
            return this.mHasMaxAspectRatio;
        }

        private boolean hasMinAspectRatio() {
            return this.mHasMinAspectRatio;
        }

        Activity(Package owner, String className, ActivityInfo info) {
            super(owner, new ArrayList(0), className);
            this.info = info;
            this.info.applicationInfo = owner.applicationInfo;
        }

        public Activity(ParseComponentArgs args, ActivityInfo _info) {
            super(args, _info);
            this.info = _info;
            this.info.applicationInfo = args.owner.applicationInfo;
        }

        @Override
        public void setPackageName(String packageName) {
            super.setPackageName(packageName);
            this.info.packageName = packageName;
        }

        private void setMaxAspectRatio(float maxAspectRatio) {
            if (this.info.resizeMode == 2 || this.info.resizeMode == 1) {
                return;
            }
            if (maxAspectRatio < 1.0f && maxAspectRatio != 0.0f) {
                return;
            }
            this.info.maxAspectRatio = maxAspectRatio;
            this.mHasMaxAspectRatio = true;
        }

        private void setMinAspectRatio(float minAspectRatio) {
            if (this.info.resizeMode == 2 || this.info.resizeMode == 1) {
                return;
            }
            if (minAspectRatio < 1.0f && minAspectRatio != 0.0f) {
                return;
            }
            this.info.minAspectRatio = minAspectRatio;
            this.mHasMinAspectRatio = true;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(128);
            sb.append("Activity{");
            sb.append(Integer.toHexString(System.identityHashCode(this)));
            sb.append(' ');
            this.appendComponentShortName(sb);
            sb.append('}');
            return sb.toString();
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeParcelable(this.info, flags | 2);
            dest.writeBoolean(this.mHasMaxAspectRatio);
            dest.writeBoolean(this.mHasMinAspectRatio);
        }

        private Activity(Parcel in) {
            super(in);
            this.info = (ActivityInfo)in.readParcelable(Object.class.getClassLoader());
            this.mHasMaxAspectRatio = in.readBoolean();
            this.mHasMinAspectRatio = in.readBoolean();
            for (ActivityIntentInfo aii : this.intents) {
                aii.activity = this;
                this.order = Math.max(aii.getOrder(), this.order);
            }
            if (this.info.permission != null) {
                this.info.permission = this.info.permission.intern();
            }
        }
    }

    public static final class PermissionGroup
    extends Component<IntentInfo>
    implements Parcelable {
        @UnsupportedAppUsage
        public final PermissionGroupInfo info;
        public static final Parcelable.Creator CREATOR = new Parcelable.Creator<PermissionGroup>(){

            @Override
            public PermissionGroup createFromParcel(Parcel in) {
                return new PermissionGroup(in);
            }

            public PermissionGroup[] newArray(int size) {
                return new PermissionGroup[size];
            }
        };

        public PermissionGroup(Package owner, int requestDetailResourceId, int backgroundRequestResourceId, int backgroundRequestDetailResourceId) {
            super(owner);
            this.info = new PermissionGroupInfo(requestDetailResourceId, backgroundRequestResourceId, backgroundRequestDetailResourceId);
        }

        public PermissionGroup(Package _owner, PermissionGroupInfo _info) {
            super(_owner);
            this.info = _info;
        }

        @Override
        public void setPackageName(String packageName) {
            super.setPackageName(packageName);
            this.info.packageName = packageName;
        }

        public String toString() {
            return "PermissionGroup{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.info.name + "}";
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeParcelable(this.info, flags);
        }

        private PermissionGroup(Parcel in) {
            super(in);
            this.info = (PermissionGroupInfo)in.readParcelable(Object.class.getClassLoader());
        }
    }

    public static final class Permission
    extends Component<IntentInfo>
    implements Parcelable {
        @UnsupportedAppUsage
        public final PermissionInfo info;
        @UnsupportedAppUsage
        public boolean tree;
        @UnsupportedAppUsage
        public PermissionGroup group;
        public static final Parcelable.Creator CREATOR = new Parcelable.Creator<Permission>(){

            @Override
            public Permission createFromParcel(Parcel in) {
                return new Permission(in);
            }

            public Permission[] newArray(int size) {
                return new Permission[size];
            }
        };

        public Permission(Package owner, String backgroundPermission) {
            super(owner);
            this.info = new PermissionInfo(backgroundPermission);
        }

        @UnsupportedAppUsage
        public Permission(Package _owner, PermissionInfo _info) {
            super(_owner);
            this.info = _info;
        }

        @Override
        public void setPackageName(String packageName) {
            super.setPackageName(packageName);
            this.info.packageName = packageName;
        }

        public String toString() {
            return "Permission{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.info.name + "}";
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeParcelable(this.info, flags);
            dest.writeInt(this.tree ? 1 : 0);
            dest.writeParcelable(this.group, flags);
        }

        public boolean isAppOp() {
            return this.info.isAppOp();
        }

        private Permission(Parcel in) {
            super(in);
            ClassLoader boot = Object.class.getClassLoader();
            this.info = (PermissionInfo)in.readParcelable(boot);
            if (this.info.group != null) {
                this.info.group = this.info.group.intern();
            }
            this.tree = in.readInt() == 1;
            this.group = (PermissionGroup)in.readParcelable(boot);
        }
    }

    public static abstract class Component<II extends IntentInfo> {
        @UnsupportedAppUsage
        public final ArrayList<II> intents;
        @UnsupportedAppUsage
        public final String className;
        @UnsupportedAppUsage
        public Bundle metaData;
        @UnsupportedAppUsage
        public Package owner;
        public int order;
        ComponentName componentName;
        String componentShortName;

        public Component(Package owner, ArrayList<II> intents, String className) {
            this.owner = owner;
            this.intents = intents;
            this.className = className;
        }

        public Component(Package owner) {
            this.owner = owner;
            this.intents = null;
            this.className = null;
        }

        public Component(ParsePackageItemArgs args, PackageItemInfo outInfo) {
            this.owner = args.owner;
            this.intents = new ArrayList(0);
            this.className = PackageParser.parsePackageItemInfo(args.owner, outInfo, args.outError, args.tag, args.sa, true, args.nameRes, args.labelRes, args.iconRes, args.roundIconRes, args.logoRes, args.bannerRes) ? outInfo.name : null;
        }

        public Component(ParseComponentArgs args, ComponentInfo outInfo) {
            this((ParsePackageItemArgs)args, (PackageItemInfo)outInfo);
            if (args.outError[0] != null) {
                return;
            }
            if (args.processRes != 0) {
                String pname = this.owner.applicationInfo.targetSdkVersion >= 8 ? args.sa.getNonConfigurationString(args.processRes, 1024) : args.sa.getNonResourceString(args.processRes);
                outInfo.processName = PackageParser.buildProcessName(this.owner.applicationInfo.packageName, this.owner.applicationInfo.processName, pname, args.flags, args.sepProcesses, args.outError);
            }
            if (args.descriptionRes != 0) {
                outInfo.descriptionRes = args.sa.getResourceId(args.descriptionRes, 0);
            }
            outInfo.enabled = args.sa.getBoolean(args.enabledRes, true);
        }

        public Component(Component<II> clone) {
            this.owner = clone.owner;
            this.intents = clone.intents;
            this.className = clone.className;
            this.componentName = clone.componentName;
            this.componentShortName = clone.componentShortName;
        }

        @UnsupportedAppUsage
        public ComponentName getComponentName() {
            if (this.componentName != null) {
                return this.componentName;
            }
            if (this.className != null) {
                this.componentName = new ComponentName(this.owner.applicationInfo.packageName, this.className);
            }
            return this.componentName;
        }

        protected Component(Parcel in) {
            this.className = in.readString();
            this.metaData = in.readBundle();
            this.intents = Component.createIntentsList(in);
            this.owner = null;
        }

        protected void writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.className);
            dest.writeBundle(this.metaData);
            Component.writeIntentsList(this.intents, dest, flags);
        }

        private static void writeIntentsList(ArrayList<? extends IntentInfo> list, Parcel out, int flags) {
            if (list == null) {
                out.writeInt(-1);
                return;
            }
            int N = list.size();
            out.writeInt(N);
            if (N > 0) {
                IntentInfo info = list.get(0);
                out.writeString(info.getClass().getName());
                for (int i = 0; i < N; ++i) {
                    list.get(i).writeIntentInfoToParcel(out, flags);
                }
            }
        }

        private static <T extends IntentInfo> ArrayList<T> createIntentsList(Parcel in) {
            ArrayList<IntentInfo> intentsList;
            int N = in.readInt();
            if (N == -1) {
                return null;
            }
            if (N == 0) {
                return new ArrayList(0);
            }
            String componentName = in.readString();
            try {
                Class<?> cls = Class.forName(componentName);
                Constructor<?> cons = cls.getConstructor(Parcel.class);
                intentsList = new ArrayList<IntentInfo>(N);
                for (int i = 0; i < N; ++i) {
                    intentsList.add((IntentInfo)cons.newInstance(in));
                }
            }
            catch (ReflectiveOperationException ree) {
                throw new AssertionError((Object)("Unable to construct intent list for: " + componentName));
            }
            return intentsList;
        }

        public void appendComponentShortName(StringBuilder sb) {
            ComponentName.appendShortString(sb, this.owner.applicationInfo.packageName, this.className);
        }

        public void printComponentShortName(PrintWriter pw) {
            ComponentName.printShortString(pw, this.owner.applicationInfo.packageName, this.className);
        }

        public void setPackageName(String packageName) {
            this.componentName = null;
            this.componentShortName = null;
        }
    }

    public static final class Package
    implements Parcelable {
        @UnsupportedAppUsage
        public String packageName;
        public String manifestPackageName;
        public String[] splitNames;
        public String volumeUuid;
        public String codePath;
        public String baseCodePath;
        public String[] splitCodePaths;
        public int baseRevisionCode;
        public int[] splitRevisionCodes;
        public int[] splitFlags;
        public int[] splitPrivateFlags;
        public boolean baseHardwareAccelerated;
        @UnsupportedAppUsage
        public ApplicationInfo applicationInfo = new ApplicationInfo();
        @UnsupportedAppUsage
        public final ArrayList<Permission> permissions = new ArrayList(0);
        @UnsupportedAppUsage
        public final ArrayList<PermissionGroup> permissionGroups = new ArrayList(0);
        @UnsupportedAppUsage
        public final ArrayList<Activity> activities = new ArrayList(0);
        @UnsupportedAppUsage
        public final ArrayList<Activity> receivers = new ArrayList(0);
        @UnsupportedAppUsage
        public final ArrayList<Provider> providers = new ArrayList(0);
        @UnsupportedAppUsage
        public final ArrayList<Service> services = new ArrayList(0);
        @UnsupportedAppUsage
        public final ArrayList<Instrumentation> instrumentation = new ArrayList(0);
        @UnsupportedAppUsage
        public final ArrayList<String> requestedPermissions = new ArrayList();
        public final ArrayList<String> implicitPermissions = new ArrayList();
        @UnsupportedAppUsage
        public ArrayList<String> protectedBroadcasts;
        public Package parentPackage;
        public ArrayList<Package> childPackages;
        public String staticSharedLibName = null;
        public long staticSharedLibVersion = 0L;
        public ArrayList<String> libraryNames = null;
        @UnsupportedAppUsage
        public ArrayList<String> usesLibraries = null;
        public ArrayList<String> usesStaticLibraries = null;
        public long[] usesStaticLibrariesVersions = null;
        public String[][] usesStaticLibrariesCertDigests = null;
        @UnsupportedAppUsage
        public ArrayList<String> usesOptionalLibraries = null;
        @UnsupportedAppUsage
        public String[] usesLibraryFiles = null;
        public ArrayList<SharedLibraryInfo> usesLibraryInfos = null;
        public ArrayList<ActivityIntentInfo> preferredActivityFilters = null;
        public ArrayList<String> mOriginalPackages = null;
        public String mRealPackage = null;
        public ArrayList<String> mAdoptPermissions = null;
        @UnsupportedAppUsage
        public Bundle mAppMetaData = null;
        @UnsupportedAppUsage
        public int mVersionCode;
        public int mVersionCodeMajor;
        @UnsupportedAppUsage
        public String mVersionName;
        @UnsupportedAppUsage
        public String mSharedUserId;
        @UnsupportedAppUsage
        public int mSharedUserLabel;
        @UnsupportedAppUsage
        public SigningDetails mSigningDetails = SigningDetails.UNKNOWN;
        @UnsupportedAppUsage
        public int mPreferredOrder = 0;
        public long[] mLastPackageUsageTimeInMills = new long[8];
        @UnsupportedAppUsage
        public Object mExtras;
        @UnsupportedAppUsage
        public ArrayList<ConfigurationInfo> configPreferences = null;
        @UnsupportedAppUsage
        public ArrayList<FeatureInfo> reqFeatures = null;
        public ArrayList<FeatureGroupInfo> featureGroups = null;
        @UnsupportedAppUsage
        public int installLocation;
        public boolean coreApp;
        public boolean mRequiredForAllUsers;
        public String mRestrictedAccountType;
        public String mRequiredAccountType;
        public String mOverlayTarget;
        public String mOverlayTargetName;
        public String mOverlayCategory;
        public int mOverlayPriority;
        public boolean mOverlayIsStatic;
        public int mCompileSdkVersion;
        public String mCompileSdkVersionCodename;
        @UnsupportedAppUsage
        public ArraySet<String> mUpgradeKeySets;
        @UnsupportedAppUsage
        public ArrayMap<String, ArraySet<PublicKey>> mKeySetMapping;
        public String cpuAbiOverride;
        public boolean use32bitAbi;
        public byte[] restrictUpdateHash;
        public boolean visibleToInstantApps;
        public boolean isStub;
        public static final Parcelable.Creator CREATOR = new Parcelable.Creator<Package>(){

            @Override
            public Package createFromParcel(Parcel in) {
                return new Package(in);
            }

            public Package[] newArray(int size) {
                return new Package[size];
            }
        };

        public long getLongVersionCode() {
            return PackageInfo.composeLongVersionCode(this.mVersionCodeMajor, this.mVersionCode);
        }

        @UnsupportedAppUsage
        public Package(String packageName) {
            this.packageName = packageName;
            this.manifestPackageName = packageName;
            this.applicationInfo.packageName = packageName;
            this.applicationInfo.uid = -1;
        }

        public void setApplicationVolumeUuid(String volumeUuid) {
            UUID storageUuid = StorageManager.convert(volumeUuid);
            this.applicationInfo.volumeUuid = volumeUuid;
            this.applicationInfo.storageUuid = storageUuid;
            if (this.childPackages != null) {
                int packageCount = this.childPackages.size();
                for (int i = 0; i < packageCount; ++i) {
                    this.childPackages.get((int)i).applicationInfo.volumeUuid = volumeUuid;
                    this.childPackages.get((int)i).applicationInfo.storageUuid = storageUuid;
                }
            }
        }

        public void setApplicationInfoCodePath(String codePath) {
            this.applicationInfo.setCodePath(codePath);
            if (this.childPackages != null) {
                int packageCount = this.childPackages.size();
                for (int i = 0; i < packageCount; ++i) {
                    this.childPackages.get((int)i).applicationInfo.setCodePath(codePath);
                }
            }
        }

        @Deprecated
        public void setApplicationInfoResourcePath(String resourcePath) {
            this.applicationInfo.setResourcePath(resourcePath);
            if (this.childPackages != null) {
                int packageCount = this.childPackages.size();
                for (int i = 0; i < packageCount; ++i) {
                    this.childPackages.get((int)i).applicationInfo.setResourcePath(resourcePath);
                }
            }
        }

        @Deprecated
        public void setApplicationInfoBaseResourcePath(String resourcePath) {
            this.applicationInfo.setBaseResourcePath(resourcePath);
            if (this.childPackages != null) {
                int packageCount = this.childPackages.size();
                for (int i = 0; i < packageCount; ++i) {
                    this.childPackages.get((int)i).applicationInfo.setBaseResourcePath(resourcePath);
                }
            }
        }

        public void setApplicationInfoBaseCodePath(String baseCodePath) {
            this.applicationInfo.setBaseCodePath(baseCodePath);
            if (this.childPackages != null) {
                int packageCount = this.childPackages.size();
                for (int i = 0; i < packageCount; ++i) {
                    this.childPackages.get((int)i).applicationInfo.setBaseCodePath(baseCodePath);
                }
            }
        }

        public List<String> getChildPackageNames() {
            if (this.childPackages == null) {
                return null;
            }
            int childCount = this.childPackages.size();
            ArrayList<String> childPackageNames = new ArrayList<String>(childCount);
            for (int i = 0; i < childCount; ++i) {
                String childPackageName = this.childPackages.get((int)i).packageName;
                childPackageNames.add(childPackageName);
            }
            return childPackageNames;
        }

        public boolean hasChildPackage(String packageName) {
            int childCount = this.childPackages != null ? this.childPackages.size() : 0;
            for (int i = 0; i < childCount; ++i) {
                if (!this.childPackages.get((int)i).packageName.equals(packageName)) continue;
                return true;
            }
            return false;
        }

        public void setApplicationInfoSplitCodePaths(String[] splitCodePaths) {
            this.applicationInfo.setSplitCodePaths(splitCodePaths);
        }

        @Deprecated
        public void setApplicationInfoSplitResourcePaths(String[] resroucePaths) {
            this.applicationInfo.setSplitResourcePaths(resroucePaths);
        }

        public void setSplitCodePaths(String[] codePaths) {
            this.splitCodePaths = codePaths;
        }

        public void setCodePath(String codePath) {
            this.codePath = codePath;
            if (this.childPackages != null) {
                int packageCount = this.childPackages.size();
                for (int i = 0; i < packageCount; ++i) {
                    this.childPackages.get((int)i).codePath = codePath;
                }
            }
        }

        public void setBaseCodePath(String baseCodePath) {
            this.baseCodePath = baseCodePath;
            if (this.childPackages != null) {
                int packageCount = this.childPackages.size();
                for (int i = 0; i < packageCount; ++i) {
                    this.childPackages.get((int)i).baseCodePath = baseCodePath;
                }
            }
        }

        public void setSigningDetails(SigningDetails signingDetails) {
            this.mSigningDetails = signingDetails;
            if (this.childPackages != null) {
                int packageCount = this.childPackages.size();
                for (int i = 0; i < packageCount; ++i) {
                    this.childPackages.get((int)i).mSigningDetails = signingDetails;
                }
            }
        }

        public void setVolumeUuid(String volumeUuid) {
            this.volumeUuid = volumeUuid;
            if (this.childPackages != null) {
                int packageCount = this.childPackages.size();
                for (int i = 0; i < packageCount; ++i) {
                    this.childPackages.get((int)i).volumeUuid = volumeUuid;
                }
            }
        }

        public void setApplicationInfoFlags(int mask, int flags) {
            this.applicationInfo.flags = this.applicationInfo.flags & ~mask | mask & flags;
            if (this.childPackages != null) {
                int packageCount = this.childPackages.size();
                for (int i = 0; i < packageCount; ++i) {
                    this.childPackages.get((int)i).applicationInfo.flags = this.applicationInfo.flags & ~mask | mask & flags;
                }
            }
        }

        public void setUse32bitAbi(boolean use32bitAbi) {
            this.use32bitAbi = use32bitAbi;
            if (this.childPackages != null) {
                int packageCount = this.childPackages.size();
                for (int i = 0; i < packageCount; ++i) {
                    this.childPackages.get((int)i).use32bitAbi = use32bitAbi;
                }
            }
        }

        public boolean isLibrary() {
            return this.staticSharedLibName != null || !ArrayUtils.isEmpty(this.libraryNames);
        }

        public List<String> getAllCodePaths() {
            ArrayList<String> paths = new ArrayList<String>();
            paths.add(this.baseCodePath);
            if (!ArrayUtils.isEmpty(this.splitCodePaths)) {
                Collections.addAll(paths, this.splitCodePaths);
            }
            return paths;
        }

        public List<String> getAllCodePathsExcludingResourceOnly() {
            ArrayList<String> paths = new ArrayList<String>();
            if ((this.applicationInfo.flags & 4) != 0) {
                paths.add(this.baseCodePath);
            }
            if (!ArrayUtils.isEmpty(this.splitCodePaths)) {
                for (int i = 0; i < this.splitCodePaths.length; ++i) {
                    if ((this.splitFlags[i] & 4) == 0) continue;
                    paths.add(this.splitCodePaths[i]);
                }
            }
            return paths;
        }

        @UnsupportedAppUsage
        public void setPackageName(String newName) {
            int i;
            this.packageName = newName;
            this.applicationInfo.packageName = newName;
            for (i = this.permissions.size() - 1; i >= 0; --i) {
                this.permissions.get(i).setPackageName(newName);
            }
            for (i = this.permissionGroups.size() - 1; i >= 0; --i) {
                this.permissionGroups.get(i).setPackageName(newName);
            }
            for (i = this.activities.size() - 1; i >= 0; --i) {
                this.activities.get(i).setPackageName(newName);
            }
            for (i = this.receivers.size() - 1; i >= 0; --i) {
                this.receivers.get(i).setPackageName(newName);
            }
            for (i = this.providers.size() - 1; i >= 0; --i) {
                this.providers.get(i).setPackageName(newName);
            }
            for (i = this.services.size() - 1; i >= 0; --i) {
                this.services.get(i).setPackageName(newName);
            }
            for (i = this.instrumentation.size() - 1; i >= 0; --i) {
                this.instrumentation.get(i).setPackageName(newName);
            }
        }

        public boolean hasComponentClassName(String name) {
            int i;
            for (i = this.activities.size() - 1; i >= 0; --i) {
                if (!name.equals(this.activities.get((int)i).className)) continue;
                return true;
            }
            for (i = this.receivers.size() - 1; i >= 0; --i) {
                if (!name.equals(this.receivers.get((int)i).className)) continue;
                return true;
            }
            for (i = this.providers.size() - 1; i >= 0; --i) {
                if (!name.equals(this.providers.get((int)i).className)) continue;
                return true;
            }
            for (i = this.services.size() - 1; i >= 0; --i) {
                if (!name.equals(this.services.get((int)i).className)) continue;
                return true;
            }
            for (i = this.instrumentation.size() - 1; i >= 0; --i) {
                if (!name.equals(this.instrumentation.get((int)i).className)) continue;
                return true;
            }
            return false;
        }

        public boolean isExternal() {
            return this.applicationInfo.isExternal();
        }

        public boolean isForwardLocked() {
            return false;
        }

        public boolean isOem() {
            return this.applicationInfo.isOem();
        }

        public boolean isVendor() {
            return this.applicationInfo.isVendor();
        }

        public boolean isProduct() {
            return this.applicationInfo.isProduct();
        }

        public boolean isProductServices() {
            return this.applicationInfo.isProductServices();
        }

        public boolean isOdm() {
            return this.applicationInfo.isOdm();
        }

        public boolean isPrivileged() {
            return this.applicationInfo.isPrivilegedApp();
        }

        public boolean isSystem() {
            return this.applicationInfo.isSystemApp();
        }

        public boolean isUpdatedSystemApp() {
            return this.applicationInfo.isUpdatedSystemApp();
        }

        public boolean canHaveOatDir() {
            return !this.isSystem() || this.isUpdatedSystemApp();
        }

        public boolean isMatch(int flags) {
            if ((flags & 0x100000) != 0) {
                return this.isSystem();
            }
            return true;
        }

        public long getLatestPackageUseTimeInMills() {
            long latestUse = 0L;
            for (long use : this.mLastPackageUsageTimeInMills) {
                latestUse = Math.max(latestUse, use);
            }
            return latestUse;
        }

        public long getLatestForegroundPackageUseTimeInMills() {
            int[] foregroundReasons = new int[]{0, 2};
            long latestUse = 0L;
            for (int reason : foregroundReasons) {
                latestUse = Math.max(latestUse, this.mLastPackageUsageTimeInMills[reason]);
            }
            return latestUse;
        }

        public String toString() {
            return "Package{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.packageName + "}";
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public Package(Parcel dest) {
            ClassLoader boot = Object.class.getClassLoader();
            this.packageName = dest.readString().intern();
            this.manifestPackageName = dest.readString();
            this.splitNames = dest.readStringArray();
            this.volumeUuid = dest.readString();
            this.codePath = dest.readString();
            this.baseCodePath = dest.readString();
            this.splitCodePaths = dest.readStringArray();
            this.baseRevisionCode = dest.readInt();
            this.splitRevisionCodes = dest.createIntArray();
            this.splitFlags = dest.createIntArray();
            this.splitPrivateFlags = dest.createIntArray();
            this.baseHardwareAccelerated = dest.readInt() == 1;
            this.applicationInfo = (ApplicationInfo)dest.readParcelable(boot);
            if (this.applicationInfo.permission != null) {
                this.applicationInfo.permission = this.applicationInfo.permission.intern();
            }
            dest.readParcelableList(this.permissions, boot);
            this.fixupOwner(this.permissions);
            dest.readParcelableList(this.permissionGroups, boot);
            this.fixupOwner(this.permissionGroups);
            dest.readParcelableList(this.activities, boot);
            this.fixupOwner(this.activities);
            dest.readParcelableList(this.receivers, boot);
            this.fixupOwner(this.receivers);
            dest.readParcelableList(this.providers, boot);
            this.fixupOwner(this.providers);
            dest.readParcelableList(this.services, boot);
            this.fixupOwner(this.services);
            dest.readParcelableList(this.instrumentation, boot);
            this.fixupOwner(this.instrumentation);
            dest.readStringList(this.requestedPermissions);
            Package.internStringArrayList(this.requestedPermissions);
            dest.readStringList(this.implicitPermissions);
            Package.internStringArrayList(this.implicitPermissions);
            this.protectedBroadcasts = dest.createStringArrayList();
            Package.internStringArrayList(this.protectedBroadcasts);
            this.parentPackage = (Package)dest.readParcelable(boot);
            this.childPackages = new ArrayList();
            dest.readParcelableList(this.childPackages, boot);
            if (this.childPackages.size() == 0) {
                this.childPackages = null;
            }
            this.staticSharedLibName = dest.readString();
            if (this.staticSharedLibName != null) {
                this.staticSharedLibName = this.staticSharedLibName.intern();
            }
            this.staticSharedLibVersion = dest.readLong();
            this.libraryNames = dest.createStringArrayList();
            Package.internStringArrayList(this.libraryNames);
            this.usesLibraries = dest.createStringArrayList();
            Package.internStringArrayList(this.usesLibraries);
            this.usesOptionalLibraries = dest.createStringArrayList();
            Package.internStringArrayList(this.usesOptionalLibraries);
            this.usesLibraryFiles = dest.readStringArray();
            this.usesLibraryInfos = dest.createTypedArrayList(SharedLibraryInfo.CREATOR);
            int libCount = dest.readInt();
            if (libCount > 0) {
                this.usesStaticLibraries = new ArrayList(libCount);
                dest.readStringList(this.usesStaticLibraries);
                Package.internStringArrayList(this.usesStaticLibraries);
                this.usesStaticLibrariesVersions = new long[libCount];
                dest.readLongArray(this.usesStaticLibrariesVersions);
                this.usesStaticLibrariesCertDigests = new String[libCount][];
                for (int i = 0; i < libCount; ++i) {
                    this.usesStaticLibrariesCertDigests[i] = dest.createStringArray();
                }
            }
            this.preferredActivityFilters = new ArrayList();
            dest.readParcelableList(this.preferredActivityFilters, boot);
            if (this.preferredActivityFilters.size() == 0) {
                this.preferredActivityFilters = null;
            }
            this.mOriginalPackages = dest.createStringArrayList();
            this.mRealPackage = dest.readString();
            this.mAdoptPermissions = dest.createStringArrayList();
            this.mAppMetaData = dest.readBundle();
            this.mVersionCode = dest.readInt();
            this.mVersionCodeMajor = dest.readInt();
            this.mVersionName = dest.readString();
            if (this.mVersionName != null) {
                this.mVersionName = this.mVersionName.intern();
            }
            this.mSharedUserId = dest.readString();
            if (this.mSharedUserId != null) {
                this.mSharedUserId = this.mSharedUserId.intern();
            }
            this.mSharedUserLabel = dest.readInt();
            this.mSigningDetails = (SigningDetails)dest.readParcelable(boot);
            this.mPreferredOrder = dest.readInt();
            this.configPreferences = new ArrayList();
            dest.readParcelableList(this.configPreferences, boot);
            if (this.configPreferences.size() == 0) {
                this.configPreferences = null;
            }
            this.reqFeatures = new ArrayList();
            dest.readParcelableList(this.reqFeatures, boot);
            if (this.reqFeatures.size() == 0) {
                this.reqFeatures = null;
            }
            this.featureGroups = new ArrayList();
            dest.readParcelableList(this.featureGroups, boot);
            if (this.featureGroups.size() == 0) {
                this.featureGroups = null;
            }
            this.installLocation = dest.readInt();
            this.coreApp = dest.readInt() == 1;
            this.mRequiredForAllUsers = dest.readInt() == 1;
            this.mRestrictedAccountType = dest.readString();
            this.mRequiredAccountType = dest.readString();
            this.mOverlayTarget = dest.readString();
            this.mOverlayTargetName = dest.readString();
            this.mOverlayCategory = dest.readString();
            this.mOverlayPriority = dest.readInt();
            this.mOverlayIsStatic = dest.readInt() == 1;
            this.mCompileSdkVersion = dest.readInt();
            this.mCompileSdkVersionCodename = dest.readString();
            this.mUpgradeKeySets = dest.readArraySet(boot);
            this.mKeySetMapping = Package.readKeySetMapping(dest);
            this.cpuAbiOverride = dest.readString();
            this.use32bitAbi = dest.readInt() == 1;
            this.restrictUpdateHash = dest.createByteArray();
            this.visibleToInstantApps = dest.readInt() == 1;
        }

        private static void internStringArrayList(List<String> list) {
            if (list != null) {
                int N = list.size();
                for (int i = 0; i < N; ++i) {
                    list.set(i, list.get(i).intern());
                }
            }
        }

        private void fixupOwner(List<? extends Component<?>> list) {
            if (list != null) {
                for (Component<?> c : list) {
                    c.owner = this;
                    if (c instanceof Activity) {
                        ((Activity)c).info.applicationInfo = this.applicationInfo;
                        continue;
                    }
                    if (c instanceof Service) {
                        ((Service)c).info.applicationInfo = this.applicationInfo;
                        continue;
                    }
                    if (!(c instanceof Provider)) continue;
                    ((Provider)c).info.applicationInfo = this.applicationInfo;
                }
            }
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.packageName);
            dest.writeString(this.manifestPackageName);
            dest.writeStringArray(this.splitNames);
            dest.writeString(this.volumeUuid);
            dest.writeString(this.codePath);
            dest.writeString(this.baseCodePath);
            dest.writeStringArray(this.splitCodePaths);
            dest.writeInt(this.baseRevisionCode);
            dest.writeIntArray(this.splitRevisionCodes);
            dest.writeIntArray(this.splitFlags);
            dest.writeIntArray(this.splitPrivateFlags);
            dest.writeInt(this.baseHardwareAccelerated ? 1 : 0);
            dest.writeParcelable(this.applicationInfo, flags);
            dest.writeParcelableList(this.permissions, flags);
            dest.writeParcelableList(this.permissionGroups, flags);
            dest.writeParcelableList(this.activities, flags);
            dest.writeParcelableList(this.receivers, flags);
            dest.writeParcelableList(this.providers, flags);
            dest.writeParcelableList(this.services, flags);
            dest.writeParcelableList(this.instrumentation, flags);
            dest.writeStringList(this.requestedPermissions);
            dest.writeStringList(this.implicitPermissions);
            dest.writeStringList(this.protectedBroadcasts);
            dest.writeParcelable(this.parentPackage, flags);
            dest.writeParcelableList(this.childPackages, flags);
            dest.writeString(this.staticSharedLibName);
            dest.writeLong(this.staticSharedLibVersion);
            dest.writeStringList(this.libraryNames);
            dest.writeStringList(this.usesLibraries);
            dest.writeStringList(this.usesOptionalLibraries);
            dest.writeStringArray(this.usesLibraryFiles);
            dest.writeTypedList(this.usesLibraryInfos);
            if (ArrayUtils.isEmpty(this.usesStaticLibraries)) {
                dest.writeInt(-1);
            } else {
                dest.writeInt(this.usesStaticLibraries.size());
                dest.writeStringList(this.usesStaticLibraries);
                dest.writeLongArray(this.usesStaticLibrariesVersions);
                for (String[] usesStaticLibrariesCertDigest : this.usesStaticLibrariesCertDigests) {
                    dest.writeStringArray(usesStaticLibrariesCertDigest);
                }
            }
            dest.writeParcelableList(this.preferredActivityFilters, flags);
            dest.writeStringList(this.mOriginalPackages);
            dest.writeString(this.mRealPackage);
            dest.writeStringList(this.mAdoptPermissions);
            dest.writeBundle(this.mAppMetaData);
            dest.writeInt(this.mVersionCode);
            dest.writeInt(this.mVersionCodeMajor);
            dest.writeString(this.mVersionName);
            dest.writeString(this.mSharedUserId);
            dest.writeInt(this.mSharedUserLabel);
            dest.writeParcelable(this.mSigningDetails, flags);
            dest.writeInt(this.mPreferredOrder);
            dest.writeParcelableList(this.configPreferences, flags);
            dest.writeParcelableList(this.reqFeatures, flags);
            dest.writeParcelableList(this.featureGroups, flags);
            dest.writeInt(this.installLocation);
            dest.writeInt(this.coreApp ? 1 : 0);
            dest.writeInt(this.mRequiredForAllUsers ? 1 : 0);
            dest.writeString(this.mRestrictedAccountType);
            dest.writeString(this.mRequiredAccountType);
            dest.writeString(this.mOverlayTarget);
            dest.writeString(this.mOverlayTargetName);
            dest.writeString(this.mOverlayCategory);
            dest.writeInt(this.mOverlayPriority);
            dest.writeInt(this.mOverlayIsStatic ? 1 : 0);
            dest.writeInt(this.mCompileSdkVersion);
            dest.writeString(this.mCompileSdkVersionCodename);
            dest.writeArraySet(this.mUpgradeKeySets);
            Package.writeKeySetMapping(dest, this.mKeySetMapping);
            dest.writeString(this.cpuAbiOverride);
            dest.writeInt(this.use32bitAbi ? 1 : 0);
            dest.writeByteArray(this.restrictUpdateHash);
            dest.writeInt(this.visibleToInstantApps ? 1 : 0);
        }

        private static void writeKeySetMapping(Parcel dest, ArrayMap<String, ArraySet<PublicKey>> keySetMapping) {
            if (keySetMapping == null) {
                dest.writeInt(-1);
                return;
            }
            int N = keySetMapping.size();
            dest.writeInt(N);
            for (int i = 0; i < N; ++i) {
                dest.writeString(keySetMapping.keyAt(i));
                ArraySet<PublicKey> keys = keySetMapping.valueAt(i);
                if (keys == null) {
                    dest.writeInt(-1);
                    continue;
                }
                int M = keys.size();
                dest.writeInt(M);
                for (int j = 0; j < M; ++j) {
                    dest.writeSerializable(keys.valueAt(j));
                }
            }
        }

        private static ArrayMap<String, ArraySet<PublicKey>> readKeySetMapping(Parcel in) {
            int N = in.readInt();
            if (N == -1) {
                return null;
            }
            ArrayMap<String, ArraySet<PublicKey>> keySetMapping = new ArrayMap<String, ArraySet<PublicKey>>();
            for (int i = 0; i < N; ++i) {
                String key = in.readString();
                int M = in.readInt();
                if (M == -1) {
                    keySetMapping.put(key, null);
                    continue;
                }
                ArraySet<PublicKey> keys = new ArraySet<PublicKey>(M);
                for (int j = 0; j < M; ++j) {
                    PublicKey pk = (PublicKey)in.readSerializable();
                    keys.add(pk);
                }
                keySetMapping.put(key, keys);
            }
            return keySetMapping;
        }
    }

    public static final class SigningDetails
    implements Parcelable {
        @UnsupportedAppUsage
        public final Signature[] signatures;
        @SignatureSchemeVersion
        public final int signatureSchemeVersion;
        public final ArraySet<PublicKey> publicKeys;
        public final Signature[] pastSigningCertificates;
        private static final int PAST_CERT_EXISTS = 0;
        public static final SigningDetails UNKNOWN = new SigningDetails(null, 0, null, null);
        public static final Parcelable.Creator<SigningDetails> CREATOR = new Parcelable.Creator<SigningDetails>(){

            @Override
            public SigningDetails createFromParcel(Parcel source) {
                if (source.readBoolean()) {
                    return UNKNOWN;
                }
                return new SigningDetails(source);
            }

            public SigningDetails[] newArray(int size) {
                return new SigningDetails[size];
            }
        };

        @VisibleForTesting
        public SigningDetails(Signature[] signatures, @SignatureSchemeVersion int signatureSchemeVersion, ArraySet<PublicKey> keys, Signature[] pastSigningCertificates) {
            this.signatures = signatures;
            this.signatureSchemeVersion = signatureSchemeVersion;
            this.publicKeys = keys;
            this.pastSigningCertificates = pastSigningCertificates;
        }

        public SigningDetails(Signature[] signatures, @SignatureSchemeVersion int signatureSchemeVersion, Signature[] pastSigningCertificates) throws CertificateException {
            this(signatures, signatureSchemeVersion, PackageParser.toSigningKeys(signatures), pastSigningCertificates);
        }

        public SigningDetails(Signature[] signatures, @SignatureSchemeVersion int signatureSchemeVersion) throws CertificateException {
            this(signatures, signatureSchemeVersion, null);
        }

        public SigningDetails(SigningDetails orig) {
            if (orig != null) {
                this.signatures = orig.signatures != null ? (Signature[])orig.signatures.clone() : null;
                this.signatureSchemeVersion = orig.signatureSchemeVersion;
                this.publicKeys = new ArraySet<PublicKey>(orig.publicKeys);
                this.pastSigningCertificates = orig.pastSigningCertificates != null ? (Signature[])orig.pastSigningCertificates.clone() : null;
            } else {
                this.signatures = null;
                this.signatureSchemeVersion = 0;
                this.publicKeys = null;
                this.pastSigningCertificates = null;
            }
        }

        public boolean hasSignatures() {
            return this.signatures != null && this.signatures.length > 0;
        }

        public boolean hasPastSigningCertificates() {
            return this.pastSigningCertificates != null && this.pastSigningCertificates.length > 0;
        }

        public boolean hasAncestorOrSelf(SigningDetails oldDetails) {
            if (this == UNKNOWN || oldDetails == UNKNOWN) {
                return false;
            }
            if (oldDetails.signatures.length > 1) {
                return this.signaturesMatchExactly(oldDetails);
            }
            return this.hasCertificate(oldDetails.signatures[0]);
        }

        public boolean hasAncestor(SigningDetails oldDetails) {
            if (this == UNKNOWN || oldDetails == UNKNOWN) {
                return false;
            }
            if (this.hasPastSigningCertificates() && oldDetails.signatures.length == 1) {
                for (int i = 0; i < this.pastSigningCertificates.length - 1; ++i) {
                    if (!this.pastSigningCertificates[i].equals(oldDetails.signatures[i])) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean checkCapability(SigningDetails oldDetails, @CertCapabilities int flags) {
            if (this == UNKNOWN || oldDetails == UNKNOWN) {
                return false;
            }
            if (oldDetails.signatures.length > 1) {
                return this.signaturesMatchExactly(oldDetails);
            }
            return this.hasCertificate(oldDetails.signatures[0], flags);
        }

        public boolean checkCapabilityRecover(SigningDetails oldDetails, @CertCapabilities int flags) throws CertificateException {
            if (oldDetails == UNKNOWN || this == UNKNOWN) {
                return false;
            }
            if (this.hasPastSigningCertificates() && oldDetails.signatures.length == 1) {
                for (int i = 0; i < this.pastSigningCertificates.length; ++i) {
                    if (!Signature.areEffectiveMatch(oldDetails.signatures[0], this.pastSigningCertificates[i]) || this.pastSigningCertificates[i].getFlags() != flags) continue;
                    return true;
                }
            } else {
                return Signature.areEffectiveMatch(oldDetails.signatures, this.signatures);
            }
            return false;
        }

        public boolean hasCertificate(Signature signature) {
            return this.hasCertificateInternal(signature, 0);
        }

        public boolean hasCertificate(Signature signature, @CertCapabilities int flags) {
            return this.hasCertificateInternal(signature, flags);
        }

        public boolean hasCertificate(byte[] certificate) {
            Signature signature = new Signature(certificate);
            return this.hasCertificate(signature);
        }

        private boolean hasCertificateInternal(Signature signature, int flags) {
            if (this == UNKNOWN) {
                return false;
            }
            if (this.hasPastSigningCertificates()) {
                for (int i = 0; i < this.pastSigningCertificates.length - 1; ++i) {
                    if (!this.pastSigningCertificates[i].equals(signature) || flags != 0 && (flags & this.pastSigningCertificates[i].getFlags()) != flags) continue;
                    return true;
                }
            }
            return this.signatures.length == 1 && this.signatures[0].equals(signature);
        }

        public boolean checkCapability(String sha256String, @CertCapabilities int flags) {
            if (this == UNKNOWN) {
                return false;
            }
            byte[] sha256Bytes = ByteStringUtils.fromHexToByteArray(sha256String);
            if (this.hasSha256Certificate(sha256Bytes, flags)) {
                return true;
            }
            String[] mSignaturesSha256Digests = PackageUtils.computeSignaturesSha256Digests(this.signatures);
            String mSignaturesSha256Digest = PackageUtils.computeSignaturesSha256Digest(mSignaturesSha256Digests);
            return mSignaturesSha256Digest.equals(sha256String);
        }

        public boolean hasSha256Certificate(byte[] sha256Certificate) {
            return this.hasSha256CertificateInternal(sha256Certificate, 0);
        }

        public boolean hasSha256Certificate(byte[] sha256Certificate, @CertCapabilities int flags) {
            return this.hasSha256CertificateInternal(sha256Certificate, flags);
        }

        private boolean hasSha256CertificateInternal(byte[] sha256Certificate, int flags) {
            if (this == UNKNOWN) {
                return false;
            }
            if (this.hasPastSigningCertificates()) {
                for (int i = 0; i < this.pastSigningCertificates.length - 1; ++i) {
                    byte[] digest = PackageUtils.computeSha256DigestBytes(this.pastSigningCertificates[i].toByteArray());
                    if (!Arrays.equals(sha256Certificate, digest) || flags != 0 && (flags & this.pastSigningCertificates[i].getFlags()) != flags) continue;
                    return true;
                }
            }
            if (this.signatures.length == 1) {
                byte[] digest = PackageUtils.computeSha256DigestBytes(this.signatures[0].toByteArray());
                return Arrays.equals(sha256Certificate, digest);
            }
            return false;
        }

        public boolean signaturesMatchExactly(SigningDetails other) {
            return Signature.areExactMatch(this.signatures, other.signatures);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            boolean isUnknown = UNKNOWN == this;
            dest.writeBoolean(isUnknown);
            if (isUnknown) {
                return;
            }
            dest.writeTypedArray(this.signatures, flags);
            dest.writeInt(this.signatureSchemeVersion);
            dest.writeArraySet(this.publicKeys);
            dest.writeTypedArray(this.pastSigningCertificates, flags);
        }

        protected SigningDetails(Parcel in) {
            ClassLoader boot = Object.class.getClassLoader();
            this.signatures = in.createTypedArray(Signature.CREATOR);
            this.signatureSchemeVersion = in.readInt();
            this.publicKeys = in.readArraySet(boot);
            this.pastSigningCertificates = in.createTypedArray(Signature.CREATOR);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SigningDetails)) {
                return false;
            }
            SigningDetails that = (SigningDetails)o;
            if (this.signatureSchemeVersion != that.signatureSchemeVersion) {
                return false;
            }
            if (!Signature.areExactMatch(this.signatures, that.signatures)) {
                return false;
            }
            if (this.publicKeys != null ? !this.publicKeys.equals(that.publicKeys) : that.publicKeys != null) {
                return false;
            }
            return Arrays.equals(this.pastSigningCertificates, that.pastSigningCertificates);
        }

        public int hashCode() {
            int result = Arrays.hashCode(this.signatures);
            result = 31 * result + this.signatureSchemeVersion;
            result = 31 * result + (this.publicKeys != null ? this.publicKeys.hashCode() : 0);
            result = 31 * result + Arrays.hashCode(this.pastSigningCertificates);
            return result;
        }

        public static class Builder {
            private Signature[] mSignatures;
            private int mSignatureSchemeVersion = 0;
            private Signature[] mPastSigningCertificates;

            @UnsupportedAppUsage
            public Builder() {
            }

            @UnsupportedAppUsage
            public Builder setSignatures(Signature[] signatures) {
                this.mSignatures = signatures;
                return this;
            }

            @UnsupportedAppUsage
            public Builder setSignatureSchemeVersion(int signatureSchemeVersion) {
                this.mSignatureSchemeVersion = signatureSchemeVersion;
                return this;
            }

            @UnsupportedAppUsage
            public Builder setPastSigningCertificates(Signature[] pastSigningCertificates) {
                this.mPastSigningCertificates = pastSigningCertificates;
                return this;
            }

            private void checkInvariants() {
                if (this.mSignatures == null) {
                    throw new IllegalStateException("SigningDetails requires the current signing certificates.");
                }
            }

            @UnsupportedAppUsage
            public SigningDetails build() throws CertificateException {
                this.checkInvariants();
                return new SigningDetails(this.mSignatures, this.mSignatureSchemeVersion, this.mPastSigningCertificates);
            }
        }

        public static @interface CertCapabilities {
            public static final int INSTALLED_DATA = 1;
            public static final int SHARED_USER_ID = 2;
            public static final int PERMISSION = 4;
            public static final int ROLLBACK = 8;
            public static final int AUTH = 16;
        }

        public static @interface SignatureSchemeVersion {
            public static final int UNKNOWN = 0;
            public static final int JAR = 1;
            public static final int SIGNING_BLOCK_V2 = 2;
            public static final int SIGNING_BLOCK_V3 = 3;
        }
    }

    private static class SplitNameComparator
    implements Comparator<String> {
        private SplitNameComparator() {
        }

        @Override
        public int compare(String lhs, String rhs) {
            if (lhs == null) {
                return -1;
            }
            if (rhs == null) {
                return 1;
            }
            return lhs.compareTo(rhs);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ParseFlags {
    }

    public static final class CallbackImpl
    implements Callback {
        private final PackageManager mPm;

        public CallbackImpl(PackageManager pm) {
            this.mPm = pm;
        }

        @Override
        public boolean hasFeature(String feature) {
            return this.mPm.hasSystemFeature(feature);
        }

        @Override
        public String[] getOverlayPaths(String targetPackageName, String targetPath) {
            return null;
        }

        @Override
        public String[] getOverlayApks(String targetPackageName) {
            return null;
        }
    }

    public static interface Callback {
        public boolean hasFeature(String var1);

        public String[] getOverlayPaths(String var1, String var2);

        public String[] getOverlayApks(String var1);
    }

    private static class CachedComponentArgs {
        ParseComponentArgs mActivityArgs;
        ParseComponentArgs mActivityAliasArgs;
        ParseComponentArgs mServiceArgs;
        ParseComponentArgs mProviderArgs;

        private CachedComponentArgs() {
        }
    }

    public static class ApkLite {
        public final String codePath;
        public final String packageName;
        public final String splitName;
        public boolean isFeatureSplit;
        public final String configForSplit;
        public final String usesSplitName;
        public final int versionCode;
        public final int versionCodeMajor;
        public final int revisionCode;
        public final int installLocation;
        public final int minSdkVersion;
        public final int targetSdkVersion;
        public final VerifierInfo[] verifiers;
        public final SigningDetails signingDetails;
        public final boolean coreApp;
        public final boolean debuggable;
        public final boolean multiArch;
        public final boolean use32bitAbi;
        public final boolean extractNativeLibs;
        public final boolean isolatedSplits;
        public final boolean isSplitRequired;
        public final boolean useEmbeddedDex;

        public ApkLite(String codePath, String packageName, String splitName, boolean isFeatureSplit, String configForSplit, String usesSplitName, boolean isSplitRequired, int versionCode, int versionCodeMajor, int revisionCode, int installLocation, List<VerifierInfo> verifiers, SigningDetails signingDetails, boolean coreApp, boolean debuggable, boolean multiArch, boolean use32bitAbi, boolean useEmbeddedDex, boolean extractNativeLibs, boolean isolatedSplits, int minSdkVersion, int targetSdkVersion) {
            this.codePath = codePath;
            this.packageName = packageName;
            this.splitName = splitName;
            this.isFeatureSplit = isFeatureSplit;
            this.configForSplit = configForSplit;
            this.usesSplitName = usesSplitName;
            this.versionCode = versionCode;
            this.versionCodeMajor = versionCodeMajor;
            this.revisionCode = revisionCode;
            this.installLocation = installLocation;
            this.signingDetails = signingDetails;
            this.verifiers = verifiers.toArray(new VerifierInfo[verifiers.size()]);
            this.coreApp = coreApp;
            this.debuggable = debuggable;
            this.multiArch = multiArch;
            this.use32bitAbi = use32bitAbi;
            this.useEmbeddedDex = useEmbeddedDex;
            this.extractNativeLibs = extractNativeLibs;
            this.isolatedSplits = isolatedSplits;
            this.isSplitRequired = isSplitRequired;
            this.minSdkVersion = minSdkVersion;
            this.targetSdkVersion = targetSdkVersion;
        }

        public long getLongVersionCode() {
            return PackageInfo.composeLongVersionCode(this.versionCodeMajor, this.versionCode);
        }
    }

    public static class PackageLite {
        @UnsupportedAppUsage
        public final String packageName;
        public final int versionCode;
        public final int versionCodeMajor;
        @UnsupportedAppUsage
        public final int installLocation;
        public final VerifierInfo[] verifiers;
        public final String[] splitNames;
        public final boolean[] isFeatureSplits;
        public final String[] usesSplitNames;
        public final String[] configForSplit;
        public final String codePath;
        public final String baseCodePath;
        public final String[] splitCodePaths;
        public final int baseRevisionCode;
        public final int[] splitRevisionCodes;
        public final boolean coreApp;
        public final boolean debuggable;
        public final boolean multiArch;
        public final boolean use32bitAbi;
        public final boolean extractNativeLibs;
        public final boolean isolatedSplits;

        public PackageLite(String codePath, ApkLite baseApk, String[] splitNames, boolean[] isFeatureSplits, String[] usesSplitNames, String[] configForSplit, String[] splitCodePaths, int[] splitRevisionCodes) {
            this.packageName = baseApk.packageName;
            this.versionCode = baseApk.versionCode;
            this.versionCodeMajor = baseApk.versionCodeMajor;
            this.installLocation = baseApk.installLocation;
            this.verifiers = baseApk.verifiers;
            this.splitNames = splitNames;
            this.isFeatureSplits = isFeatureSplits;
            this.usesSplitNames = usesSplitNames;
            this.configForSplit = configForSplit;
            this.codePath = codePath;
            this.baseCodePath = baseApk.codePath;
            this.splitCodePaths = splitCodePaths;
            this.baseRevisionCode = baseApk.revisionCode;
            this.splitRevisionCodes = splitRevisionCodes;
            this.coreApp = baseApk.coreApp;
            this.debuggable = baseApk.debuggable;
            this.multiArch = baseApk.multiArch;
            this.use32bitAbi = baseApk.use32bitAbi;
            this.extractNativeLibs = baseApk.extractNativeLibs;
            this.isolatedSplits = baseApk.isolatedSplits;
        }

        public List<String> getAllCodePaths() {
            ArrayList<String> paths = new ArrayList<String>();
            paths.add(this.baseCodePath);
            if (!ArrayUtils.isEmpty(this.splitCodePaths)) {
                Collections.addAll(paths, this.splitCodePaths);
            }
            return paths;
        }
    }

    @VisibleForTesting
    public static class ParseComponentArgs
    extends ParsePackageItemArgs {
        final String[] sepProcesses;
        final int processRes;
        final int descriptionRes;
        final int enabledRes;
        int flags;

        public ParseComponentArgs(Package _owner, String[] _outError, int _nameRes, int _labelRes, int _iconRes, int _roundIconRes, int _logoRes, int _bannerRes, String[] _sepProcesses, int _processRes, int _descriptionRes, int _enabledRes) {
            super(_owner, _outError, _nameRes, _labelRes, _iconRes, _roundIconRes, _logoRes, _bannerRes);
            this.sepProcesses = _sepProcesses;
            this.processRes = _processRes;
            this.descriptionRes = _descriptionRes;
            this.enabledRes = _enabledRes;
        }
    }

    static class ParsePackageItemArgs {
        final Package owner;
        final String[] outError;
        final int nameRes;
        final int labelRes;
        final int iconRes;
        final int roundIconRes;
        final int logoRes;
        final int bannerRes;
        String tag;
        TypedArray sa;

        ParsePackageItemArgs(Package _owner, String[] _outError, int _nameRes, int _labelRes, int _iconRes, int _roundIconRes, int _logoRes, int _bannerRes) {
            this.owner = _owner;
            this.outError = _outError;
            this.nameRes = _nameRes;
            this.labelRes = _labelRes;
            this.iconRes = _iconRes;
            this.logoRes = _logoRes;
            this.bannerRes = _bannerRes;
            this.roundIconRes = _roundIconRes;
        }
    }

    public static class NewPermissionInfo {
        @UnsupportedAppUsage
        public final String name;
        @UnsupportedAppUsage
        public final int sdkVersion;
        public final int fileVersion;

        public NewPermissionInfo(String name, int sdkVersion, int fileVersion) {
            this.name = name;
            this.sdkVersion = sdkVersion;
            this.fileVersion = fileVersion;
        }
    }
}

