/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm.dex;

import android.content.pm.PackageParser;
import android.util.ArrayMap;
import android.util.jar.StrictJarFile;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class DexMetadataHelper {
    private static final String DEX_METADATA_FILE_EXTENSION = ".dm";

    private DexMetadataHelper() {
    }

    public static boolean isDexMetadataFile(File file) {
        return DexMetadataHelper.isDexMetadataPath(file.getName());
    }

    private static boolean isDexMetadataPath(String path) {
        return path.endsWith(DEX_METADATA_FILE_EXTENSION);
    }

    public static long getPackageDexMetadataSize(PackageParser.PackageLite pkg) {
        long sizeBytes = 0L;
        Collection<String> dexMetadataList = DexMetadataHelper.getPackageDexMetadata(pkg).values();
        for (String dexMetadata : dexMetadataList) {
            sizeBytes += new File(dexMetadata).length();
        }
        return sizeBytes;
    }

    public static File findDexMetadataForFile(File targetFile) {
        String dexMetadataPath = DexMetadataHelper.buildDexMetadataPathForFile(targetFile);
        File dexMetadataFile = new File(dexMetadataPath);
        return dexMetadataFile.exists() ? dexMetadataFile : null;
    }

    public static Map<String, String> getPackageDexMetadata(PackageParser.Package pkg) {
        return DexMetadataHelper.buildPackageApkToDexMetadataMap(pkg.getAllCodePaths());
    }

    private static Map<String, String> getPackageDexMetadata(PackageParser.PackageLite pkg) {
        return DexMetadataHelper.buildPackageApkToDexMetadataMap(pkg.getAllCodePaths());
    }

    private static Map<String, String> buildPackageApkToDexMetadataMap(List<String> codePaths) {
        ArrayMap<String, String> result = new ArrayMap<String, String>();
        for (int i = codePaths.size() - 1; i >= 0; --i) {
            String codePath = codePaths.get(i);
            String dexMetadataPath = DexMetadataHelper.buildDexMetadataPathForFile(new File(codePath));
            if (!Files.exists(Paths.get(dexMetadataPath, new String[0]), new LinkOption[0])) continue;
            result.put(codePath, dexMetadataPath);
        }
        return result;
    }

    public static String buildDexMetadataPathForApk(String codePath) {
        if (!PackageParser.isApkPath(codePath)) {
            throw new IllegalStateException("Corrupted package. Code path is not an apk " + codePath);
        }
        return codePath.substring(0, codePath.length() - ".apk".length()) + DEX_METADATA_FILE_EXTENSION;
    }

    private static String buildDexMetadataPathForFile(File targetFile) {
        return PackageParser.isApkFile(targetFile) ? DexMetadataHelper.buildDexMetadataPathForApk(targetFile.getPath()) : targetFile.getPath() + DEX_METADATA_FILE_EXTENSION;
    }

    public static void validatePackageDexMetadata(PackageParser.Package pkg) throws PackageParser.PackageParserException {
        Collection<String> apkToDexMetadataList = DexMetadataHelper.getPackageDexMetadata(pkg).values();
        for (String dexMetadata : apkToDexMetadataList) {
            DexMetadataHelper.validateDexMetadataFile(dexMetadata);
        }
    }

    private static void validateDexMetadataFile(String dmaPath) throws PackageParser.PackageParserException {
        StrictJarFile jarFile = null;
        try {
            jarFile = new StrictJarFile(dmaPath, false, false);
        }
        catch (IOException e) {
            throw new PackageParser.PackageParserException(-117, "Error opening " + dmaPath, e);
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void validateDexPaths(String[] paths) {
        ArrayList<String> apks = new ArrayList<String>();
        for (int i = 0; i < paths.length; ++i) {
            if (!PackageParser.isApkPath(paths[i])) continue;
            apks.add(paths[i]);
        }
        ArrayList<String> unmatchedDmFiles = new ArrayList<String>();
        for (int i = 0; i < paths.length; ++i) {
            String dmPath = paths[i];
            if (!DexMetadataHelper.isDexMetadataPath(dmPath)) continue;
            boolean valid = false;
            for (int j = apks.size() - 1; j >= 0; --j) {
                if (!dmPath.equals(DexMetadataHelper.buildDexMetadataPathForFile(new File((String)apks.get(j))))) continue;
                valid = true;
                break;
            }
            if (valid) continue;
            unmatchedDmFiles.add(dmPath);
        }
        if (!unmatchedDmFiles.isEmpty()) {
            throw new IllegalStateException("Unmatched .dm files: " + unmatchedDmFiles);
        }
    }
}

