/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.annotation.UnsupportedAppUsage;
import android.content.res.StringBlock;
import android.content.res.XmlBlock;
import android.content.res.XmlResourceParser;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.Preconditions;
import java.io.FileDescriptor;
import java.io.IOException;

public final class ApkAssets {
    @GuardedBy(value={"this"})
    private final long mNativePtr;
    @GuardedBy(value={"this"})
    private final StringBlock mStringBlock;
    @GuardedBy(value={"this"})
    private boolean mOpen = true;

    public static ApkAssets loadFromPath(String path) throws IOException {
        return new ApkAssets(path, false, false, false);
    }

    public static ApkAssets loadFromPath(String path, boolean system) throws IOException {
        return new ApkAssets(path, system, false, false);
    }

    public static ApkAssets loadFromPath(String path, boolean system, boolean forceSharedLibrary) throws IOException {
        return new ApkAssets(path, system, forceSharedLibrary, false);
    }

    public static ApkAssets loadFromFd(FileDescriptor fd, String friendlyName, boolean system, boolean forceSharedLibrary) throws IOException {
        return new ApkAssets(fd, friendlyName, system, forceSharedLibrary);
    }

    public static ApkAssets loadOverlayFromPath(String idmapPath, boolean system) throws IOException {
        return new ApkAssets(idmapPath, system, false, true);
    }

    private ApkAssets(String path, boolean system, boolean forceSharedLib, boolean overlay) throws IOException {
        Preconditions.checkNotNull(path, "path");
        this.mNativePtr = ApkAssets.nativeLoad(path, system, forceSharedLib, overlay);
        this.mStringBlock = new StringBlock(ApkAssets.nativeGetStringBlock(this.mNativePtr), true);
    }

    private ApkAssets(FileDescriptor fd, String friendlyName, boolean system, boolean forceSharedLib) throws IOException {
        Preconditions.checkNotNull(fd, "fd");
        Preconditions.checkNotNull(friendlyName, "friendlyName");
        this.mNativePtr = ApkAssets.nativeLoadFromFd(fd, friendlyName, system, forceSharedLib);
        this.mStringBlock = new StringBlock(ApkAssets.nativeGetStringBlock(this.mNativePtr), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public String getAssetPath() {
        ApkAssets apkAssets = this;
        synchronized (apkAssets) {
            return ApkAssets.nativeGetAssetPath(this.mNativePtr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CharSequence getStringFromPool(int idx) {
        ApkAssets apkAssets = this;
        synchronized (apkAssets) {
            return this.mStringBlock.get(idx);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XmlResourceParser openXml(String fileName) throws IOException {
        Preconditions.checkNotNull(fileName, "fileName");
        ApkAssets apkAssets = this;
        synchronized (apkAssets) {
            long nativeXmlPtr = ApkAssets.nativeOpenXml(this.mNativePtr, fileName);
            try (XmlBlock block = new XmlBlock(null, nativeXmlPtr);){
                XmlResourceParser parser = block.newParser();
                if (parser == null) {
                    throw new AssertionError((Object)"block.newParser() returned a null parser");
                }
                XmlResourceParser xmlResourceParser = parser;
                return xmlResourceParser;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUpToDate() {
        ApkAssets apkAssets = this;
        synchronized (apkAssets) {
            return ApkAssets.nativeIsUpToDate(this.mNativePtr);
        }
    }

    public String toString() {
        return "ApkAssets{path=" + this.getAssetPath() + "}";
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws Throwable {
        ApkAssets apkAssets = this;
        synchronized (apkAssets) {
            if (this.mOpen) {
                this.mOpen = false;
                this.mStringBlock.close();
                ApkAssets.nativeDestroy(this.mNativePtr);
            }
        }
    }

    private static native long nativeLoad(String var0, boolean var1, boolean var2, boolean var3) throws IOException;

    private static native long nativeLoadFromFd(FileDescriptor var0, String var1, boolean var2, boolean var3) throws IOException;

    private static native void nativeDestroy(long var0);

    private static native String nativeGetAssetPath(long var0);

    private static native long nativeGetStringBlock(long var0);

    private static native boolean nativeIsUpToDate(long var0);

    private static native long nativeOpenXml(long var0, String var2) throws IOException;
}

