/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.annotation.UnsupportedAppUsage;
import android.content.pm.ActivityInfo;
import android.content.res.ApkAssets;
import android.content.res.AssetFileDescriptor;
import android.content.res.Configuration;
import android.content.res.XmlBlock;
import android.content.res.XmlResourceParser;
import android.os.ParcelFileDescriptor;
import android.util.ArraySet;
import android.util.Log;
import android.util.SparseArray;
import android.util.TypedValue;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.Preconditions;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import libcore.io.IoUtils;

public final class AssetManager
implements AutoCloseable {
    private static final String TAG = "AssetManager";
    private static final boolean DEBUG_REFS = false;
    private static final boolean FEATURE_FLAG_IDMAP2 = true;
    private static final String FRAMEWORK_APK_PATH = "/system/framework/framework-res.apk";
    private static final Object sSync = new Object();
    private static final ApkAssets[] sEmptyApkAssets = new ApkAssets[0];
    @UnsupportedAppUsage
    @GuardedBy(value={"sSync"})
    static AssetManager sSystem = null;
    @GuardedBy(value={"sSync"})
    private static ApkAssets[] sSystemApkAssets = new ApkAssets[0];
    @GuardedBy(value={"sSync"})
    private static ArraySet<ApkAssets> sSystemApkAssetsSet;
    public static final int ACCESS_UNKNOWN = 0;
    public static final int ACCESS_RANDOM = 1;
    public static final int ACCESS_STREAMING = 2;
    public static final int ACCESS_BUFFER = 3;
    @GuardedBy(value={"this"})
    private final TypedValue mValue = new TypedValue();
    @GuardedBy(value={"this"})
    private final long[] mOffsets = new long[2];
    @UnsupportedAppUsage
    @GuardedBy(value={"this"})
    private long mObject;
    @GuardedBy(value={"this"})
    private ApkAssets[] mApkAssets;
    @GuardedBy(value={"this"})
    private boolean mOpen = true;
    @GuardedBy(value={"this"})
    private int mNumRefs = 1;
    @GuardedBy(value={"this"})
    private HashMap<Long, RuntimeException> mRefStacks;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public AssetManager() {
        ApkAssets[] assets;
        Object object = sSync;
        synchronized (object) {
            AssetManager.createSystemAssetsInZygoteLocked();
            assets = sSystemApkAssets;
        }
        this.mObject = AssetManager.nativeCreate();
        this.setApkAssets(assets, false);
    }

    private AssetManager(boolean sentinel) {
        this.mObject = AssetManager.nativeCreate();
    }

    @GuardedBy(value={"sSync"})
    private static void createSystemAssetsInZygoteLocked() {
        if (sSystem != null) {
            return;
        }
        try {
            ArrayList<ApkAssets> apkAssets = new ArrayList<ApkAssets>();
            apkAssets.add(ApkAssets.loadFromPath(FRAMEWORK_APK_PATH, true));
            String[] systemIdmapPaths = AssetManager.nativeCreateIdmapsForStaticOverlaysTargetingAndroid();
            if (systemIdmapPaths != null) {
                for (String idmapPath : systemIdmapPaths) {
                    apkAssets.add(ApkAssets.loadOverlayFromPath(idmapPath, true));
                }
            } else {
                Log.w(TAG, "'idmap2 --scan' failed: no static=\"true\" overlays targeting \"android\" will be loaded");
            }
            sSystemApkAssetsSet = new ArraySet(apkAssets);
            sSystemApkAssets = apkAssets.toArray(new ApkAssets[apkAssets.size()]);
            sSystem = new AssetManager(true);
            sSystem.setApkAssets(sSystemApkAssets, false);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create system AssetManager", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadStaticRuntimeOverlays(ArrayList<ApkAssets> outApkAssets) throws IOException {
        FileInputStream fis;
        try {
            fis = new FileInputStream("/data/resource-cache/overlays.list");
        }
        catch (FileNotFoundException e) {
            Log.i(TAG, "no overlays.list file found");
            return;
        }
        try (BufferedReader br = new BufferedReader(new InputStreamReader(fis));
             FileLock flock = fis.getChannel().lock(0L, Long.MAX_VALUE, true);){
            String line;
            while ((line = br.readLine()) != null) {
                String idmapPath = line.split(" ")[1];
                outApkAssets.add(ApkAssets.loadOverlayFromPath(idmapPath, true));
            }
        }
        finally {
            IoUtils.closeQuietly(fis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public static AssetManager getSystem() {
        Object object = sSync;
        synchronized (object) {
            AssetManager.createSystemAssetsInZygoteLocked();
            return sSystem;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            if (!this.mOpen) {
                return;
            }
            this.mOpen = false;
            this.decRefsLocked(this.hashCode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setApkAssets(ApkAssets[] apkAssets, boolean invalidateCaches) {
        Preconditions.checkNotNull(apkAssets, "apkAssets");
        ApkAssets[] newApkAssets = new ApkAssets[sSystemApkAssets.length + apkAssets.length];
        System.arraycopy(sSystemApkAssets, 0, newApkAssets, 0, sSystemApkAssets.length);
        int newLength = sSystemApkAssets.length;
        for (ApkAssets apkAsset : apkAssets) {
            if (sSystemApkAssetsSet.contains(apkAsset)) continue;
            newApkAssets[newLength++] = apkAsset;
        }
        if (newLength != newApkAssets.length) {
            newApkAssets = Arrays.copyOf(newApkAssets, newLength);
        }
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureOpenLocked();
            this.mApkAssets = newApkAssets;
            AssetManager.nativeSetApkAssets(this.mObject, this.mApkAssets, invalidateCaches);
            if (invalidateCaches) {
                this.invalidateCachesLocked(-1);
            }
        }
    }

    private void invalidateCachesLocked(int diff) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public ApkAssets[] getApkAssets() {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            if (this.mOpen) {
                return this.mApkAssets;
            }
        }
        return sEmptyApkAssets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getApkPaths() {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            if (this.mOpen) {
                String[] paths = new String[this.mApkAssets.length];
                int count = this.mApkAssets.length;
                for (int i = 0; i < count; ++i) {
                    paths[i] = this.mApkAssets[i].getAssetPath();
                }
                return paths;
            }
        }
        return new String[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findCookieForPath(String path) {
        Preconditions.checkNotNull(path, "path");
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            int count = this.mApkAssets.length;
            for (int i = 0; i < count; ++i) {
                if (!path.equals(this.mApkAssets[i].getAssetPath())) continue;
                return i + 1;
            }
        }
        return 0;
    }

    @Deprecated
    @UnsupportedAppUsage
    public int addAssetPath(String path) {
        return this.addAssetPathInternal(path, false, false);
    }

    @Deprecated
    @UnsupportedAppUsage
    public int addAssetPathAsSharedLibrary(String path) {
        return this.addAssetPathInternal(path, false, true);
    }

    @Deprecated
    @UnsupportedAppUsage
    public int addOverlayPath(String path) {
        return this.addAssetPathInternal(path, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int addAssetPathInternal(String path, boolean overlay, boolean appAsLib) {
        Preconditions.checkNotNull(path, "path");
        AssetManager assetManager = this;
        synchronized (assetManager) {
            ApkAssets assets;
            this.ensureOpenLocked();
            int count = this.mApkAssets.length;
            for (int i = 0; i < count; ++i) {
                if (!this.mApkAssets[i].getAssetPath().equals(path)) continue;
                return i + 1;
            }
            try {
                if (overlay) {
                    String idmapPath = "/data/resource-cache/" + path.substring(1).replace('/', '@') + "@idmap";
                    assets = ApkAssets.loadOverlayFromPath(idmapPath, false);
                } else {
                    assets = ApkAssets.loadFromPath(path, false, appAsLib);
                }
            }
            catch (IOException e) {
                return 0;
            }
            this.mApkAssets = Arrays.copyOf(this.mApkAssets, count + 1);
            this.mApkAssets[count] = assets;
            AssetManager.nativeSetApkAssets(this.mObject, this.mApkAssets, true);
            this.invalidateCachesLocked(-1);
            return count + 1;
        }
    }

    @GuardedBy(value={"this"})
    private void ensureValidLocked() {
        if (this.mObject == 0L) {
            throw new RuntimeException("AssetManager has been destroyed");
        }
    }

    @GuardedBy(value={"this"})
    private void ensureOpenLocked() {
        if (!this.mOpen) {
            throw new RuntimeException("AssetManager has been closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    boolean getResourceValue(int resId, int densityDpi, TypedValue outValue, boolean resolveRefs) {
        Preconditions.checkNotNull(outValue, "outValue");
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            int cookie = AssetManager.nativeGetResourceValue(this.mObject, resId, (short)densityDpi, outValue, resolveRefs);
            if (cookie <= 0) {
                return false;
            }
            outValue.changingConfigurations = ActivityInfo.activityInfoConfigNativeToJava(outValue.changingConfigurations);
            if (outValue.type == 3) {
                outValue.string = this.mApkAssets[cookie - 1].getStringFromPool(outValue.data);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    CharSequence getResourceText(int resId) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            TypedValue outValue = this.mValue;
            if (this.getResourceValue(resId, 0, outValue, true)) {
                return outValue.coerceToString();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    CharSequence getResourceBagText(int resId, int bagEntryId) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            TypedValue outValue = this.mValue;
            int cookie = AssetManager.nativeGetResourceBagValue(this.mObject, resId, bagEntryId, outValue);
            if (cookie <= 0) {
                return null;
            }
            outValue.changingConfigurations = ActivityInfo.activityInfoConfigNativeToJava(outValue.changingConfigurations);
            if (outValue.type == 3) {
                return this.mApkAssets[cookie - 1].getStringFromPool(outValue.data);
            }
            return outValue.coerceToString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getResourceArraySize(int resId) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeGetResourceArraySize(this.mObject, resId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getResourceArray(int resId, int[] outData) {
        Preconditions.checkNotNull(outData, "outData");
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeGetResourceArray(this.mObject, resId, outData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] getResourceStringArray(int resId) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeGetResourceStringArray(this.mObject, resId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CharSequence[] getResourceTextArray(int resId) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            int[] rawInfoArray = AssetManager.nativeGetResourceStringArrayInfo(this.mObject, resId);
            if (rawInfoArray == null) {
                return null;
            }
            int rawInfoArrayLen = rawInfoArray.length;
            int infoArrayLen = rawInfoArrayLen / 2;
            CharSequence[] retArray = new CharSequence[infoArrayLen];
            int i = 0;
            int j = 0;
            while (i < rawInfoArrayLen) {
                int cookie = rawInfoArray[i];
                int index = rawInfoArray[i + 1];
                retArray[j] = index >= 0 && cookie > 0 ? this.mApkAssets[cookie - 1].getStringFromPool(index) : null;
                i += 2;
                ++j;
            }
            return retArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int[] getResourceIntArray(int resId) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeGetResourceIntArray(this.mObject, resId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int[] getStyleAttributes(int resId) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeGetStyleAttributes(this.mObject, resId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getThemeValue(long theme, int resId, TypedValue outValue, boolean resolveRefs) {
        Preconditions.checkNotNull(outValue, "outValue");
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            int cookie = AssetManager.nativeThemeGetAttributeValue(this.mObject, theme, resId, outValue, resolveRefs);
            if (cookie <= 0) {
                return false;
            }
            outValue.changingConfigurations = ActivityInfo.activityInfoConfigNativeToJava(outValue.changingConfigurations);
            if (outValue.type == 3) {
                outValue.string = this.mApkAssets[cookie - 1].getStringFromPool(outValue.data);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dumpTheme(long theme, int priority, String tag, String prefix) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            AssetManager.nativeThemeDump(this.mObject, theme, priority, tag, prefix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    String getResourceName(int resId) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeGetResourceName(this.mObject, resId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    String getResourcePackageName(int resId) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeGetResourcePackageName(this.mObject, resId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    String getResourceTypeName(int resId) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeGetResourceTypeName(this.mObject, resId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    String getResourceEntryName(int resId) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeGetResourceEntryName(this.mObject, resId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    int getResourceIdentifier(String name, String defType, String defPackage) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeGetResourceIdentifier(this.mObject, name, defType, defPackage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResourceResolutionLoggingEnabled(boolean enabled) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            AssetManager.nativeSetResourceResolutionLoggingEnabled(this.mObject, enabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLastResourceResolution() {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeGetLastResourceResolution(this.mObject);
        }
    }

    CharSequence getPooledStringForCookie(int cookie, int id2) {
        return this.getApkAssets()[cookie - 1].getStringFromPool(id2);
    }

    public InputStream open(String fileName) throws IOException {
        return this.open(fileName, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream open(String fileName, int accessMode) throws IOException {
        Preconditions.checkNotNull(fileName, "fileName");
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureOpenLocked();
            long asset = AssetManager.nativeOpenAsset(this.mObject, fileName, accessMode);
            if (asset == 0L) {
                throw new FileNotFoundException("Asset file: " + fileName);
            }
            AssetInputStream assetInputStream = new AssetInputStream(asset);
            this.incRefsLocked(assetInputStream.hashCode());
            return assetInputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AssetFileDescriptor openFd(String fileName) throws IOException {
        Preconditions.checkNotNull(fileName, "fileName");
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureOpenLocked();
            ParcelFileDescriptor pfd = AssetManager.nativeOpenAssetFd(this.mObject, fileName, this.mOffsets);
            if (pfd == null) {
                throw new FileNotFoundException("Asset file: " + fileName);
            }
            return new AssetFileDescriptor(pfd, this.mOffsets[0], this.mOffsets[1]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] list(String path) throws IOException {
        Preconditions.checkNotNull(path, "path");
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeList(this.mObject, path);
        }
    }

    @UnsupportedAppUsage
    public InputStream openNonAsset(String fileName) throws IOException {
        return this.openNonAsset(0, fileName, 2);
    }

    @UnsupportedAppUsage
    public InputStream openNonAsset(String fileName, int accessMode) throws IOException {
        return this.openNonAsset(0, fileName, accessMode);
    }

    @UnsupportedAppUsage
    public InputStream openNonAsset(int cookie, String fileName) throws IOException {
        return this.openNonAsset(cookie, fileName, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public InputStream openNonAsset(int cookie, String fileName, int accessMode) throws IOException {
        Preconditions.checkNotNull(fileName, "fileName");
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureOpenLocked();
            long asset = AssetManager.nativeOpenNonAsset(this.mObject, cookie, fileName, accessMode);
            if (asset == 0L) {
                throw new FileNotFoundException("Asset absolute file: " + fileName);
            }
            AssetInputStream assetInputStream = new AssetInputStream(asset);
            this.incRefsLocked(assetInputStream.hashCode());
            return assetInputStream;
        }
    }

    public AssetFileDescriptor openNonAssetFd(String fileName) throws IOException {
        return this.openNonAssetFd(0, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AssetFileDescriptor openNonAssetFd(int cookie, String fileName) throws IOException {
        Preconditions.checkNotNull(fileName, "fileName");
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureOpenLocked();
            ParcelFileDescriptor pfd = AssetManager.nativeOpenNonAssetFd(this.mObject, cookie, fileName, this.mOffsets);
            if (pfd == null) {
                throw new FileNotFoundException("Asset absolute file: " + fileName);
            }
            return new AssetFileDescriptor(pfd, this.mOffsets[0], this.mOffsets[1]);
        }
    }

    public XmlResourceParser openXmlResourceParser(String fileName) throws IOException {
        return this.openXmlResourceParser(0, fileName);
    }

    public XmlResourceParser openXmlResourceParser(int cookie, String fileName) throws IOException {
        try (XmlBlock block = this.openXmlBlockAsset(cookie, fileName);){
            XmlResourceParser parser = block.newParser();
            if (parser == null) {
                throw new AssertionError((Object)"block.newParser() returned a null parser");
            }
            XmlResourceParser xmlResourceParser = parser;
            return xmlResourceParser;
        }
    }

    XmlBlock openXmlBlockAsset(String fileName) throws IOException {
        return this.openXmlBlockAsset(0, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XmlBlock openXmlBlockAsset(int cookie, String fileName) throws IOException {
        Preconditions.checkNotNull(fileName, "fileName");
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureOpenLocked();
            long xmlBlock = AssetManager.nativeOpenXmlAsset(this.mObject, cookie, fileName);
            if (xmlBlock == 0L) {
                throw new FileNotFoundException("Asset XML file: " + fileName);
            }
            XmlBlock block = new XmlBlock(this, xmlBlock);
            this.incRefsLocked(block.hashCode());
            return block;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void xmlBlockGone(int id2) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.decRefsLocked(id2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    void applyStyle(long themePtr, int defStyleAttr, int defStyleRes, XmlBlock.Parser parser, int[] inAttrs, long outValuesAddress, long outIndicesAddress) {
        Preconditions.checkNotNull(inAttrs, "inAttrs");
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            AssetManager.nativeApplyStyle(this.mObject, themePtr, defStyleAttr, defStyleRes, parser != null ? parser.mParseState : 0L, inAttrs, outValuesAddress, outIndicesAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int[] getAttributeResolutionStack(long themePtr, int defStyleAttr, int defStyleRes, int xmlStyle) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            return AssetManager.nativeAttributeResolutionStack(this.mObject, themePtr, xmlStyle, defStyleAttr, defStyleRes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    boolean resolveAttrs(long themePtr, int defStyleAttr, int defStyleRes, int[] inValues, int[] inAttrs, int[] outValues, int[] outIndices) {
        Preconditions.checkNotNull(inAttrs, "inAttrs");
        Preconditions.checkNotNull(outValues, "outValues");
        Preconditions.checkNotNull(outIndices, "outIndices");
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeResolveAttrs(this.mObject, themePtr, defStyleAttr, defStyleRes, inValues, inAttrs, outValues, outIndices);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    boolean retrieveAttributes(XmlBlock.Parser parser, int[] inAttrs, int[] outValues, int[] outIndices) {
        Preconditions.checkNotNull(parser, "parser");
        Preconditions.checkNotNull(inAttrs, "inAttrs");
        Preconditions.checkNotNull(outValues, "outValues");
        Preconditions.checkNotNull(outIndices, "outIndices");
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeRetrieveAttributes(this.mObject, parser.mParseState, inAttrs, outValues, outIndices);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    long createTheme() {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            long themePtr = AssetManager.nativeThemeCreate(this.mObject);
            this.incRefsLocked(themePtr);
            return themePtr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseTheme(long themePtr) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            AssetManager.nativeThemeDestroy(themePtr);
            this.decRefsLocked(themePtr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void applyStyleToTheme(long themePtr, int resId, boolean force) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            AssetManager.nativeThemeApplyStyle(this.mObject, themePtr, resId, force);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    void setThemeTo(long dstThemePtr, AssetManager srcAssetManager, long srcThemePtr) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            AssetManager assetManager2 = srcAssetManager;
            synchronized (assetManager2) {
                srcAssetManager.ensureValidLocked();
                AssetManager.nativeThemeCopy(this.mObject, dstThemePtr, srcAssetManager.mObject, srcThemePtr);
            }
        }
    }

    protected void finalize() throws Throwable {
        if (this.mObject != 0L) {
            AssetManager.nativeDestroy(this.mObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public boolean isUpToDate() {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            if (!this.mOpen) {
                return false;
            }
            for (ApkAssets apkAssets : this.mApkAssets) {
                if (apkAssets.isUpToDate()) continue;
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getLocales() {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeGetLocales(this.mObject, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getNonSystemLocales() {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeGetLocales(this.mObject, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Configuration[] getSizeConfigurations() {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeGetSizeConfigurations(this.mObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public void setConfiguration(int mcc, int mnc, String locale, int orientation, int touchscreen, int density, int keyboard, int keyboardHidden, int navigation, int screenWidth, int screenHeight, int smallestScreenWidthDp, int screenWidthDp, int screenHeightDp, int screenLayout, int uiMode, int colorMode, int majorVersion) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            AssetManager.nativeSetConfiguration(this.mObject, mcc, mnc, locale, orientation, touchscreen, density, keyboard, keyboardHidden, navigation, screenWidth, screenHeight, smallestScreenWidthDp, screenWidthDp, screenHeightDp, screenLayout, uiMode, colorMode, majorVersion);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public SparseArray<String> getAssignedPackageIdentifiers() {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeGetAssignedPackageIdentifiers(this.mObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value={"this"})
    public Map<String, String> getOverlayableMap(String packageName) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeGetOverlayableMap(this.mObject, packageName);
        }
    }

    @GuardedBy(value={"this"})
    private void incRefsLocked(long id2) {
        ++this.mNumRefs;
    }

    @GuardedBy(value={"this"})
    private void decRefsLocked(long id2) {
        --this.mNumRefs;
        if (this.mNumRefs == 0 && this.mObject != 0L) {
            AssetManager.nativeDestroy(this.mObject);
            this.mObject = 0L;
            this.mApkAssets = sEmptyApkAssets;
        }
    }

    private static native long nativeCreate();

    private static native void nativeDestroy(long var0);

    private static native void nativeSetApkAssets(long var0, ApkAssets[] var2, boolean var3);

    private static native void nativeSetConfiguration(long var0, int var2, int var3, String var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14, int var15, int var16, int var17, int var18, int var19);

    private static native SparseArray<String> nativeGetAssignedPackageIdentifiers(long var0);

    private static native String[] nativeList(long var0, String var2) throws IOException;

    private static native long nativeOpenAsset(long var0, String var2, int var3);

    private static native ParcelFileDescriptor nativeOpenAssetFd(long var0, String var2, long[] var3) throws IOException;

    private static native long nativeOpenNonAsset(long var0, int var2, String var3, int var4);

    private static native ParcelFileDescriptor nativeOpenNonAssetFd(long var0, int var2, String var3, long[] var4) throws IOException;

    private static native long nativeOpenXmlAsset(long var0, int var2, String var3);

    private static native int nativeGetResourceValue(long var0, int var2, short var3, TypedValue var4, boolean var5);

    private static native int nativeGetResourceBagValue(long var0, int var2, int var3, TypedValue var4);

    private static native int[] nativeGetStyleAttributes(long var0, int var2);

    private static native String[] nativeGetResourceStringArray(long var0, int var2);

    private static native int[] nativeGetResourceStringArrayInfo(long var0, int var2);

    private static native int[] nativeGetResourceIntArray(long var0, int var2);

    private static native int nativeGetResourceArraySize(long var0, int var2);

    private static native int nativeGetResourceArray(long var0, int var2, int[] var3);

    private static native int nativeGetResourceIdentifier(long var0, String var2, String var3, String var4);

    private static native String nativeGetResourceName(long var0, int var2);

    private static native String nativeGetResourcePackageName(long var0, int var2);

    private static native String nativeGetResourceTypeName(long var0, int var2);

    private static native String nativeGetResourceEntryName(long var0, int var2);

    private static native String[] nativeGetLocales(long var0, boolean var2);

    private static native Configuration[] nativeGetSizeConfigurations(long var0);

    private static native void nativeSetResourceResolutionLoggingEnabled(long var0, boolean var2);

    private static native String nativeGetLastResourceResolution(long var0);

    private static native int[] nativeAttributeResolutionStack(long var0, long var2, int var4, int var5, int var6);

    private static native void nativeApplyStyle(long var0, long var2, int var4, int var5, long var6, int[] var8, long var9, long var11);

    private static native boolean nativeResolveAttrs(long var0, long var2, int var4, int var5, int[] var6, int[] var7, int[] var8, int[] var9);

    private static native boolean nativeRetrieveAttributes(long var0, long var2, int[] var4, int[] var5, int[] var6);

    private static native long nativeThemeCreate(long var0);

    private static native void nativeThemeDestroy(long var0);

    private static native void nativeThemeApplyStyle(long var0, long var2, int var4, boolean var5);

    private static native void nativeThemeCopy(long var0, long var2, long var4, long var6);

    static native void nativeThemeClear(long var0);

    private static native int nativeThemeGetAttributeValue(long var0, long var2, int var4, TypedValue var5, boolean var6);

    private static native void nativeThemeDump(long var0, long var2, int var4, String var5, String var6);

    static native int nativeThemeGetChangingConfigurations(long var0);

    private static native void nativeAssetDestroy(long var0);

    private static native int nativeAssetReadChar(long var0);

    private static native int nativeAssetRead(long var0, byte[] var2, int var3, int var4);

    private static native long nativeAssetSeek(long var0, long var2, int var4);

    private static native long nativeAssetGetLength(long var0);

    private static native long nativeAssetGetRemainingLength(long var0);

    private static native void nativeVerifySystemIdmaps();

    private static native String[] nativeCreateIdmapsForStaticOverlaysTargetingAndroid();

    private static native Map nativeGetOverlayableMap(long var0, String var2);

    @UnsupportedAppUsage
    public static native int getGlobalAssetCount();

    public static native String getAssetAllocations();

    @UnsupportedAppUsage
    public static native int getGlobalAssetManagerCount();

    static /* synthetic */ ApkAssets[] access$102(AssetManager x0, ApkAssets[] x1) {
        x0.mApkAssets = x1;
        return x1;
    }

    public final class AssetInputStream
    extends InputStream {
        private long mAssetNativePtr;
        private long mLength;
        private long mMarkPos;

        @UnsupportedAppUsage
        public final int getAssetInt() {
            throw new UnsupportedOperationException();
        }

        @UnsupportedAppUsage
        public final long getNativeAsset() {
            return this.mAssetNativePtr;
        }

        private AssetInputStream(long assetNativePtr) {
            this.mAssetNativePtr = assetNativePtr;
            this.mLength = AssetManager.nativeAssetGetLength(assetNativePtr);
        }

        @Override
        public final int read() throws IOException {
            this.ensureOpen();
            return AssetManager.nativeAssetReadChar(this.mAssetNativePtr);
        }

        @Override
        public final int read(byte[] b) throws IOException {
            this.ensureOpen();
            Preconditions.checkNotNull(b, "b");
            return AssetManager.nativeAssetRead(this.mAssetNativePtr, b, 0, b.length);
        }

        @Override
        public final int read(byte[] b, int off, int len) throws IOException {
            this.ensureOpen();
            Preconditions.checkNotNull(b, "b");
            return AssetManager.nativeAssetRead(this.mAssetNativePtr, b, off, len);
        }

        @Override
        public final long skip(long n) throws IOException {
            this.ensureOpen();
            long pos = AssetManager.nativeAssetSeek(this.mAssetNativePtr, 0L, 0);
            if (pos + n > this.mLength) {
                n = this.mLength - pos;
            }
            if (n > 0L) {
                AssetManager.nativeAssetSeek(this.mAssetNativePtr, n, 0);
            }
            return n;
        }

        @Override
        public final int available() throws IOException {
            this.ensureOpen();
            long len = AssetManager.nativeAssetGetRemainingLength(this.mAssetNativePtr);
            return len > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)len;
        }

        @Override
        public final boolean markSupported() {
            return true;
        }

        @Override
        public final void mark(int readlimit) {
            this.ensureOpen();
            this.mMarkPos = AssetManager.nativeAssetSeek(this.mAssetNativePtr, 0L, 0);
        }

        @Override
        public final void reset() throws IOException {
            this.ensureOpen();
            AssetManager.nativeAssetSeek(this.mAssetNativePtr, this.mMarkPos, -1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void close() throws IOException {
            if (this.mAssetNativePtr != 0L) {
                AssetManager.nativeAssetDestroy(this.mAssetNativePtr);
                this.mAssetNativePtr = 0L;
                AssetManager assetManager = AssetManager.this;
                synchronized (assetManager) {
                    AssetManager.this.decRefsLocked(this.hashCode());
                }
            }
        }

        protected void finalize() throws Throwable {
            this.close();
        }

        private void ensureOpen() {
            if (this.mAssetNativePtr == 0L) {
                throw new IllegalStateException("AssetInputStream is closed");
            }
        }
    }

    public static class Builder {
        private ArrayList<ApkAssets> mUserApkAssets = new ArrayList();

        public Builder addApkAssets(ApkAssets apkAssets) {
            this.mUserApkAssets.add(apkAssets);
            return this;
        }

        public AssetManager build() {
            ApkAssets[] systemApkAssets = AssetManager.getSystem().getApkAssets();
            int totalApkAssetCount = systemApkAssets.length + this.mUserApkAssets.size();
            ApkAssets[] apkAssets = new ApkAssets[totalApkAssetCount];
            System.arraycopy(systemApkAssets, 0, apkAssets, 0, systemApkAssets.length);
            int userApkAssetCount = this.mUserApkAssets.size();
            for (int i = 0; i < userApkAssetCount; ++i) {
                apkAssets[i + systemApkAssets.length] = this.mUserApkAssets.get(i);
            }
            AssetManager assetManager = new AssetManager(false);
            AssetManager.access$102(assetManager, apkAssets);
            AssetManager.nativeSetApkAssets(assetManager.mObject, apkAssets, false);
            return assetManager;
        }
    }
}

