/*
 * Decompiled with CFR 0.152.
 */
package android.database;

import android.database.Cursor;
import java.util.Iterator;

public final class CursorJoiner
implements Iterator<Result>,
Iterable<Result> {
    private Cursor mCursorLeft;
    private Cursor mCursorRight;
    private boolean mCompareResultIsValid;
    private Result mCompareResult;
    private int[] mColumnsLeft;
    private int[] mColumnsRight;
    private String[] mValues;

    public CursorJoiner(Cursor cursorLeft, String[] columnNamesLeft, Cursor cursorRight, String[] columnNamesRight) {
        if (columnNamesLeft.length != columnNamesRight.length) {
            throw new IllegalArgumentException("you must have the same number of columns on the left and right, " + columnNamesLeft.length + " != " + columnNamesRight.length);
        }
        this.mCursorLeft = cursorLeft;
        this.mCursorRight = cursorRight;
        this.mCursorLeft.moveToFirst();
        this.mCursorRight.moveToFirst();
        this.mCompareResultIsValid = false;
        this.mColumnsLeft = this.buildColumnIndiciesArray(cursorLeft, columnNamesLeft);
        this.mColumnsRight = this.buildColumnIndiciesArray(cursorRight, columnNamesRight);
        this.mValues = new String[this.mColumnsLeft.length * 2];
    }

    @Override
    public Iterator<Result> iterator() {
        return this;
    }

    private int[] buildColumnIndiciesArray(Cursor cursor, String[] columnNames) {
        int[] columns = new int[columnNames.length];
        for (int i = 0; i < columnNames.length; ++i) {
            columns[i] = cursor.getColumnIndexOrThrow(columnNames[i]);
        }
        return columns;
    }

    @Override
    public boolean hasNext() {
        if (this.mCompareResultIsValid) {
            switch (this.mCompareResult) {
                case BOTH: {
                    return !this.mCursorLeft.isLast() || !this.mCursorRight.isLast();
                }
                case LEFT: {
                    return !this.mCursorLeft.isLast() || !this.mCursorRight.isAfterLast();
                }
                case RIGHT: {
                    return !this.mCursorLeft.isAfterLast() || !this.mCursorRight.isLast();
                }
            }
            throw new IllegalStateException("bad value for mCompareResult, " + (Object)((Object)this.mCompareResult));
        }
        return !this.mCursorLeft.isAfterLast() || !this.mCursorRight.isAfterLast();
    }

    @Override
    public Result next() {
        boolean hasRight;
        if (!this.hasNext()) {
            throw new IllegalStateException("you must only call next() when hasNext() is true");
        }
        this.incrementCursors();
        assert (this.hasNext());
        boolean hasLeft = !this.mCursorLeft.isAfterLast();
        boolean bl = hasRight = !this.mCursorRight.isAfterLast();
        if (hasLeft && hasRight) {
            CursorJoiner.populateValues(this.mValues, this.mCursorLeft, this.mColumnsLeft, 0);
            CursorJoiner.populateValues(this.mValues, this.mCursorRight, this.mColumnsRight, 1);
            switch (CursorJoiner.compareStrings(this.mValues)) {
                case -1: {
                    this.mCompareResult = Result.LEFT;
                    break;
                }
                case 0: {
                    this.mCompareResult = Result.BOTH;
                    break;
                }
                case 1: {
                    this.mCompareResult = Result.RIGHT;
                }
            }
        } else if (hasLeft) {
            this.mCompareResult = Result.LEFT;
        } else {
            assert (hasRight);
            this.mCompareResult = Result.RIGHT;
        }
        this.mCompareResultIsValid = true;
        return this.mCompareResult;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("not implemented");
    }

    private static void populateValues(String[] values, Cursor cursor, int[] columnIndicies, int startingIndex) {
        assert (startingIndex == 0 || startingIndex == 1);
        for (int i = 0; i < columnIndicies.length; ++i) {
            values[startingIndex + i * 2] = cursor.getString(columnIndicies[i]);
        }
    }

    private void incrementCursors() {
        if (this.mCompareResultIsValid) {
            switch (this.mCompareResult) {
                case LEFT: {
                    this.mCursorLeft.moveToNext();
                    break;
                }
                case RIGHT: {
                    this.mCursorRight.moveToNext();
                    break;
                }
                case BOTH: {
                    this.mCursorLeft.moveToNext();
                    this.mCursorRight.moveToNext();
                }
            }
            this.mCompareResultIsValid = false;
        }
    }

    private static int compareStrings(String ... values) {
        if (values.length % 2 != 0) {
            throw new IllegalArgumentException("you must specify an even number of values");
        }
        for (int index = 0; index < values.length; index += 2) {
            if (values[index] == null) {
                if (values[index + 1] == null) continue;
                return -1;
            }
            if (values[index + 1] == null) {
                return 1;
            }
            int comp = values[index].compareTo(values[index + 1]);
            if (comp == 0) continue;
            return comp < 0 ? -1 : 1;
        }
        return 0;
    }

    public static enum Result {
        RIGHT,
        LEFT,
        BOTH;

    }
}

