/*
 * Decompiled with CFR 0.152.
 */
package android.database;

import android.database.CharArrayBuffer;
import android.database.CrossProcessCursorWrapper;
import android.database.Cursor;
import android.database.CursorWindow;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteQueryBuilder;
import android.net.Uri;
import android.os.CancellationSignal;
import android.util.ArraySet;
import com.android.internal.util.ArrayUtils;
import java.util.Arrays;
import java.util.Objects;

public class TranslatingCursor
extends CrossProcessCursorWrapper {
    private final Config mConfig;
    private final Translator mTranslator;
    private final boolean mDropLast;
    private final int mAuxiliaryColumnIndex;
    private final ArraySet<Integer> mTranslateColumnIndices;

    public TranslatingCursor(Cursor cursor, Config config, Translator translator, boolean dropLast) {
        super(cursor);
        this.mConfig = Objects.requireNonNull(config);
        this.mTranslator = Objects.requireNonNull(translator);
        this.mDropLast = dropLast;
        this.mAuxiliaryColumnIndex = cursor.getColumnIndexOrThrow(config.auxiliaryColumn);
        this.mTranslateColumnIndices = new ArraySet();
        for (int i = 0; i < cursor.getColumnCount(); ++i) {
            String columnName = cursor.getColumnName(i);
            if (!ArrayUtils.contains(config.translateColumns, columnName)) continue;
            this.mTranslateColumnIndices.add(i);
        }
    }

    @Override
    public int getColumnCount() {
        if (this.mDropLast) {
            return super.getColumnCount() - 1;
        }
        return super.getColumnCount();
    }

    @Override
    public String[] getColumnNames() {
        if (this.mDropLast) {
            return Arrays.copyOfRange(super.getColumnNames(), 0, super.getColumnCount() - 1);
        }
        return super.getColumnNames();
    }

    public static Cursor query(Config config, Translator translator, SQLiteQueryBuilder qb, SQLiteDatabase db, String[] projectionIn, String selection, String[] selectionArgs, String groupBy, String having, String sortOrder, String limit, CancellationSignal signal) {
        boolean requestedTranslateColumns;
        boolean requestedAuxiliaryColumn = ArrayUtils.isEmpty(projectionIn) || ArrayUtils.contains(projectionIn, config.auxiliaryColumn);
        boolean bl = requestedTranslateColumns = ArrayUtils.isEmpty(projectionIn) || ArrayUtils.containsAny(projectionIn, config.translateColumns);
        if (!requestedTranslateColumns) {
            return qb.query(db, projectionIn, selection, selectionArgs, groupBy, having, sortOrder, limit, signal);
        }
        if (!requestedAuxiliaryColumn) {
            projectionIn = ArrayUtils.appendElement(String.class, projectionIn, config.auxiliaryColumn);
        }
        Cursor c = qb.query(db, projectionIn, selection, selectionArgs, groupBy, having, sortOrder);
        return new TranslatingCursor(c, config, translator, !requestedAuxiliaryColumn);
    }

    @Override
    public void fillWindow(int position, CursorWindow window) {
        DatabaseUtils.cursorFillWindow(this, position, window);
    }

    @Override
    public CursorWindow getWindow() {
        return null;
    }

    @Override
    public Cursor getWrappedCursor() {
        throw new UnsupportedOperationException("Returning underlying cursor risks leaking data");
    }

    @Override
    public double getDouble(int columnIndex) {
        if (ArrayUtils.contains(this.mTranslateColumnIndices, Integer.valueOf(columnIndex))) {
            throw new IllegalArgumentException();
        }
        return super.getDouble(columnIndex);
    }

    @Override
    public float getFloat(int columnIndex) {
        if (ArrayUtils.contains(this.mTranslateColumnIndices, Integer.valueOf(columnIndex))) {
            throw new IllegalArgumentException();
        }
        return super.getFloat(columnIndex);
    }

    @Override
    public int getInt(int columnIndex) {
        if (ArrayUtils.contains(this.mTranslateColumnIndices, Integer.valueOf(columnIndex))) {
            throw new IllegalArgumentException();
        }
        return super.getInt(columnIndex);
    }

    @Override
    public long getLong(int columnIndex) {
        if (ArrayUtils.contains(this.mTranslateColumnIndices, Integer.valueOf(columnIndex))) {
            throw new IllegalArgumentException();
        }
        return super.getLong(columnIndex);
    }

    @Override
    public short getShort(int columnIndex) {
        if (ArrayUtils.contains(this.mTranslateColumnIndices, Integer.valueOf(columnIndex))) {
            throw new IllegalArgumentException();
        }
        return super.getShort(columnIndex);
    }

    @Override
    public String getString(int columnIndex) {
        if (ArrayUtils.contains(this.mTranslateColumnIndices, Integer.valueOf(columnIndex))) {
            return this.mTranslator.translate(super.getString(columnIndex), this.mAuxiliaryColumnIndex, this.getColumnName(columnIndex), this);
        }
        return super.getString(columnIndex);
    }

    @Override
    public void copyStringToBuffer(int columnIndex, CharArrayBuffer buffer) {
        if (ArrayUtils.contains(this.mTranslateColumnIndices, Integer.valueOf(columnIndex))) {
            throw new IllegalArgumentException();
        }
        super.copyStringToBuffer(columnIndex, buffer);
    }

    @Override
    public byte[] getBlob(int columnIndex) {
        if (ArrayUtils.contains(this.mTranslateColumnIndices, Integer.valueOf(columnIndex))) {
            throw new IllegalArgumentException();
        }
        return super.getBlob(columnIndex);
    }

    @Override
    public int getType(int columnIndex) {
        if (ArrayUtils.contains(this.mTranslateColumnIndices, Integer.valueOf(columnIndex))) {
            return 3;
        }
        return super.getType(columnIndex);
    }

    @Override
    public boolean isNull(int columnIndex) {
        if (ArrayUtils.contains(this.mTranslateColumnIndices, Integer.valueOf(columnIndex))) {
            return this.getString(columnIndex) == null;
        }
        return super.isNull(columnIndex);
    }

    public static interface Translator {
        public String translate(String var1, int var2, String var3, Cursor var4);
    }

    public static class Config {
        public final Uri baseUri;
        public final String auxiliaryColumn;
        public final String[] translateColumns;

        public Config(Uri baseUri, String auxiliaryColumn, String ... translateColumns) {
            this.baseUri = baseUri;
            this.auxiliaryColumn = auxiliaryColumn;
            this.translateColumns = translateColumns;
        }
    }
}

