/*
 * Decompiled with CFR 0.152.
 */
package android.ddm;

import java.nio.ByteBuffer;
import org.apache.harmony.dalvik.ddmc.Chunk;
import org.apache.harmony.dalvik.ddmc.ChunkHandler;
import org.apache.harmony.dalvik.ddmc.DdmServer;
import org.apache.harmony.dalvik.ddmc.DdmVmInternal;

public class DdmHandleThread
extends ChunkHandler {
    public static final int CHUNK_THEN = DdmHandleThread.type("THEN");
    public static final int CHUNK_THCR = DdmHandleThread.type("THCR");
    public static final int CHUNK_THDE = DdmHandleThread.type("THDE");
    public static final int CHUNK_THST = DdmHandleThread.type("THST");
    public static final int CHUNK_STKL = DdmHandleThread.type("STKL");
    private static DdmHandleThread mInstance = new DdmHandleThread();

    private DdmHandleThread() {
    }

    public static void register() {
        DdmServer.registerHandler(CHUNK_THEN, mInstance);
        DdmServer.registerHandler(CHUNK_THST, mInstance);
        DdmServer.registerHandler(CHUNK_STKL, mInstance);
    }

    @Override
    public void connected() {
    }

    @Override
    public void disconnected() {
    }

    @Override
    public Chunk handleChunk(Chunk request) {
        int type = request.type;
        if (type == CHUNK_THEN) {
            return this.handleTHEN(request);
        }
        if (type == CHUNK_THST) {
            return this.handleTHST(request);
        }
        if (type == CHUNK_STKL) {
            return this.handleSTKL(request);
        }
        throw new RuntimeException("Unknown packet " + ChunkHandler.name(type));
    }

    private Chunk handleTHEN(Chunk request) {
        ByteBuffer in = DdmHandleThread.wrapChunk(request);
        boolean enable = in.get() != 0;
        DdmVmInternal.threadNotify(enable);
        return null;
    }

    private Chunk handleTHST(Chunk request) {
        ByteBuffer in = DdmHandleThread.wrapChunk(request);
        byte[] status = DdmVmInternal.getThreadStats();
        if (status != null) {
            return new Chunk(CHUNK_THST, status, 0, status.length);
        }
        return DdmHandleThread.createFailChunk(1, "Can't build THST chunk");
    }

    private Chunk handleSTKL(Chunk request) {
        ByteBuffer in = DdmHandleThread.wrapChunk(request);
        int threadId = in.getInt();
        StackTraceElement[] trace = DdmVmInternal.getStackTraceById(threadId);
        if (trace == null) {
            return DdmHandleThread.createFailChunk(1, "Stack trace unavailable");
        }
        return this.createStackChunk(trace, threadId);
    }

    private Chunk createStackChunk(StackTraceElement[] trace, int threadId) {
        int bufferSize = 0;
        bufferSize += 4;
        bufferSize += 4;
        bufferSize += 4;
        for (StackTraceElement elem : trace) {
            bufferSize += 4 + elem.getClassName().length() * 2;
            bufferSize += 4 + elem.getMethodName().length() * 2;
            bufferSize += 4;
            if (elem.getFileName() != null) {
                bufferSize += elem.getFileName().length() * 2;
            }
            bufferSize += 4;
        }
        ByteBuffer out = ByteBuffer.allocate(bufferSize);
        out.putInt(0);
        out.putInt(threadId);
        out.putInt(trace.length);
        for (StackTraceElement elem : trace) {
            out.putInt(elem.getClassName().length());
            DdmHandleThread.putString(out, elem.getClassName());
            out.putInt(elem.getMethodName().length());
            DdmHandleThread.putString(out, elem.getMethodName());
            if (elem.getFileName() != null) {
                out.putInt(elem.getFileName().length());
                DdmHandleThread.putString(out, elem.getFileName());
            } else {
                out.putInt(0);
            }
            out.putInt(elem.getLineNumber());
        }
        return new Chunk(CHUNK_STKL, out);
    }
}

