/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.core;

import android.annotation.UnsupportedAppUsage;
import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.FrameFormat;
import android.filterfw.core.InputPort;
import android.filterfw.core.KeyValueMap;
import android.filterfw.core.OutputPort;
import android.filterpacks.base.FrameBranch;
import android.filterpacks.base.NullFilter;
import android.util.Log;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class FilterGraph {
    private HashSet<Filter> mFilters = new HashSet();
    private HashMap<String, Filter> mNameMap = new HashMap();
    private HashMap<OutputPort, LinkedList<InputPort>> mPreconnections = new HashMap();
    public static final int AUTOBRANCH_OFF = 0;
    public static final int AUTOBRANCH_SYNCED = 1;
    public static final int AUTOBRANCH_UNSYNCED = 2;
    public static final int TYPECHECK_OFF = 0;
    public static final int TYPECHECK_DYNAMIC = 1;
    public static final int TYPECHECK_STRICT = 2;
    private boolean mIsReady = false;
    private int mAutoBranchMode = 0;
    private int mTypeCheckMode = 2;
    private boolean mDiscardUnconnectedOutputs = false;
    private boolean mLogVerbose = Log.isLoggable(this.TAG, 2);
    private String TAG = "FilterGraph";

    public boolean addFilter(Filter filter) {
        if (!this.containsFilter(filter)) {
            this.mFilters.add(filter);
            this.mNameMap.put(filter.getName(), filter);
            return true;
        }
        return false;
    }

    public boolean containsFilter(Filter filter) {
        return this.mFilters.contains(filter);
    }

    @UnsupportedAppUsage
    public Filter getFilter(String name) {
        return this.mNameMap.get(name);
    }

    public void connect(Filter source, String outputName, Filter target, String inputName) {
        if (source == null || target == null) {
            throw new IllegalArgumentException("Passing null Filter in connect()!");
        }
        if (!this.containsFilter(source) || !this.containsFilter(target)) {
            throw new RuntimeException("Attempting to connect filter not in graph!");
        }
        OutputPort outPort = source.getOutputPort(outputName);
        InputPort inPort = target.getInputPort(inputName);
        if (outPort == null) {
            throw new RuntimeException("Unknown output port '" + outputName + "' on Filter " + source + "!");
        }
        if (inPort == null) {
            throw new RuntimeException("Unknown input port '" + inputName + "' on Filter " + target + "!");
        }
        this.preconnect(outPort, inPort);
    }

    public void connect(String sourceName, String outputName, String targetName, String inputName) {
        Filter source = this.getFilter(sourceName);
        Filter target = this.getFilter(targetName);
        if (source == null) {
            throw new RuntimeException("Attempting to connect unknown source filter '" + sourceName + "'!");
        }
        if (target == null) {
            throw new RuntimeException("Attempting to connect unknown target filter '" + targetName + "'!");
        }
        this.connect(source, outputName, target, inputName);
    }

    public Set<Filter> getFilters() {
        return this.mFilters;
    }

    public void beginProcessing() {
        if (this.mLogVerbose) {
            Log.v(this.TAG, "Opening all filter connections...");
        }
        for (Filter filter : this.mFilters) {
            filter.openOutputs();
        }
        this.mIsReady = true;
    }

    public void flushFrames() {
        for (Filter filter : this.mFilters) {
            filter.clearOutputs();
        }
    }

    public void closeFilters(FilterContext context) {
        if (this.mLogVerbose) {
            Log.v(this.TAG, "Closing all filters...");
        }
        for (Filter filter : this.mFilters) {
            filter.performClose(context);
        }
        this.mIsReady = false;
    }

    public boolean isReady() {
        return this.mIsReady;
    }

    public void setAutoBranchMode(int autoBranchMode) {
        this.mAutoBranchMode = autoBranchMode;
    }

    public void setDiscardUnconnectedOutputs(boolean discard) {
        this.mDiscardUnconnectedOutputs = discard;
    }

    public void setTypeCheckMode(int typeCheckMode) {
        this.mTypeCheckMode = typeCheckMode;
    }

    @UnsupportedAppUsage
    public void tearDown(FilterContext context) {
        if (!this.mFilters.isEmpty()) {
            this.flushFrames();
            for (Filter filter : this.mFilters) {
                filter.performTearDown(context);
            }
            this.mFilters.clear();
            this.mNameMap.clear();
            this.mIsReady = false;
        }
    }

    private boolean readyForProcessing(Filter filter, Set<Filter> processed) {
        if (processed.contains(filter)) {
            return false;
        }
        for (InputPort port : filter.getInputPorts()) {
            Filter dependency = port.getSourceFilter();
            if (dependency == null || processed.contains(dependency)) continue;
            return false;
        }
        return true;
    }

    private void runTypeCheck() {
        Stack<Filter> filterStack = new Stack<Filter>();
        HashSet<Filter> processedFilters = new HashSet<Filter>();
        filterStack.addAll(this.getSourceFilters());
        while (!filterStack.empty()) {
            Filter filter = (Filter)filterStack.pop();
            processedFilters.add(filter);
            this.updateOutputs(filter);
            if (this.mLogVerbose) {
                Log.v(this.TAG, "Running type check on " + filter + "...");
            }
            this.runTypeCheckOn(filter);
            for (OutputPort port : filter.getOutputPorts()) {
                Filter target = port.getTargetFilter();
                if (target == null || !this.readyForProcessing(target, processedFilters)) continue;
                filterStack.push(target);
            }
        }
        if (processedFilters.size() != this.getFilters().size()) {
            throw new RuntimeException("Could not schedule all filters! Is your graph malformed?");
        }
    }

    private void updateOutputs(Filter filter) {
        for (OutputPort outputPort : filter.getOutputPorts()) {
            InputPort inputPort = outputPort.getBasePort();
            if (inputPort == null) continue;
            FrameFormat inputFormat = inputPort.getSourceFormat();
            FrameFormat outputFormat = filter.getOutputFormat(outputPort.getName(), inputFormat);
            if (outputFormat == null) {
                throw new RuntimeException("Filter did not return an output format for " + outputPort + "!");
            }
            outputPort.setPortFormat(outputFormat);
        }
    }

    private void runTypeCheckOn(Filter filter) {
        for (InputPort inputPort : filter.getInputPorts()) {
            if (this.mLogVerbose) {
                Log.v(this.TAG, "Type checking port " + inputPort);
            }
            FrameFormat sourceFormat = inputPort.getSourceFormat();
            FrameFormat targetFormat = inputPort.getPortFormat();
            if (sourceFormat == null || targetFormat == null) continue;
            if (this.mLogVerbose) {
                Log.v(this.TAG, "Checking " + sourceFormat + " against " + targetFormat + ".");
            }
            boolean compatible = true;
            switch (this.mTypeCheckMode) {
                case 0: {
                    inputPort.setChecksType(false);
                    break;
                }
                case 1: {
                    compatible = sourceFormat.mayBeCompatibleWith(targetFormat);
                    inputPort.setChecksType(true);
                    break;
                }
                case 2: {
                    compatible = sourceFormat.isCompatibleWith(targetFormat);
                    inputPort.setChecksType(false);
                }
            }
            if (compatible) continue;
            throw new RuntimeException("Type mismatch: Filter " + filter + " expects a format of type " + targetFormat + " but got a format of type " + sourceFormat + "!");
        }
    }

    private void checkConnections() {
    }

    private void discardUnconnectedOutputs() {
        LinkedList<NullFilter> addedFilters = new LinkedList<NullFilter>();
        for (Filter filter : this.mFilters) {
            int id2 = 0;
            for (OutputPort port : filter.getOutputPorts()) {
                if (port.isConnected()) continue;
                if (this.mLogVerbose) {
                    Log.v(this.TAG, "Autoconnecting unconnected " + port + " to Null filter.");
                }
                NullFilter nullFilter = new NullFilter(filter.getName() + "ToNull" + id2);
                nullFilter.init();
                addedFilters.add(nullFilter);
                port.connectTo(nullFilter.getInputPort("frame"));
                ++id2;
            }
        }
        for (Filter filter : addedFilters) {
            this.addFilter(filter);
        }
    }

    private void removeFilter(Filter filter) {
        this.mFilters.remove(filter);
        this.mNameMap.remove(filter.getName());
    }

    private void preconnect(OutputPort outPort, InputPort inPort) {
        LinkedList<InputPort> targets = this.mPreconnections.get(outPort);
        if (targets == null) {
            targets = new LinkedList();
            this.mPreconnections.put(outPort, targets);
        }
        targets.add(inPort);
    }

    private void connectPorts() {
        int branchId = 1;
        for (Map.Entry<OutputPort, LinkedList<InputPort>> connection : this.mPreconnections.entrySet()) {
            OutputPort outputPort = connection.getKey();
            LinkedList<InputPort> inputPorts = connection.getValue();
            if (inputPorts.size() == 1) {
                outputPort.connectTo(inputPorts.get(0));
                continue;
            }
            if (this.mAutoBranchMode == 0) {
                throw new RuntimeException("Attempting to connect " + outputPort + " to multiple filter ports! Enable auto-branching to allow this.");
            }
            if (this.mLogVerbose) {
                Log.v(this.TAG, "Creating branch for " + outputPort + "!");
            }
            FrameBranch branch = null;
            if (this.mAutoBranchMode != 1) {
                throw new RuntimeException("TODO: Unsynced branches not implemented yet!");
            }
            branch = new FrameBranch("branch" + branchId++);
            KeyValueMap branchParams = new KeyValueMap();
            branch.initWithAssignmentList("outputs", inputPorts.size());
            this.addFilter(branch);
            outputPort.connectTo(branch.getInputPort("in"));
            Iterator inputPortIter = inputPorts.iterator();
            for (OutputPort branchOutPort : branch.getOutputPorts()) {
                branchOutPort.connectTo((InputPort)inputPortIter.next());
            }
        }
        this.mPreconnections.clear();
    }

    private HashSet<Filter> getSourceFilters() {
        HashSet<Filter> sourceFilters = new HashSet<Filter>();
        for (Filter filter : this.getFilters()) {
            if (filter.getNumberOfConnectedInputs() != 0) continue;
            if (this.mLogVerbose) {
                Log.v(this.TAG, "Found source filter: " + filter);
            }
            sourceFilters.add(filter);
        }
        return sourceFilters;
    }

    void setupFilters() {
        if (this.mDiscardUnconnectedOutputs) {
            this.discardUnconnectedOutputs();
        }
        this.connectPorts();
        this.checkConnections();
        this.runTypeCheck();
    }
}

