/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.core;

import android.annotation.UnsupportedAppUsage;
import android.filterfw.core.FrameFormat;
import android.filterfw.core.FrameManager;
import android.graphics.Bitmap;
import java.nio.ByteBuffer;

public abstract class Frame {
    public static final int NO_BINDING = 0;
    public static final long TIMESTAMP_NOT_SET = -2L;
    public static final long TIMESTAMP_UNKNOWN = -1L;
    private FrameFormat mFormat;
    private FrameManager mFrameManager;
    private boolean mReadOnly = false;
    private boolean mReusable = false;
    private int mRefCount = 1;
    private int mBindingType = 0;
    private long mBindingId = 0L;
    private long mTimestamp = -2L;

    Frame(FrameFormat format, FrameManager frameManager) {
        this.mFormat = format.mutableCopy();
        this.mFrameManager = frameManager;
    }

    Frame(FrameFormat format, FrameManager frameManager, int bindingType, long bindingId) {
        this.mFormat = format.mutableCopy();
        this.mFrameManager = frameManager;
        this.mBindingType = bindingType;
        this.mBindingId = bindingId;
    }

    @UnsupportedAppUsage
    public FrameFormat getFormat() {
        return this.mFormat;
    }

    public int getCapacity() {
        return this.getFormat().getSize();
    }

    public boolean isReadOnly() {
        return this.mReadOnly;
    }

    public int getBindingType() {
        return this.mBindingType;
    }

    public long getBindingId() {
        return this.mBindingId;
    }

    public void setObjectValue(Object object) {
        this.assertFrameMutable();
        if (object instanceof int[]) {
            this.setInts((int[])object);
        } else if (object instanceof float[]) {
            this.setFloats((float[])object);
        } else if (object instanceof ByteBuffer) {
            this.setData((ByteBuffer)object);
        } else if (object instanceof Bitmap) {
            this.setBitmap((Bitmap)object);
        } else {
            this.setGenericObjectValue(object);
        }
    }

    public abstract Object getObjectValue();

    @UnsupportedAppUsage
    public abstract void setInts(int[] var1);

    public abstract int[] getInts();

    public abstract void setFloats(float[] var1);

    public abstract float[] getFloats();

    public abstract void setData(ByteBuffer var1, int var2, int var3);

    public void setData(ByteBuffer buffer) {
        this.setData(buffer, 0, buffer.limit());
    }

    public void setData(byte[] bytes, int offset, int length) {
        this.setData(ByteBuffer.wrap(bytes, offset, length));
    }

    public abstract ByteBuffer getData();

    public abstract void setBitmap(Bitmap var1);

    @UnsupportedAppUsage
    public abstract Bitmap getBitmap();

    @UnsupportedAppUsage
    public void setTimestamp(long timestamp) {
        this.mTimestamp = timestamp;
    }

    @UnsupportedAppUsage
    public long getTimestamp() {
        return this.mTimestamp;
    }

    public void setDataFromFrame(Frame frame) {
        this.setData(frame.getData());
    }

    protected boolean requestResize(int[] newDimensions) {
        return false;
    }

    public int getRefCount() {
        return this.mRefCount;
    }

    @UnsupportedAppUsage
    public Frame release() {
        if (this.mFrameManager != null) {
            return this.mFrameManager.releaseFrame(this);
        }
        return this;
    }

    public Frame retain() {
        if (this.mFrameManager != null) {
            return this.mFrameManager.retainFrame(this);
        }
        return this;
    }

    public FrameManager getFrameManager() {
        return this.mFrameManager;
    }

    protected void assertFrameMutable() {
        if (this.isReadOnly()) {
            throw new RuntimeException("Attempting to modify read-only frame!");
        }
    }

    protected void setReusable(boolean reusable) {
        this.mReusable = reusable;
    }

    protected void setFormat(FrameFormat format) {
        this.mFormat = format.mutableCopy();
    }

    protected void setGenericObjectValue(Object value) {
        throw new RuntimeException("Cannot set object value of unsupported type: " + value.getClass());
    }

    protected static Bitmap convertBitmapToRGBA(Bitmap bitmap) {
        if (bitmap.getConfig() == Bitmap.Config.ARGB_8888) {
            return bitmap;
        }
        Bitmap result = bitmap.copy(Bitmap.Config.ARGB_8888, false);
        if (result == null) {
            throw new RuntimeException("Error converting bitmap to RGBA!");
        }
        if (result.getRowBytes() != result.getWidth() * 4) {
            throw new RuntimeException("Unsupported row byte count in bitmap!");
        }
        return result;
    }

    protected void reset(FrameFormat newFormat) {
        this.mFormat = newFormat.mutableCopy();
        this.mReadOnly = false;
        this.mRefCount = 1;
    }

    protected void onFrameStore() {
    }

    protected void onFrameFetch() {
    }

    protected abstract boolean hasNativeAllocation();

    protected abstract void releaseNativeAllocation();

    final int incRefCount() {
        ++this.mRefCount;
        return this.mRefCount;
    }

    final int decRefCount() {
        --this.mRefCount;
        return this.mRefCount;
    }

    final boolean isReusable() {
        return this.mReusable;
    }

    final void markReadOnly() {
        this.mReadOnly = true;
    }
}

