/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.core;

import android.annotation.UnsupportedAppUsage;
import android.filterfw.core.FilterContext;
import android.filterfw.core.Frame;
import android.filterfw.core.FrameFormat;
import android.filterfw.core.GLEnvironment;
import android.filterfw.core.MutableFrameFormat;

public abstract class FrameManager {
    private FilterContext mContext;

    @UnsupportedAppUsage
    public abstract Frame newFrame(FrameFormat var1);

    @UnsupportedAppUsage
    public abstract Frame newBoundFrame(FrameFormat var1, int var2, long var3);

    @UnsupportedAppUsage
    public Frame duplicateFrame(Frame frame) {
        Frame result = this.newFrame(frame.getFormat());
        result.setDataFromFrame(frame);
        return result;
    }

    public Frame duplicateFrameToTarget(Frame frame, int newTarget) {
        MutableFrameFormat newFormat = frame.getFormat().mutableCopy();
        newFormat.setTarget(newTarget);
        Frame result = this.newFrame(newFormat);
        result.setDataFromFrame(frame);
        return result;
    }

    public abstract Frame retainFrame(Frame var1);

    public abstract Frame releaseFrame(Frame var1);

    public FilterContext getContext() {
        return this.mContext;
    }

    public GLEnvironment getGLEnvironment() {
        return this.mContext != null ? this.mContext.getGLEnvironment() : null;
    }

    public void tearDown() {
    }

    void setContext(FilterContext context) {
        this.mContext = context;
    }
}

